<?php
function auto_update_wishlist_count(){
	if( function_exists( 'YITH_WCWL' ) ){
		wp_send_json( '&#40;'.YITH_WCWL()->count_products().'&#41;' );
	}
	 wp_die();
}
add_action( 'wp_ajax_auto_update_wishlist_count', 'auto_update_wishlist_count' );
add_action( 'wp_ajax_nopriv_auto_update_wishlist_count', 'auto_update_wishlist_count' );


function au_ajax_search_product(){
	$search_val = $_POST['s'];
	$search_cat = $_POST['product_cat']; 
	if ( isset( $_REQUEST['s'] ) && ! empty( $_REQUEST['s'] ) ) {
		$query = sanitize_text_field( $_REQUEST['s'] ); 
			// native WordPress search
		$args = array(
			's'             => $query,
			'post_status'   => 'publish',
			'post_type'     => 'product',
		); 
		if(isset($_POST['product_cat']) && $_POST['product_cat'] !=''){
			$args['tax_query'][] = array(
				'taxonomy' => 'product_cat',
				'field'    => 'slug',
				'terms'    => $_POST['product_cat'],
				'operator' => 'IN'
			);
		}
		query_posts( $args );
		if ( have_posts() ) : 
			while ( have_posts() ) : the_post(); 
				$post_type = get_post_type_object( get_post_type() ); ?>
				<div class="auto-search-result">
					<p>
						<a class="hover" href="<?php echo esc_url( get_permalink() ); ?>">
							<?php the_title(); ?>
						</a>
					</p>
				</div>
		<?php endwhile;
		else : ?>
			<p class="auto-search-no-results">
				<?php esc_html_e( 'No results found.', 'modus' ); ?>
			</p>
		<?php endif;
	}
	die();
}
add_action( 'wp_ajax_au_ajax_search_product', 'au_ajax_search_product' );
add_action( 'wp_ajax_nopriv_au_ajax_search_product', 'au_ajax_search_product' );

add_action( 'wp_ajax_modus_ajax_load_more', 'modus_ajax_load_more' );
add_action( 'wp_ajax_nopriv_modus_ajax_load_more', 'modus_ajax_load_more' ); 
function modus_ajax_load_more(){
	$modus_post_type = $_POST['modus_posttype'];
	$modus_tax = $_POST['modus_tax'];
	$modus_taxtype = $_POST['modus_taxtype'];
	$modus_layout = $_POST['modus_layout'];
    $modus_typeproduct = $_POST['modus_typeproduct'];
    $modus_typeitem = $_POST['modus_typeitem'];
    $modus_product_list = $_POST['modus_list'];
    $modus_product_grid = $_POST['modus_grid'];
    $modus_column = $_POST['modus_column'];
    $modus_typeList = $_POST['modus_typeList'];
    $modus_layout_masonry = $_POST['modus_layoutMasonry'];
	$modus_perpage = $_POST['modus_perpage'];
	$modus_currentpage = $_POST['modus_currentpage'];
    switch ( $modus_column ) {
        case '1':
            $col = 'col-xs-12 col-sm-12 col-md-12';
            break;
        case '2':
            $col = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $col = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $col = 'col-xs-12 col-sm-6 col-md-3';
            break;
        case '5':
            $col = 'col-xs-12 col-sm-15 col-md-15';
            break;
        case '6':
            $col = 'col-xs-12 col-sm-2 col-md-2';
            break;
        default:
            break;
    }
	if( $modus_post_type == "post"){
		if ( $modus_tax != '' ) :
            $args = array(
                'post_type' => 'post' ,
                'post_status' => 'publish',
                'posts_per_page' => $modus_perpage,
				'paged' => (int)$modus_currentpage + 1,
                'tax_query' => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => $modus_taxtype,
                        'field'    => 'slug',
                        'terms'    => $modus_tax,
                    ),
                ),
            );
        else :
            $args = array(
                'post_type' => 'post' ,
                'post_status' => 'publish',
                'posts_per_page' => $modus_perpage,
				'paged' => (int)$modus_currentpage + 1,
            );
        endif;
        $rquery_post = new Wp_Query( $args );

        /*Layout layout1*/
		if ( $modus_layout == 'list'){
			if ( $rquery_post->have_posts() ):
                $item_index = 0;
                while ( $rquery_post->have_posts() ) : $rquery_post->the_post();
                    $item_index ++;
                    if ( $modus_typeList == 'type1' ) :
                        if ( $item_index%2 == 0 ) $cl_event = 'even'; else $cl_event='odd';
                        ?>
                        <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
                            <article class="blog item-blog <?php echo esc_attr( $cl_event ); ?>">
                                <div class="text-left">
                                    <?php if ( $cl_event == 'odd' ) : ?>
                                        <?php if ( has_post_thumbnail() ) : ?>
                                            <div class="img-box">
                                                <?php the_post_thumbnail('full');?>
                                            </div>
                                        <?php endif; ?>
                                    <?php else : ?>
                                        <div class="blog-text">
                                            <div class="post-cat"><span class="before">&nbsp;</span><?php echo get_the_category_list( get_the_ID() ); ?><span class="after">&nbsp;</span></div>
                                            <div class="postTitle">
                                                <a href="<?php the_permalink();?>" title="<?php the_title(); ?>">
                                                    <h2><?php the_title(); ?></h2>
                                                    <span>&nbsp;</span>
                                                </a>
                                            </div>
                                            <div class="postContent">
                                                <?php echo content(22);?>
                                            </div>
                                            <a class="read-more" href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php echo esc_html__('Read more','modus'); ?></a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="text-right">
                                    <?php if ( $cl_event == 'even' ) : ?>
                                        <?php if ( has_post_thumbnail() ) : ?>
                                            <div class="img-box">
                                                <?php the_post_thumbnail('full');?>
                                            </div>
                                        <?php endif; ?>
                                    <?php else : ?>
                                        <div class="blog-text">
                                            <div class="post-cat"><span class="before">&nbsp;</span><?php echo get_the_category_list( get_the_ID() ); ?><span class="after">&nbsp;</span></div>
                                            <div class="postTitle">
                                                <a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><h2><?php the_title(); ?></h2><span>&nbsp;</span></a>
                                            </div>
                                            <div class="postContent">
                                                <?php echo content(22);?>
                                            </div>
                                            <a class="read-more" href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php echo esc_html__('Read more','modus'); ?></a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </article>
                        </div>
                        <?php
                    endif;
                    if ( $modus_typeList == 'type2' ) :
                        $archive_month = get_the_time('M');
                        $archive_day   = get_the_time('d');
                        $archive_year  = get_the_time('Y');
                        if ( $item_index == 1 ) echo '<div class="row">';
                        if ( ($item_index-1)%2 == 0 && $item_index > 2 ) echo '<div class="row">';
                            ?>
                            <div class="col-md-6 col-sm-6 col-lg-6">
                                <article class="blog item-blog type-2">
                                    <div class="img-box">
                                        <?php the_post_thumbnail();?>
                                    </div>
                                    <div class="blog-text">
                                        <div class="postTitle">
                                            <a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><h2><?php the_title(); ?></h2></a>
                                        </div>
                                        <div class="post-meta">
                                            <p><?php echo esc_html( $archive_month ); ?> <?php echo esc_html( $archive_day ); ?>, <?php echo esc_html( $archive_year ); ?>
                                            <a class="blog-read-more" href="<?php the_permalink();?>"><?php echo esc_html__('Read more','modus');?></a></p>
                                        </div>
                                    </div>
                                </article>
                            </div>
                            <?php
                        if ( $item_index == 2 ) echo '</div>';
                        if ( $item_index%2 == 0  && $item_index>2 ) echo '</div>';
                    endif;
                endwhile;
                if ( $modus_typeList == 'type2' ) :
                    if ( $item_index%2 != 0 ) echo '</div>';
                endif;
                wp_reset_postdata();
            endif;
		}
	}
    if( $modus_post_type == "product"){
        if ( $modus_layout == 'producttab-loadmore' ) :
            if ( $modus_typeproduct == 'new-product') {
                if ( $modus_tax == '' ){
                    $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $modus_perpage,
                        'paged' => (int)$modus_currentpage + 1,
                    );
                }else{
                    $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $modus_perpage,
                        'paged' => (int)$modus_currentpage + 1,
                        'tax_query' => array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'slug',
                                'terms'    => $modus_tax,
                            ),
                        ),
                    );
                }
            }elseif ( $modus_typeproduct == 'feature-product' ) {
                $product_visibility_term_ids = wc_get_product_visibility_term_ids();
                if ( $modus_tax== '' ) :
                    $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $modus_perpage,
                        'paged' => (int)$modus_currentpage + 1,
                        'tax_query'      => array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_visibility',
                                'field'    => 'term_taxonomy_id',
                                'terms'    => array( $product_visibility_term_ids['featured'] ),
                            ),
                            array(
                                'taxonomy' => 'product_visibility',
                                'field'    => 'term_taxonomy_id',
                                'terms'    => array( $product_visibility_term_ids['exclude-from-catalog'] ),
                                'operator' => 'NOT IN',
                            ),
                        ),
                        'orderby'    => 'date',
                    );
                else :
                    $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $modus_perpage,
                        'paged' => (int)$modus_currentpage + 1,
                        'tax_query'      => array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'slug',
                                'terms'    => $modus_tax,
                            ),
                            array(
                                'taxonomy' => 'product_visibility',
                                'field'    => 'term_taxonomy_id',
                                'terms'    => array( $product_visibility_term_ids['featured'] ),
                            ),
                            array(
                                'taxonomy' => 'product_visibility',
                                'field'    => 'term_taxonomy_id',
                                'terms'    => array( $product_visibility_term_ids['exclude-from-catalog'] ),
                                'operator' => 'NOT IN',
                            ),
                        )
                    );
                endif;
            }elseif ( $modus_typeproduct == 'sale-product' ){
                if ( $modus_tax == '' ) :
                    $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $modus_perpage,
                        'paged' => (int)$modus_currentpage + 1,
                        'meta_query'     => array(
                            'relation' => 'OR',
                            array( // Simple products type
                                'key'           => '_sale_price',
                                'value'         => 0,
                                'compare'       => '>',
                                'type'          => 'numeric'
                            ),
                            array( // Variable products type
                                'key'           => '_min_variation_sale_price',
                                'value'         => 0,
                                'compare'       => '>',
                                'type'          => 'numeric'
                            )
                        )
                    );
                else :
                    $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $modus_perpage,
                        'paged' => (int)$modus_currentpage + 1,
                        'tax_query' => array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'slug',
                                'terms'    => $modus_tax,
                            ),
                        ),
                        'meta_query'     => array(
                            'relation' => 'OR',
                            array( // Simple products type
                                'key'           => '_sale_price',
                                'value'         => 0,
                                'compare'       => '>',
                                'type'          => 'numeric'
                            ),
                            array( // Variable products type
                                'key'           => '_min_variation_sale_price',
                                'value'         => 0,
                                'compare'       => '>',
                                'type'          => 'numeric'
                            )
                        )
                    );
                endif;
            }else{
                $args = '';
            };
            $rquery = new Wp_Query($args);
            if ( $rquery -> have_posts() ) :
                $i_row = 0;
                while ( $rquery -> have_posts() ) : $rquery -> the_post();
                    $i_row++;
                    if ( $i_row == 1 ) echo '<div class="row">';
                    if ( ($i_row-1)%$modus_column == 0 && $i_row>$modus_column ) echo '<div class="row">';
                        ?>
                        <div class="<?php echo esc_attr( $col );?>">
                            <?php
                            if ( $modus_typeitem == 'list' ) :
                                if ( $modus_product_list == 'type1' )
                                    wc_get_template_part( 'content', 'product-list-1',array( 'show_rating' => true ) );
                                if ( $modus_product_list == 'type2' )
                                    wc_get_template_part( 'content', 'product-list-2',array( 'show_rating' => true ) );
                            endif;
                            if ( $modus_typeitem == 'grid' ) :
                                if ( $modus_product_grid == 'type1' )
                                    wc_get_template_part( 'content', 'product-grid',array( 'show_rating' => true ));
                                if ( $modus_product_grid == 'type2' )
                                    wc_get_template_part( 'content', 'product-grid-2',array( 'show_rating' => true ));
                                if ( $modus_product_grid == 'type3' )
                                    wc_get_template_part( 'content', 'product-grid-3',array( 'show_rating' => true ));
                                if ( $modus_product_grid == 'type4' )
                                    wc_get_template_part( 'content', 'product-grid-4',array( 'show_rating' => true ));
                                if ( $modus_product_grid == 'type5' )
                                    wc_get_template_part( 'content', 'product-grid-5',array( 'show_rating' => true ));
                                if ( $modus_product_grid == 'type6' )
                                    wc_get_template_part( 'content', 'product-grid-6',array( 'show_rating' => true ));
                                if ( $modus_product_grid == 'type7' )
                                    wc_get_template_part( 'content', 'product-grid-7',array( 'show_rating' => true ));
                            endif;
                            ?>
                        </div>
                        <?php
                        if ( $i_row == $modus_column ) echo '</div>';
                        if ( $i_row%$modus_column == 0 && $i_row>$modus_column ) echo '</div>';
                    endwhile;
                    if ( $i_row%$modus_column != 0 ) echo '</div>';
                    wp_reset_postdata();
                endif;
        endif;
        if ( $modus_layout == 'feature-product-more' ) :
            $product_visibility_term_ids = wc_get_product_visibility_term_ids();
            if ( $modus_tax == '' ) :
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => $modus_perpage,
                    'paged' => (int)$modus_currentpage + 1,
                    'tax_query'      => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'term_taxonomy_id',
                            'terms'    => array( $product_visibility_term_ids['featured'] ),
                        ),
                        array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'term_taxonomy_id',
                            'terms'    => array( $product_visibility_term_ids['exclude-from-catalog'] ),
                            'operator' => 'NOT IN',
                        ),
                    )
                );
            else :
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => $modus_perpage,
                    'paged' => (int)$modus_currentpage + 1,
                    'tax_query'      => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'slug',
                            'terms'    => $modus_tax,
                        ),
                        array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'term_taxonomy_id',
                            'terms'    => array( $product_visibility_term_ids['featured'] ),
                        ),
                        array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'term_taxonomy_id',
                            'terms'    => array( $product_visibility_term_ids['exclude-from-catalog'] ),
                            'operator' => 'NOT IN',
                        ),
                    )
                );
            endif;
            $rquery = new Wp_Query( $args );
            switch ( $modus_column ) {
                case '1':
                    $cl_class = 'col-xs-12 col-sm-12 col-md-12';
                    break;
                case '2':
                    $cl_class = 'col-xs-12 col-sm-6 col-md-6';
                    break;
                case '3':
                    $cl_class = 'col-xs-12 col-sm-4 col-md-4';
                    break;
                case '4':
                    $cl_class = 'col-xs-12 col-sm-6 col-md-3';
                    break;

                default:
                    $cl_class = '';
                    break;
            }
            if ( $rquery -> have_posts() ) :
                echo '<div class="row">';
                while ( $rquery -> have_posts() ) : $rquery -> the_post();
                ?>
                    <div class="<?php echo esc_attr($cl_class); ?>">
                        <div class="item-grid grid-type-4">
                        <?php
                            wc_get_template_part( 'template-parts/content', 'product-feature' );
                        ?>
                        </div>
                    </div>
                    <?php
                endwhile;
                echo '</div>';
                wp_reset_postdata();
            endif;
        endif;
    }
    /**Portfolio Tab**/

    else if( $modus_post_type == "portfolio"){
        if ( $modus_tax == '' ) :
            $args = array(
                'post_type' => 'portfolio',
                'post_status' => 'publish',
                'posts_per_page' => $modus_perpage,
                'paged' => (int)$modus_currentpage + 1,
                'order'   => 'DESC',
            );
        else :
            $args = array(
                'post_type' => 'portfolio',
                'post_status' => 'publish',
                'posts_per_page' => $modus_perpage,
                'paged' => (int)$modus_currentpage + 1,
                'tax_query' => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'portfolio_cat',
                        'field'    => 'slug',
                        'terms'    => $modus_tax,
                    ),
                ),
            );
        endif;
        $rquery_post = new Wp_Query( $args );
        $cl_item = 'col-xs-12 col-sm-3 col-md-3';
        switch ($modus_column) {
            case '2':
                $cl_item = 'col-md-6 col-sm-6 col-xs-12';
                break;
            case '3':
                $cl_item = 'col-md-4 col-sm-4 col-xs-12';
                break;
            case '4':
                $cl_item = 'col-md-3 col-sm-3 col-xs-12';
                break;
             case '6':
                $cl_item = 'col-md-2 col-sm-2 col-xs-12';
                break;
            default:
                $cl_item = 'col-md-6 col-sm-6 col-xs-12';
        }
		while ( $rquery_post -> have_posts() ) : $rquery_post -> the_post();
            $modus_portfolio_cat = get_the_terms( get_the_ID(),'portfolio_cat');
            $count = count( $modus_portfolio_cat );
            $i = 0;
            $filter_name = $filter_slug = '';
            if ( $modus_portfolio_cat != '' ):
                foreach($modus_portfolio_cat as $term){
                    $i++;
                    $term_link = get_term_link( $term );
                    $filter_slug .= $term-> slug.' ';
                    $filter_name .= '<li><a href="'.$term_link.'">'.$term-> name.'</a></li>';
                    if ( $count != $i ) {
                        $filter_name .= '&sbquo; ';
                    }
                    else {
                        $filter_name .= '';
                    }
                }
            endif;
			?>
				<div class="<?php echo esc_attr($cl_item); ?>">
					<div class="item-portfolio">
						<?php  the_post_thumbnail( 'full' );?>
						<div class="box-holder">
							<div class="box-holder-content">
								<span><?php the_title();?></span>
								<ul class="cat_portfolio">
									<?php echo wp_kses_post($filter_name); ?>
								</ul>
								<a class="md-linkto" href="<?php the_permalink();?>"><i class="Pe-icon-7-stroke-link"></i></a>
							</div>
						</div>
					</div>
				</div>
			<?php
        endwhile;
    }
     /**End Portfolio Tab**/
	exit();
}
 