<?php
/**
 * Register styles, scripts
 */
function modus_theme_styles() {
	return array(
		'bootstrap'        		=> MODUS_DIR_URI . '/assets/css/bootstrap.min.css',
		'font-awesome'        	=> MODUS_DIR_URI . '/assets/css/font-awesome.min.css',
		'pe-icon'        		=> MODUS_DIR_URI . '/assets/css/Pe-icon-7-stroke.min.css',
        'pe-filled'             => MODUS_DIR_URI . '/assets/css/pe-icon-7-filled.min.css',
		'pe-icon-social'        => MODUS_DIR_URI . '/assets/css/pe-icon-social.min.css',
        'theme'                 => MODUS_DIR_URI . '/assets/css/style.min.css',
		'theme-rtl'        		=> MODUS_DIR_URI . '/assets/css/style-rtl.min.css',
        'theme-fonts'           => MODUS_DIR_URI . '/assets/css/fonts.min.css',
        'modus-icon'            => MODUS_DIR_URI . '/assets/css/modus-icomoon.min.css',
		'flexslider'            => MODUS_DIR_URI . '/assets/css/flexslider.min.css',
        'fancybox'              => MODUS_DIR_URI . '/assets/css/jquery.fancybox.min.css',
	);
}
function modus_theme_scripts() {
	return array(
		'jquery'                 	=> MODUS_DIR_URI . '/assets/js/jquery.js',
		'bootstrap'              	=> MODUS_DIR_URI . '/assets/js/bootstrap.min.js',
		'countdownTimer'            => MODUS_DIR_URI . '/assets/js/jquery.countdownTimer.min.js',
		'slick'                 	=> MODUS_DIR_URI . '/assets/js/slick.min.js',
        'animate'                   => MODUS_DIR_URI . '/assets/js/wow.min.js',
        'isotop'                    => MODUS_DIR_URI . '/assets/js/isotope.pkgd.min.js',
		'main'                      => MODUS_DIR_URI . '/assets/js/jquery.main.min.js',
		'custom'                  	=> MODUS_DIR_URI . '/assets/js/custom.min.js',
		'map'                  		=> MODUS_DIR_URI . '/assets/js/modus_map.min.js',
		'jquery-flexslider'         => MODUS_DIR_URI . '/assets/js/jquery.flexslider-min.js', 
		'carousel'                  => MODUS_DIR_URI . '/assets/js/owl.carousel.min.js',
        'fancybox'                  => MODUS_DIR_URI . '/assets/js/jquery.fancybox.min.js',
	);
}
function modus_post_nagivation( $args ) {
    global $post;
    $default = array(
        'post_type_link'    => '',
        'container_class'   => '',
        'prev_link_class'   => '',
        'next_link_class'   => '',
        'prev_link_before'  => '',
        'next_link_after'   => ''
    );

    $args = array_merge( $default, $args );
    if ( '' != $args['prev_link_class'] ) {
        $args['prev_link_class'] = ' class="' . $args['prev_link_class'] . '"';
    }
    if ( '' != $args['next_link_class'] ) {
        $args['next_link_class'] = ' class="' . $args['next_link_class'] . '"';
    }

    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous )
        return;
    ?>
    <nav class="navigation post-navigation">
        <div class="nav-links clearfix <?php echo esc_attr($args['container_class']); ?>">
            <?php
            $prev_post = get_previous_post();
            if (!empty( $prev_post )): ?>
              <a <?php echo wp_kses_post($args['prev_link_class']); ?>
                href="<?php echo get_permalink( $prev_post->ID ); ?>"><?php
                    echo wp_kses_post($args['prev_link_before']);?></a>
            <?php endif; ?>
            <a href="<?php echo esc_url($args[ 'post_type_link' ]) ?>" class="dashboard"><i class="fa fa-th-large" aria-hidden="true"></i></a>
            <?php
            $next_post = get_next_post();
            if ( is_a( $next_post , 'WP_Post' ) ) { ?>
              <a <?php echo wp_kses_post($args['next_link_class']); ?>
                href="<?php echo get_permalink( $next_post->ID ); ?>"><?php
                    echo wp_kses_post($args['next_link_after']); ?></a>
            <?php } ?>

            </div><!-- .nav-links -->
    </nav><!-- .navigation -->
    <?php
}
function modus_get_term_posttype( $post_id, $posttype ) {
        $results = '';
        $terms = get_the_terms( $post_id, $posttype );
        $d=0;
        if ($terms !=''):
			foreach ($terms as $key => $value) {
					# code...
					if ($d != 0){
							$results .= '<a href="' . get_term_link( $value->term_id, $posttype ) . '" >';
							$results .= ', '.$value->name ;
							$results .='</a>';
					}else{
							$results .= '<a href="' . get_term_link( $value->term_id, $posttype ) . '" >';
							$results .= $value->name ;
							$results .='</a>';
					}
					$d++;
			}
        endif;
        return $results;
}

function modus_loader(){
	$modus_config = modus_settings();
	if(isset($modus_config ['modus_preload']) && $modus_config ['modus_preload'] == 'show'){
		?>
		<div class="loaderWrap"> 
            <div id="loader"> 
			<?php if (isset($modus_config ['modus_preload_style']) && $modus_config['modus_preload_style'] == 'style_1'): ?>
                <div class="thecube">
    				<div class="cube c1"></div>
    				<div class="cube c2"></div>
    				<div class="cube c4"></div>
    				<div class="cube c3"></div>
    			</div>
             <?php elseif (isset($modus_config ['modus_preload_style']) && $modus_config['modus_preload_style'] == 'style_2'): ?>
                <div class="loader-dot"></div>
		    <?php else: ?>
                <div class="preloader8">
                    <span></span>
                    <span></span>
                </div>
            <?php endif ?>
            </div> 
        </div> 
	<?php
    }
}
function modus_post_comment() {
    if( comments_open() || get_comments_number() ) {
        return true;
    }else{
        return false;
    }
}
function modus_gallery_image_portfolio( $post_id ){
    $portfolio_gallery_id = get_post_meta($post_id, 'portfolio_gallery_id', true);
    $portfolio_gallery_id = explode (',',$portfolio_gallery_id);
    if ( is_array($portfolio_gallery_id) && count($portfolio_gallery_id) > 0 && $portfolio_gallery_id[0] != '' ):
        ?>
        <div class="slide-gallery_image_portfolio">
            <div class="beans-stepslider" data-rotate="true">
                <div class="beans-mask">
                    <div class="beans-slideset">
                        <?php
                        if ( has_post_thumbnail() ) {
                            echo '<div class="beans-slide">';
                            the_post_thumbnail('full');
                            echo '</div>';
                        }
                        foreach( $portfolio_gallery_id as $key => $value ) :
                            $image = wp_get_attachment_image_src( (int)$value, 'full' );
                            ?>
                            <div class="beans-slide">
                                <img class="image-preview" src="<?php echo esc_url( $image[0] ); ?>" alt="image"/>
                            </div>
                            <?php
                        endforeach;
                        ?>
                    </div>
                </div>
                <div class="beans-pagination">
                    <!-- pagination generated here -->
                </div>
                <a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
            </div>
        </div>
        <?php
    else:
        if ( has_post_thumbnail() ) {
            the_post_thumbnail('full');
        }
    endif;
}