<?php
//Saves new custom options for navigation
add_action('wp_update_nav_menu_item', 'modus_custom_nav_update', 10, 3);

function modus_custom_nav_update($menu_id, $menu_item_db_id, $args) {
    $use_megamenu = isset($_POST['menu-item-use_megamenu'][$menu_item_db_id]) ? 1 : 0;
    update_post_meta($menu_item_db_id, '_menu_item_use_megamenu', $use_megamenu);
    $mega_layout = isset($_POST['menu-item-mega_layout'][$menu_item_db_id]) ? $_POST['menu-item-mega_layout'][$menu_item_db_id] : 'default';
    update_post_meta($menu_item_db_id, '_menu_item_mega_layout', $mega_layout);
	$mega_width=isset($_POST['menu-item-mega_width'][$menu_item_db_id]) ?  $_POST['menu-item-mega_width'][$menu_item_db_id] : 900;
	update_post_meta($menu_item_db_id, '_menu_item_mega_width', $mega_width);
    if(isset($_POST['menu-item-mega_item'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_menu_item_mega_item', $_POST['menu-item-mega_item'][$menu_item_db_id]);
    }
    if ( ! empty( $_POST['menu-item-iconfont'][ $menu_item_db_id ] )) {
		update_post_meta( $menu_item_db_id, '_menu_item_modus_mega_menu_iconfont', $_POST['menu-item-iconfont'][ $menu_item_db_id ]  );
	} else {
		delete_post_meta( $menu_item_db_id, '_menu_item_modus_mega_menu_iconfont' );
	}
	$check = array('modus_mega_menu_iconfont_position');

    foreach ( $check as $key ) {
        if (isset($_POST['menu-item-'.$key][$menu_item_db_id])){
            update_post_meta( $menu_item_db_id, '_menu_item_'.$key, $_POST['menu-item-'.$key][$menu_item_db_id]);
        }
        else{
            delete_post_meta( $menu_item_db_id, '_menu_item_'.$key );
        }
    } 	
}

//Adds value of custom option to $item object that will be passed to modus_Walker_Nav_Menu_Edit
add_filter('wp_setup_nav_menu_item', 'modus_custom_nav_item');

function modus_custom_nav_item($menu_item) {
	if(isset($menu_item->ID)){
		$menu_item->use_megamenu = get_post_meta($menu_item->ID, '_menu_item_use_megamenu', true);
		$menu_item->mega_item = get_post_meta($menu_item->ID, '_menu_item_mega_item', true); 
		$menu_item->mega_layout = get_post_meta($menu_item->ID, '_menu_item_mega_layout', true);
		$menu_item->mega_width = get_post_meta($menu_item->ID, '_menu_item_mega_width', true);
		$menu_item->modus_mega_menu_iconfont = get_post_meta( $menu_item->ID, '_menu_item_modus_mega_menu_iconfont', true );
		$menu_item->modus_mega_menu_iconfont_position = get_post_meta( $menu_item->ID, '_menu_item_modus_mega_menu_iconfont_position', true );
    }
    return $menu_item;
}

add_filter('wp_edit_nav_menu_walker', 'modus_custom_nav_edit_walker', 10, 2);

function modus_custom_nav_edit_walker($walker, $menu_id) {
    return 'Modus_Walker_Nav_Menu_Edit';
}
//Add menu item options
if (!class_exists('Modus_Walker_Nav_Menu_Edit')) {
    
    function modus_get_megamenu() {
		$arg_mega_menu = array('post_type'=> 'arr_megamenu','posts_per_page'=> -1);
		$mymega_menu = get_posts( $arg_mega_menu );
        return  $mymega_menu;
    }

    class Modus_Walker_Nav_Menu_Edit extends Walker_Nav_Menu {
		public function start_lvl( &$output, $depth = 0, $args = array() ) {}

		public function end_lvl( &$output, $depth = 0, $args = array() ) {}
			
		public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			global $_wp_nav_menu_max_depth;
			$_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;

			ob_start();
			$item_id = esc_attr( $item->ID );
			$removed_args = array(
				'action',
				'customlink-tab',
				'edit-menu-item',
				'menu-item',
				'page-tab',
				'_wpnonce',
			);
			$default_mega_menu_fields = array(
				'modus_mega_menu_iconfont' => '',
			);
			$original_title = '';
			if ( 'taxonomy' == $item->type ) {
				$original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
				if ( is_wp_error( $original_title ) )
					$original_title = false;
			} elseif ( 'post_type' == $item->type ) {
				$original_object = get_post( $item->object_id ); 
				$original_title = isset( $original_object->post_title ) ? $original_object->post_title : '';
			}

			$classes = array(
				'menu-item menu-item-depth-' . $depth,
				'menu-item-' . esc_attr( $item->object ),
				'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
			);

			$title = $item->title;
			if ( ! empty( $item->_invalid ) ) {
				$classes[] = 'menu-item-invalid';
				/* translators: %s: title of menu item which is invalid */
				$title = sprintf( esc_html__( '%s (Invalid)', 'modus' ), $item->title );
			} elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
				$classes[] = 'pending';
				/* translators: %s: title of menu item in draft status */
				$title = sprintf( esc_html__('%s (Pending)', 'modus'), $item->title );
			}

			$title = ( ! isset( $item->label ) || '' == $item->label ) ? $title : $item->label;

			$submenu_text = '';
			if ( 0 == $depth )
				$submenu_text = 'style="display: none;"';

			?>
			<li id="menu-item-<?php echo esc_attr($item_id); ?>" class="<?php echo implode(' ', $classes ); ?>">
				<div class="menu-item-bar">
					<div class="menu-item-handle">
						<span class="item-title"><span class="menu-item-title"><?php echo esc_html( $title ); ?></span> <span class="is-submenu" <?php echo esc_attr($submenu_text); ?>><?php echo esc_html__( 'sub item','modus' ); ?></span></span>
						<span class="item-controls">
							<span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
							<span class="item-order hide-if-js">
								<a href="<?php
									echo wp_nonce_url(
										add_query_arg(
											array(
												'action' => 'move-up-menu-item',
												'menu-item' => $item_id,
											),
											remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
										),
										'move-menu_item'
									);
								?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up','modus'); ?>">&#8593;</abbr></a>
								|
								<a href="<?php
									echo wp_nonce_url(
										add_query_arg(
											array(
												'action' => 'move-down-menu-item',
												'menu-item' => $item_id,
											),
											remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
										),
										'move-menu_item'
									);
								?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down','modus'); ?>">&#8595;</abbr></a>
							</span>
							<a class="item-edit" id="edit-<?php echo esc_attr($item_id); ?>" title="<?php esc_attr_e('Edit Menu Item','modus'); ?>" href="<?php
								echo ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? admin_url( 'nav-menus.php' ) : add_query_arg( 'edit-menu-item', $item_id, remove_query_arg( $removed_args, admin_url( 'nav-menus.php#menu-item-settings-' . $item_id ) ) );
							?>"><?php echo esc_html__( 'Edit Menu Item','modus' ); ?></a>
						</span>
					</div>
				</div>

				<div class="menu-item-settings  wp-clearfix" id="menu-item-settings-<?php echo esc_attr($item_id); ?>">
					<?php if ( 'custom' == $item->type ) : ?>
						<p class="field-url description description-wide">
							<label for="edit-menu-item-url-<?php echo esc_attr($item_id); ?>">
								<?php echo esc_html__( 'URL','modus' ); ?><br />
								<input type="text" id="edit-menu-item-url-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
							</label>
						</p>
					<?php endif; ?>
					<p class="description description-wide">
						<label for="edit-menu-item-title-<?php echo esc_attr($item_id); ?>">
							<?php echo esc_html__( 'Navigation Label','modus' ); ?><br />
							<input type="text" id="edit-menu-item-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
						</label>
					</p>
					<p class="field-title-attribute description description-wide">
						<label for="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>">
							<?php echo esc_html__( 'Title Attribute','modus' ); ?><br />
							<input type="text" id="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->post_excerpt ); ?>" />
						</label>
					</p>
					<p class="field-link-target description">
						<label for="edit-menu-item-target-<?php echo esc_attr($item_id); ?>">
							<input type="checkbox" id="edit-menu-item-target-<?php echo esc_attr($item_id); ?>" value="_blank" name="menu-item-target[<?php echo esc_attr($item_id); ?>]"<?php checked( $item->target, '_blank' ); ?> />
							<?php echo esc_html__( 'Open link in a new window/tab','modus' ); ?>
						</label>
					</p>
					<p class="field-css-classes description description-thin">
						<label for="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>">
							<?php echo esc_html__( 'CSS Classes (optional)','modus' ); ?><br />
							<input type="text" id="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
						</label>
					</p>
					<p class="field-xfn description description-thin">
						<label for="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>">
							<?php echo esc_html__( 'Link Relationship (XFN)','modus' ); ?><br />
							<input type="text" id="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
						</label>
					</p>
					<p class="field-description description description-wide">
						<label for="edit-menu-item-description-<?php echo esc_attr($item_id); ?>">
							<?php echo esc_html__( 'Description','modus' ); ?><br />
							<textarea id="edit-menu-item-description-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo esc_attr($item_id); ?>]"><?php echo esc_html( $item->description ); // textarea_escaped ?></textarea>
							<span class="description"><?php echo esc_html__('The description will be displayed in the menu if the current theme supports it.','modus'); ?></span>
						</label>
					</p>
					<p class="field-modus-iconfont description description-wide">
						<label>
							<?php echo esc_html__('Icon Font Class','modus'); ?><br />
				            <input type="text" id="edit-menu-item-iconfont-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-iconfont"
				                <?php if (esc_attr( $item->modus_mega_menu_iconfont )) : ?>
				                    name="menu-item-iconfont[<?php echo esc_attr($item_id); ?>]"
				                <?php endif; ?>
				                   data-name="menu-item-iconfont[<?php echo esc_attr($item_id); ?>]"
				                   value="<?php echo esc_attr( $item->modus_mega_menu_iconfont ); ?>" />				
						</label>
					</p>
					<p class="description description-wide">
						<?php echo esc_html__('Icon Position: ','modus'); ?>
						<select name="menu-item-modus_mega_menu_iconfont_position[<?php echo esc_attr($item_id); ?>]" id="edit-menu-item-modus_mega_menu_iconfont_position-<?php echo esc_attr($item_id); ?>">
							<?php 
							$modus_menu_icon_pos = array( 
								esc_html__('left','modus') => 'left',
								esc_html__('top','modus') => 'top', 
							);
							foreach( $modus_menu_icon_pos as $title=>$value): ?>
								<option value="<?php echo esc_attr($value); ?>" <?php selected($value, $item->modus_mega_menu_iconfont_position); ?>><?php echo esc_html($title); ?></option>
							<?php endforeach; ?>
						</select>
					</p>				
					<?php
					/*
					 * Add custom options
					 */
					?>  
					<div class="wrap-custom-options-level0-<?php echo esc_attr($item_id); ?>" style="<?php echo esc_attr($depth == 0 ? 'display:block;' : 'display:none;') ?>">
						<p class="description">
							<label for="edit-menu-item-use_megamenu-<?php echo esc_attr($item_id); ?>">
								<input type="checkbox" id="edit-menu-item-use_megamenu-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-use_megamenu" 
									name="menu-item-use_megamenu[<?php echo esc_attr($item_id); ?>]" 
									data-name="menu-item-use_megamenu[<?php echo esc_attr($item_id); ?>]"
									value="1" <?php echo esc_attr($item->use_megamenu && $item->use_megamenu == 1 ? 'checked' : '') ?> />
								<?php echo esc_html__('Mega menu', 'modus'); ?>
							</label>
						</p>
						<?php $mega_items = modus_get_megamenu(); ?>
						<div class="wrap-custom-image wrap-custom-image-<?php echo esc_attr($item_id); ?>"  style="<?php echo !($item->use_megamenu && $item->use_megamenu == 1) ? 'display:none;' : '' ?>">
							<p class="description" id="wrap-edit-menu-item-mega_item-<?php echo esc_attr($item_id) ?>">
								<label for="edit-menu-item-mega_item-<?php echo esc_attr($item_id); ?>">
									<?php echo esc_html__('Display Content of panel columns', 'modus'); ?>
									<select id="edit-menu-item-mega_item-<?php echo esc_attr($item_id); ?>" class="edit-menu-item-mega_item" name="menu-item-mega_item[<?php echo esc_attr($item_id); ?>]" data-name="menu-item-mega_item[<?php echo esc_attr($item_id); ?>]">
										<?php foreach($mega_items as $post): ?>
										<option value="<?php echo esc_attr($post->ID) ?>" <?php echo esc_attr($item->mega_item && $item->mega_item == $post->ID) ? 'selected' : '' ?>><?php echo esc_html($post->post_title) ?></option>
										<?php endforeach; ?>
									</select>
								</label>
							</p>
							<p class="description" id="wrap-edit-menu-item-mega_layout-<?php echo esc_attr($item_id) ?>">
								<label for="edit-menu-item-mega_layout-<?php echo esc_attr($item_id); ?>">
									<?php echo esc_html__('Full Width', 'modus'); ?> 
									<select id="edit-menu-item-mega_layout-<?php echo esc_attr($item_id); ?>" class="edit-menu-item-mega_layout" name="menu-item-mega_layout[<?php echo esc_attr($item_id); ?>]" data-name="menu-item-mega_layout[<?php echo esc_attr($item_id); ?>]"> 
										<option value="default" <?php echo esc_attr($item->mega_layout && $item->mega_layout == 'default') ? 'selected' : '' ?>><?php echo esc_html__('Default','modus') ?></option> 
										<option value="fullwidth" <?php echo esc_attr($item->mega_layout && $item->mega_layout == 'fullwidth') ? 'selected' : '' ?>><?php echo esc_html__('Full Width','modus') ?></option> 
									</select>
								</label>
							</p>	
							<?php if($item->mega_layout && $item->mega_layout == 'fullwidth') $hidden = 'hidden'; else $hidden =''; ?>
							<p class="description <?php echo esc_attr($hidden); ?> wrap-edit-menu-item-mega_width" id="wrap-edit-menu-item-mega_width-<?php echo esc_attr($item_id) ?>">
								<label for="edit-menu-item-mega_width-<?php echo esc_attr($item_id); ?>">
									<?php echo esc_html__('Menu width', 'modus'); ?>
									<input type="number" id="edit-menu-item-mega_width-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-mega_width"  name="menu-item-mega_width[<?php echo esc_attr($item_id); ?>]"data-name="menu-item-mega_width[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item -> mega_width) ?>"/>
								</label>
							</p>					                                                
						</div>
					</div>  
					<p class="field-move hide-if-no-js description description-wide">
						<label>
							<span><?php echo esc_html__( 'Move', 'modus' ); ?></span>
							<a href="#" class="menus-move menus-move-up" data-dir="up"><?php echo esc_html__( 'Up one', 'modus' ); ?></a>
							<a href="#" class="menus-move menus-move-down" data-dir="down"><?php echo esc_html__( 'Down one', 'modus' ); ?></a>
							<a href="#" class="menus-move menus-move-left" data-dir="left"></a>
							<a href="#" class="menus-move menus-move-right" data-dir="right"></a>
							<a href="#" class="menus-move menus-move-top" data-dir="top"><?php echo esc_html__( 'To the top', 'modus' ); ?></a>
						</label>
					</p>

					<div class="menu-item-actions description-wide submitbox">
						<?php if ( 'custom' != $item->type && $original_title !== false ) : ?>
							<p class="link-to-original">
								<?php printf( esc_html__('Original: %s', 'modus'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
							</p>
						<?php endif; ?>
						<a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr($item_id); ?>" href="<?php
						echo wp_nonce_url(
							add_query_arg(
								array(
									'action' => 'delete-menu-item',
									'menu-item' => esc_attr($item_id),
								),
								admin_url( 'nav-menus.php' )
							),
							'delete-menu_item_' . esc_attr($item_id)
						); ?>"><?php echo esc_html__( 'Remove', 'modus' ); ?></a> <span class="meta-sep hide-if-no-js"> | </span> <a class="item-cancel submitcancel hide-if-no-js" id="cancel-<?php echo esc_attr($item_id); ?>" href="<?php echo esc_url( add_query_arg( array( 'edit-menu-item' => $item_id, 'cancel' => time() ), admin_url( 'nav-menus.php' ) ) );
							?>#menu-item-settings-<?php echo esc_attr($item_id); ?>"><?php echo esc_html__('Cancel', 'modus'); ?></a>
					</div>

					<input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item_id) ?>" />
					<input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" />
					<input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->object ); ?>" />
					<input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" />
					<input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" />
					<input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->type ); ?>" />
				</div><!-- .menu-item-settings-->
				<ul class="menu-item-transport"></ul>
			<?php
			$output .= ob_get_clean();
		}
    }

}

//Primary menu
if (!class_exists('Modus_Sublevel_Walker')) {

    class Modus_Sublevel_Walker extends Walker_Nav_Menu {

        public function start_lvl(&$output, $depth = 0, $args = array()) {
            $indent = str_repeat("\t", $depth);
            $output .= "\n$indent<ul class=\"children sub-menu dropdown-menu\">\n";
        } 
        public function end_lvl(&$output, $depth = 0, $args = array()){
		        $indent = str_repeat("\t", $depth); 
		        $output .= "$indent</ul>\n";
		}
        public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
            $indent = ( $depth ) ? str_repeat("\t", $depth) : '';
            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;

			if(isset($item->modus_mega_menu_iconfont_position) && $item->modus_mega_menu_iconfont_position=='top'){
				$classes[] = ' menu_icon_top ';
			} 
            if($item->use_megamenu && $depth == 0) {
                $classes[] = 'megamenu';
            } 
            $parent_use_megamenu = false; 
            
            if($args->has_children){
                $classes[] = 'page_item_has_children';
            }
            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args, $depth));
            $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';

            $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args, $depth);
            $id = $id ? ' id="' . esc_attr($id) . '"' : '';
			if($depth == 1) { 
				$parent_use_megamenu = get_post_meta($item->menu_item_parent, '_menu_item_use_megamenu', true); 
				
				$output .= $indent . '<li' . $id . $class_names . '>';
				
			}else{
				$output .= $indent . '<li' . $id . $class_names . '>';
			}

            $atts = array();
            $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';
            $atts['href'] = !empty($item->url) ? $item->url : '';
            
            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);

            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $value = ( 'href' === $attr ) ? esc_url($value) : esc_attr($value);
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }
			$icon =  '';
			if(isset($item->modus_mega_menu_iconfont) && $item->modus_mega_menu_iconfont!=''){
				$icon = wp_kses('<i class="icons-menu '.esc_html($item->modus_mega_menu_iconfont).'"></i>',array(
						'i'=> array(
								'class'=> array(),
							),
					));
			}
			$title = $icon.apply_filters( 'the_title', $item->title, $item->ID );
			$title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );
            $item_output = $args->before;
            if($item->use_megamenu && $depth == 0 ) {
				$item_output .= '<a' . $attributes . '>';
				$item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after; 
				$item_output .= '</a>'; 
				$mega_item = get_post_meta($item->ID, '_menu_item_mega_item', true);
				$post_content = get_post($mega_item);
				$content = $post_content->post_content;
				$content = apply_filters('the_content',$content);
				
				if(!get_post_meta( (int)$mega_item, '_wpb_shortcodes_custom_css', true )){
					 
				}else{
					$post_custom_css = get_post_meta( (int)$mega_item, '_wpb_shortcodes_custom_css', true );
					$post_custom_css = strip_tags( $post_custom_css );
					$mega_css = '<style type="text/css" data-type="vc_custom-css">';
					$mega_css .= $post_custom_css;
					$mega_css .= '</style>'; 
				}  
				if($item->mega_layout=='fullwidth'){
					$item_output .= '<div class="menu_fullwidth megamenu_sub"><div class="container">'. $content .'</div></div>';
				}else{
					$width = $item->mega_width;
					$data_width =  $item->mega_width ;
					$item_output .= '<div class="megamenu_sub megamenu_right" data-width="'. $data_width .'">'. $content .'</div>';
				}
			}else if($depth == 1) { 
					$parent_use_megamenu = get_post_meta($item->menu_item_parent, '_menu_item_use_megamenu', true);
                    $parent_mega_item = get_post_meta($item->menu_item_parent, '_menu_item_mega_item', true);
                    
						$item_output .= '<a' . $attributes . '>';  
						$item_output .= $args->link_before . $title . $args->link_after;
						$item_output .= '</a>'; 
					
            }else{
				$item_output .= '<a' . $attributes . '>';  
				$item_output .= $args->link_before . $title . $args->link_after;
				$item_output .= '</a>'; 
			}
            $item_output .= $args->after;

            $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);

        }
        public function display_element( $element, &$children_elements, $max_depth, $depth=0, $args, &$output ) {
            $id_field = $this->db_fields['id'];
            if ( is_object( $args[0] ) ) {
                $args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
            }
            return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
        }

    }

}
