<?php

/**
 * Modus Settings Options
 */
if (!class_exists('Framework_Modus_Settings')) {

    class Framework_Modus_Settings {

        public $ReduxFramework;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if (true == Redux_Helpers::isTheme(__FILE__)) {
                $this->initSettings();
            } else {
                add_action('plugins_loaded', array($this, 'initSettings'), 10);
            }
        }

        public function initSettings() {
            $this->ReduxFramework = new ReduxFramework($this->modus_get_setting_sections(), $this->modus_get_setting_arguments());
        }


        public function modus_get_setting_sections() {
			global $modus_social_array;
			$modus_social_array=array(
				'facebook' 			=>'Facebook',
				'twitter' 			=>'Twitter',
				'google-plus' 		=>'Google Plus',
				'pinterest' 		=>'Pinterest',
				'instagram' 		=>'Instagram',
				'dribbble' 			=>'Dribbble',
				'flickr' 			=>'Flickr',
				'linkedin' 			=>'Linkedin',
				'behance' 			=>'Behance',
				'youtube' 			=>'YouTube',
			);
			$modus_social_share_array=array(
				'digg' 				=>'Digg',
				'facebook' 			=>'Facebook',
				'google-plus' 		=>'Google Plus',
				'linkedin' 			=>'Linkedin',
				'pinterest' 		=>'Pinterest',
				'reddit' 			=>'Reddit',
				'stumbleUpon' 		=>'StumbleUpon',
				'tumblr' 			=>'Tumblr',
				'twitter' 			=>'Twitter',
				'vk' 				=>'VK',
			);
			$header_option = array('header_1' => 'Header Layout 1','header_2' => 'Header Layout 2','header_3' => 'Header Layout 3','header_4' => 'Header Layout 4','header_5' => 'Header Layout 5','header_6' => 'Header Layout 6','header_7' => 'Header Layout 7','header_8' => 'Header Layout 8','header_9' => 'Header Layout 9','header_10' => 'Header Layout 10' , 'header_11' => 'Header Layout 11');
			$footer_layout_option = array('footer_1' => 'Footer Layout 1','footer_2' => 'Footer Layout 2','footer_3' => 'Footer Layout 3','footer_4' => 'Footer Layout 4','footer_5' => 'Footer Layout 5','footer_6' => 'Footer Layout 6','footer_7' => 'Footer Layout 7','footer_8' => 'Footer Layout 8','footer_9' => 'Footer Layout 9','footer_10' => 'Footer Layout 10','footer_11' => 'Footer Layout 11');
			if ( class_exists('Modus_import_demo') ){
				$sections[] = array(
					'icon' => 'el-icon-cog',
					'icon_class' => 'icon',
					'title' => esc_html__('Demo', 'modus'),
					'fields' => array(
						array(
							'id'=>'import-demo',
							'type' => 'info',
							'title' => esc_html__('Import Demo', 'modus'),
							'desc' => '<br/><strong>'.esc_html__('If import failed, please check your site and click "Import" again.', 'modus') . '</strong>',
							'notice' => false
						),

						array(
							'id'        => 'import-demo-success',
							'type'      => 'raw',
							'content'   => (isset($_GET['import_options_success'])?'<strong>' . esc_html__('Successfully Imported!', 'modus') . '</strong><br/><br/>':'').'<a href="#" id="btn_import" class="button button-primary">' . esc_html__('Import', 'modus') . '</a>'
						),
					)
				);
			}
			$sections[] = array(
				'icon' => 'el-icon-dashboard',
				'icon_class' => 'icon',
				'title' => esc_html__('General', 'modus'),
				'fields' => array(
					//-- Pre load
					array(
						'id'            => 'modus_preload',
						'type'          => 'button_set',
						'title'         => esc_html__('Pre load', 'modus'),
						'options'       => array(
							'show'  => esc_html__( 'Enable Preload', 'modus' ),
							'hide'  => esc_html__( 'Disable Preload', 'modus' ),
						),
						'default'       => 'show',
					),
					array(
						'id'            => 'modus_preload_style',
						'type'          => 'button_set',
						'title'         => esc_html__('Pre load style', 'modus'),
						'options'       => array(
							'style_1'  => esc_html__( 'Style 1', 'modus' ),
							'style_2'  => esc_html__( 'Style 2', 'modus' ),
							'style_3'  => esc_html__( 'Style 3', 'modus' ),
						),

						'default'       => 'style_1',
						'required'  =>  array('modus_preload','=','show')
					),
					//-- Body background
					array(
						'id'            => 'basic_background_color',
						'type'          => 'color',
						'title'         => esc_html__('Background Color', 'modus'),
						'description'   => esc_html__('Set background Color for body', 'modus'),
						'default'       => '#ffffff',
						'validate' => 'color',
					),
					//-- Pre load
					array(
						'id'            => 'modus_sticky',
						'type'          => 'button_set',
						'title'         => esc_html__('Sticky Menu', 'modus'),
						'options'       => array(
							'show'  => esc_html__( 'Enable Sticky', 'modus' ),
							'hide'  => esc_html__( 'Disable Sticky', 'modus' ),
						),
						'default'       => 'show',
					),
					//-- Logo upload
					array(
						'id'            => 'logo_type',
						'type'          => 'button_set',
						'title'         => esc_html__('Logo', 'modus'),
						'options'       => array(
							'logo_text'  => esc_html__( 'Logo Text', 'modus' ),
							'logo_image'  => esc_html__( 'Logo Image', 'modus' ),
						),
						'default'       => 'logo_image',
					),
					array(
						'id'            => 'logo_image',
						'type'          => 'media',
						'title'         => esc_html__( 'Logo', 'modus' ),
						'description'   => esc_html__( 'Select an image file for your logo, requred size: 170 x 29 pixels.', 'modus' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo.png'
						),
						'required'  =>  array('logo_type','=','logo_image')
					),
					array(
						'id'            => 'logo_white_image',
						'type'          => 'media',
						'title'         => esc_html__( 'Logo(Header 2, Header 6, Header 9 )', 'modus' ),
						'description'   => esc_html__( 'Select an image file for your logo, requred size: 170 x 29 pixels.', 'modus' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo-white.png'
						),
					),
					array(
						'id'            => 'logo_header_7',
						'type'          => 'media',
						'title'         => esc_html__( 'Logo(Header 7)', 'modus' ),
						'description'   => esc_html__( 'Select an image file for your logo, requred size: 170 x 29 pixels.', 'modus' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo_home8.png'
						),
					),
					array(
						'id'            => 'logo_image_mobile',
						'type'          => 'media',
						'title'         => esc_html__( 'Logo on mobile', 'modus' ),
						'description'   => esc_html__( 'Select an image file for your logo, requred size: 170 x 29 pixels.', 'modus' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo.png'
						),
						'required'  =>  array('logo_type','=','logo_image')
					),
					array(
						'id'            => 'logo_text',
						'type'          => 'text',
						'title'         => esc_html__( 'Logo', 'modus' ),
						'description'   => esc_html__( 'Enter your logo', 'modus' ),
						'default'       => esc_html('modus'),
						'required'  =>  array('logo_type','=','logo_text')
					),
					//-- Favicon upload
					array(
						'id'            => 'favicon_main',
						'type'          => 'media',
						'title'         => esc_html__( 'Favicon', 'modus' ),
						'description'   => esc_html__( 'Specify a','modus') .'<a href="'.esc_url('en.wikipedia.org/wiki/Favicon').'" target="_blank">'.esc_html__( ' favicon','modus').'</a>'.esc_html__( ' for your site. Accepted formats: .ico, .png, .gif.', 'modus' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/favicon.ico'
						)
					),
					array(
						'id'            => 'modus_address',
						'type'          => 'text',
						'title'         => esc_html__('Address','modus'),
						'default'       => 'PO Box 16122 Collins Street, West  Victoria 8007, Australia',
					),
					array(
						'id'            => 'modus_mail',
						'type'          => 'text',
						'title'         => esc_html__('Mail','modus'),
						'default'       => 'info@modus.com'
					),
					array(
						'id'            => 'modus_phone',
						'type'          => 'text',
						'title'         => esc_html__('Phone','modus'),
						'default'       => '&#40;+12&#41;123456789',
					),
					array(
						'id'            => 'modus_support',
						'type'          => 'text',
						'title'         => esc_html__('Support','modus'),
						'default'       => 'SUPPORT 24/7',
					),
					array(
						'id'            => 'modus_time',
						'type'          => 'text',
						'title'         => esc_html__('Time','modus'),
						'default'       => '9:00 AM - 18:00 PM',
					),
					array(
						'id'            => 'mapapi',
						'type'          => 'text',
						'title'         => esc_html__('Map API ', 'modus'),
						'description'   => esc_html__('Enter Map API', 'modus') .' <a href="'.esc_url('developers.google.com/maps/documentation/javascript/get-api-key').'" target="_blank">'.esc_html__("Get API", "modus").'</a> ',
						'default'       => '',
					),
					array(
						'id' => 'js-code',
						'type' => 'ace_editor',
						'title' => esc_html__('JS Code', 'modus'),
						'subtitle' => esc_html__('Paste your JS code here.', 'modus'),
						'mode' => 'javascript',
						'theme' => 'chrome',
						'default' => ""
					)
				)
			);
            $sections[] =  array(
                'icon_class' => 'icon',
                'subsection' => true,
                'title' => esc_html__('Countdown', 'modus'),
                'fields' => array(
                    array(
                        'id' => "under-contr-day",
                        'type' => 'text',
                        'title' => esc_html__('Text display under day number', 'modus'),
                        'default' => esc_html__('Days', 'modus')
                    ),
                    array(
                        'id' => "under-contr-hour",
                        'type' => 'text',
                        'title' => esc_html__('Text display under hour number', 'modus'),
                        'default' => esc_html__('Hours', 'modus')
                    ),
                    array(
                        'id' => "under-contr-min",
                        'type' => 'text',
                        'title' => esc_html__('Text display under minute number', 'modus'),
                        'default' => esc_html__('Mins', 'modus')
                    ),
                    array(
                        'id' => "under-contr-sec",
                        'type' => 'text',
                        'title' => esc_html__('Text display under secs number', 'modus'),
                        'default' => esc_html__('Secs', 'modus')
                    ),
                ),
            );
				/**
				 * 404 Page
				 */
			$sections[] = array(
				'title' => esc_html__('404 page','modus'),
				'icon' 	=> 'el-icon-website',
				'fields'=> array(
					// Layout 1
					array(
						'id'            => '404_bg',
						'type'          => 'media',
						'title'         => esc_html__( 'Background for 404 page', 'modus' ),
						'description'   => esc_html__( 'Select an image file for 404 page background image', 'modus' ),
						'default'       => array(
							'url' => get_template_directory_uri() . '/inc/admin/settings/images/bg-404.jpg'
						),
					),
					array(
						'id'            => '404_title',
						'type'          => 'text',
						'title'         => esc_html__( 'Title for 404 page', 'modus' ),
						'description'   => esc_html__( 'Title for 404 page', 'modus' ),
						'default'       => esc_html__('Looks like you are lost !','modus'),
					),
					array(
						'id'            => '404_txt',
						'type'          => 'textarea',
						'title'         => esc_html__( 'Enter 404 content here', 'modus' ),
						'description'   => esc_html__( 'Enter 404 content here', 'modus' ),
						'default'       => wp_kses_post(__('<h1>404</h1>You seen to have reached a page that doesn&rsquo;t exist.<br/>Don&rsquo;t worry we can help you find your way back home!', 'modus')),
					),
					array(
						'id'            => 'button_404',
						'type'          => 'text',
						'title'         => esc_html__( 'Button value', 'modus' ),
						'description'   => esc_html__( 'Enter Button value here', 'modus' ),
						'default'       => esc_html__( 'Go back to our home page', 'modus' ),
					),
					array(
						'id'            => 'header_404',
						'type'          => 'select',
						'title'         => esc_html__( 'Header layout 404', 'modus' ),
						'subtitle'   	=> esc_html__( 'Select layout header 404', 'modus' ),
						'data'			=> 'header_404-1',
						'options'       => array(
							'header_1' => esc_html__( 'Header Layout 1', 'modus' ),
							'header_2' => esc_html__( 'Header Layout 2', 'modus' ),
							'header_3' => esc_html__( 'Header Layout 3', 'modus' ),
							'header_4' => esc_html__( 'Header Layout 4', 'modus' ),

						),
						'default'		=> 'header_1',
					),
					array(
						'id'            => '404_copyright_show',
						'type'          => 'button_set',
						'title'         => esc_html__('Copyright', 'modus'),
						'options'       => array(
						'hidden_copyright'  => esc_html__( 'Hidden', 'modus' ),
						'show_copyright'  => esc_html__( 'Show', 'modus' ),
						),
						'default'       => 'show_copyright',
					),
				)
			);
				/**
				 * SOCIAL NETWORK
				 */
			$modus_arg_socials = array();
			foreach($modus_social_array as $key => $value){
				$modus_arg_social=array(array(
										'id'            => 'social_'.$key.'_link',
										'type'          => 'text',
										'title'         => $value,
										'default'       => '#',
									));
				$modus_arg_socials = array_merge($modus_arg_socials,$modus_arg_social);
			}
			$sections[] = array(
				'title'     => esc_html__( 'Social Networks', 'modus' ),
				'icon'      => 'el-icon-share',
				'fields'    => $modus_arg_socials
			);
			/**
			 * STYLE OPTION
			 */
            $sections[] = array(
				'icon' => 'el-icon-css',
				'icon_class' => 'icon',
				'title' => esc_html__('Skin', 'modus'),
				'fields' => array(
					array(
						'id' => 'main_color',
						'type' => 'color',
						'title' => esc_html__('Main Color', 'modus'),
						'transparent'	=> false,
						'description'   => esc_html__('Set color for main theme', 'modus'),
						'default'       => '#ff9801',
					),
					array(
						'id'            => 'primary_font',
						'type'          => 'typography',
						'title'         => esc_html__( 'Primary font', 'modus' ),
						'description'   => esc_html__( 'Specify the body font properties.', 'modus' ),
						'font-backup'   => true,
						'all_styles'    => true,
						'text-align'    => false,
						'default'       => array(
							'subsets'		=>'latin',
							'font-family'   => 'Poppins',
							'font-backup'   => 'Arial, Helvetica, sans-serif',
							'font-weight'   => '400',
							'font-size'     => '14px',
							'line-height'	=> '24px',
							'color'         => '#666',
						),
					),
					array(
						'id' => 'link_color',
						'type' => 'color',
						'title' => esc_html__('Link Color', 'modus'),
						'transparent'	=> false,
						'description'   => esc_html__('Set color for tag <a></a> theme', 'modus'),
						'default'       => '#ff9801',
					),
				)
			); 
			$header_fields=array(
				array(
					'id'            => 'header_selected',
					'type'          => 'select',
					'title'         => esc_html__( 'Select Header', 'modus' ),
					'subtitle'   	=> esc_html__( 'Select header to default', 'modus' ),
					'options'		=> $header_option,
					'default'		=> 'header_1',
				),
				array(
					'id'            => 'header_fixed',
					'type'          => 'button_set',
					'title'          => esc_html__('Header Fixed','modus'),
					'options'       => array(
						'show' => esc_html__( 'Show', 'modus' ),
						'hide' => esc_html__( 'Hide', 'modus' )
					),
					'default'		=> 'hide',
				),
				array(
					'id' => 'header_bg_image',
					'type' => 'background',
					'title' => esc_html__('Background Image', 'modus'),
					'default' => array(
						'background-image' => get_template_directory_uri() . '/assets/images/bg-header-fixed.jpg',
						'background-size' => 'cover',
						'background-repeat' => 'no-repeat',
						'background-position' => 'center center',
						'background-attachment' => 'inherit',
						'background-color' => 'transparent'
					),
					'required' => array('header_fixed', 'equals', array(
							'show'
					)),                                                           
					'output' => array('.header-fixed .breadcrumb-container' ),   
				),
				array(
					'id' => 'header_bg_image_opacity',
					'type' => 'text',
					'title' => esc_html__('Opacity Overlay Background', 'modus'),  
					'placeholder' => esc_html__('0.5 ', 'modus'),
                    'default'=> '0',   
					'required' => array('header_fixed', 'equals', array(
                            'show'
                    )),
                    'output' => array('.show-breadcrumb .breadcrumb-container:before'),
				),
				array(
					'id'            => 'header_bg',
					'type'          => 'color',
					'title'         => esc_html__( 'Select Background Color', 'modus' ),
					'default'		=> '#fff',
				),
				array(
					'id'            => 'header_bg_sticky',
					'type'          => 'color',
					'title'         => esc_html__( 'Select Background Sticky Menu Color', 'modus' ),
					'subtitle'   	=> esc_html__( 'For Header 2 and Header 9', 'modus' ),
					'default'		=> '#222',
				),
			);
			$i=0;
			foreach($header_option as $value){
				$i++;
				$header_fields[]= array(
						'id'            => 'header_'.$i.'_img',
						'type'          => 'image_select',
						'title'         => esc_html__( 'Header', 'modus' ),
						'options'       => array(
							'header_layout_'.$i.'' => get_template_directory_uri() . '/inc/admin/settings/images/header-'.$i.'.jpg'
						),
						'default'       => 'header_layout_'.$i.'',
						'required'      => array(
							array( 'header_selected', '=', 'header_'.$i.'' )
						),
					);
			}
			$sections[] = array(
				'title'         => esc_html__( 'Header', 'modus' ),
				'fields' =>  $header_fields
			);
		/*
		*	header layout 1
		*/
			$modus_arg_header1 = array(
				array(
					'id'            => 'header_1_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 1', 'modus' ),
					'options'       => array(
						'header_1' => get_template_directory_uri() . '/inc/admin/settings/images/header-1.jpg'
					),
					'default'       => 'header_1',
				),
				array(
					'id'       => 'height_menu_1',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_1_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => esc_html__('Top bar','modus'),
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'modus' ),
						'hide' => esc_html__( 'Hide Top bar', 'modus' )
					),
					'default'		=> 'hide',
				),
				array(
					'id'            => 'header_1_topbar_support',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => esc_html__('Support','modus'),
					'options'       => array(
						'show' => esc_html__( 'Show Support', 'modus' ),
						'hide' => esc_html__( 'Hide Support', 'modus' )
					),
					'default'		=> 'hide',
				),
				array(
					'id'            => 'header_1_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main menu','modus'),
					'default'		=> 23,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_1_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_1_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 1', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header1
			);
		/*
		*	header layout 2
		*/
			$modus_arg_header2 = array(
				array(
					'id'            => 'header_2_img_option',
					'type'          => 'image_select',
					'options'       => array(
						'header_2' => get_template_directory_uri() . '/inc/admin/settings/images/header-2.jpg'
					),
					'default'       => 'header_2',
				),
				array(
					'id'       => 'height_menu_2',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_2_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => esc_html__('Top bar','modus'),
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'modus' ),
						'hide' => esc_html__( 'Hide Top bar', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_2_menu',
					'title'          => esc_html__('Main Menu','modus'),
					'type'          => 'select',
					'default'		=> 23,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_2_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_2_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 2', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header2
			);
		/* <-- end header layout 2 */
		/*
		*	header layout 3
		*/
			$modus_arg_header3 = array(
				array(
					'id'            => 'header_3_img_option',
					'type'          => 'image_select',
					'options'       => array(
						'header_3' => get_template_directory_uri() . '/inc/admin/settings/images/header-3.jpg'
					),
					'default'       => 'header_3',
				),
				array(
					'id'       => 'height_menu_3',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_3_menu',
					'title'          => esc_html__('Main Menu','modus'),
					'type'          => 'select',
					'default'		=> 23,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_3_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_3_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),
			);

			$sections[] = array(
				'title'         => esc_html__( 'Header 3', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header3
			);
		/* <-- end header layout 3 */
		/*
		*	header layout 4
		*/
			$modus_arg_header4 = array(
				array(
					'id'            => 'header_4_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 4', 'modus' ),
					'options'       => array(
						'header_4' => get_template_directory_uri() . '/inc/admin/settings/images/header-4.jpg'
					),
					'default'       => 'header_4',
				),
				array(
					'id'       => 'height_menu_4',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_4_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => esc_html__('Top bar','modus'),
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'modus' ),
						'hide' => esc_html__( 'Hide Top bar', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_4_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main menu','modus'),
					'default'		=> 26,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_4_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_4_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),

			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 4', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header4
			);
		/*
		*	header layout 5
		*/
			$modus_arg_header5 = array(
				array(
					'id'            => 'header_5_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 5', 'modus' ),
					'options'       => array(
						'header_4' => get_template_directory_uri() . '/inc/admin/settings/images/header-5.jpg'
					),
					'default'       => 'header_5',
				),
				array(
					'id'       => 'height_menu_5',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_5_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => esc_html__('Top bar','modus'),
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'modus' ),
						'hide' => esc_html__( 'Hide Top bar', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'topbar_txt',
					'type'          => 'textarea',
					'title'         => esc_html__( 'Top bar text', 'modus' ),
					'description'   => '',
					'default'       => wp_kses_post(__('<p>Welcome to our interior website. <a href="#">Register</a> or <a href="#">Login.</a></p>', 'modus'))
				),
				array(
					'id'            => 'header_5_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main menu','modus'),
					'default'		=> 26,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_5_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 5', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header5
			);
		/*
		*	header layout 6
		*/
			$modus_arg_header6 = array(
				array(
					'id'            => 'header_5_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 6', 'modus' ),
					'options'       => array(
						'header_6' => get_template_directory_uri() . '/inc/admin/settings/images/header-6.jpg'
					),
					'default'       => 'header_6',
				),
				array(
					'id'       => 'height_menu_6',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'call_us',
					'type'          => 'textarea',
					'title'         => esc_html__( 'Call us text', 'modus' ),
					'description'   => '',
					'default'       => wp_kses_post(__('<p>Call Us To Day!<span>123-456-7890</span></p>', 'modus'))
				),
				array(
					'id'            => 'header_6_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main menu','modus'),
					'default'		=> 26,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_6_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_6_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),

			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 6', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header6
			);
			/*
		*	header layout 7
		*/
			$modus_arg_header7 = array(
				array(
					'id'            => 'header_7_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 7', 'modus' ),
					'options'       => array(
						'header_7' => get_template_directory_uri() . '/inc/admin/settings/images/header-7.jpg'
					),
					'default'       => 'header_7',
				),
				array(
					'id'       => 'height_menu_7',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_7_topbar_show',
					'type'          => 'button_set',
					'class'          => 'option_child',
					'title'          => esc_html__('Top bar','modus'),
					'options'       => array(
						'show' => esc_html__( 'Show Top bar', 'modus' ),
						'hide' => esc_html__( 'Hide Top bar', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_7_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main menu','modus'),
					'default'		=> 26,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_7_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_7_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),

			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 7', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header7
			);
		/*
		*	header layout 8
		*/
			$modus_arg_header8 = array(
				array(
					'id'            => 'header_8_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 8', 'modus' ),
					'options'       => array(
						'header_8' => get_template_directory_uri() . '/inc/admin/settings/images/header-8.jpg'
					),
					'default'       => 'header_8',
				),
				array(
					'id'       => 'height_menu_8',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_8_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main Menu','modus'),
					'default'		=> 23,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_8_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_8_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 8', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header8
			);
		/* <-- end header layout 8 */
		/*
		*	header layout 9
		*/
			$modus_arg_header9 = array(
				array(
					'id'            => 'header_9_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 9', 'modus' ),
					'options'       => array(
						'header_8' => get_template_directory_uri() . '/inc/admin/settings/images/header-9.jpg'
					),
					'default'       => 'header_9',
				),
				array(
					'id'       => 'height_menu_9',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_9_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main Menu','modus'),
					'default'		=> 23,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_9_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_9_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 9', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header9
			);
		/* <-- end header layout 9*/
		/*
		*	header layout 10
		*/
			$modus_arg_header10 = array(
				array(
					'id'            => 'header_10_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 10', 'modus' ),
					'options'       => array(
						'header_8' => get_template_directory_uri() . '/inc/admin/settings/images/header-10.jpg'
					),
					'default'       => 'header_10',
				),
				array(
					'id'       => 'height_menu_10',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_10_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main Menu','modus'),
					'default'		=> 23,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_10_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_10_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 10', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header10
			);
		/* <-- end header layout 10*/
		/*
		*	header layout 11
		*/
			$modus_arg_header11 = array(
				array(
					'id'            => 'header_11_img_option',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Header 11', 'modus' ),
					'options'       => array(
						'header_8' => get_template_directory_uri() . '/inc/admin/settings/images/header-11.jpg'
					),
					'default'       => 'header_11',
				),
				array(
					'id'       => 'height_menu_11',
					'type'     => 'dimensions',
					'units'    => array('em','px','%'),
					'title'    => esc_html__('Set height menu', 'modus'),
					'subtitle' => esc_html__('Allow users to set height for header menu', 'modus'),
					'height'   => true,
					'width'   => false,
				), 
				array(
					'id'            => 'header_11_menu',
					'type'          => 'select',
					'title'          => esc_html__('Main Menu','modus'),
					'default'		=> 23,
					'data'		=> 'menus',
				),
				array(
					'id'            => 'header_11_cart',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden cart', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Cart', 'modus' ),
						'hide' => esc_html__( 'Hide Cart', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'header_11_account',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Show/hidden account', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Account', 'modus' ),
						'hide' => esc_html__( 'Hide Account', 'modus' )
					),
					'default'		=> 'show',
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Header 11', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_header11
			);
		/* <-- end header layout 11*/
		/**
		* FOOTER SETTINGS
		*/
			$footer_fields=array(
				array(
					'id'            => 'footer_selected',
					'type'          => 'select',
					'title'         => esc_html__( 'Select Footer', 'modus' ),
					'subtitle'   	=> esc_html__( 'Select Footer to default', 'modus' ),
					'options'		=> $footer_layout_option,
					'default'		=> 'footer_1',
				)
			);
			$i=0;
			foreach($footer_layout_option as $value){
				$i++;
				$footer_fields[]= array(
						'id'            => 'footer_'.$i.'_img',
						'type'          => 'image_select',
						'title'         => esc_html__( 'Footer', 'modus' ),
						'options'       => array(
							'footer_layout_'.$i.'' => get_template_directory_uri() . '/inc/admin/settings/images/footer-'.$i.'.jpg'
						),
						'default'       => 'footer_layout_'.$i.'',
						'required'      => array(
							array( 'footer_selected', '=', 'footer_'.$i.'' )
						),
					);
			}
			$sections[] = array(
				'title'         => esc_html__( 'Footer', 'modus' ),
				'fields' =>  $footer_fields
			);
			$modus_arg_footer1 = array(
				array(
					'id'            => 'footer_layout_1_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_1_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-1.jpg'
					),
					'default'		=> 'footer_layout_1_img',
				),
				array(
					'id'            => 'footer_1_top',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Top', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Top', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Top', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_1_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'modus' ),
						'hide' => esc_html__( 'Hide Footer center', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_1_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
                    'id' => 'bg_img_footer1',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#fff',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v1',
                        'background-size' => '.footer-v1',
                        'background-repeat' => '.footer-v1',
                        'background-position' => '.footer-v1',
                        'background-attachment' => '.footer-v1',
                        'background-color' =>'.footer-v1',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer1-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#000',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v1 .widget-title'),
                ), 
				 array(
                    'id' => 'footer1-text-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer 1 text color', 'modus'),
                    'default' => '#555',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v1, .footer-v1 .dsc-newletter, .footer-v1 .widget.widget_nav_menu ul li a , .site-footer .footer-v1 ul li a,  .footer-v1 .social-login-options .social a'),
                ), 
				 array(
                    'id' => 'footer1-desc-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer 1 description color', 'modus'),
                    'default' => '#222',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v1 .widget_media_image .widget-title'),
                ),
				array(
					'id' => 'footer1-icon-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer 1 icon color', 'modus'),
                    'default' => '#666',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.modus_widget_contact ul li em'),
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 1', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer1
			);
			// Footer 2
			$modus_arg_footer2 = array(
				array(
					'id'            => 'footer_layout_2_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_2_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-2.jpg'
					),
					'default'		=> 'footer_layout_2_img',
				),
				array(
					'id'            => 'footer_2_logo',
					'type'          => 'media',
					'title'         => esc_html__( 'Logo', 'modus' ),
					'description'   => esc_html__( 'Select an image file for your logo.', 'modus' ),
					'default'       => array(
						'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo-white.png'
					),
				),
				array(
					'id'            => 'footer_2_top',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Top', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Top', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Top', 'modus' )
					),
					'default'		=> 'hide',
				),
				array(
					'id'            => 'footer_2_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'modus' ),
						'hide' => esc_html__( 'Hide Footer center', 'modus' )
					),
					'default'		=> 'hide',
				),
				array(
					'id'            => 'footer_2_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
                    'id' => 'bg_img_footer2',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#222',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.site-footer .footer-v2 .footer-tops',
                        'background-size' => '.site-footer .footer-v2 .footer-tops',
                        'background-repeat' => '.site-footer .footer-v2 .footer-tops',
                        'background-position' => '.site-footer .footer-v2 .footer-tops',
                        'background-attachment' => '.site-footer .footer-v2 .footer-tops',
                        'background-color' =>'.site-footer .footer-v2 .footer-tops',
                    ),                                                              
                ), 
                array(
                    'id' => 'bg_copyright_footer2',
                    'type' => 'background',
                    'title' => esc_html__('Background copyright footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#111',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v2 .footer-bottom',
                        'background-size' => '.footer-v2 .footer-bottom',
                        'background-repeat' => '.footer-v2 .footer-bottom',
                        'background-position' => '.footer-v2 .footer-bottom',
                        'background-attachment' => '.footer-v2 .footer-bottom',
                        'background-color' =>'.footer-v2 .footer-bottom',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer2-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer 2 title widget color', 'modus'),
                    'default' => '#fff',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v2 .widget-title, .footer-v2 .social-login-options .social a'),
                ), 
				 array(
                    'id' => 'footer2-text-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer 2 text color', 'modus'),
                    'default' => '#ccc',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v2 ul li a, .footer-v2 .social-login-options .social a, .site-footer .footer-v2 .widget.widget_nav_menu ul li a,.footer-v2 .modus_widget_contact em, .footer-v2 .modus_widget_contact span'),
                ), 
				array(
					'id' => 'footer2-link-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer 2 link color', 'modus'),
                    'default' => '#555',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v2'),
				),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 2', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer2
			);
			/*Footer 3*/
			$modus_arg_footer3 = array(
				array(
					'id'            => 'footer_layout_3_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_3_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-3.jpg'
					),
					'default'		=> 'footer_layout_3_img',
				),
				array(
					'id'            => 'footer_3_top',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer top', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show footer top', 'modus' ),
						'hide' => esc_html__( 'Hide footer top', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_3_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'modus' ),
						'hide' => esc_html__( 'Hide Footer center', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_3_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
                    'id' => 'bg_img_footer3',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#fff',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v3',
                        'background-size' => '.footer-v3',
                        'background-repeat' => '.footer-v3',
                        'background-position' => '.footer-v3',
                        'background-attachment' => '.footer-v3',
                        'background-color' =>'.footer-v3',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer3-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#000',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .widget-title'),
                ), 
				 array(
                    'id' => 'footer3-text-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer 3 text color', 'modus'),
                    'default' => '#555',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v3,.footer-v3 .widget.widget_archive ul li a,.footer-v3 .widget.widget_categories ul li a,.footer-v3 .widget.widget_meta ul li a, .footer-v3 .widget.widget_nav_menu ul li a, .footer-v3 .widget.widget_pages ul li a,.footer-v3 .widget.widget_recent_entries ul li a '),
                ), 
				 array(
                    'id' => 'footer3-link-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer 3 link color', 'modus'),
                    'default' => '#666',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer ul li a, .modus_widget_contact ul li em '),
                ),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 3', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer3
			);
			/*End footer 3*/
			/*Footer 4*/
			$modus_arg_footer4 = array(
				array(
					'id'            => 'footer_layout_4_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_4_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-4.jpg'
					),
					'default'		=> 'footer_layout_4_img',
				),
				array(
					'id'            => 'footer_4_logo',
					'type'          => 'media',
					'title'         => esc_html__( 'Logo', 'modus' ),
					'description'   => esc_html__( 'Select an image file for your logo.', 'modus' ),
					'default'       => array(
						'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo-white.png'
					),
				),
				array(
					'id'            => 'footer_4_top',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer top', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show footer top', 'modus' ),
						'hide' => esc_html__( 'Hide footer top', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_4_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'modus' ),
						'hide' => esc_html__( 'Hide Footer center', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_4_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
                    'id' => 'bg_img_footer4',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#444',   
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer.footer-v4 .footer-tops',
                        'background-size' => '.footer.footer-v4 .footer-tops',
                        'background-repeat' => '.footer.footer-v4 .footer-tops',
                        'background-position' => '.footer.footer-v4 .footer-tops',
                        'background-attachment' => '.footer.footer-v4 .footer-tops',
                        'background-color' =>'.footer.footer-v4 .footer-tops',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer4-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#999',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer.footer-v4 .widget-title'),
                ), 
				 array(
                    'id' => 'footer4-text-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer 4 text color', 'modus'),
                    'default' => '#999',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer.footer-v4 p,.site-footer .footer-v4 .footercopyright, .footer.footer-v4 .social-login-options .social a i'),
                ), 
				 array(
                    'id' => 'footer4-link-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer 4 link color', 'modus'),
                    'default' => '#fff',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer.footer-v4 .widget.widget_nav_menu ul li a '),
                ),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 4', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer4
			);
			/*End footer 4*/
			/*Footer 5 */
			$modus_arg_footer5 = array(
				array(
					'id'            => 'footer_layout_5_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_5_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-5.jpg'
					),
					'default'		=> 'footer_layout_5_img',
				),
				array(
					'id'            => 'footer_5_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'modus' ),
						'hide' => esc_html__( 'Hide Footer center', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_5_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
                    'id' => 'bg_img_footer5',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#f2f3f4',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v5',
                        'background-size' => '.footer-v5',
                        'background-repeat' => '.footer-v5',
                        'background-position' => '.footer-v5',
                        'background-attachment' => '.footer-v5',
                        'background-color' =>'.footer-v5',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer5-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#000',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer.footer-v5 .widget-title, .site-footer .footer-v5 .footercopyright a'),
                ), 
				 array(
                    'id' => 'footer5-text-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer text color', 'modus'),
                    'default' => '#555',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer.footer-v5 .textwidget p,.site-footer .footer-v5 .footercopyright, .footer.footer-v5 .drop-message-form input[type=email], .footer.footer-v5 .drop-message-form input[type=text]'),
                ), 
				 array(
                    'id' => 'footer5-link-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer link color', 'modus'),
                    'default' => '#222',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v5 .widget.widget_nav_menu ul li a'),
                ),
				  array(
                    'id' => 'footer5-icon-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer icon color', 'modus'),
                    'default' => '#999',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer.footer-v5 .social-login-options .social a'),
                ),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 5', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer5
			);
			/*End footer 5*/
			/*Footer 6 */
			$modus_arg_footer6 = array(
				array(
					'id'            => 'footer_layout_6_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_6_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-6.jpg'
					),
					'default'		=> 'footer_layout_6_img',
				),
				array(
					'id'            => 'footer_6_center',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer center', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer center', 'modus' ),
						'hide' => esc_html__( 'Hide Footer center', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_6_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
                    'id' => 'bg_img_footer6',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#222',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.site-footer .footer-v6',
                        'background-size' => '.site-footer .footer-v6',
                        'background-repeat' => '.site-footer .footer-v6',
                        'background-position' => '.site-footer .footer-v6',
                        'background-attachment' => '.site-footer .footer-v6',
                        'background-color' =>'.site-footer .footer-v6',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer6-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#999',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v6 .widget-title, .site-footer .footer-v6 .footercopyright, .footer-v6 .social-login-options .social a'),
                ), 
				 array(
                    'id' => 'footer6-text-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer text color', 'modus'),
                    'default' => '#ccc',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v6 p'),
                ), 
				 array(
                    'id' => 'footer6-link-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer link color', 'modus'),
                    'default' => '#fff',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v6 .footer-top ul li a'),
                ),
				 array(
                    'id' => 'footer6-link-copyright-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer link copyright color', 'modus'),
                    'default' => '#555',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v6 .footercopyright a'),
                ),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 6', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer6
			);
			/*End footer 6*/
			/*Footer 7 */
			$modus_arg_footer7 = array(
				array(
					'id'            => 'footer_layout_7_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_7_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-7.jpg'
					),
					'default'		=> 'footer_layout_7_img',
				),
				array(
					'id'            => 'footer_7_logo',
					'type'          => 'media',
					'title'         => esc_html__( 'Logo', 'modus' ),
					'description'   => esc_html__( 'Select an image file for your logo.', 'modus' ),
					'default'       => array(
						'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo-white.png'
					),
				),
				array(
					'id'            => 'footer_7_top',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer top', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer top', 'modus' ),
						'hide' => esc_html__( 'Hide Footer top', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
					'id'            => 'footer_7_bottom',
					'type'          => 'button_set',
					'title'         => esc_html__( 'Footer Bottom', 'modus' ),
					'options'       => array(
						'show' => esc_html__( 'Show Footer Bottom', 'modus' ),
						'hide' => esc_html__( 'Hide Footer Bottom', 'modus' )
					),
					'default'		=> 'show',
				),
				array(
                    'id' => 'bg_img_footer7',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#333',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v7',
                        'background-size' => '.footer-v7',
                        'background-repeat' => '.footer-v7',
                        'background-position' => '.footer-v7',
                        'background-attachment' => '.footer-v7',
                        'background-color' =>'.footer-v7',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer7-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#999',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v7 .widget-title,.site-footer .footer-v7 .footercopyright , .footer-v7 .modus_widget_contact ul li em'),
                ), 
				 array(
                    'id' => 'footer7-text-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer text color', 'modus'),
                    'default' => '#ccc',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v7 p, .site-footer .footer-v7 ul li, .site-footer .footer-v7 ul li a'),
                ), 
				 array(
                    'id' => 'footer7-link-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer link color', 'modus'),
                    'default' => '#fff',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v7 .widget.widget_nav_menu ul li a'),
                ),			);
			
			$sections[] = array(
				'title'         => esc_html__( 'Footer 7', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer7
			);
			/*End footer 7*/
			/*Footer 8 */
			$modus_arg_footer8 = array(
				array(
					'id'            => 'footer_layout_8_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_8_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-8.jpg'
					),
					'default'		=> 'footer_layout_8_img',
				),
				array(
					'id'            => 'footer_8_logo',
					'type'          => 'media',
					'title'         => esc_html__( 'Logo', 'modus' ),
					'description'   => esc_html__( 'Select an image file for your logo.', 'modus' ),
					'default'       => array(
						'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo-white.png'
					),
				),
				array(
                    'id' => 'bg_img_footer8',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#222',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v8',
                        'background-size' => '.footer-v8',
                        'background-repeat' => '.footer-v8',
                        'background-position' => '.footer-v8',
                        'background-attachment' => '.footer-v8',
                        'background-color' =>'.footer-v8',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer8-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#fff',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v8 .widget-title, .site-footer .footer-v8 p, .footer-v8 .mc4wp-form-fields input[type=submit]'),
                ), 
				 array(
                    'id' => 'footer8-link-color', 
                    'type' => 'color',
                    'title' => esc_html__('Footer link color', 'modus'),
                    'default' => '#ccc',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v8 .widget ul.menu li a, .site-footer .footer-v8 .social-login-options .social a'),
                ),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 8', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer8
			);
			/*Footer 9 */
			$modus_arg_footer9 = array(
				array(
					'id'            => 'footer_layout_9_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_9_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-9.jpg'
					),
					'default'		=> 'footer_layout_9_img',
				),
				array(
					'id'            => 'footer_9_logo',
					'type'          => 'media',
					'title'         => esc_html__( 'Logo', 'modus' ),
					'description'   => esc_html__( 'Select an image file for your logo.', 'modus' ),
					'default'       => array(
						'url' => get_template_directory_uri() . '/inc/admin/settings/images/logo.png'
					),
				),
				array(
                    'id' => 'bg_img_footer9',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#f5f5f5',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v9',
                        'background-size' => '.footer-v9',
                        'background-repeat' => '.footer-v9',
                        'background-position' => '.footer-v9',
                        'background-attachment' => '.footer-v9',
                        'background-color' =>'.footer-v9',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer9-t-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#222',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v9 .widget-title,'),
                ), 
                array(
                    'id' => 'footer9-text-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer text color', 'modus'),
                    'default' => '#555',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.site-footer .footer-v9 a, .site-footer .footer-v9 p,.footer-v9 .widget ul.menu li a'),
                ),
                 array(
                    'id' => 'footer9-icon-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer icon color', 'modus'),
                    'default' => '#999',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v9 .mc4wp-form-fields input[type=email],.site-footer .footer-v9 .social-login-options .social a '),
                ),
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 9', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer9
			);
			/*Footer 9 */
			$modus_arg_footer10 = array(
				array(
					'id'            => 'footer_layout_10_img',
					'type'          => 'image_select',
					'title'         => esc_html__( 'Footer Layout', 'modus' ),
					'options'       => array(
						'footer_layout_10_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-10.jpg'
					),
					'default'		=> 'footer_layout_10_img',
				),
				array(
                    'id' => 'bg_img_footer10',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#fff',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v10',
                        'background-size' => '.footer-v10',
                        'background-repeat' => '.footer-v10',
                        'background-position' => '.footer-v10',
                        'background-attachment' => '.footer-v10',
                        'background-color' =>'.footer-v10',
                    ),                                                              
                ), 
				array(
                    'id' => 'footer10-text-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer title widget color', 'modus'),
                    'default' => '#555',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v8,.site-footer .footer-v10 .footercopyright a'),
                ), 
				
			);
			$sections[] = array(
				'title'         => esc_html__( 'Footer 10', 'modus' ),
				'subsection'    => true,
				'fields'        => $modus_arg_footer10
			);
            /* Footer 11 */
            $modus_arg_footer11 = array(
                array(
                    'id'            => 'footer_layout_11_img',
                    'type'          => 'image_select',
                    'title'         => esc_html__( 'Footer Layout', 'modus' ),
                    'options'       => array(
                        'footer_layout_11_img' => get_template_directory_uri() . '/inc/admin/settings/images/footer-11.jpg'
                    ),
                    'default'		=> 'footer_layout_11_img',
                ),
				array(
                    'id' => 'bg_img_footer11',
                    'type' => 'background',
                    'title' => esc_html__('Background footer', 'modus'),
                    'background-color' => true, 
                    'default' => array(
                        'background-color' =>'#222',
                        'background-image' => '',
                        'background-size' => 'cover',
                        'background-repeat' => 'no-repeat',
                        'background-position' => 'center center',
                        'background-attachment' => 'fixed'
                    ),                      
                    'output'    => array(
                        'background-image' =>'.footer-v11',
                        'background-size' => '.footer-v11',
                        'background-repeat' => '.footer-v11',
                        'background-position' => '.footer-v11',
                        'background-attachment' => '.footer-v11',
                        'background-color' =>'.footer-v11',
                    ),                                                              
                ), 
                array(
                    'id' => 'footer11-text-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer text color', 'modus'),
                    'default' => '#fff',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v11 .footer-top .widget h3.widget-title, .footer-v11 .footer-top .widget.widget_nav_menu ul li a, .footer-v11 .bottom-footer .footercopyright, .footer-v11 .bottom-footer .footercopyright a'),
                ),
                 array(
                    'id' => 'footer11-icon-color',
                    'type' => 'color',
                    'title' => esc_html__('Footer icon color', 'modus'),
                    'default' => '#999',
                    'validate' => 'color',
                    'transparent' =>false,
                    'output' => array('.footer-v11 .footer-top .widget.modus_widget_social .social a '),
                ),
            );
            $sections[] = array(
                'title'         => esc_html__( 'Footer 11', 'modus' ),
                'subsection'    => true,
                'fields'        => $modus_arg_footer11
            );
			$sections[] = array(
				'title'         => esc_html__( 'Copy Right', 'modus' ),
				'subsection'    => true,
				'fields'        => array(
						array(
							'id'            => 'footer_coppyright',
							'type'          => 'textarea',
							'title'         => esc_html__( 'Text copyright', 'modus' ),
							'description'   => esc_html__( 'Enter text content here', 'modus' ),
							'default'		=> wp_kses_post(__( 'Copyright <a href="#"></a> &#169; 2018 Modus - Design by Arrowhitech - ALL Rights Reserved', 'modus' )),
						),
				)
			);
			$sections[] = array(
				'title'         => esc_html__( 'Logo Bank', 'modus' ),
				'subsection'    => true,
				'fields'        => array(
						array(
							'id'            => 'show_payment',
							'type'          => 'button_set',
							'title'         => esc_html__('Show Payment', 'modus' ),
							'options'       => array(
								'show' => esc_html__( 'Show', 'modus' ),
								'hide' => esc_html__( 'Hide', 'modus' ),
							),
							'default'       => 'hide',
						),
						array(
							'id'            => 'footer_bank',
							'type'          => 'editor',
							'title'         => esc_html__( 'Footer Bank', 'modus' ),
							'description'   => esc_html__( 'Enter content here', 'modus' ),
							'required' => array(
                                    array('show_payment', 'equals', array(
                                    'show'
                                )),
                            ),
						),
				)
			);
			
		/*
		*	Page option
		*/
			$sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'icon',
				'title' => esc_html__('Page', 'modus'),
				'fields' => array(
					array(
						'id'            => 'page_sidebar_position',
						'type'          => 'select',
						'title' 				=> esc_html__('Sidebar', 'modus'),
						'description'   => esc_html__('Select layout type', 'modus'),
						'options'          => array(
							'no-sidebar' => esc_html('No sidebar','modus'),
							'left-sidebar' => esc_html('Left sidebar','modus'),
							'right-sidebar' => esc_html('Right sidebar','modus'),
						),
						'default'	=>'no-sidebar',
					),
					array(
						'id'            => 'page_bread_crumb',
						'type'          => 'select',
						'title' 				=> esc_html__('BreadCrumb', 'modus'),
						'description'   => esc_html__('Select show Breadcrumb', 'modus'),
						'options'          => array(
							'show' => esc_html('Show breadcrumb','modus'),
							'hide' => esc_html('Hide breadcrumb','modus'),
						),
						'default'	=>'show',
					),
					array(
						'id'            => 'page_title',
						'type'          => 'select',
						'title' 				=> esc_html__('Page Title', 'modus'),
						'description'   => esc_html__('Select show title', 'modus'),
						'options'          => array(
							'show' => esc_html('Show Title','modus'),
							'hide' => esc_html('Hide Title','modus'),
						),
						'default'	=>'show',
					),
					array(
						'id'            => 'page_sidebar_ct',
						'type'          => 'select',
						'description'   => esc_html__('Select layout type', 'modus'),
						'data'			=> 'sidebar',
						'required'      => array(
							array( 'page_sidebar_position', '!=', 'no-sidebar' ),
						),
					),
				)
			);
			/** Sections Blog */
            $sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'icon',
				'title' => esc_html__('Blog', 'modus'),
				'fields' => array(
					array(
						'id'=>'blog_title',
						'type' => 'text',
						'title' => esc_html__('Page Title', 'modus'),
						'default' => 'Blog'
					),
					array(
						'id'=>'blog-layout',
						'type' => 'select',
						'title' => esc_html__('Blog layout', 'modus'),
						'options'       => array(
							'default' => esc_html__( 'Default', 'modus' ),
							'layout2' => esc_html__( 'Layout 2', 'modus' ),
							'layout3' => esc_html__( 'Layout 3', 'modus' ),
							'layout4' => esc_html__( 'Layout 4', 'modus' ),
						),
						'default' => 'default'
					),
					array(
						'id'            => 'post_sidebar_position',
						'type'          => 'button_set',
						'title'         => esc_html__( 'Sidebar Position', 'modus' ),
						'subtitle'   	=> esc_html__( 'Position Sidebar to Blog & Single Post', 'modus' ),
						'options'       => array(
							'left-sidebar' => esc_html__( 'Left', 'modus' ),
							'right-sidebar' => esc_html__( 'Right', 'modus' ),
							'none' => esc_html__( 'None', 'modus' ),
						),
						'default'		=> 'left-sidebar',
					),
					array(
						'id'            => 'post_sidebar',
						'type'          => 'select',
						'title'         => esc_html__( 'Sidebar', 'modus' ),
						'subtitle'   	=> esc_html__( 'Select Sidebar to Blog & Single Post', 'modus' ),
						'data'			=> 'sidebar',
						'default'		=> 'blog-sidebar',
						'required'      => array(
							array( 'post_sidebar_position', '!=', 'none' )
						),
					),
					//archive
					array(
						'id'            => 'archive_blog_banner',
						'type'          => 'button_set',
						'title'         => esc_html__('Breadcrumb', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show Breadcrumb', 'modus' ),
							'hide' => esc_html__( 'Hide Breadcrumb', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'meta_date',
						'type'          => 'button_set',
						'title'         => esc_html__('Show date', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'meta_author',
						'type'          => 'button_set',
						'title'         => esc_html__('Show author', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'meta_comment',
						'type'          => 'button_set',
						'title'         => esc_html__('Show comment', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'meta_cat',
						'type'          => 'button_set',
						'title'         => esc_html__('Show categories', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'meta_tag',
						'type'          => 'button_set',
						'title'         => esc_html__('Show tags', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'meta_format',
						'type'          => 'button_set',
						'title'         => esc_html__('Show format', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					), 
				)
			);
			$sections[] = array(
				'icon_class' => 'icon',
				'subsection' => true,
				'title' => esc_html__('Single', 'modus'),
				'fields' => array(
					array(
						'id'            => 'single_meta_author_des',
						'type'          => 'button_set',
						'title'         => esc_html__('Show Author Description', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'hide', 
					),
					array(
						'id'            => 'single_meta_date',
						'type'          => 'button_set',
						'title'         => esc_html__('Show date', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show', 
					),
					array(
						'id'            => 'single_meta_author',
						'type'          => 'button_set',
						'title'         => esc_html__('Show author', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'single_meta_comment',
						'type'          => 'button_set',
						'title'         => esc_html__('Show comment', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show',

					),
					array(
						'id'            => 'single_meta_format',
						'type'          => 'button_set',
						'title'         => esc_html__('Show format', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show', 
					), 
					array(
						'id'            => 'single_meta_cat',
						'type'          => 'button_set',
						'title'         => esc_html__('Show categories', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show', 
					),
					array(
						'id'            => 'single_meta_tag',
						'type'          => 'button_set',
						'title'         => esc_html__('Show tags', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'show', 
					),
					array(
						'id'            => 'single_meta_share',
						'type'          => 'button_set',
						'title'         => esc_html__('Show Share', 'modus' ),
						'options'       => array(
							'show' => esc_html__( 'Show', 'modus' ),
							'hide' => esc_html__( 'Hide', 'modus' ),
						),
						'default'       => 'hide', 
					), 
					array(
						'id'       => 'single_share',
						'type'     => 'select',
						'multi'    => true,
						'title'    => esc_html__('Social Share', 'modus'),  
						'desc'     => esc_html__('Select Social Share', 'modus'), 
						'options'  => array( 
							'Digg' => 'Digg', 
							'Facebook' => 'Facebook' ,
							'Google' => 'Google +' , 
							'LinkedIn' => 'LinkedIn',
							'Pinterest' => 'Pinterest', 
							'Reddit' => 'Reddit',
							'StumbleUpon' => 'StumbleUpon',
							'Tumblr' => 'Tumblr',
							'Twitter' => 'Twitter',
							'VK' => 'VK' 
						),
						'default'  => array('Facebook','Twitter','Pinterest','Google'),
						'required'      => array(
							array( 'single_meta_share', '=', 'show' )
						),
					),
				),  
			);
			/** End Sections Blog */
			/** Sections Portfolio */
			$sections[] = array(
				'icon' => 'el-icon-file',
				'icon_class' => 'icon',
				'title' => esc_html__('Portfolio', 'modus'),
				'fields' => array(	
					array(
						'id'            => 'portfolio_slug',
						'type'          => 'text',
						'title'         => esc_html__('Portfolio Slug Name', 'modus' ),
						'default'	=>'',
					),
					array(
						'id'            => 'portfolio_cat_slug',
						'type'          => 'text',
						'title'         => esc_html__('Portfolio Categories Slug Name', 'modus' ),
						'default'	=>'',
					),
					//single
					array(
						'id'            => 'archive_portfolio_sitebar',
						'type'          => 'select',
						'title'         => esc_html__('Side bar', 'modus' ),
						'options'          => array(
							'no-sidebar' => esc_html('No sidebar','modus'),
							'left-sidebar' => esc_html('Left sidebar','modus'),
							'right-sidebar' => esc_html('Right sidebar','modus'),
						),
						'default'	=>'no-sidebar',
					),
					array(
						'id'            => 'archive_portfolio_sitebar_left',
						'type'          => 'select',
						'title'         => esc_html__('Sidebar left', 'modus' ),
						'data'			=> 'sidebar',
						'default'		=> 'left-sidebar',
						'required'      => array(
							array( 'archive_portfolio_sitebar', '!=', 'right-sidebar' ),
							array( 'archive_portfolio_sitebar', '!=', 'no-sidebar' )
						),
					),
					array(
						'id'            => 'archive_portfolio_sitebar_right',
						'type'          => 'select',
						'title'         => esc_html__('Sidebar right', 'modus' ),
						'data'			=> 'sidebar',
						'default'		=> 'right-sidebar',
						'required'      => array(
							array( 'archive_portfolio_sitebar', '!=', 'left-sidebar' ),
							array( 'archive_portfolio_sitebar', '!=', 'no-sidebar' )
						),
					),
					array(
						'id'            => 'single_portfolio_type',
						'type'          => 'select',
						'title'         => esc_html__('Single Layout', 'modus' ),
						'description'   => esc_html__('Select layout single portfolio', 'modus'),
						'options'          => array(
							'layout1' => esc_html('Layout 1','modus'),
							'layout2' => esc_html('Layout 2','modus'),
							'layout3' => esc_html('Layout 3','modus'),
						),
						'default'	=>'layout1',
					),
				)
			);
			/** End Sections Portfolio */
			if ( class_exists( 'WooCommerce' ) ):
				$compare_fields=array();
				if(class_exists( 'YITH_WOOCOMPARE' ) ) {
					$compare_fields[] = array(
							'id'            => 'modus_compare_page',
							'type'          => 'select',
							'title'         => esc_html__( 'Compare ', 'modus' ),
							'subtitle'   	=> esc_html__( 'Select page to Compare page', 'modus' ),
							'data'			=> 'pages',
							'default'		=> '',
						);
				}
				
				$sections[] = array(
					'icon' => 'el-icon-file',
					'icon_class' => 'icon',
					'title' => esc_html__('WooCommerce', 'modus'),
					'fields' => $compare_fields
				);
				$sections[] = array(
					'icon_class' => 'icon',
					'subsection' => true,
					'title' => esc_html__('Product Categories', 'modus'),
					'fields' => array(
						array(
							'id'=>'product_categories',
							'type' => 'info',
							'title' => esc_html__('Product Categories', 'modus'),
							'desc' => '<br/><strong>'.esc_html__('Set up for &ldquo;Product Categories&ldquo;', 'modus') . '</strong>',
							'notice' => false
						),
						array(
							'id'            => 'archive_product_sub',
							'type'          => 'button_set',
							'title'         => esc_html__('Shop page display', 'modus' ),
							'options'       => array(
								'grid' => esc_html__( 'Grid', 'modus' ),
								'slide' => esc_html__( 'Slide', 'modus' ),
							),
							'default'       => 'grid',
						),
						array(
							'id'            => 'archive_width',
							'type'          => 'select',
							'title'         => esc_html__('Layout width', 'modus' ),
							'options'       => array(
								'full-width' => esc_html('Full width','modus'),
								'full-site' => esc_html('Full site','modus') ,
							),
							'default'       => 'full-site',
						),
						array(
							'id'            => 'archive_product_breadcrumb',
							'type'          => 'button_set',
							'title'         => esc_html__('Shop Breadcrumb', 'modus' ),
							'options'       => array(
								'show' => esc_html__( 'Show breadcrumb', 'modus' ),
								'hide' => esc_html__( 'Hide breadcrumb', 'modus' ),
							),
							'default'       => 'show',
						),
						array(
							'id'            => 'shop_sortby',
							'type'          => 'button_set',
							'title'         => esc_html__( 'Sortby', 'modus' ),
							'options'       => array(
								'default' => esc_html__( 'Default', 'modus' ),
								'category' => esc_html__( 'Category', 'modus' ),
							),
							'default'		=> 'category',
						),
						array(
							'id'            => 'shop_layout',
							'type'          => 'select',
							'title'         => esc_html__( 'Layout', 'modus' ),
							'subtitle'   	=> esc_html__( 'Select layout shop', 'modus' ),
							'data'			=> 'layout-1',
							'options'       => array(
								'grid' => esc_html__( 'Grid', 'modus' ),
								'list' => esc_html__( 'List', 'modus' ),
								'metro' => esc_html__( 'Metro', 'modus' ),
							),
							'default'		=> 'grid',

						),
						array(
							'id'            => 'shop_layout_item',
							'type'          => 'select',
							'title'         => esc_html__( 'Layout content product', 'modus' ),
							'subtitle'   	=> esc_html__( 'Select layout show item product', 'modus' ),
							'data'			=> 'layout-1',
							'options'       => array(
								'layout-1' => esc_html__( 'Grid layout 1', 'modus' ),
								'layout-2' => esc_html__( 'Grid layout 2', 'modus' ),
								'layout-3' => esc_html__( 'Grid layout 3', 'modus' ),
								'layout-4' => esc_html__( 'Grid layout 4', 'modus' ),
								'layout-5' => esc_html__( 'Grid layout 5', 'modus' ),
								'layout-6' => esc_html__( 'Grid layout 6', 'modus' ),
								'layout-7' => esc_html__( 'Grid layout 7', 'modus' ),
								'layout-8' => esc_html__( 'Grid layout 8', 'modus' ),
							),
							'default'		=> 'layout-1',
							'required'      => array(
								array( 'shop_layout', '=', 'grid' )
							),
						),

						array(
							'id'            => 'product_categories_sidebar_1',
							'type'          => 'select',
							'title'         => esc_html__( 'Sidebar Click', 'modus' ),
							'subtitle'   	=> esc_html__( 'Select Sidebar to Product Categories', 'modus' ),
							'data'			=> 'sidebar',
							'default'		=> 'shop-sidebar',
						),
						array(
							'id'            => 'product_categories_sidebar',
							'type'          => 'select',
							'title'         => esc_html__( 'Sidebar', 'modus' ),
							'subtitle'   	=> esc_html__( 'Select Sidebar to Product Categories', 'modus' ),
							'data'			=> 'sidebar',
							'default'		=> 'shop-sidebar',
							'required'      => array(
								array( 'product_categories_sidebar_position', '!=', 'none' )
							),
						),
						array(
							'id'            => 'product_categories_sidebar_position',
							'type'          => 'select',
							'title'         => esc_html__('Sidebar Position', 'modus' ),
							'options'          => array(
								'left-sidebar' => esc_html('Left sidebar','modus'),
								'right-sidebar' => esc_html('Right sidebar','modus'),
							),
							'default'	=>'no-sidebar',
						),
						array(
							'id'            => 'column',
							'type'          => 'select',
							'title'         => esc_html__( 'Column', 'modus' ),
							'subtitle'   	=> esc_html__( 'Select Column to Product Categories', 'modus' ),
							'data'			=> 'column-1',
							'options'       => array(
								'2' => esc_html__( '2 Column', 'modus' ),
								'3' => esc_html__( '3 Column', 'modus' ),
								'4' => esc_html__( '4 Column', 'modus' ),
								'5' => esc_html__( '5 Column', 'modus' ),
								'6' => esc_html__( '6 Column', 'modus' ),
							),
							'default'		=> '3',

						),
						array(
							'id'            => 'archive_product_num_item_2',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'modus' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'modus' ),
							'default'  => '10',
							'min'      => '4',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '2' ),
							),
						),
						array(
							'id'            => 'archive_product_num_item_3',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'modus' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'modus' ),
							'default'  => '18',
							'min'      => '6',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '3' ),
							),
						),
						array(
							'id'            => 'archive_product_num_item_4',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'modus' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'modus' ),
							'default'  => '12',
							'min'      => '8',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '4' ),
							),
						),
						array(
							'id'            => 'archive_product_num_item_5',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'modus' ),
							'subtitle'   	=> esc_html__( 'Numbers item product show on shop', 'modus' ),
							'default'  => '15',
							'min'      => '10',
							'step'     => '1',
							'max'      => '50',
							'required'      => array(
								array( 'column', '=', '5' ),
							),
						),
						array(
							'id' => 'product-cart',
							'type' => 'switch',
							'title' => esc_html__('Show Add to Cart button', 'modus'),
							'default' => true,
							'on' => esc_html__('Yes', 'modus'),
							'off' => esc_html__('No', 'modus')
						),
					)
				);

				// Single Product
				$sections[] = array(
					'icon_class' => 'icon',
					'subsection' => true,
					'title' => esc_html__('Product Single', 'modus'),
					'fields' => array(
						array(
							'id'=>'product_single',
							'type' => 'info',
							'title' => esc_html__('Product Single', 'modus'),
							'desc' => '<br/><strong>'.esc_html__('Set up for &ldquo;Product Single&ldquo;', 'modus') . '</strong>',
							'notice' => false
						),
						array(
							'id'            => 'single_product_breadcrumb',
							'type'          => 'button_set',
							'title'         => esc_html__('Single Page Breadcrumb', 'modus' ),
							'options'       => array(
								'show' => esc_html__( 'Show breadcrumb', 'modus' ),
								'hide' => esc_html__( 'Hide breadcrumb', 'modus' ),
							),
							'default'       => 'show',

						),
						array(
							'id'            => 'product_single_sidebar_position',
							'type'          => 'button_set',
							'title'         => esc_html__( 'Sidebar Position', 'modus' ),
							'subtitle'   	=> esc_html__( 'Position Sidebar to Product Single', 'modus' ),
							'options'       => array(
								'left-sidebar' => esc_html__( 'Left', 'modus' ),
								'right-sidebar' => esc_html__( 'Right', 'modus' ),
								'none' => esc_html__( 'None', 'modus' ),
							),
							'default'		=> 'left-sidebar',
						),
						array(
							'id'            => 'product_single_sidebar',
							'type'          => 'select',
							'title'         => esc_html__( 'Sidebar', 'modus' ),
							'subtitle'   	=> esc_html__( 'Select Sidebar to Product Single', 'modus' ),
							'data'			=> 'sidebar',
							'default'		=> 'single-product-sidebar',
							'required'      => array(
								array( 'product_single_sidebar_position', '!=', 'none' )
							),
						),
						array(
							'id'            => 'product_single_share',
							'type'          => 'button_set',
							'title'         => esc_html__( 'Share Product', 'modus' ), 
							'options'       => array(
								'show' => esc_html__( 'Show Share', 'modus' ),
								'hide' => esc_html__( 'Hide Share', 'modus' ), 
							),
							'default'		=> 'hide',
						),
						array(
							'id'            => 'single_product_num_item_related',
							'type'          => 'spinner',
							'title'         => esc_html__('Number items', 'modus' ),
							'subtitle'   	=> esc_html__( 'Numbers item product related on page single product', 'modus' ),
							'default'  => '5',
							'min'      => '0',
							'step'     => '1',
							'max'      => '10',
						),
						array(
							'id'	=> 'single_product_sort_by',
							'type'	=> 'button_set',
							'title'	=> esc_html__( 'Sort by', 'modus' ),
							'subtitle' => esc_html__( 'Sort list of single products by: ' , 'modus' ),
							'options' => array(
								'category' => esc_html__( 'Category', 'modus' ),
								'default' => esc_html__( 'Default', 'modus'),
							),
							'default' => 'category',
						),
					),
				); 
			endif; // end of if ( class_exists( 'WooCommerce' ) )
            return $sections;
        } 
        public function modus_get_setting_arguments() {
            $theme = wp_get_theme();
            $args = array(
                // TYPICAL -> Change these values as you need/desire
                'opt_name' => 'modus_settings',
                'display_name' => $theme->get('Name'),
                'display_version' => $theme->get('Version'),
                'menu_type' => 'menu',
                'allow_sub_menu' => true,
                'menu_title' => 'Modus',
                'page_title' => 'Modus',
                'google_api_key' => '',
                'google_update_weekly' => false,
                'async_typography' => true,
                'admin_bar' => true,
                'admin_bar_icon' => 'dashicons-admin-generic',
                'admin_bar_priority' => 50,
                'global_variable' => '',
                'dev_mode' => false,
				'forced_dev_mode_off' => false,
                'update_notice' => false,
                'customizer' => true,
                'page_priority' => null,
                'page_parent' => 'themes.php',
                'page_permissions' => 'manage_options',
                'menu_icon' => '',
                'last_tab' => '',
                'page_icon' => 'icon-themes',
                'page_slug' => '',
                'save_defaults' => true,
                'default_show' => false,
                'default_mark' => '',
                'show_import_export' => true,
                'transient_time' => 60 * MINUTE_IN_SECONDS,
                'output' => true,
                'output_tag' => true,
                'database' => '',
                'use_cdn' => true,
                // HINTS
                'hints' => array(
                    'icon' => 'el el-question-sign',
                    'icon_position' => 'right',
                    'icon_color' => 'lightgray',
                    'icon_size' => 'normal',
                    'tip_style' => array(
                        'color' => 'red',
                        'shadow' => true,
                        'rounded' => false,
                        'style' => '',
                    ),
                    'tip_position' => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect' => array(
                        'show' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'mouseover',
                        ),
                        'hide' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'click mouseleave',
                        ),
                    ),
                )
            );
            return $args;
        }

        protected function modus_header_types() {
            return array();
        }

        protected function modus_footer_types() {
            return array();
        }

    }

    global $modusReduxSettings;
    $modusReduxSettings = new Framework_Modus_Settings();
}