<?php
require_once( MODUS_ADMIN . '/settings/settings.php' );
require_once( MODUS_ADMIN . '/settings/save_settings.php' );
require_once( MODUS_ADMIN . '/settings/walker_nav_menu/walker_nav_menu.php' );
require_once (MODUS_ADMIN . '/config_skin_scss.php');


function modus_removeDemoModeLink() {
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );
        $ReduxFrameworkPlugin =array();
        $ReduxFrameworkPlugin ['demo'] ='';
        update_option( 'ReduxFrameworkPlugin',$ReduxFrameworkPlugin  );
    }
}
add_action('init', 'modus_removeDemoModeLink');

//get theme sidebar position options
function modus_sidebar_position() {
    return array(
        'default' => esc_html__('Default Position', 'modus'),
        'left-sidebar' => esc_html__('Left', 'modus'),
        'right-sidebar' => esc_html__('Right', 'modus'),
        'none' => esc_html__('None', 'modus')
    );
}
function modus_settings() {
    global $modus_settings;
    return $modus_settings;
}
/******** logo Functions ***********/
function modus_logo($mobile = null){
    $config = modus_settings();
    $modus_header_layout = modus_header_types();
    if (isset($config['logo_white_image']) && $config['logo_white_image'] != '' && ($modus_header_layout == 'header_6' || $modus_header_layout == 'header_9' || $modus_header_layout == 'header_2' ) ) {
        echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_white_image']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';

    }elseif (isset($config['logo_header_7']) && $config['logo_header_7'] != '' && ($modus_header_layout == 'header_7')) {
        echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_header_7']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';
    }
    elseif(isset($config['logo_type']) && $config['logo_type'] == 'logo_image'){
        if($mobile == 'mobile' && $config['logo_image_mobile']['url']!=''){
            echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_image_mobile']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';
        }else{
            echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_image']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';
        }

    }
    else{
        ob_start();
        if ( is_front_page() && is_home() ) : ?>
            <h1 class="site-title"><?php echo esc_html($config['logo_text']); ?></h1>
        <?php else : ?>
            <p class="site-title"><?php echo esc_html($config['logo_text']); ?></p>
        <?php endif;
        echo ob_get_clean();
    }
}

/******** seach Functions **********/
function modus_search(){
    $config = modus_settings();
    $template = get_search_form(false);
    if(class_exists( 'WooCommerce' ) && isset($config['search_type']) && $config['search_type']=='product'){
        $template = get_product_search_form(false);
    }
    echo esc_attr($template );
}
function modus_excert($length,$post_id = 0) {
    if ( is_numeric( $post_id ) && $post_id > 0 ) {
        $post_obj = get_post( $post_id );
        $excerpt = $post_obj->post_excerpt;
        $content = strip_tags( apply_filters( 'the_content', $post_obj->post_content ) );
    } else {
        $excerpt = get_the_excerpt();
        $content = strip_tags( apply_filters( 'the_content', do_shortcode( get_the_content('') ) ) );
    }
    if ( mb_strlen( $excerpt ) > $length ) {
        $subex = mb_substr( $excerpt, 0, $length - 5 );
        $indicator = apply_filters( 'excerpt_more', '' );
    } else {
        if ( mb_strlen( $content ) > $length ) {
            $indicator = apply_filters( 'excerpt_more', '' );
            $subex = mb_substr( $content, 0, $length - 5 );
        } else {
            return $content;
        }
    }

    if ( ! strpos( $subex, ' ' ) ) return '';

    $exwords = explode( ' ', $subex );
    $excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
    if ( $excut < 0 ) {
        return trim( mb_substr( $subex, 0, $excut ) ) . $indicator;
    } else {
        return trim( $subex ) . $indicator;
    }
}
/****** Social Functions *******/
function modus_social($header_type){
    $modus_config = modus_settings();
    $modus_socials = $modus_config[$header_type.'_social'];
    if(count($modus_socials) > 0){
        echo '<ul class="modus_socials">';
        for($i=0; $i< count($modus_socials); $i++){
            echo '<li class="social"> <a href="'.esc_url($modus_config['social_'.$modus_socials[$i].'_link']).'" target="_blank"><i class="fa fa-'.$modus_socials[$i].'"></i></a></li>';
        }
        echo '</ul>';
    }
}
function modus_social_share($social,$link,$des){
    $modus_config = modus_settings();
    ?>
    <li class="share-buttons">
        <?php
        switch ($social) {
            case 'digg':
                ?>
                <a href="http://www.digg.com/submit?url=<?php echo esc_attr($link) ?>" target="_blank">
                    <span><i class="fa fa-digg"></i></span>
                </a>
                <?php
                break;
            case 'facebook':
                ?>
                <a href="http://www.facebook.com/sharer.php?u=<?php echo esc_attr($link) ?>&[title]=<?php echo esc_attr($des) ?>" target="_blank">
                    <span><i class="fa fa-facebook"></i></span>
                </a>
                <?php
                break;
            case 'google-plus':
                ?>
                <!-- Google+ -->
                <a href="https://plus.google.com/share?url=<?php echo esc_attr($link) ?>" target="_blank">
                    <span><i class="fa fa-google-plus"></i></span>
                </a>
                <?php
                break;
            case 'linkedin':
                ?>
                <!-- LinkedIn -->
                <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_attr($link) ?>" target="_blank">
                    <span><i class="fa fa-linkedin"></i></span>
                </a>
                <?php
                break;
            case 'pinterest':
                ?>
                <!-- Pinterest -->
                <a href="http://pinterest.com/pin/create/button/?url=<?php echo esc_attr($link) ?>&description=<?php  echo esc_attr($des)?>"  target="_blank">
                    <span><i class="fa fa-pinterest"></i></span>
                </a>
                <?php
                break;
            case 'reddit':
                ?>
                <!-- Reddit -->
                <a href="http://reddit.com/submit?url=<?php echo esc_attr($link) ?>&title=<?php echo esc_attr($des) ?>" target="_blank">
                    <span><i class="fa fa-reddit"></i></span>
                </a>
                <?php
                break;
            case 'stumbleUpon':
                ?>
                <!-- StumbleUpon-->
                <a href="http://www.stumbleupon.com/submit?url=<?php echo esc_attr($link) ?>&title=<?php echo esc_attr($des) ?>" target="_blank">
                    <span><i class="fa fa-stumbleUpon"></i></span>
                </a>
                <?php
                break;
            case 'tumblr':
                ?>
                <!-- Tumblr-->
                <a href="http://www.tumblr.com/share/link?url=<?php echo esc_attr($link) ?>&title=<?php echo esc_attr($des) ?>" target="_blank">
                    <span><i class="fa fa-tumblr"></i></span>
                </a>
                <?php
                break;
            case 'twitter':
                ?>
                <!-- Twitter -->
                <a href="https://twitter.com/share?url=<?php echo esc_attr($link) ?>& =<?php echo esc_attr($des) ?>" target="_blank">
                    <span><i class="fa fa-twitter"></i></span>
                </a>
                <?php
                break;
            case 'vk':
                ?>
                <!-- VK -->
                <a href="http://vkontakte.ru/share.php?url=<?php echo esc_attr($link) ?>" target="_blank">
                    <span><i class="fa fa-vk"></i></span>
                </a>
                <?php
                break;
            default:
                break;
        }
        ?>
    </li>
    <?php
}
/******** Breacrumb functions ********/
//breadcum...
function modus_breadcrumbs() {
    global $post, $wp_query, $author, $modus_settings;
    $prepend = '';
    $before = '<li>';
    $after = '</li>';
    $home = esc_html__('Home', 'modus');
    $shop_page_id = false;
    $shop_page = false;
    $front_page_shop = false;
    if ( defined( 'WOOCOMMERCE_VERSION' ) ) {
        $permalinks   = get_option( 'woocommerce_permalinks' );
        $shop_page_id = wc_get_page_id( 'shop' );
        $shop_page    = get_post( $shop_page_id );
        $front_page_shop = get_option( 'page_on_front' ) == wc_get_page_id( 'shop' );
    }
    // If permalinks contain the shop page in the URI prepend the breadcrumb with shop
    if ( $shop_page_id && $shop_page && strstr( $permalinks['product_base'], '/' . $shop_page->post_name ) && get_option( 'page_on_front' ) != $shop_page_id ) {
        $prepend = '<li>' . '<a href="' . get_permalink( $shop_page ) . '">' . $shop_page->post_title . '</a> ' . '</li>';
    }

    if ( ( ! is_home() && ! is_front_page() && ! ( is_post_type_archive() && $front_page_shop ) ) || is_paged() ) {
        echo '<ul class="breadcrumbs list-inline">';

        if ( ! empty( $home ) ) {
            echo '<li>' . '<a class="home" href="' . apply_filters( 'woocommerce_breadcrumb_home_url', home_url('/') ) . '">' . esc_html($home) . '</a>' . '</li>';
        }

        if ( is_home() ) {

            echo '<li>' . single_post_title('', false) . '</li>';

        } else if(is_search()){
            echo '<li>'. esc_html__( 'Search Results for: ', 'modus' ). get_search_query() .'</li>';

        }else if ( is_category()) {

            if ( get_option( 'show_on_front' ) == 'page' && get_option('page_for_posts' ) ) {
                echo '<li>' . '<a href="' . get_permalink( get_option('page_for_posts' ) ) . '">' . get_the_title( get_option('page_for_posts', true) ) . '</a>' . '</li>';
            }

            $cat_obj = $wp_query->get_queried_object();
            $this_category = get_category( $cat_obj->term_id );

            echo '<li>' . single_cat_title( '', false ) . '</li>';

        } elseif ( is_tax('product_cat') || is_tax('portfolio_cat')) {

            echo wp_kses_post($prepend);

            if ( is_tax('portfolio_cat') ) {
                $post_type = get_post_type_object( 'portfolio' );
                echo '<li>' . '<a href="' . get_post_type_archive_link( 'portfolio' ) . '">' . esc_html($post_type->labels->singular_name) . '</a>' . '</li>';
            }
            $current_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

            $ancestors = array_reverse( get_ancestors( $current_term->term_id, get_query_var( 'taxonomy' ) ) );

            foreach ( $ancestors as $ancestor ) {
                $ancestor = get_term( $ancestor, get_query_var( 'taxonomy' ) );

                echo '<li>' . '<a href="' . get_term_link( $ancestor->slug, get_query_var( 'taxonomy' ) ) . '">' . esc_html( $ancestor->name ) . '</a>' . '</li>';
            }

            echo '<li>' . esc_html( $current_term->name ) . '</li>';

        } elseif ( is_tax('product_tag') ) {

            $queried_object = $wp_query->get_queried_object();
            echo wp_kses_post($prepend) . '<li>' . ' ' . esc_html__( 'Products tagged &ldquo;', 'modus' ) . esc_html($queried_object->name) . '&rdquo;' . '</li>';

        } elseif ( is_day() ) {

            echo '<li>' . '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a>' . '</li>';
            echo '<li>' . '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a>' . '</li>';
            echo '<li>' . get_the_time('d') . '</li>';

        } elseif ( is_month() ) {

            echo '<li>' . '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a>' . '</li>';
            echo '<li>' . get_the_time('F') . '</li>';

        } elseif ( is_year() ) {

            echo '<li>' . get_the_time('Y') . '</li>';

        } elseif ( is_post_type_archive('product') && get_option('page_on_front') !== $shop_page_id ) {

            $_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';

            if ( ! $_name ) {
                $product_post_type = get_post_type_object( 'product' );
                $_name = $product_post_type->labels->singular_name;
            }

            if ( is_search() ) {

                echo '<li>' . '<a href="' . get_post_type_archive_link('product') . '">' . esc_html($_name) . '</a>' . esc_html__( 'Search results for &ldquo;', 'modus' ) . get_search_query() . '&rdquo;' . '</li>';

            } elseif ( is_paged() ) {

                echo '<li>' . '<a href="' . get_post_type_archive_link('product') . '">' . esc_html($_name) . '</a>' . '</li>';

            } else {

                echo '<li>' . esc_html($_name) . '</li>';

            }

        } elseif ( is_single() && ! is_attachment() ) {
            if ( 'product' == get_post_type() ) {

                echo wp_kses_post($prepend);

                if ( $terms = wc_get_product_terms( $post->ID, 'product_cat', array( 'orderby' => 'parent', 'order' => 'DESC' ) ) ) {
                    $main_term = $terms[0];
                    $ancestors = get_ancestors( $main_term->term_id, 'product_cat' );
                    $ancestors = array_reverse( $ancestors );

                    foreach ( $ancestors as $ancestor ) {
                        $ancestor = get_term( $ancestor, 'product_cat' );

                        if ( ! is_wp_error( $ancestor ) && $ancestor ) {
                            echo '<li>' . '<a href="' . get_term_link( $ancestor ) . '">' . esc_html($ancestor->name) . '</a>' . '</li>';
                        }
                    }

                    echo '<li>' . '<a href="' . get_term_link( $main_term ) . '">' . esc_html($main_term->name) . '</a>' . '</li>';

                }

                echo '<li>' . get_the_title() . '</li>';

            } elseif ( 'post' != get_post_type() ) {
                $post_type = get_post_type_object( get_post_type() );
                $slug = $post_type->rewrite;
                if ( is_taxonomy_hierarchical('portfolio_cat') ){
                    $taxonomies = get_object_taxonomies( $post_type, 'objects' );
                    $terms = wp_get_post_terms( $post->ID, 'portfolio_cat');
                    foreach ($terms as $term) :
                        echo '<li><a href="'.get_term_link($term->slug, 'portfolio_cat').'">'.esc_html__('Gallery','modus').'</a></li>';
                    endforeach;
                }else{
                    echo '<li>' . '<a href="' . get_post_type_archive_link( get_post_type() ) . '">' . esc_html($post_type->labels->singular_name) . '</a>' . '</li>';

                }

                echo '<li>' . get_the_title() . '</li>';

            } else {

                if ( 'post' == get_post_type() && get_option('page_for_posts' ) ) {
                    echo '<li>' . '<a href="' . get_permalink( get_option('page_for_posts' ) ) . '">' . get_the_title( get_option('page_for_posts', true) ) . '</a>' . '</li>';
                }

                $cat = current( get_the_category() );
                if ( ( $parents = get_category_parents( $cat, TRUE, $after . $before ) ) && ! is_wp_error( $parents ) ) {
                    echo '<li>' . substr( $parents, 0, strlen($parents) - strlen($after . $before) ) . '</li>';
                }
                echo '<li>' . get_the_title() . '</li>';

            }

        } elseif ( is_404() ) {

            echo '<li>' . esc_html__( '404', 'modus' ) . '</li>';

        } elseif ( ! is_single() && ! is_page() && get_post_type() != 'post' ) {

            $post_type = get_post_type_object( get_post_type() );

            if ( $post_type ) {
                echo '<li>' . esc_html($post_type->labels->singular_name) . '</li>';
            }

        } elseif ( is_attachment() ) {

            $parent = get_post( $post->post_parent );
            $cat = get_the_category( $parent->ID );
            $cat = $cat[0];
            if ( ( $parents = get_category_parents( $cat, TRUE, $after . $before ) ) && ! is_wp_error( $parents ) ) {
                echo '<li>' . substr( $parents, 0, strlen($parents) - strlen($after . $before) ) . '</li>';
            }
            echo '<li>' . '<a href="' . get_permalink( $parent ) . '">' . esc_html($parent->post_title) . '</a>'. '</li>';
            echo '<li>' . get_the_title() . '</li>';

        } elseif ( is_page() && !$post->post_parent ) {

            echo '<li>' . get_the_title() . '</li>';

        } elseif ( is_page() && $post->post_parent ) {

            $parent_id  = $post->post_parent;
            $breadcrumbs = array();

            while ( $parent_id ) {
                $page = get_post( $parent_id );
                $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title( $page->ID ) . '</a>';
                $parent_id  = $page->post_parent;
            }

            $breadcrumbs = array_reverse( $breadcrumbs );

            foreach ( $breadcrumbs as $crumb ) {
                echo ('<li>' . $crumb . '</li>');
            }

            echo '<li>' . get_the_title() . '</li>';

        } elseif ( is_search() ) {

            echo '<li>' . esc_html__( 'Search results for &ldquo;', 'modus' ) . get_search_query() . '&rdquo;' . '</li>';

        } elseif ( is_tag() ) {

            echo '<li>' . esc_html__( 'Posts tagged &ldquo;', 'modus' ) . single_tag_title('', false) . '&rdquo;' . '</li>';

        } elseif ( is_author() ) {

            $userdata = get_userdata($author);
            echo '<li>' . esc_html__( 'Author:', 'modus' ) . ' ' . esc_html($userdata->display_name) . '</li>';

        }

        if ( get_query_var( 'paged' ) ) {
            echo '<li>' . '&nbsp;(' . esc_html__( 'Page', 'modus' ) . ' ' . get_query_var( 'paged' ) . ')' . '</li>';
        }

        echo '</ul>';
    } else {
        if ( is_home() && !is_front_page() ) {
            if( $modus_settings['blog_title'] !=''){
                if(get_option('blog_title')){
                    $blog_title = get_option('blog_title');
                }else{
                    $blog_title = $modus_settings['blog_title'];
                }
            }
            echo '<ul class="breadcrumbs list-inline">';

            if ( ! empty( $home ) ) {
                echo '<li>' . '<a class="home" href="' . apply_filters( 'woocommerce_breadcrumb_home_url', home_url('/') ) . '">' . esc_html($home) . '</a>' . '</li>';

                echo '<li>' . esc_html($blog_title) . '</li>';
            }

            echo '</ul>';
        }
    }
}
function modus_page_title() {
    global $modus_settings, $post, $wp_query, $author;
    $home = esc_html__('Home', 'modus');
    $shop_page_id = false;
    $front_page_shop = false;
    if ( defined( 'WOOCOMMERCE_VERSION' ) ) {
        $shop_page_id = wc_get_page_id( 'shop' );
        $front_page_shop = get_option( 'page_on_front' ) == wc_get_page_id( 'shop' );
    }

    if ( ( ! is_home() && ! is_front_page() && ! ( is_post_type_archive() && $front_page_shop ) ) || is_paged() ) {

        if ( is_home() ) {

        } else if ( is_category() ) {

            echo single_cat_title( '', false );

        } elseif ( is_tax('product_cat') || is_tax('portfolio_cat')) {

            $current_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

            echo esc_html( $current_term->name );

        } elseif ( is_tax('product_tag') ) {

            $queried_object = $wp_query->get_queried_object();
            echo esc_html__( 'Products tagged &ldquo;', 'modus' ) . $queried_object->name . '&rdquo;';

        } elseif ( is_day() ) {

            printf( esc_html__( 'Daily Archives: %s', 'modus' ), get_the_date() );

        } elseif ( is_month() ) {

            printf( esc_html__( 'Monthly Archives: %s', 'modus' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'modus' ) ) );

        } elseif ( is_year() ) {

            printf( esc_html__( 'Yearly Archives: %s', 'modus' ), get_the_date( _x( 'Y', 'yearly archives date format', 'modus' ) ) );

        } elseif ( is_post_type_archive('product') && get_option('page_on_front') !== $shop_page_id ) {

            $_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';

            if ( ! $_name ) {
                $product_post_type = get_post_type_object( 'product' );
                $_name = $product_post_type->labels->singular_name;
            }

            if ( is_search() ) {

            } elseif ( is_paged() ) {

            } else {

                echo esc_html($_name);

            }

        } elseif ( is_post_type_archive('portfolio') ) {

            $post_type = get_post_type_object( 'portfolio' );
            echo esc_html($post_type->labels->name);

        } else if ( is_post_type_archive() ) {
            sprintf( esc_html__( 'Archives: %s', 'modus' ), post_type_archive_title( '', false ) );
        } elseif ( is_single() && ! is_attachment() ) {

            if ( 'portfolio' == get_post_type() ) {

                echo get_the_title();

            } else {

                echo get_the_title();

            }

        } elseif ( is_404() ) {

            echo esc_html__( '404', 'modus' );

        } elseif ( ! is_single() && ! is_page() && get_post_type() != 'post' ) {

            $post_type = get_post_type_object( get_post_type() );

            if ( $post_type ) {
                echo esc_html($post_type->labels->singular_name);
            }

        } elseif ( is_attachment() ) {

            echo get_the_title();

        } elseif ( is_page() && !$post->post_parent ) {

            echo get_the_title();

        } elseif ( is_page() && $post->post_parent ) {

            echo get_the_title();

        } elseif ( is_search() ) {

            echo esc_html__( 'Search results for &ldquo;', 'modus' ) . get_search_query() . '&rdquo;';

        } elseif ( is_tag() ) {

            echo esc_html__( 'Posts tagged &ldquo;', 'modus' ) . single_tag_title('', false) . '&rdquo;';

        } elseif ( is_author() ) {

            $userdata = get_userdata($author);
            echo esc_html__( 'Author:', 'modus' ) . ' ' . $userdata->display_name;

        }

        if ( get_query_var( 'paged' ) ) {
            echo ' (' . esc_html__( 'Page', 'modus' ) . ' ' . get_query_var( 'paged' ) . ')';
        }
    } else {
        if ( is_home() && !is_front_page() ) {
            if( $modus_settings['blog_title'] !=''){
                if(get_option('blog_title')){
                    $blog_title = get_option('blog_title');
                }else{
                    $blog_title = $modus_settings['blog_title'];
                }
            }
            if ( ! empty( $home ) ) {
                echo esc_html($blog_title);
            }
        }
    }
}
function modus_heading_banner($type) {
    $config = modus_settings();
    $breadcrumbs_type = modus_get_meta_value('banner_color', false);
    $class_bg = 'default';
    $modus_style='';
    ob_start();
    ?>
    <div class="page-banner small">
        <?php
        if( $breadcrumbs_type == 'banner_color' ) {
            if( $config[$type.'_bg_color'] !=''){
                $class_bg = 'bg_color';
                $modus_style = 'background-color:'. $config[$type.'_bg_color'];
            }else {
                $class_bg = 'default';
            }
        }elseif( $config[$type.'_banner'] =='show' ) {
            if( $config[$type.'_bg'] =='show' ) {
                if( $config[$type.'_bg_image'] !=''){
                    $modus_style = 'background-image:url('.esc_url( $config[$type.'_bg_image']['url'] ).')';
                    $class_bg = 'bg_image';
                }else{
                    $class_bg = 'default';
                }
            }else{
                if( $config[$type.'_bg_color'] !=''){
                    $class_bg = 'bg_color';
                    $modus_style = 'background-color:'. $config[$type.'_bg_color'];
                }else {
                    $class_bg = 'default';
                }
            }
        }
        ?>
        <div class="breadcrumb <?php echo esc_attr($class_bg); ?>" style="<?php echo esc_attr($modus_style); ?>">
            <div class="breadcrumbs-content">
                <div class="container">
                    <div class="table-middle">
                        <div class="table-cell">
                            <div class="page-title">
                                <h1 class="heading text-uppercase"><?php modus_page_title(); ?></h1>
                            </div>
                            <?php modus_breadcrumbs(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    echo ob_get_clean();
}
/*modus Pagination Custom*/
function custom_pagination($numpages = '', $pagerange = '', $paged='') {

    if (empty($pagerange)) {
        $pagerange = 2;
    }
    global $paged;
    if (empty($paged)) {
        $paged = 1;
    }
    if ($numpages == '') {
        global $wp_query;
        $numpages = $wp_query->max_num_pages;
        if(!$numpages) {
            $numpages = 1;
        }
    }
    $pagination_args = array(
        'base'            => get_pagenum_link(1) . '%_%',
        'format'          => 'page/%#%',
        'total'           => $numpages,
        'current'         => $paged,
        'show_all'        => False,
        'end_size'        => 1,
        'mid_size'        => $pagerange,
        'prev_next'       => True,
        'prev_text'       => '<',
        'next_text'       => '>',
        'type'            => 'plain',
        'add_args'        => false,
        'add_fragment'    => ''
    );

    $paginate_links = paginate_links($pagination_args);

    if ($paginate_links) {
        echo "<nav class='custom-pagination'>";
        echo esc_attr($paginate_links);
        echo "</nav>";
    }

}
/***** Header Footer functions ******/
function modus_header_show(){
    global $post;
    $modus_header_show = 'show_header';
    if(is_page()){
        $modus_id = $post->ID;
    }
    elseif(function_exists('is_shop') && is_shop()){
        $modus_id = get_option( 'woocommerce_shop_page_id' );
    }
    else{
        $modus_id = -1;
    }
    if(get_post_meta($modus_id, 'hidden_header', true)){
        $modus_header_show = get_post_meta($modus_id, 'hidden_header', true);
    }
    return $modus_header_show;
}
function modus_header_types() {
    global $post;
    $config = modus_settings();
    $modus_header_show = 'show_header';
    $modus_header_layout = '';
    $modus_header_layout = $config['header_selected'];

    if(is_page()){
        $modus_id = $post->ID;
    }
    elseif(function_exists('is_shop') && is_shop()){
        $modus_id = get_option( 'woocommerce_shop_page_id' );
    }
    else{
        $modus_id = -1;
    }
    if(get_post_meta($modus_id, 'hidden_header', true)){
        $modus_header_show = get_post_meta($modus_id, 'hidden_header', true);
    }
    if(get_post_meta($modus_id, 'header_layout', true) && get_post_meta($modus_id, 'header_layout', true) !='default'){
        $modus_header_layout = get_post_meta($modus_id, 'header_layout', true);


    }
    return $modus_header_layout;
}
function modus_header() {
    $modus_header_layout = modus_header_types();
    $modus_header_show = modus_header_show();
    ob_start();
    if($modus_header_show == 'show_header'){
        switch($modus_header_layout){
            case 'header_1':
                get_template_part( 'inc/template-parts/headers/header-1' );
                break;
            case 'header_2':
                get_template_part( 'inc/template-parts/headers/header-2' );
                break;
            case 'header_3':
                get_template_part( 'inc/template-parts/headers/header-3' );
                break;
            case 'header_4':
                get_template_part( 'inc/template-parts/headers/header-4' );
                break;
            case 'header_5':
                get_template_part( 'inc/template-parts/headers/header-5' );
                break;
            case 'header_6':
                get_template_part( 'inc/template-parts/headers/header-6' );
                break;
            case 'header_7':
                get_template_part( 'inc/template-parts/headers/header-7' );
                break;
            case 'header_8':
                get_template_part( 'inc/template-parts/headers/header-8' );
                break;
            case 'header_9':
                get_template_part( 'inc/template-parts/headers/header-9' );
                break;
            case 'header_10':
                get_template_part( 'inc/template-parts/headers/header-10' );
                break;
            case 'header_11':
                get_template_part( 'inc/template-parts/headers/header-11' );
                break;
            default :
                get_template_part( 'inc/template-parts/headers/header-1' );
                break;
        }
    }else{
        echo '<div class="site-inner"></div>';
    }
    echo ob_get_clean();
}
function modus_footer_types() {
    global $post;
    $modus_config = modus_settings();
    ob_start();
    $modus_footer_show = 'show_footer';
    $modus_footer_layout = '';
    $modus_footer_layout = $modus_config['footer_selected'];
    if(is_page()){
        $modus_id = $post->ID;
    }
    elseif(function_exists('is_shop') && is_shop()){
        $modus_id = get_option( 'woocommerce_shop_page_id' );
    }
    else{
        $modus_id = -1;
    }
    $posttype = get_post_type($post );
    if(get_post_meta($modus_id, 'hidden_footer', true)){
        $modus_footer_show = get_post_meta($modus_id, 'hidden_footer', true);
    }
    if(get_post_meta($modus_id, 'footer_layout', true) && get_post_meta($modus_id, 'footer_layout', true) !='default'){
        $modus_footer_layout = get_post_meta($modus_id, 'footer_layout', true);
    }
    if($modus_footer_show == 'show_footer'){
        switch($modus_footer_layout){
            case 'footer_1':
                get_template_part( 'inc/template-parts/footers/footer-1' );
                break;
            case 'footer_2':
                get_template_part( 'inc/template-parts/footers/footer-2' );
                break;
            case 'footer_3':
                get_template_part( 'inc/template-parts/footers/footer-3' );
                break;
            case 'footer_4':
                get_template_part( 'inc/template-parts/footers/footer-4' );
                break;
            case 'footer_5':
                get_template_part( 'inc/template-parts/footers/footer-5' );
                break;
            case 'footer_6':
                get_template_part( 'inc/template-parts/footers/footer-6' );
                break;
            case 'footer_7':
                get_template_part( 'inc/template-parts/footers/footer-7' );
                break;
            case 'footer_8':
                get_template_part( 'inc/template-parts/footers/footer-8' );
                break;
            case 'footer_9':
                get_template_part( 'inc/template-parts/footers/footer-9' );
                break;
            case 'footer_10':
                get_template_part( 'inc/template-parts/footers/footer-10' );
                break;
            case 'footer_11':
                get_template_part( 'inc/template-parts/footers/footer-11' );
                break;
            default :
                get_template_part( 'inc/template-parts/footers/footer-1' );
                break;
        }
    }
    echo ob_get_clean();
}