<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	<?php $modus_settings = modus_settings();
		if ((! function_exists( 'has_site_icon' ) || ! has_site_icon()) &&!empty($modus_settings['favicon_main'])): ?>
			<link rel="shortcut icon" href="<?php echo esc_url( is_ssl() ? (str_replace("http://","https://",$modus_settings['favicon_main']['url'])) : $modus_settings['favicon_main']['url'])?> "/>
    <?php endif; ?>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
	modus_loader();
?>
<?php
	$modus_config = modus_settings();
	$show_title = 'show';
	if (isset($modus_config['page_title']) && $modus_config['page_title'] != '') {
		$show_title = $modus_config['page_title'];
	}
	if (get_post_meta(get_the_ID(), 'show_title_page', true) != '' && get_post_meta(get_the_ID(), 'show_title_page', true) != 'default') {
		$show_title = get_post_meta(get_the_ID(), 'show_title_page', true);
	}
	$page_show_breadcrumb = 'hide';
	if (isset($modus_config['page_bread_crumb']) && $modus_config['page_bread_crumb'] != '') {
		$page_show_breadcrumb = $modus_config['page_bread_crumb'];
	}
	if (get_post_meta(get_the_ID(), 'show_breadcrumb', true) != '' && get_post_meta(get_the_ID(), 'show_breadcrumb', true) != 'default') {
		$page_show_breadcrumb = get_post_meta(get_the_ID(), 'show_breadcrumb', true);
	}
?>
<div id="page" class="site <?php if ($show_title == 'show' && $page_show_breadcrumb == 'show'){ echo 'show-breadcrumb';} ?> <?php echo esc_attr(modus_header_fixed_2())?>">
	<div class="site-inner">
		<header id="masthead">
			<?php modus_header() ; ?>
		</header><!-- .site-header -->
		<div id="content" class="site-content">