<?php
/**
 * The template for displaying comments
 *
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div id="comments" class="comments-area">  
	<?php if (get_comments_number() > 0){ ?>
		<div class="count-cmt">
			<span>
				<?php
					echo get_comments_number() .' ';
					if ( get_comments_number() > 1 ){
						echo esc_html__('Comment(s)','modus');
					}else{
						echo esc_html__('Comment','modus');
					}
				?>
			</span>
		</div>
	<?php } ?>
	<?php if ( have_comments() ) : ?>

		<?php the_comments_navigation(); ?>

		<ul class="comment-list">
			<?php
				wp_list_comments( array(
					'style'       => 'ul',
					'short_ping'  => true,
					'avatar_size' => 100,
					'callback'      => 'modus_theme_comments'
				) );
			?>
		</ul><!-- .comment-list -->

		<?php the_comments_navigation(); ?>

	<?php endif; // Check for have_comments(). ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'modus' ); ?></p>
	<?php endif; ?>
	<?php
	    $commenter = wp_get_current_commenter();
	    $req = get_option( 'require_name__mail' );
	    $aria_req = ( $req ? " aria-required='true'" : '' );
	    if ( !is_user_logged_in() ):
    	 	$args = array(
                'id_form'           => 'commentform',
                'id_submit'         => 'submit',
                'title_reply_before'=> '<span class="title-reply">',
                'title_reply_after'=> '</span><p>'. esc_html__('Your email address will not be published. Required fields are marked *', 'modus') .'</p>',
                'title_reply'       => esc_html__( 'Leave a reply', 'modus' ),
                'title_reply_to'    => esc_html__( 'Leave a reply to %s', 'modus' ),
                'cancel_reply_link' => esc_html__( 'Cancel reply', 'modus' ),
                'label_submit'      => esc_html__( 'Post Comment', 'modus' ),
                'comment_notes_before' => '',
                'fields' => apply_filters( 'comment_form_default_fields', array(
                    'author' =>
                        '<div class="inputField"><div class="row">' .
                        '<div class="col-md-4"><input class="grey_comment" name="author" type="text" aria-required="true" required="required" placeholder="' . esc_attr__( 'Your Name*', 'modus' ) . '"/></div>' ,
                    'email' =>
                                '<div class="col-md-4"><input class="grey_comment" name="email" type="email" aria-describedby="email-notes" aria-required="true"' .
                                ' required="required" placeholder="' . esc_attr__( 'Your Email*', 'modus' ) . '"/></div>'  ,
                    'subject' =>
                                '<div class="col-md-4"><input class="grey_comment" name="subject" type="text" aria-describedby="subject-notes" aria-required="true"' .
                                ' required="required" placeholder="' . esc_attr__( 'Your subject*', 'modus' ) . '"/></div></div></div>',
                    'comment_field' =>
                        '<textarea class="grey_comment" id="comment" name="comment" placeholder="'. esc_attr__('Your comment', 'modus' ).'" aria-required="true">' .
                        '</textarea>',
                    )
                ),
                'comment_field' =>
                        '',
                'comment_notes_after' => '',
        );
	    else :
	        $args = array(
	                'id_form'           => 'commentform',
	                'id_submit'         => 'submit',
	                'title_reply_before'=> '<span class="title-reply">',
	                'title_reply_after'=> '</span>',
	                'title_reply'       => esc_html__( 'Leave a reply', 'modus' ),
	                'title_reply_to'    => esc_html__( 'Leave a Rreply to %s', 'modus' ),
	                'cancel_reply_link' => esc_html__( 'Cancel reply', 'modus' ),
	                'label_submit'      => esc_html__( 'Add comment', 'modus' ),
	                'comment_notes_before' => '',
	                'fields' => apply_filters( 'comment_form_default_fields', array(
	                    'author' =>
	                        '<div class="inputField">' .
	                                '<input class="grey_comment f_left" name="author" type="text" aria-required="true" required="required" placeholder="' . esc_attr__( 'Your Name', 'modus' ) . '"/>' ,

	                    'email' =>

	                                '<input class="grey_comment f_right" name="email" type="email" aria-describedby="email-notes" aria-required="true"' .
	                                    ' required="required" placeholder="' . esc_attr__( 'Your Email', 'modus' ) . '"/></div>'  ,
	                )
	                ),
	                'comment_field' =>
	                        '<textarea class="grey_comment" id="comment" name="comment" placeholder="'. esc_attr__('Your Comment', 'modus' ).'" aria-required="true">' .
	                        '</textarea>',
	                'comment_notes_after' => '',
	        );
	    endif;
	    comment_form($args);?>

</div><!-- .comments-area -->
