// page init
jQuery(function(){
    "use strict";
    initGoogleMap();
});
function initGoogleMap() {
	if(jQuery('.modus_map_api').length){
		jQuery('.modus_map_api').each(function(){
			var url_img = jQuery(this).find('.map-info').attr('data-image');
			var info_map = jQuery(this).find('.map-info');
			jQuery(this).find('.map').googleMapAPI({
				marker: url_img,
				mapInfoContent: info_map,
				streetViewControl: true,
				mapTypeControl: true,
				scrollwheel: true,
				panControl: true,
				zoomControl: true
			});
		});
	}
}
/*!
 * Google Map module
 */

;(function($) {
	function GoogleMapAPI(options) {
		this.options = $.extend({
			mapTypeId: google.maps.MapTypeId.ROADMAP
		}, options);
		this.init();
	}

	GoogleMapAPI.prototype = {
		init: function() {
			this.findStructure();
			this.getInfoWindowContent();
			this.createMap();
			this.createMarker();
			this.createInfoWindow();
		},

		findStructure: function() {
            this.container = $(this.options.container);
            this.lat = parseFloat(this.container.attr('data-lat'));
            this.lng = parseFloat(this.container.attr('data-lng'));
            this.coords = new google.maps.LatLng(this.lat, this.lng);
            this.zoom = parseInt(this.container.attr('data-zoom'));
            this.infoWindowContent = this.container.find('.map-info');
            this.mapOptions = {
                mapTypeId: this.options.mapTypeId,
                panControl: this.options.panControl,
                zoomControl: this.options.zoomControl,
                streetViewControl: this.options.streetViewControl,
                mapTypeControl: this.options.mapTypeControl,
                center: this.coords,
                scrollwheel: this.options.scrollwheel,
                zoom: this.zoom,
                styles: [{"featureType":"water","elementType":"geometry.fill","stylers":[{"color":"#35adea"}]},{"featureType":"transit","stylers":[{"color":"#808080"},{"visibility":"off"}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"visibility":"on"},{"color":"#b3b3b3"}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"road.local","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#ffffff"},{"weight":1.8}]},{"featureType":"road.local","elementType":"geometry.stroke","stylers":[{"color":"#d7d7d7"}]},{"featureType":"poi","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#ebebeb"}]},{"featureType":"administrative","elementType":"geometry","stylers":[{"color":"#a7a7a7"}]},{"featureType":"road.arterial","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"road.arterial","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"landscape","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#efefef"}]},{"featureType":"road","elementType":"labels.text.fill","stylers":[{"color":"#696969"}]},{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"visibility":"on"},{"color":"#000000"}]},{"featureType":"poi","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"poi","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"road.arterial","elementType":"geometry.stroke","stylers":[{"color":"#d6d6d6"}]},{"featureType":"road","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{},{"featureType":"poi","elementType":"geometry.fill","stylers":[{"color":"#dadada"}]}]
            };
        },

		getInfoWindowContent: function() {
			this.infoWindowContent = this.options.mapInfoContent;
		},

		createMap: function() {
			this.map = new google.maps.Map(this.container.get(0), this.mapOptions);
		},

		createMarker: function() {
			this.marker = new google.maps.Marker({
				icon: this.options.marker,
				position: this.coords
			});

			this.marker.setMap(this.map);
		},

		createInfoWindow: function() {
			var self = this;
			this.infoWindow = new google.maps.InfoWindow({
				content: this.infoWindowContent.get(0)
			});
			this.marker.addListener('click', function() {
				self.infoWindow.open(self.map, self.marker);
			});
		}
	};

	$.fn.googleMapAPI = function(opt) {
		return this.each(function() {
			$(this).data('GoogleMapAPI', new GoogleMapAPI($.extend(opt, {container: this})));
		});
	};
}(jQuery));