// page init
jQuery(function () {
    "use strict";
    initScollTop();
    initSlide_product('.initSlide_product');
    initSlideList('.initSlide_client');
    initSlideList('.slide-product');
    initSlideList('.slide-product-widget');
    initSlideList('.slide-product-custom');
    initStickyHeader();
    modus_initmegamenu();
    modus_404();
    modus_initloader();
    modus_initIsotopControl();
    init_ultimate_spacer_custom();
});
function modus_initIsotopControl() {
    var isotopeHolder = jQuery('.icotop-holder'),
        win = jQuery(window);
    isotopeHolder.isotope({transitionDuration: '0.75s'});

    setTimeout(function () {
        isotopeHolder.isotope('layout');
    }, 100);
    win.resize(function () {
        isotopeHolder.isotope('layout');
    });
    jQuery('.list-view-as li').each(function (index, el) {
        jQuery(this).on("click", function () {
            setTimeout(function () {
                isotopeHolder.isotope('layout');
            }, 100);
            win.resize(function () {
                isotopeHolder.isotope('layout');
            });
        });
    });
}

function modus_404() {
    jQuery(document).ready(function () {
        if (jQuery(".home404").length > 0) {
            jQuery(window).height();
            jQuery('.content-area').css('min-height', (jQuery(window).height() - jQuery('.site-header').innerHeight()));
        }
    });
    jQuery(window).resize(function () {
        if (jQuery(".home404").length > 0) {
            jQuery(window).height();
            jQuery('.content-area').css('min-height', (jQuery(window).height() - jQuery('.site-header').innerHeight()));
        }
    });
}

function modus_getAbsolutePath() {
    var loc = window.location;
    var pathName = loc.pathname.substring(0, loc.pathname.lastIndexOf('/') + 1);
    return loc.href.substring(0, loc.href.length - ((loc.pathname + loc.search + loc.hash).length - pathName.length));
}

function modus_initmegamenu() {
    jQuery(document).ready(function () {
        var currentURL = modus_getAbsolutePath();
        if (jQuery(window).width() > 991) {
            jQuery('li.megamenu .menu_fullwidth').each(function () {
                var fullwidth = jQuery(this);
                var offset = fullwidth.offset();
                var offset_left = offset.left;
                fullwidth.css('left', -offset_left + 'px');
                fullwidth.css('width', jQuery('.site-content').width());

            });
            jQuery('li.megamenu .megamenu_right').each(function () {
                var megamenu_right = jQuery(this);
                var width = megamenu_right.attr('data-width');
                var width_wrap = jQuery('header').find('.header_wrap').innerWidth();
                megamenu_right.css('width', width + 'px');
                if (megamenu_right.innerWidth() > width_wrap) {
                    megamenu_right.css('width', width_wrap);
                }
                var offset = megamenu_right.closest('li').offset();
                var offset_right = jQuery(window).width() - offset.left - (jQuery(window).width() - width_wrap) / 2;
                if (offset_right > megamenu_right.innerWidth()) {
                    megamenu_right.addClass('mega_center');
                }
            });
            jQuery('.menu_items li').each(function () {
                var menu_item_href = jQuery(this).find('a').attr('href');
                if (menu_item_href == currentURL) {
                    jQuery(this).addClass('current_page_item');
                    var current_item = jQuery(this).attr('data-iteme');
                    jQuery(this).closest('.mega-menu-items').find('.menu_images li.' + current_item).addClass('active');
                }
                jQuery(this).hover(
                    function () {
                        var current_item = jQuery(this).attr('data-iteme');
                        if (jQuery(this).closest('.mega-menu-items').find('.menu_images li.' + current_item).hasClass('active')) {

                        } else {
                            jQuery(this).closest('.mega-menu-items').find('.menu_images li.active').addClass('current');
                            jQuery(this).closest('.mega-menu-items').find('.menu_images li').addClass('unhover');
                            jQuery(this).closest('.mega-menu-items').find('.menu_images li.' + current_item).removeClass('unhover');
                            jQuery(this).closest('.mega-menu-items').find('.menu_images li.' + current_item).addClass('hover');
                        }
                    }, function () {
                        var current_item = jQuery(this).attr('data-iteme');
                        jQuery(this).closest('.mega-menu-items').find('.menu_images li').removeClass('unhover');
                        if (jQuery(this).closest('.mega-menu-items').find('.menu_images li.' + current_item).hasClass('active')) {
                        } else {
                            jQuery(this).closest('.mega-menu-items').find('.menu_images li.' + current_item).addClass('current');
                        }
                        jQuery(this).closest('.mega-menu-items').find('.menu_images li.' + current_item).removeClass('hover');
                        setTimeout(function () {
                                jQuery('.mega-menu-items .menu_images li').removeClass('current');
                            },
                            500);
                    }
                );
            });
        } else {
            jQuery('.header-over').each(function () {
                jQuery(this).addClass('header-over-rm');
                jQuery(this).removeClass('header-over');
            });
        }
    });
    jQuery(window).resize(function () {
        if (jQuery(window).width() > 991) {
            jQuery('li.megamenu .menu_fullwidth').each(function () {
                var fullwidth = jQuery(this);
                fullwidth.css('left', 0);
                var offset = fullwidth.offset();
                var offset_left = offset.left;
                fullwidth.css('left', -offset_left + 'px');
                fullwidth.css('width', jQuery('.site-content').width());

            });
            jQuery('li.megamenu .megamenu_right').each(function () {
                var megamenu_right = jQuery(this);
                megamenu_right.removeClass('mega_center');
                var offset = megamenu_right.closest('li').offset();
                var width = megamenu_right.attr('data-width');
                var width_wrap = megamenu_right.closest('.header_wrap').innerWidth();
                var offset_right = jQuery(window).width() - offset.left - (jQuery(window).width() - width_wrap) / 2;
                megamenu_right.css('width', width + 'px');
                if (megamenu_right.innerWidth() > width_wrap) {
                    megamenu_right.css('width', width_wrap);
                }
                if (offset_right > megamenu_right.innerWidth()) {
                    megamenu_right.addClass('mega_center');
                }
            });
            jQuery('.header-over-rm').each(function () {
                jQuery(this).addClass('header-over');
                jQuery(this).removeClass('header-over-rm');
            });
        } else {
            jQuery('li.megamenu').each(function () {
                if (jQuery(this).find('> .menu_fullwidth > ul.sub-menu').length) {
                    var container = jQuery(this).find(' > .menu_fullwidth > ul.sub-menu');
                    container.unwrap();
                }
            });
            jQuery('.header-over').each(function () {
                jQuery(this).addClass('header-over-rm');
                jQuery(this).removeClass('header-over');
            });
        }
    });

}

function modus_initloader() {
    jQuery(window).load(function () {
        if (jQuery(".loaderWrap").length > 0) {
            jQuery(".loaderWrap").delay(300).fadeOut("slow");
        }
    });
}

//Scoll Top
function initScollTop() {
    if (jQuery('.scroll-to-top').length) {
        var linkTop = jQuery('.scroll-to-top');
        var animationSpeed = 600;

        linkTop.on("click", function (e) {
            e.preventDefault();

            jQuery('body,html').stop(true).animate({
                scrollTop: 0
            }, animationSpeed);
        });

        initGoToTopScroll();
    }

    jQuery(window).scroll(function () {
        initGoToTopScroll();
    });

    function initGoToTopScroll() {
        var linkTop = jQuery('.scroll-to-top'),
            win = jQuery(window);

        if (win.scrollTop() > 0) {
            linkTop.css('bottom', '25px');
        } else {
            linkTop.css('bottom', '-100px');
        }
    }
}

function initSlide_product(element) {
    jQuery(document).ready(function () {
        var $rtl = false;
        if (modus_params.modus_rtl == 'yes') {
            $rtl = true;
        }
        jQuery(element + ' .beans-stepslider').each(function () {
            var item = jQuery(this);
            var column = item.parent().attr('data-columns');
            var btnPrev = item.find('.btn-prev');
            var btnNext = item.find('.btn-next');
            var slider = item.find('.beans-slideset');
            var pagination = item.find('.beans-pagination');
            var column_768 = 1, column_640 = 1, column_480 = 1;
            if (parseInt(column) > 3) {
                column_1024 = parseInt(column) - 1;
            } else {
                column_1024 = parseInt(column);
            }
            if (parseInt(column) > 3) {
                column_992 = parseInt(column) - 2;
            } else {
                column_992 = parseInt(column);
            }
            if (item.parent().attr('data-column1024')) {
                column_1024 = item.parent().attr('data-column1024');
            }
            if (item.parent().attr('data-column992')) {
                column_992 = item.parent().attr('data-column992');
            }
            if (item.parent().attr('data-column768')) {
                column_768 = item.parent().attr('data-column768');
            }
            if (item.parent().attr('data-column640')) {
                column_640 = item.parent().attr('data-column640');
            }
            slider.slick({
                prevArrow: '<button type="button" class="slick-prev"><i class="Pe-icon-7-stroke-angle-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="Pe-icon-7-stroke-angle-right"></i></button>',
                arrows: (btnPrev.length > 0) && (btnNext.length > 0) ? true : false,
                dots: pagination.length > 0 ? true : false,
                rtl: $rtl,
                slidesToShow: parseInt(column),
                slidesToScroll: parseInt(column),
                autoplay: false,
                responsive: [
                    {
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: parseInt(column_1024),
                            slidesToScroll: parseInt(column_1024),
                        }
                    }, {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: parseInt(column_992),
                            slidesToScroll: parseInt(column_992),
                        }
                    }, {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: parseInt(column_768),
                            slidesToScroll: parseInt(column_768),
                        }
                    }, {
                        breakpoint: 640,
                        settings: {
                            slidesToShow: parseInt(column_640),
                            slidesToScroll: parseInt(column_640),
                        }
                    }
                ]
            });
            pagination.remove();
            btnPrev.remove();
            btnNext.remove();
        });
    });
}

/*slider thumb single product*/
function initProductSlide_thumb(element) {
    jQuery(element + ' .beans-stepslider').each(function () {
        var $rtl = false;
        if (modus_params.modus_rtl == 'yes') {
            $rtl = true;
        }
        var item = jQuery(this);
        var btnPrev = item.find('.btn-prev');
        var btnNext = item.find('.btn-next');
        var slider = item.find('.beans-slideset');
        var pagination = item.find('.beans-pagination');

        slider.slick({
            arrows: (btnPrev.length > 0) && (btnNext.length > 0) ? true : false,
            dots: pagination.length > 0 ? true : false,
            rtl: $rtl,
            slidesToShow: 1,
            mobileFirst: true,
            autoplay: false,
            responsive: [
                {
                    breakpoint: 1024,
                    settings: {
                        slidesToShow: 3
                    }
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: 3
                    }
                },
                {
                    breakpoint: 640,
                    settings: {
                        slidesToShow: 2
                    }
                },
                {
                    breakpoint: 320,
                    settings: {
                        slidesToShow: 2
                    }
                }
            ]
        });
        slider.slick('setPosition');
        pagination.remove();
        btnPrev.remove();
        btnNext.remove();
    });
}

function initSlideList(element) {
    jQuery(element).each(function () {
        var $rtl = false;
        if (modus_params.modus_rtl == 'yes') {
            $rtl = true;
        }
        var item = jQuery(this);
        var column = item.attr('data-columns');
        var row = item.attr('data-rows');
        var btnPrev = item.find('.btn-prev');
        var btnNext = item.find('.btn-next');
        var slider = item.find('.beans-slideset');
        var pagination = item.find('.beans-pagination');
        var column_responsive = 3;
        var column_responsive_2 = 3;
        var column_responsive_1 = 2;
        if (element != '.slide-product-widget') {
            var arrow_prev = item.closest('.modus-product').find('.heading-title .slide-control-custom .prev');
            var arrow_next = item.closest('.modus-product').find('.heading-title .slide-control-custom .next');
            if (parseInt(column) <= 3) {
                if (parseInt(column) > 1) {
                    column_responsive = parseInt(column);
                    column_responsive_2 = parseInt(column);
                }
            }
        } else {
            var arrow_prev = '<button type="button" class="slick-prev"><i class="Pe-icon-7-stroke-angle-left"></i></button>';
            var arrow_next = '<button type="button" class="slick-next"><i class="Pe-icon-7-stroke-angle-right"></i></button>';
            column_responsive = 1;
            column_responsive_2 = 2;
        }
        slider.slick({
            prevArrow: arrow_prev,
            nextArrow: arrow_next,
            arrows: (btnPrev.length > 0) && (btnNext.length > 0) ? true : false,
            dots: pagination.length > 0 ? true : false,
            rtl: $rtl,
            slidesToShow: 1,
            slidesToScroll: 1,
            mobileFirst: true,
            autoplay: false,
            rows: parseInt(row),
            responsive: [
                {
                    breakpoint: 1366,
                    settings: {
                        slidesToShow: parseInt(column),
                    }
                },
                {
                    breakpoint: 1024,
                    settings: {
                        slidesToShow: parseInt(column),
                    }
                },
                {
                    breakpoint: 991,
                    settings: {
                        slidesToShow: parseInt(column_responsive),
                    }
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: parseInt(column_responsive_2),
                    }
                },
                {
                    breakpoint: 640,
                    settings: {
                        slidesToShow: parseInt(column_responsive_1),
                    }
                },
                {
                    breakpoint: 376,
                    settings: {
                        slidesToShow: parseInt(column_responsive_1),
                    }
                },
                {
                    breakpoint: 320,
                    settings: {
                        slidesToShow: 1
                    }
                }

            ]
        });
        slider.slick('setPosition');
        pagination.remove();
        btnPrev.remove();
        btnNext.remove();
    });
}


// sticky header init
function initStickyHeader() {
    var win = jQuery(window),
        stickyClass = 'fixed-position';

    jQuery('.header_fixed').each(function () {

        var header = jQuery(this);
        var headerOffset = header.offset().top || 0;
        var flag = true;

        function scrollHandler() {
            if (win.scrollTop() > headerOffset) {
                if (flag) {
                    flag = false;
                    header.addClass(stickyClass);
                }
            } else {
                if (!flag) {
                    flag = true;
                    header.removeClass(stickyClass);
                }
            }
            ResponsiveHelper.addRange({
                '..767': {
                    on: function () {
                        header.removeClass(stickyClass);
                    }
                }
            });
        }

        scrollHandler();
        win.on('scroll resize orientationchange', scrollHandler);
    });
}

//  Custom variables for isotop
function init_ultimate_spacer_custom() {
    var css = '';
    jQuery('.ult-spacer').each(function (i, spacer) {
        var uid = jQuery(spacer).data('id');
        var body_width = jQuery("body").width();
        var height_on_mob = jQuery(spacer).data('height-mobile');
        var height_on_mob_landscape = jQuery(spacer).data('height-mobile-landscape');
        var height_on_tabs = jQuery(spacer).data('height-tab');
        var height_on_tabs_portrait = jQuery(spacer).data('height-tab-portrait');
        var height = jQuery(spacer).data('height');

        if (height != '') {
            css += ' .spacer-' + uid + ' { height:' + height + 'px } ';
        }
        if (height_on_tabs != '' || height_on_tabs == '0' || height_on_tabs == 0) {
            css += ' @media (max-width: 1199px) { .spacer-' + uid + ' { height:' + height_on_tabs + 'px } } ';
        }
        if (typeof height_on_tabs_portrait != 'undefined' && (height_on_tabs_portrait != '' || height_on_tabs_portrait == '0' || height_on_tabs_portrait == 0)) {
            css += ' @media (max-width: 991px) { .spacer-' + uid + ' { height:' + height_on_tabs_portrait + 'px } } ';
        }
        if (typeof height_on_mob_landscape != 'undefined' && (height_on_mob_landscape != '' || height_on_mob_landscape == '0' || height_on_mob_landscape == 0)) {
            css += ' @media (max-width: 767px) { .spacer-' + uid + ' { height:' + height_on_mob_landscape + 'px } } ';
        }
        if (height_on_mob != '' || height_on_mob == '0' || height_on_mob == 0) {
            css += ' @media (max-width: 479px) { .spacer-' + uid + ' { height:' + height_on_mob + 'px } } ';
        }
    });
    if (css != '') {
        css = '<style>' + css + '</style>';
        jQuery('head').append(css);
    }
}

/*
 * Responsive Layout helper
 */
ResponsiveHelper = (function ($) {
    var handlers = [],
        prevWinWidth,
        win = $(window),
        nativeMatchMedia = false;
    if (window.matchMedia) {
        if (window.Window && window.matchMedia === Window.prototype.matchMedia) {
            nativeMatchMedia = true;
        } else if (window.matchMedia.toString().indexOf('native') > -1) {
            nativeMatchMedia = true;
        }
    }

    function resizeHandler() {
        var winWidth = win.width();
        if (winWidth !== prevWinWidth) {
            prevWinWidth = winWidth;
            $.each(handlers, function (index, rangeObject) {
                $.each(rangeObject.data, function (property, item) {
                    if (item.currentActive && !matchRange(item.range[0], item.range[1])) {
                        item.currentActive = false;
                        if (typeof item.disableCallback === 'function') {
                            item.disableCallback();
                        }
                    }
                });
                $.each(rangeObject.data, function (property, item) {
                    if (!item.currentActive && matchRange(item.range[0], item.range[1])) {
                        // make callback
                        item.currentActive = true;
                        if (typeof item.enableCallback === 'function') {
                            item.enableCallback();
                        }
                    }
                });
            });
        }
    }

    win.on('load resize orientationchange', resizeHandler);

    function matchRange(r1, r2) {
        var mediaQueryString = '';
        if (r1 > 0) {
            mediaQueryString += '(min-width: ' + r1 + 'px)';
        }
        if (r2 < Infinity) {
            mediaQueryString += (mediaQueryString ? ' and ' : '') + '(max-width: ' + r2 + 'px)';
        }
        return matchQuery(mediaQueryString, r1, r2);
    }

    function matchQuery(query, r1, r2) {
        if (window.matchMedia && nativeMatchMedia) {
            return matchMedia(query).matches;
        } else if (window.styleMedia) {
            return styleMedia.matchMedium(query);
        } else if (window.media) {
            return media.matchMedium(query);
        } else {
            return prevWinWidth >= r1 && prevWinWidth <= r2;
        }
    }

    function parseRange(rangeStr) {
        var rangeData = rangeStr.split('..');
        var x1 = parseInt(rangeData[0], 10) || -Infinity;
        var x2 = parseInt(rangeData[1], 10) || Infinity;
        return [x1, x2].sort(function (a, b) {
            return a - b;
        });
    }

    return {
        addRange: function (ranges) {
            // parse data and add items to collection
            var result = {data: {}};
            $.each(ranges, function (property, data) {
                result.data[property] = {
                    range: parseRange(property),
                    enableCallback: data.on,
                    disableCallback: data.off
                };
            });
            handlers.push(result);
            prevWinWidth = null;
            resizeHandler();
        }
    };

}(jQuery));