<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 *
 * @package WordPress
 * @subpackage modus
 */

get_header();
$modus_sidebar_position = 'left'; 
$padding_top = '';
$padding_bottom = '';
$modus_config = modus_settings();
if(isset($modus_config['post_sidebar_position'])){
	$modus_sidebar_position = $modus_config['post_sidebar_position'];
}
if(isset($modus_config['post_sidebar'])){
	$modus_sidebars = $modus_config['post_sidebar'];
	if(!is_active_sidebar($modus_sidebars)){
		$modus_sidebar_position = 'none'; 
	}
}
if ( get_post_meta(get_the_ID(), 'no_padding_top', true) != ''){

	$padding_top = get_post_meta(get_the_ID(), 'no_padding_top', true);
}
if ( get_post_meta(get_the_ID(), 'no_padding_bottom', true) != ''){
	$padding_bottom = get_post_meta(get_the_ID(), 'no_padding_bottom', true);
}

if($modus_sidebar_position == 'left-sidebar' ){
	$modus_class_sidebar = 'sidebar_left';
	$modus_wrap_content = 'col-xs-12 col-sm-12 col-md-8 col-lg-9 right';
}else if( $modus_sidebar_position == 'right-sidebar' ){
	$modus_class_sidebar = 'sidebar_right';
	$modus_wrap_content = 'col-xs-12 col-sm-12 col-md-8 col-lg-9';
}else{
	$modus_wrap_content='col-xs-12 col-sm-12 col-md-12';
}
$show_title = 'show';
if(isset($modus_config['page_title']) && $modus_config['page_title']!=''){
	$show_title = $modus_config['page_title'];
} 
if ( get_post_meta(get_the_ID(), 'show_title_page', true) != '' && get_post_meta(get_the_ID(), 'show_title_page', true) != 'default'){
	$show_title = get_post_meta(get_the_ID(), 'show_title_page', true);
}
$blog_show_breadcrumb = '';
$blog_show_breadcrumb = 'hide'; 
if(isset($modus_config['archive_blog_banner']) && $modus_config['archive_blog_banner']!=''){
	$blog_show_breadcrumb = $modus_config['archive_blog_banner'];
} 
if ( get_post_meta(get_the_ID(), 'show_breadcrumb', true) != '' && get_post_meta(get_the_ID(), 'show_breadcrumb', true) != 'default'){
	$blog_show_breadcrumb = get_post_meta(get_the_ID(), 'show_breadcrumb', true);
}
$blog_per_pages = 5;
if( is_front_page() || is_home()) :
	$blog_show_breadcrumb = 'hide';
endif;
if ( isset( $modus_config['archive_blog_num_item'] ) ) $blog_per_pages = $modus_config['archive_blog_num_item'];
?>
	<div id="primary" class="content-area">
		<main id="main" class="blog site-main<?php if ( $blog_show_breadcrumb == 'hide' ) echo ' padding-top-60'; ?>" role="main">
			<?php if($show_title == 'show' && $blog_show_breadcrumb == 'show' ):?>
				<div class="breadcrumb-container">
					<div class="bottom-breadcrumb">
						<div class=" container">
							<?php if($show_title == 'show'){ ?>
							<div class="page-title">
								<?php if ( is_author() ):?>
									<?php   $userdata = get_userdata($author);?> 
									<h1><?php  echo  esc_html($userdata->display_name) ?></h1>
								<?php elseif ( is_date() ):?>
									<?php  $datepost = get_the_date();?> 
									<h1><?php  echo  esc_html($datepost) ?></h1>
				                <?php else:?>
				                	<h1> <?php echo single_cat_title(); ?></h1>
				              	<?php endif;?>
							</div>
							<?php } ?>			
							<?php if ( $blog_show_breadcrumb == 'show' ) { ?>
							<div class="bread-crumb">
								<?php echo modus_breadcrumbs(); ?>
							</div> 
							<?php } ?>
						</div>
					</div>	
				</div>	
			<?php endif;?>
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr($modus_wrap_content); ?>">
						<?php if ( have_posts() ) : ?>
							<?php
							// Start the Loop. 
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content', get_post_format() );

							// End the loop.
							endwhile;
							$older_posts = esc_html__('Older posts','modus');
							$newer_posts = esc_html__('Newer posts','modus');
							// Previous/next page navigation.
							the_posts_pagination( array(
								'prev_text'          => '<i class="Pe-icon-7-stroke-angle-left"></i> '. $newer_posts .'',
								'next_text'          => ''. $older_posts .'<i class="Pe-icon-7-stroke-angle-right"></i>',
								'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',
							) );
						// If no content, include the "No posts found" template.
						else :
							get_template_part( 'template-parts/content', 'none' );

						endif;
						?>
					</div>
					<?php
					if( $modus_sidebar_position != 'none' && $modus_sidebar_position != '' ){ ?>
						<div class="col-lg-3 col-md-4 col-xs-12 col-sm-12 <?php echo esc_attr( $modus_class_sidebar ); ?>">
							<div class="sidebar sidebarArea sidebar-blog">
								<?php dynamic_sidebar($modus_sidebars ); ?>
							</div>
						</div>
					<?php
						}
					?>
				</div>
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->
<?php get_footer(); ?>
