<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */
$modus_config = modus_settings();
get_header();
$bg_404 = $md_404_title = $md_404_txt = $title_404 = $md_404_btn = $copyright_404 = '';
if ( $modus_config != '' ) :
	$bg_404 = $modus_config['404_bg']['url'];
else :
	$bg_404 = get_template_directory_uri(). '/assets/images/bg-404.jpg';
endif;
$keys = parse_url($bg_404);
$path = explode("/", $keys['path']);
$last = end($path); 

if( $modus_config['404_title'] !=''){
	if(get_option('404_title')){
		$md_404_title = get_option('404_title');
	}else{
		$md_404_title =$modus_config['404_title'];
	}
}
if( $modus_config['404_txt'] !=''){
	if(get_option('404_txt')){
		$md_404_txt = get_option('404_txt');
	}else{
		$md_404_txt =$modus_config['404_txt'];
	}
}
if( $modus_config['button_404'] !=''){
	if(get_option('button_404')){
		$md_404_btn = get_option('button_404');
	}else{
		$md_404_btn = $modus_config['button_404'];
	}
}
if( $modus_config['footer_coppyright'] !=''){
	if(get_option('footer_coppyright')){
		$copyright_404 = get_option('footer_coppyright');
	}else{
		$copyright_404 = $modus_config['footer_coppyright'];
	}
}
?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<section class="error-404 not-found">
				<div class="content-404">
					<div class="container">
						<div class="hidden-lg hidden-md  col-xs-12">
							<img src="<?php echo esc_url($bg_404); ?>" alt="<?php echo esc_attr($last)?>">
						</div>
						<div class="col-md-6 col-xs-12 col-sm-12">
							<h1 class="title-404"><?php echo esc_html( $md_404_title ); ?></h1>
							<div class="page-content">
								<p><?php echo wp_kses_post( $md_404_txt ); ?></p>
							</div><!-- .page-content -->
						</div>
						<div class="bg-img-404 col-md-6 hidden-sm hidden-xs">
							<img src="<?php echo esc_url($bg_404); ?>" alt="<?php echo esc_attr($last)?>">
						</div>
					</div>
				</div>
			</section><!-- .error-404 -->
			<div class="border-tranger"></div>
			<div class="container">
				<div class="button-wed"><a class="hvr-shutter-out-horizontal" href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr__('Back Home','modus')?>"><?php echo esc_html($md_404_btn);?></a></div>
			</div>
			<div class="copyright-404">
				<?php echo wp_kses_post($copyright_404);?>
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->

<?php get_footer(); ?>
