(function($){

    "use strict";

    function uniqueID() {return Math.floor((Math.random() * 1000000) + 1);}

    function isInArray(value, array) {return array.indexOf(value) > -1;}

    String.prototype.replaceAll = function(str1, str2, ignore) {
        return this.replace(new RegExp(str1.toString().replace(/([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g,"\\$&"),(ignore?"gi":"g")),(typeof(str2)=="string")?str2.replace(/\$/g,"$$$$"):str2);
    }

    function iframeCSS(CSS){
        var iframe = $('#vc_inline-frame');
        if (typeof(iframe) != 'undefined' && iframe != null){
            iframe.ready(function() {
                CSS = CSS.replaceAll("dir-child*",">");
                iframe.contents().find("#dynamic-styles-inline-css").append(CSS);
            });
        }
    }

    function iframeSCRIPT(element,doc){
        $(element).each(function(){

            var $this       = $(this),
                $thisParent = $this.parent(),
                speed       = $this.data('speed'),
                move        = $this.data('move'),
                xCoordinate = $this.data('coordinatex'),
                yCoordinate = $this.data('coordinatey'),
                classes     = $this.attr('class'),
                classArray  = classes.split(' '),
                disableArray = [];

                for (var i = 0; i < classArray.length; i++) {
                    if (classArray[i].includes("disable")) {
                        disableArray.push(classArray[i])
                    }
                }

            if ($this.parents().hasClass('effect-fadeIn') || $this.parents().hasClass('effect-moveUp')) {
                $this.find('.et-item-inner').addClass('animate');
            }
        });
    }

    $( document ).ajaxComplete(function( event, xhr, settings ) {

        if (settings['type'] != 'POST') {return;}

        /* Prepare settings
        /*-------------*/

            var data = decodeURIComponent(settings['data']);

            data = data.split("&");

            var dataObj = [{}];

            for (var i = 0; i < data.length; i++) {
                var property = data[i].split("=");
                var key      = (property[0]);
                var value    = (property[1]);
                dataObj[key] = value;
            }

            var elementExists = Object.keys(dataObj).some(function(key) {
                return dataObj[key] === "et_make";
            });

        /* Edit element
        /*-------------*/

            if(dataObj['action'] == "vc_edit_form" && dataObj['tag'] == "et_make"){

                var edit_element = $('#vc_ui-panel-edit-element[data-vc-shortcode="et_make"]'),
                    element_css  = edit_element.find('textarea[name="element_css"]'),
                    element_id   = edit_element.find('input[name="element_id"]'),
                    icon          = edit_element.find('input[name="icon"]'),
                    icon_val      = icon.val(),
                    icon_list     = edit_element.find('ul.admin-icon-list');

                if(typeof(icon_val) != "undefined" && icon_val.length){

                    icon_list.each(function(){
                        $(this).find('li').each(function(){

                            var $this = $(this),
                                icon = $this.find('span');

                            if (icon.data('name') == icon_val) {
                                icon.addClass('active');
                                $this.siblings().find('span').removeClass('active');
                            }

                        });
                    });

                    
                } else {
                    icon_list.first().find('li:first-child span').addClass('active');
                }

                icon_list.each(function(){
                    $(this).find('li').each(function(){

                        var $this = $(this),
                            icon = $this.find('span');

                        icon.on('click',function(){
                            icon.addClass('active');
                            $this.siblings().find('span').removeClass('active');
                        });

                    });
                });

                $('#vc_ui-panel-edit-element[data-vc-shortcode="et_make"] .vc_ui-button-action[data-vc-ui-element="button-save"]').on('click',function(){

                    if ($('#vc_ui-panel-edit-element[data-vc-shortcode="et_make"]').length) {

                        var ID  = uniqueID();
                        var CSS = '';

                        edit_element = $('#vc_ui-panel-edit-element[data-vc-shortcode="et_make"]');

                        /* Styling
                        ---------------*/

                            var icon_name         = edit_element.find('ul.admin-icon-list span.active').data('name'),
                                title_color       = edit_element.find('input[name="title_color"]').val(),
                                box_color         = edit_element.find('input[name="box_color"]').val(),
                                title_color_hover = edit_element.find('input[name="title_color_hover"]').val(),
                                box_color_hover   = edit_element.find('input[name="box_color_hover"]').val(),
                                shadow            = edit_element.find('input[name="shadow"]');

                            icon.val(icon_name);

                            if (shadow.length && shadow.is(":checked")) {
                                CSS += '#et-make-'+ID+' {';
                                    CSS += 'box-shadow:0px 8px 24px 0px rgba(0, 0, 0, 0.08);';
                                CSS += '}';
                            }


                            CSS += '#et-make-'+ID+' {';
                                if (box_color.length) {
                                    CSS += 'background-color:'+box_color+';';
                                }
                            CSS += '}';

                            CSS += '#et-make-'+ID+':hover {';
                                if (box_color_hover.length) {
                                    CSS += 'background-color:'+box_color_hover+';';
                                }
                            CSS += '}';
                            

                            if (title_color.length) {
                                CSS += '#et-make-'+ID+' .et-make-title {';
                                    CSS += 'color:'+title_color+';';
                                CSS += '}';
                            }

                            if (title_color_hover.length) {
                                CSS += '#et-make-'+ID+':hover .et-make-title {';
                                    CSS += 'color:'+title_color_hover+';';
                                CSS += '}';
                            }

                        element_id.val(ID);

                        if (CSS) {
                            element_css.text(CSS);
                            iframeCSS(CSS);
                            CSS = '';
                        }

                    }
                    
                });

                return;
            }

        /* Load element
        /*-------------*/

            if((dataObj['action'] == "vc_load_shortcode" && elementExists)){
                var iframe = $('#vc_inline-frame');
                if (typeof(iframe) != 'undefined' && iframe != null){
                    iframe.ready(function() {
                        var doc = iframe.contents();
                        var element = doc.find('.vc_element[data-model-id="'+dataObj['shortcodes[0][id]']+'"] .et-make');
                        if (typeof(element) != 'undefined' && element != null) {
                            iframeSCRIPT(element,doc);
                        }
                    });
                }
                return;
            }
    });

})(jQuery);