(function($){

    "use strict";

    function uniqueID() {return Math.floor((Math.random() * 1000000) + 1);}

    function isInArray(value, array) {return array.indexOf(value) > -1;}

    String.prototype.replaceAll = function(str1, str2, ignore) {
        return this.replace(new RegExp(str1.toString().replace(/([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g,"\\$&"),(ignore?"gi":"g")),(typeof(str2)=="string")?str2.replace(/\$/g,"$$$$"):str2);
    }

    function iframeCSS(CSS){
        var iframe = $('#vc_inline-frame');
        if (typeof(iframe) != 'undefined' && iframe != null){
            iframe.ready(function() {
                CSS = CSS.replaceAll("dir-child*",">");
                iframe.contents().find("#dynamic-styles-inline-css").append(CSS);
            });
        }
    }

    /* Ajax complete
    /*-------------*/

        $( document ).ajaxComplete(function( event, xhr, settings ) {

            if (settings['type'] != 'POST') {return;}

                /* Prepare settings
                /*-------------*/

                    var data = decodeURIComponent(settings['data']);

                    data = data.split("&");

                    var dataObj = [{}];

                    for (var i = 0; i < data.length; i++) {
                        var property = data[i].split("=");
                        var key      = (property[0]);
                        var value    = (property[1]);
                        dataObj[key] = value;
                    }

                    var elementExists = Object.keys(dataObj).some(function(key) {
                        return dataObj[key] === "et_ad";
                    });

                /* Edit element
                /*-------------*/

                    if(dataObj['action'] == "vc_edit_form" && dataObj['tag'] == "et_ad"){

                        var edit_element = $('#vc_ui-panel-edit-element[data-vc-shortcode="et_ad"]');

                        var element_css   = edit_element.find('textarea[name="element_css"]'),
                            element_id    = edit_element.find('input[name="element_id"]'),
                            padding_box   = edit_element.find(".padding-box"),
                            padding       = edit_element.find('input[name="padding"]'),
                            padding_val   = padding.val(),
                            padding_array = [],
                            margin_box    = edit_element.find(".margin-box"),
                            margin        = edit_element.find('input[name="margin"]'),
                            margin_val    = margin.val(),
                            margin_array  = [];

                        if(typeof(padding_val) != "undefined" && padding_val.length){

                            var padding_array = padding_val.split(",");

                            padding_box.find("input[name=\"padding-top\"]").attr('value',padding_array[0]);
                            padding_box.find("input[name=\"padding-right\"]").attr('value',padding_array[1]);
                            padding_box.find("input[name=\"padding-bottom\"]").attr('value',padding_array[2]);
                            padding_box.find("input[name=\"padding-left\"]").attr('value',padding_array[3]);

                        }

                        if(typeof(margin_val) != "undefined" && margin_val.length){

                            var margin_array = margin_val.split(",");

                            margin_box.find("input[name=\"margin-top\"]").attr('value',margin_array[0]);
                            margin_box.find("input[name=\"margin-right\"]").attr('value',margin_array[1]);
                            margin_box.find("input[name=\"margin-bottom\"]").attr('value',margin_array[2]);
                            margin_box.find("input[name=\"margin-left\"]").attr('value',margin_array[3]);

                        }

                        $('#vc_ui-panel-edit-element[data-vc-shortcode="et_ad"] .vc_ui-button-action[data-vc-ui-element="button-save"]').on('click',function(){

                            if ($('#vc_ui-panel-edit-element[data-vc-shortcode="et_ad"]').length) {

                                var ID  = uniqueID();
                                var CSS = '';

                                edit_element = $('#vc_ui-panel-edit-element[data-vc-shortcode="et_ad"]');

                                /* Styling
                                ---------------*/

                                    var back_color    = edit_element.find('input[name="back_color"]').val(),
                                        back_img      = edit_element.find('input[name="back_img"]').val(),
                                        back_position = edit_element.find('input[name="back_position"]').val(),
                                        border_width  = edit_element.find('input[name="border_width"]').val(),
                                        border_radius = edit_element.find('input[name="border_radius"]').val(),
                                        border_color  = edit_element.find('input[name="border_color"]').val(),
                                        img_x         = edit_element.find('input[name="img_x"]').val(),
                                        img_y         = edit_element.find('input[name="img_y"]').val(),
                                        tablet_img_x  = edit_element.find('input[name="tablet_img_x"]').val(),
                                        tablet_img_y  = edit_element.find('input[name="tablet_img_y"]').val(),
                                        tablet_land_img_x  = edit_element.find('input[name="tablet_land_img_x"]').val(),
                                        tablet_land_img_y  = edit_element.find('input[name="tablet_land_img_y"]').val(),
                                        mobile_img_x  = edit_element.find('input[name="mobile_img_x"]').val(),
                                        mobile_img_y  = edit_element.find('input[name="mobile_img_y"]').val();

                                    if (border_color.length && border_width.length) {
                                        CSS += '#et-ad-'+ID+' {';
                                            CSS += 'border:'+border_width+'px solid '+border_color+';';
                                        CSS += '}';
                                    }

                                    if(border_radius.length){
                                        CSS += '#et-ad-'+ID+' {';
                                            CSS += 'border-radius:'+border_radius+'px';
                                        CSS += '}';
                                    }

                                    CSS += '#et-ad-'+ID+' .background {';

                                        if(back_img.length){
                                            back_img = edit_element.find("img[rel=\""+back_img+"\"]").attr("src").replace("-150x150", "");
                                            CSS += "background-image:url("+back_img+");";
                                        }

                                        if (back_color.length) {
                                            CSS += 'background-color:'+back_color+';';
                                        }

                                        if (back_position.length) {
                                            CSS += 'background-position:'+back_position+';';
                                        }

                                    CSS += '}';

                                    if(img_x.length){
                                        CSS += '#et-ad-'+ID+' .et-ad-img {';
                                            CSS += 'left:'+img_x+'px';
                                        CSS += '}';
                                    }

                                    if(img_y.length){
                                        CSS += '#et-ad-'+ID+' .et-ad-img {';
                                            CSS += 'top:'+img_y+'px';
                                        CSS += '}';
                                    }

                                    if(tablet_img_x.length || tablet_img_y.length){
                                        CSS += '@media only screen and (min-width: 768px) and (max-width: 1279px){';
                                            if(tablet_img_x.length){
                                                CSS += '#et-ad-'+ID+' .et-ad-img {';
                                                    CSS += 'left:'+tablet_img_x+'px';
                                                CSS += '}';
                                            }
                                            if(tablet_img_y.length){
                                                CSS += '#et-ad-'+ID+' .et-ad-img {';
                                                    CSS += 'top:'+tablet_img_y+'px';
                                                CSS += '}';
                                            }
                                        CSS += '}';
                                    }

                                    if(tablet_land_img_x.length || tablet_land_img_y.length){
                                        CSS += '@media only screen and (min-width: 1024px) and (max-width: 1279px){';
                                            if(tablet_land_img_x.length){
                                                CSS += '#et-ad-'+ID+' .et-ad-img {';
                                                    CSS += 'left:'+tablet_land_img_x+'px';
                                                CSS += '}';
                                            }
                                            if(tablet_land_img_y.length){
                                                CSS += '#et-ad-'+ID+' .et-ad-img {';
                                                    CSS += 'top:'+tablet_land_img_y+'px';
                                                CSS += '}';
                                            }
                                        CSS += '}';
                                    }

                                    if(mobile_img_x.length || mobile_img_y.length){
                                        CSS += '@media only screen and (max-width: 479px){';
                                            if(mobile_img_x.length){
                                                CSS += '#et-ad-'+ID+' .et-ad-img {';
                                                    CSS += 'left:'+mobile_img_x+'px';
                                                CSS += '}';
                                            }
                                            if(mobile_img_y.length){
                                                CSS += '#et-ad-'+ID+' .et-ad-img {';
                                                    CSS += 'top:'+mobile_img_y+'px';
                                                CSS += '}';
                                            }
                                        CSS += '}';
                                    }

                                /* Padding
                                ---------------*/

                                    var padding_left   = edit_element.find(".padding-box input[name=\"padding-left\"]").val(),
                                        padding_top    = edit_element.find(".padding-box input[name=\"padding-top\"]").val(),
                                        padding_right  = edit_element.find(".padding-box input[name=\"padding-right\"]").val(),
                                        padding_bottom = edit_element.find(".padding-box input[name=\"padding-bottom\"]").val();

                                    padding_top = (padding_top.length) ? padding_top : '0';
                                    padding_right = (padding_right.length) ? padding_right : '0';
                                    padding_bottom = (padding_bottom.length) ? padding_bottom : '0';
                                    padding_left = (padding_left.length) ? padding_left : '0';

                                    var padding_output = padding_top+','+padding_right+','+padding_bottom+','+padding_left,
                                        padding_value  = padding_top+'px '+padding_right+'px '+padding_bottom+'px '+padding_left+'px';

                                    padding.val(padding_output);

                                    CSS += '#et-ad-'+ID+' {';
                                        CSS += 'padding:'+padding_value+';';
                                    CSS += '}';

                                /* Margin
                                ---------------*/

                                    var margin_left   = edit_element.find(".margin-box input[name=\"margin-left\"]").val(),
                                        margin_top    = edit_element.find(".margin-box input[name=\"margin-top\"]").val(),
                                        margin_right  = edit_element.find(".margin-box input[name=\"margin-right\"]").val(),
                                        margin_bottom = edit_element.find(".margin-box input[name=\"margin-bottom\"]").val();

                                    margin_top = (margin_top.length) ? margin_top : '0';
                                    margin_right = (margin_right.length) ? margin_right : '0';
                                    margin_bottom = (margin_bottom.length) ? margin_bottom : '0';
                                    margin_left = (margin_left.length) ? margin_left : '0';

                                    var margin_output = margin_top+','+margin_right+','+margin_bottom+','+margin_left,
                                        margin_value  = margin_top+'px '+margin_right+'px '+margin_bottom+'px '+margin_left+'px';

                                    margin.val(margin_output);

                                    CSS += '#et-ad-'+ID+' {';
                                        CSS += 'margin:'+margin_value+';';
                                    CSS += '}';

                                element_id.val(ID);

                                if (CSS) {
                                    element_css.text(CSS);
                                    iframeCSS(CSS);
                                    CSS = '';
                                }
                            }
                            
                        });

                        return;

                    }


        });

})(jQuery);