<?php if ( ! defined( 'ABSPATH' ) ) die( 'Forbidden' );
/**
 * Testimonials Shortcode
 */

$args = get_query_var('like_sc_testimonials');

$query_args = array(
	'post_type' => 'testimonials',
	'post_status' => 'publish',
	'posts_per_page' => (int)($atts['limit']),
);

$class = 'layout-'.esc_attr($atts['layout']);
if ( !empty($args['background']) ) $class .= ' bg-'.$args['background'];
if ( !empty($args['arrows']) ) $class .= ' arrows-'.$args['arrows'];
if ( !empty($args['font_weight']) ) $class .= ' font-weight-'.$args['font_weight'];

if ( !empty($args['class']) ) $class .= ' '. esc_attr($args['class']);
if ( !empty($args['id']) ) $id = ' id="'. esc_attr($args['id']). '"'; else $id = '';

$arrow_span_left = $arrow_span_right = '';
if ( !empty($args['arrows']) AND $args['arrows'] == 'text' ) {

	$arrow_span_left = esc_html__('prev', 'lt-ext');
	$arrow_span_right = esc_html__('next', 'lt-ext');
}

if ( !empty($args['ids']) ) $query_args['post__in'] = explode(',', esc_attr($args['ids']));
	else
if ( !empty($args['cat']) ) {

	$query_args['tax_query'] = 	array(
			array(
	            'taxonomy'  => 'testimonials-category',
	            'field'     => 'if', 
	            'terms'     => array(esc_attr($args['cat'])),
			)
    );
}

$query = new WP_Query( $query_args );

if ( $query->have_posts() ) {

	$cols = $args['columns'];

	$swiper_item_class = '';
	if ( !empty($args['swiper']) ) {

		$swiper_item_class = 'swiper-slide';
		echo ltx_vc_swiper_get_the_container('ltx-testimonials-list', $atts, $class, $id);
		echo '<div class="swiper-wrapper">';
	}
		else {

		echo '<div class="ltx-testimonials-list-wrapper '.esc_attr($class).'" '.$id.'><div class="ltx-testimonials-list">';
	}

	while ( $query->have_posts() ) {

		$query->the_post();

		$subheader = fw_get_db_post_option(get_The_ID(), 'subheader');
		$rate = fw_get_db_post_option(get_The_ID(), 'rate');

		echo '<div class="ltx-item '.esc_attr($swiper_item_class).'">';

			echo '<div class="inner">';

				echo '<div class="author">';

					if ($atts['photo'] == 'visible' ) {

						echo '<div class="image">';
							the_post_thumbnail('mirasat-tiny');
						echo '</div>';
					}

					if ($atts['name'] == 'visible' ) {

						$by = '';
						if ( !empty($args['author_prefix']) ) {

							$by = $args['author_prefix'].' ';
						}

						echo '<div class="header">'. esc_html($by) . get_the_title() .'</div>';

						if (!empty($subheader) AND $atts['subheader'] == 'visible') {

							echo '<div class="subheader">'. wp_kses_post($subheader) .'</div>';
						}
					}

					if ( $atts['rate'] == 'visible' AND !empty($rate) ) {

						echo '<div class="rate">';
						for ($x = 1; $x<= (int)($rate); $x++) {

							echo '<span class="fa fa-star"></span>';
						}
						echo '</div>';
					}

				echo '</div>';

				echo '<div class="text">';
					echo '<p>'. get_the_content() .'</p>
				</div>';


			echo '</div>';

		echo '</div>';
	}

	if ( !empty($args['swiper']) ) {

		echo '</div>';	
	}
		
	echo '</div></div>';

	wp_reset_postdata();
}

