<?php if ( ! defined( 'ABSPATH' ) ) die( 'Forbidden' );
/**
 * Services Shortcode
 */

$args = get_query_var('like_sc_services');

$class = '';
if ( !empty($args['class']) ) $class .= ' '. esc_attr($args['class']);
if ( !empty($args['id']) ) $id = ' id="'. esc_attr($args['id']). '"'; else $id = '';

$class .= ' layout-'.$args['layout'].' ltx-style-'.$args['style'];

$query_args = array(
	'post_type' => 'services',
	'post_status' => 'publish',
	'posts_per_page' => (int)($args['limit']),
);

if ( !empty($args['ids']) ) $query_args['post__in'] = explode(',', esc_attr($args['ids']));
	else
if ( !empty($args['cat']) ) {

	$query_args['tax_query'] = 	array(
		array(
            'taxonomy'  => 'services-category',
            'field'     => 'if', 
            'terms'     => array(esc_attr($args['cat'])),
		)
    );
}

$query = new WP_Query( $query_args );

if ( $query->have_posts() ) {

	echo '<div class="services-sc services-slider'.esc_attr($class).'" '.$id.' data-cols="3" data-autoplay="'.esc_attr($args['autoplay']).'">';
		echo '<div class="swiper-container">';
			echo '<div class="swiper-wrapper">';

		while ( $query->have_posts() ):

			$query->the_post();

			$subheader = fw_get_db_post_option(get_The_ID(), 'header');
			$price = fw_get_db_post_option(get_The_ID(), 'price');
			$cut = fw_get_db_post_option(get_The_ID(), 'cut');
			$image = fw_get_db_post_option(get_The_ID(), 'image');
			$header = get_the_title();

			if ( empty($link) ) {

				$link = get_the_permalink();
			}		

			if ( $args['layout'] == 'product' ):

				?>
				<article class="swiper-slide">

					<div class="ltx-inner">
						<?php 
							if ( has_post_thumbnail() ) {

							    echo '<a href="'.esc_url(get_the_permalink()).'" class="photo">';

							    if ( !empty($image) ) {

							    	echo '<img src="'.$image['url'].'" alt="'.esc_attr(get_the_title()).'">';
							    }
							    	else {

								    the_post_thumbnail('mirasat-service');
						    	}

						    		echo '<span class="ltx-plus"></span>';

							    echo '</a>';
							}
						?>
					    <div class="description">
					        <a href="<?php esc_url( the_permalink() ); ?>" class="header">
					        	<h5 class="header"><?php echo wp_kses_post($header); ?></h5>
					        </a>
				        	<p>
				        		<?php echo wp_kses_post(nl2br(ltx_header_parse($cut))); ?>
				        	</p>
					        <?php

								if ( !empty($args['more_text']) ) {

									echo '<a href="'.esc_url( $link ).'" class="btn btn-xs">'.esc_html($args['more_text']).'</a>';
								}		 	
							?>
					    </div>    
					</div>
				</article>	
				<?php

			endif;

		endwhile;

			echo '</div>';
		echo '</div>';

		echo '<div class="arrows">
				<a href="#" class="arrow-left fa fa-chevron-left"></a>
				<a href="#" class="arrow-right fa fa-chevron-right"></a>
			</div>';

	echo '</div>';

	wp_reset_postdata();
}

