<?php 
require_once( dirname(__FILE__) . '/../../../../wp-load.php' ); // WP environment
wp_head();
require_once( dirname(__FILE__) . '/striplibary/init.php' ); // I placed the directory with Stripe PHP library in the theme folder

$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
    $miraculous_theme_data = fw_get_db_settings_option();     
endif; 

$currency = '';
if(!empty($miraculous_theme_data['paypal_currency'])):
    $currency = $miraculous_theme_data['paypal_currency'];
endif;
$stripe_publishable_key = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_publishable_key'])):
    $stripe_publishable_key = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_publishable_key'];
endif;

$stripe_success_page_url = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_success_page_url'])):
    $stripe_success_page_url = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_success_page_url'];
endif;

$stripe_cancel_page_url = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_cancel_page_url'])):
    $stripe_cancel_page_url = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_cancel_page_url'];
endif;

// you can get it in Stripe Account Settings -> API Keys
$secret = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_secret_key'])):
    $secret = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_secret_key'];
endif;

if(isset($_POST['stripeToken'])){
	
	\Stripe\Stripe::setApiKey( $secret );

	/* we specified this parameter as a hidden field */
	$item_id = $_POST['item_id'];

    $item_type = '';
    if(isset($_POST['item_type'])){
	  $item_type = $_POST['item_type'];
    } 
    $item_name = get_the_title($item_id);
	/* if your plugin price looks like 9.59, then you need to *100 it */
	$price = get_post_meta( $item_id, 'fw_option:plan_price', true ) * 100;

	$stripe_plan_id = '';
    if($item_type == 'yearly'){
	   $stripe_plan_id = get_post_meta($item_id, 'fw_option:stripe_yearly_plan_id', true);
	}else{
	   $stripe_plan_id = get_post_meta($item_id, 'fw_option:stripe_monthly_plan_id', true);
	}
	try {

		if ( !isset($_POST['stripeToken']) )
			throw new Exception('The Stripe Token is not correct');
		
		$token = $_POST['stripeToken'];
		$email = $_POST['stripeEmail'];
		$sub_id = $_POST['sud_id'];
		$subscription = \Stripe\Subscription::retrieve($sub_id);
    $data = \Stripe\Subscription::update($sub_id, [
      'cancel_at_period_end' => false,
      'proration_behavior' => 'create_prorations',
      'items' => [
        [
          'id' => $subscription->items->data[0]->id,
          'price' => $stripe_plan_id,
        ],
      ],
    ]);

		global $wpdb;

		$tbl_pay = $wpdb->prefix. 'recurring_subscriptions';
		
		$current_user = wp_get_current_user();

		if($item_type == 'yearly'){
           $plan_validity = get_post_meta($item_id, 'fw_option:plan_validity', true);
		}else{
		   $plan_validity = 1; 
		}

		$total_uploads = '';
        if($item_type == 'yearly'){
		  $total_uploads = get_post_meta($item_id, 'fw_option:plan_yearly_uploads', true);
	    }else{
		  $total_uploads = get_post_meta($item_id, 'fw_option:plan_monthly_uploads', true);
		}
		
		$request_limite = get_post_meta($item_id, 'fw_option:plan_monthly_request_limite', true);
		  
		$sub_id = $data->id;
		$billing_ca = $data->billing_cycle_anchor;
		$collection_method = $data->collection_method;
		$st_plan_id = $data->plan->id;
		$amount = $data->plan->amount/100;
		$pl_status = $data->status;
		$customer = $data->customer;
		
	$up_query = $wpdb->update( 
			$tbl_pay, 
			array(
				'user_id' => $current_user->ID, 
				'plan_id' => $item_id, 
				'collection_method' => $collection_method,
				'billing_cycle_anchor' => $billing_ca,
				'customer_id' => $customer,
				'st_plan_id' => $st_plan_id,
				'amount' => $amount,
				'status' => $pl_status,
				'monthly_upload' => $total_uploads,
				'remains_upload' => $total_uploads,
				'createdtime' => date('Y-m-d H:i:s'),
				'expiretime' => date("Y-m-d H:i:s", strtotime("+$plan_validity months")),
				'monthly_request' => $request_limite,
				'remains_request' => $request_limite,
        ), 
        array('sub_id'=>$sub_id)
			); 
			
    if($up_query){
      $web_url = get_the_permalink($item_id); 
      $header = '';
      if(!empty($miraculous_theme_data['planspayment_header'])):
          $header = $miraculous_theme_data['planspayment_header'];
      endif;
      $emailmessage = '';
      if(!empty($miraculous_theme_data['planpayment_emailmessage'])):
        $emailmessage = $miraculous_theme_data['planpayment_emailmessage'];
      endif;
      $customer_email = $_POST['stripeEmail'];
      $admin_email = get_option('admin_email');
      $headers = array('Content-Type: text/html; charset=UTF-8',$header);
      $multiple_emails = array(
            $admin_email, 
            $customer_email,
        );
      wp_mail($multiple_emails, $emailmessage, $web_url, $headers);
    ?>
	<script>
    jQuery(document).ready(function($){
       "use strict";
        toastr.success('Thank you for Changed Plan');
        window.location.replace('<?php echo esc_url($stripe_success_page_url); ?>?plan=msg');
    });  
    </script> 
	<?php
	}else{
    ?>
    <script>
    jQuery(document).ready(function($){
       "use strict";
       toastr.success('Error!');
       window.location.replace('<?php echo esc_url($stripe_cancel_page_url); ?>');
    });  
    </script>
    <?php
	}
	
} catch (Exception $e) {
	/*
	* if something goes wrong
	*/ 
	echo $e->getMessage();
} 

}else{
	esc_html_e('The Stripe Token is not correct','miraculous');
}
wp_footer();
