<?php 
require_once( dirname(__FILE__) . '/../../../../wp-load.php' ); // WP environment
wp_head();
require_once( dirname(__FILE__) . '/striplibary/init.php' ); // I placed the directory with Stripe PHP library in the theme folder

$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
    $miraculous_theme_data = fw_get_db_settings_option();     
endif; 

$currency = '';
if(!empty($miraculous_theme_data['paypal_currency'])):
    $currency = $miraculous_theme_data['paypal_currency'];
endif;
$stripe_publishable_key = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_publishable_key'])):
    $stripe_publishable_key = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_publishable_key'];
endif;

$stripe_success_page_url = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_success_donation_page_url'])):
    $stripe_success_page_url = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_success_donation_page_url'];
endif; 

$stripe_cancel_page_url = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_cancel_page_url'])):
    $stripe_cancel_page_url = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_cancel_page_url'];
endif;

// you can get it in Stripe Account Settings -> API Keys
$secret = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_secret_key'])):
    $secret = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_secret_key'];
endif;

$stripe_commission_point = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_commission_donations'])):
   $stripe_commission_point = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_commission_donations'];
endif;

if(isset($_POST['stripeToken'])){
	
	\Stripe\Stripe::setApiKey( $secret );

	/* we specified this parameter as a hidden field */
	$donation_price = $_POST['donation_price'];
    $artist_id = $_POST['artist_id'];

    if($artist_id):
      $stripe_username = get_user_meta($artist_id,'stripe_username', true);
      $stripe_useremail = get_user_meta($artist_id,'stripe_useremail', true);
      $stripe_secretkey = get_user_meta($artist_id, 'stripe_secretkey', true); 
      $stripe_accountid = get_user_meta($artist_id, 'stripe_accountid', true); 
    endif;

	/* if your plugin price looks like 9.59, then you need to *100 it */
	$price = $donation_price*100;
	
    /**
     * commission formula
     */
    if(!empty($stripe_secretkey) && !empty($stripe_accountid)):
        $totalcommission = round($price*$stripe_commission_point/100);
        $vendorprice = round($price-$totalcommission);
     else:
        $totalcommission = round($price);
        $vendorprice = 0; 
     endif;
	
	try {
	    
		if ( !isset($_POST['stripeToken']) )
			throw new Exception('The Stripe Token is not correct');
	
		/* make a charge */
		$rdata = \Stripe\Charge::create( array( 'amount' => $totalcommission, 'currency' => $currency, 'source' => $_POST['stripeToken'], 'description' => 'User Name' . $user_name . ') User EMail: ' . $_POST['stripeEmail'] ) );
       
		if($artist_id){

           \Stripe\Stripe::setApiKey($stripe_secretkey);
		
            $payment_intent = \Stripe\PaymentIntent::create([
                'payment_method_types' => ['card'],
                'amount' => $vendorprice,
                'currency' => $currency,
            ], ['stripe_account' => $stripe_accountid]);
                
            $stripe = new \Stripe\StripeClient($stripe_secretkey);
                
            $stripe->paymentIntents->confirm(
                $payment_intent->id,
                ['payment_method' => 'pm_card_visa']
            );

		}
		
		global $wpdb; 
        $tbl_pay = $wpdb->prefix. 'ms_donation';
		$current_user = wp_get_current_user();
		$download_limite = 100;
        $tranx_amount = $price/100;;
        $amount_admin = $totalcommission/100;
        $amount_author = $vendorprice/100; 
		$tranx_id = $rdata->id;
		$tranx_status = $rdata->status;
        $plan_validity = '12';
        $author_id = get_post_field( 'post_author', $item_id);
		$wpdb->insert( 
			$tbl_pay, 
			array(
                'user_id' => $current_user->ID, 
                'author_id' => $artist_id,
                'itemid' => $artist_id,
                'txnid' => $tranx_id,
                'payment_amount' => $tranx_amount,
                'payment_amount_admin' => $amount_admin,
                'payment_amount_author' => $amount_author,
                'payment_status' => $tranx_status,
                'monthly_download_limite' => $download_limite,
                'createdtime' => date('Y-m-d H:i:s'),
                'expiretime' => date("Y-m-d H:i:s", strtotime("+$plan_validity months")),
                'extra_data' => json_encode($rdata),
			   ), 
			array(
				'%d', 
				'%d', 
				'%d',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%d', 
				'%s',
				'%s',
				'%s',
			  ) 
		); 
  
	
	if($wpdb->insert_id){

        $web_url = get_the_permalink($item_id); 
        $header = '';
        if(!empty($miraculous_theme_data['donationpayment_header'])):
            $header = $miraculous_theme_data['donationpayment_header'];
        endif;
        $emailmessage = '';
        if(!empty($miraculous_theme_data['donationpayment_emailmessage'])):
            $emailmessage = $miraculous_theme_data['donationpayment_emailmessage'];
        endif;
        $customer_email = $_POST['stripeEmail'];
        $admin_email = get_option('admin_email');
        $headers = array('Content-Type: text/html; charset=UTF-8',$header);
        
        $multiple_emails = array(
            $admin_email, 
            $customer_email,
           );
        wp_mail($multiple_emails, $emailmessage, $web_url, $headers);
    ?>
	<script>
    jQuery(document).ready(function($){
       "use strict";
        toastr.success('Thank you for making a purchase');
        window.location.replace('<?php echo esc_url($stripe_success_page_url); ?>');
    });  
    </script>
	<?php
	}else{ 
    ?>
    <script>
    jQuery(document).ready(function($){
       "use strict";
       toastr.success('Error!');
       window.location.replace('<?php echo esc_url($stripe_cancel_page_url); ?>');
    });  
    </script>
    <?php
	} 
    
} catch (Exception $e) {
		/*
		* if something goes wrong
		*/ 
		echo $e->getMessage();
	} 

}else{
	esc_html_e('The Stripe Token is not correct','miraculous');
}
wp_footer(); 