<?php if (!defined('FW')) die('Forbidden');
$heading = '';
if(!empty($atts['manage_plan_heading'])):
  $heading = $atts['manage_plan_heading'];
endif;
$priceplan = '';
if(!empty($atts['priceplan_switch'])):
  $priceplan = $atts['priceplan_switch'];
endif;

$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
    $miraculous_theme_data = fw_get_db_settings_option();     
endif;
$currency = '';
if(!empty($miraculous_theme_data['currency'])):
    $currency = $miraculous_theme_data['currency'];
endif;

$stripe_publishable_key = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_publishable_key'])):
    $stripe_publishable_key = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_publishable_key'];
endif;

$stripe_secret_key = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_secret_key'])):
    $stripe_secret_key = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_secret_key'];
endif;

$stripe_logo_image = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_logo_image']['url'])):
    $stripe_logo_image = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_logo_image']['url'];
endif;

$stripe_store_name = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_store_name'])):
    $stripe_store_name = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_store_name'];
endif;

$stripe_store_description = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_store_description'])):
    $stripe_store_description = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_store_description'];
endif;

$theme_paystack_switch = '';
if(!empty($miraculous_theme_data['theme_paystack_switch']['paystack_switch_value'])):
	$theme_paystack_switch = $miraculous_theme_data['theme_paystack_switch']['paystack_switch_value'];
endif;
$email = '';
if(!empty($miraculous_theme_data['theme_stripe_switch']['on']['stripe_email'])):
    $email = $miraculous_theme_data['theme_stripe_switch']['on']['stripe_email'];
endif;
$planid = '';
if(!empty($atts['id'])):
  $planid = $atts['id'];
endif;

$icon_doolor = get_template_directory_uri().'/assets/images/icon_doolor.png';
$paypal_icon = get_template_directory_uri().'/assets/images/paypal_icon.jpg';
$Stripe_icon = get_template_directory_uri().'/assets/images/Stripe_icon.jpg';
$Paytrac_icon = get_template_directory_uri().'/assets/images/Paytrac_icon.jpg';

$submit_url = plugins_url().'/miraculouscore/paypal/payments.php';

if(isset($_GET['sub_id'])):
  $stripe_submit_url = plugins_url().'/miraculouscore/strippayment/upgradedowngrade-subscriptions.php';
else:
  $stripe_submit_url = plugins_url().'/miraculouscore/strippayment/charge.php';
endif;
$ms_args = array('post_type' => 'ms-plans',
                 'numberposts' => -1,
                 'post__in' => $planid,
                 'order' => 'DSC'
                 ); 
$music_plans = new WP_Query( $ms_args );
$current_user = wp_get_current_user();
?>
<div class="ms_account_wrapper">
    <div class="container">
        <div class="row">
            <?php if(!empty($heading)): ?>
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1><?php echo __($heading); ?></h1>
                    </div>
                </div>
            <?php endif; ?>
            <?php
            if( $music_plans->have_posts() ):
  			$i = 1; 
            while ( $music_plans->have_posts() ) : $music_plans->the_post();
            
            $monthly_uploads = get_post_meta(get_the_id(), 'fw_option:plan_monthly_uploads', true);

            $monthly_price = get_post_meta(get_the_id(), 'fw_option:plan_monthly_price', true);

            $monthly_request_limite = get_post_meta(get_the_id(), 'fw_option:plan_monthly_request_limite', true);

            $plan_validity = get_post_meta(get_the_id(), 'fw_option:plan_validity', true);

            global $wpdb;
            $pmt_tbl = $wpdb->prefix .'ms_payments'; 
            $itemid = get_the_ID();
            $query = $wpdb->get_results( "SELECT * FROM {$pmt_tbl} WHERE user_id = {$current_user->ID} AND itemid ={$itemid}" );
            $freecheck = ''; 
            if ( isset($shortcodes[1][0]) && $content === $shortcodes[1][0] ) {
              $freecheck= $query[0]->txnid;
            }
            if($freecheck == 'Free'):
                
            else:
			?>
            <div class="col-lg-4">
                <div class="ms_plan_box <?php echo $i==2 ? 'paln_active' : ''; ?>">
                    <div class="ms_plan_header">
                        <div class="ms_plan_img">
                            <?php the_post_thumbnail( 'thumbnail' ); ?>
                        </div>
                    </div>
                    <h3 class="plan_heading"><?php the_title(); ?></h3>
                    <div class="plan_price">
					<div class="plan_dolar">
					<sup>
                    <?php
                    if(function_exists('miraculous_currency_symbol')){
                      echo miraculous_currency_symbol($currency);
                    }
					?>
                    </sup>
                    <span class="monthly_price">
                        <?php echo esc_attr($monthly_price); ?>
                    </span> 
                    </div> 
					</div>
                    <div class="plancontent">
                        <?php echo the_content(); ?>
                    </div>
                    <?php
if ( is_user_logged_in() ) { ?>
					<a href="javascript:;" class="ms_btn bynow_btn" data-toggle="modal" data-target="#bynow" order_id="<?php echo esc_attr(get_the_id()); ?>"><?php esc_html_e('buy now', 'miraculous'); ?></a>
					<?php } else { ?>
					<a href="javascript:;" class="ms_btn bynow_btn" data-toggle="modal" data-target="#myModal" order_id="<?php echo esc_attr(get_the_id()); ?>"><?php esc_html_e('buy now', 'miraculous'); ?></a>
					 <?php }
					endif;
					?>
				  </div> 
                </div>  
             <?php  $i++; endwhile; ?>
            <?php wp_reset_postdata();
            endif; ?>
        </div>
     </div>
</div> 

<!-- Modal -->
<div class="modal fade plan_modal" id="bynow" tabindex="-1" role="dialog" aria-labelledby="payment_method" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
        <img src="<?php echo esc_url($icon_doolor); ?>" class="payment_icon">
      <div class="modal-header">
        <h5 class="modal-title" id="payment_method"><?php esc_html_e('Choose your payment method', 'miraculous'); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">X</span>
        </button>
        <?php 
					$miraculous_meta_data = '';
					if(function_exists('fw_get_db_post_option')): 
						$miraculous_meta_data = fw_get_db_post_option(get_the_id());   
					endif; 
					$free_plane_switch = '';
					if(!empty($miraculous_meta_data['free_plane_switch'])):
					  $free_plane_switch = $miraculous_meta_data['free_plane_switch'];
					  endif;
					  $theme_paypal_switch = '';
					 if(!empty($miraculous_theme_data['theme_paypal_switch']['Paypal_switch_value'])):
						 $theme_paypal_switch = $miraculous_theme_data['theme_paypal_switch']['Paypal_switch_value'];
					 endif;
					 $theme_stripe_switch = '';
					if(!empty($miraculous_theme_data['theme_stripe_switch']['stripe_switch_value'])):
						$theme_stripe_switch = $miraculous_theme_data['theme_stripe_switch']['stripe_switch_value'];
					endif;

					if ($theme_paypal_switch == 'on') {
					?>
					<div class="ms_plan_btn_modal">
                        <?php if( !empty($current_user) && $current_user->ID ){ ?>
                            <form class="paypal" action="<?php echo esc_url($submit_url); ?>" method="post" id="form_data_paypal">
                                <input type="hidden" name="cmd" value="_xclick" />
                                <input type="hidden" name="lc" value="UK" />
                                <input type="hidden" name="first_name" id="first_name" value="<?php echo esc_attr($current_user->user_firstname); ?>" />
                                <input type="hidden" name="last_name" id="last_name" value="<?php echo esc_attr($current_user->user_lastname); ?>" />
                                <input type="hidden" name="payer_email" id="payer_email" value="<?php echo esc_attr($current_user->user_email); ?>" />
                                <input type="hidden" name="user_id" id="user_id" value="<?php echo esc_attr($current_user->ID); ?>" />
                                <input type="hidden" name="item_number" id="item_number" value="<?php echo esc_attr(get_the_id()); ?>" / >
                                <input type="hidden" name="item_name" id="item_name" value="<?php the_title_attribute(); ?>" / >
                                <button ype="submit" name="submit" class="ms-paypal" class="mira_price ms_btn" value="<?php esc_attr_e('buy now', 'miraculous'); ?>">
								    <img src="<?php echo esc_url($paypal_icon); ?>" alt="<?php esc_attr_e('Buy Now', 'miraculous'); ?>">
								</button>
                            </form>
                        <?php } ?>
                    </div>
					<?php
					} 
					if ($theme_stripe_switch == 'on') {
					 ?>
					<div class="ms_plan_btn_modal">
                        <?php 
                        if(!empty($current_user) && $current_user->ID ){
                            $product_price = get_post_meta(get_the_id(), 'fw_option:plan_price', true)*100;
                            ?>
                           <!-- Stripe Payment Option -->
                            <form action="<?php echo esc_url($stripe_submit_url); ?>" method="post" id="form_data_strip">
                            <script src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                                data-key="<?php echo esc_attr($stripe_publishable_key); ?>"
                                data-name="<?php echo esc_attr($stripe_store_name); ?>"
                                data-description="<?php echo esc_attr($stripe_store_description); ?>"
                                data-image="<?php echo esc_attr($stripe_logo_image); ?>" 
                                data-currency=<?php echo esc_attr($currency); ?>
                                data-email="<?php echo esc_attr($email); ?>"
                                data-locale="auto"></script>
                                <?php /* you can pass parameters to php file in hidden fields, for example - plugin ID */ ?>
                                <input type="hidden" name="item_id" id="item_id" value="">
                                <input type="hidden" name="item_type" class="itemplan" value="">
                                <?php if(isset($_GET['sub_id'])): ?>
                                  <input type="hidden" name="sud_id" value="<?php echo esc_attr($_GET['sub_id']); ?>">
                                <?php endif; ?> 
                            </form>
                        <?php } ?>
                    </div>
					<?php
					} 
					if ($theme_paystack_switch == 'on') {
					 ?>
					<div class="ms_plan_btn_modal">
                        <?php if( !empty($current_user) && $current_user->ID ){ ?>
                            <!-- Paystack -->
							<form action="<?php echo plugins_url('miraculouscore/paystack/initialize.php'); ?>" method="POST" id="form_data_paysrack">
								<input type="hidden" name="payer_email" value="<?php echo esc_attr($current_user->user_email); ?>" />
							    <input type="hidden" class="ms-plan" id="monthly" name="monthly" type="radio" value="monthly">
								<input type="hidden" name="plan_id" id="plan_id" value="" / >
								<button type="submit" name="Paystack_submit" class="ms_btn ms-paystrack" value="<?php esc_attr_e('Paystack', 'miraculous'); ?>">
								    <img src="<?php echo esc_url($Paytrac_icon); ?>" alt="<?php esc_attr_e('Buy Now', 'miraculous'); ?>">
								</button>
                            </form> 
                        <?php } ?>
                    </div>
					<?php 
					}
					?>
      </div>
    </div>
  </div>
</div>

<style>
    button.stripe-button-el {
    background-image: url(<?php echo esc_url($Stripe_icon); ?>);
    width: 100%;
    max-width: 100%;
    height: 60px;
    margin: auto;
    display: flex;
    justify-content: center;
    align-items: center;
    padding-bottom: 10px;
    border-radius: 10px;
    background-repeat: no-repeat;
    background-size: 82%;
    background-position: center;
    background-color: white;
    margin: 15px auto;
}
.stripe-button-el:not(:disabled):active, .stripe-button-el.active {
    background-color: #005d9300!important;
    box-shadow: 0px 0 0 !important;
    background-image: url(<?php echo esc_url($Stripe_icon); ?>);
    background-size: 100%;
    background-position: center;
}
    button.stripe-button-el span {
        display: none!important;
    }
    
    
</style>