<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => __( 'General', 'minimog' ),
	'id'         => 'title_bar_general',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'          => 'title_bar_layout',
			'type'        => 'select',
			'title'       => __( 'Global Title Bar', 'minimog' ),
			'description' => __( 'Select default title bar that displays on all pages.', 'minimog' ),
			'options'     => Minimog_Title_Bar::instance()->get_list(),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_layout' ),
		),
		array(
			'id'      => 'title_bar_content_width',
			'type'    => 'select',
			'title'   => __( 'Content Width', 'minimog' ),
			'default' => Minimog_Site_Layout::CONTAINER_WIDE,
			'options' => Minimog_Site_Layout::instance()->get_container_wide_list(),
		),
		array(
			'id'      => 'breadcrumb_visibility',
			'type'    => 'button_set',
			'title'   => __( 'Breadcrumb Visibility', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'breadcrumb_visibility' ),
		),
		array(
			'id'            => 'title_bar_heading_font_size',
			'title'         => __( 'Heading Font Size', 'minimog' ),
			'type'          => 'slider',
			'default'       => 42,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_search_title',
			'title'       => __( 'Search Heading', 'minimog' ),
			'description' => __( 'Enter text prefix that displays on search results page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_search_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_home_title',
			'title'       => __( 'Home Heading', 'minimog' ),
			'description' => __( 'Enter text that displays on front latest posts page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_home_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_archive_category_title',
			'title'       => __( 'Archive Category Heading', 'minimog' ),
			'description' => __( 'Enter text prefix that displays on archive category page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_archive_category_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_archive_tag_title',
			'title'       => __( 'Archive Tag Heading', 'minimog' ),
			'description' => __( 'Enter text prefix that displays on archive tag page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_archive_tag_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_archive_author_title',
			'title'       => __( 'Archive Author Heading', 'minimog' ),
			'description' => __( 'Enter text prefix that displays on archive author page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_archive_author_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_archive_year_title',
			'title'       => __( 'Archive Year Heading', 'minimog' ),
			'description' => __( 'Enter text prefix that displays on archive year page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_archive_year_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_archive_month_title',
			'title'       => __( 'Archive Month Heading', 'minimog' ),
			'description' => __( 'Enter text prefix that displays on archive month page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_archive_month_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_archive_day_title',
			'title'       => __( 'Archive Day Heading', 'minimog' ),
			'description' => __( 'Enter text prefix that displays on archive day page.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_archive_day_title' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'title_bar_single_blog_title',
			'title'       => __( 'Single Blog Heading', 'minimog' ),
			'description' => __( 'Leave blank to use post title.', 'minimog' ),
			'default'     => Minimog_Redux::get_default_setting( 'title_bar_single_blog_title' ),
		),
	),
) );
