<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'       => __( 'Popup', 'minimog' ),
	'description' => __( 'Create coupon or newsletter popup to interact with your customer.', 'minimog' ),
	'id'          => 'panel_popup',
	'icon'        => 'eicon-upload-circle-o',
	'fields'      => array(
		array(
			'id'     => 'section_promo_popup_layout_content',
			'type'   => 'tm_heading',
			'title'  => __( 'Layout & Content', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'promo_popup_enable',
			'type'    => 'button_set',
			'title'   => __( 'Visibility', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_enable' ),
		),
		array(
			'id'      => 'promo_popup_style',
			'type'    => 'select',
			'title'   => __( 'Style', 'minimog' ),
			'options' => [
				'01' => sprintf( __( 'Style %s', 'minimog' ), '01' ),
				'02' => sprintf( __( 'Style %s', 'minimog' ), '02' ),
				'03' => sprintf( __( 'Style %s', 'minimog' ), '03' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_style' ),
		),
		array(
			'id'          => 'promo_popup_type',
			'type'        => 'select',
			'title'       => __( 'Popup Type', 'minimog' ),
			'description' => __( 'Choose goal for your promo popup', 'minimog' ),
			'options'     => [
				'subscribe'     => __( 'Subscribe', 'minimog' ),
				'discount_code' => __( 'Give a discount code', 'minimog' ),
				'announcement'  => __( 'Announcement', 'minimog' ),
			],
			'default'     => Minimog_Redux::get_default_setting( 'promo_popup_type' ),
		),
		array(
			'id'          => 'promo_popup_form_id',
			'type'        => 'select',
			'title'       => __( 'Form ID', 'minimog' ),
			'description' => __( 'Select a form by WPForms to display', 'minimog' ),
			'options'     => Minimog_Helper::get_wpforms_list( [ 'context' => 'options' ] ),
			'default'     => '',
			'required'    => array(
				[ 'promo_popup_type', '=', 'subscribe' ],
			),
		),
		array(
			'id'       => 'promo_popup_discount_code',
			'type'     => 'text',
			'title'    => __( 'Discount Code', 'minimog' ),
			'required' => array(
				[ 'promo_popup_type', '=', 'discount_code' ],
			),
		),
		array(
			'id'      => 'promo_popup_heading',
			'type'    => 'textarea',
			'title'   => __( 'Heading', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_heading' ),
		),
		array(
			'id'      => 'promo_popup_description',
			'type'    => 'textarea',
			'title'   => __( 'Description', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_description' ),
		),
		array(
			'id'    => 'promo_popup_content',
			'type'  => 'editor',
			'title' => __( 'Content', 'minimog' ),
			'desc'  => __( 'Support shortcode tags', 'minimog' ),
			'args'  => array(
				'textarea_rows'  => 5,
				'default_editor' => 'html',
			),
		),
		array(
			'id'      => 'promo_popup_image',
			'type'    => 'media',
			'title'   => __( 'Image', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_image' ),
		),
		array(
			'id'       => 'promo_popup_button_style',
			'type'     => 'select',
			'title'    => __( 'Button Style', 'minimog' ),
			'options'  => Minimog_Helper::get_button_style_options(),
			'default'  => Minimog_Redux::get_default_setting( 'promo_popup_button_style' ),
			'required' => array(
				[ 'promo_popup_type', '=', 'announcement' ],
			),
		),
		array(
			'id'       => 'promo_popup_button_text',
			'type'     => 'text',
			'title'    => __( 'Button Text', 'minimog' ),
			'default'  => Minimog_Redux::get_default_setting( 'promo_popup_button_text' ),
			'required' => array(
				[ 'promo_popup_type', '=', 'announcement' ],
			),
		),
		array(
			'id'       => 'promo_popup_button_url',
			'type'     => 'text',
			'title'    => __( 'Button Url', 'minimog' ),
			'default'  => Minimog_Redux::get_default_setting( 'promo_popup_button_url' ),
			'required' => array(
				[ 'promo_popup_type', '=', 'announcement' ],
			),
		),
		array(
			'id'       => 'section_promo_popup_conditions',
			'type'     => 'tm_heading',
			'title'    => __( 'Conditions', 'minimog' ),
			'subtitle' => __( 'Apply the popup to specify pages.', 'minimog' ),
			'indent'   => true,
		),
		array(
			'id'    => 'promo_popup_show_on_pages',
			'type'  => 'select',
			'data'  => 'pages',
			'multi' => true,
			'title' => __( 'Select Pages', 'minimog' ),
			'desc'  => __( 'Select any pages you want to display the popup. Leave blank to display on all pages.', 'minimog' ),
		),
		array(
			'id'       => 'section_promo_popup_triggers',
			'type'     => 'tm_heading',
			'title'    => __( 'Triggers', 'minimog' ),
			'subtitle' => __( 'What action the user needs to do for the popup to open.', 'minimog' ),
			'indent'   => true,
		),
		array(
			'id'      => 'promo_popup_trigger_on_load',
			'type'    => 'button_set',
			'title'   => __( 'On Page Load', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_trigger_on_load' ),
			'class'   => 'redux-row-field-parent redux-row-field-first-parent',
		),
		array(
			'type'       => 'text',
			'id'         => 'promo_popup_trigger_on_load_delay',
			'title'      => __( 'Within (sec)', 'minimog' ),
			'attributes' => [
				'type' => 'number',
				'step' => 0.1,
				'min'  => 0,
			],
			'required'   => array(
				[ 'promo_popup_trigger_on_load', '=', '1' ],
			),
			'class'      => 'redux-row-field-child',
		),
		array(
			'id'      => 'promo_popup_trigger_on_scrolling',
			'type'    => 'button_set',
			'title'   => __( 'On Scroll', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_trigger_on_scrolling' ),
			'class'   => 'redux-row-field-parent',
		),
		array(
			'id'       => 'promo_popup_trigger_scrolling_direction',
			'type'     => 'button_set',
			'title'    => __( 'Direction', 'minimog' ),
			'options'  => array(
				'down' => __( 'Down', 'minimog' ),
				'up'   => __( 'Up', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'promo_popup_trigger_scrolling_direction' ),
			'required' => array(
				[ 'promo_popup_trigger_on_scrolling', '=', '1' ],
			),
			'class'    => 'redux-row-field-child',
		),
		array(
			'type'       => 'text',
			'id'         => 'promo_popup_trigger_scrolling_offset',
			'title'      => __( 'Within (%)', 'minimog' ),
			'attributes' => [
				'type' => 'number',
				'step' => 1,
				'min'  => 0,
				'max'  => 100,
			],
			'default'    => Minimog_Redux::get_default_setting( 'promo_popup_trigger_scrolling_offset' ),
			'required'   => array(
				[ 'promo_popup_trigger_on_scrolling', '=', '1' ],
			),
			'class'      => 'redux-row-field-child',
		),
		array(
			'id'      => 'promo_popup_trigger_on_click',
			'type'    => 'button_set',
			'title'   => __( 'On Click', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_trigger_on_click' ),
			'class'   => 'redux-row-field-parent',
		),
		array(
			'type'       => 'text',
			'id'         => 'promo_popup_trigger_click_times',
			'title'      => __( 'Click Times', 'minimog' ),
			'attributes' => [
				'type' => 'number',
				'step' => 1,
				'min'  => 1,
				'max'  => 100,
			],
			'default'    => Minimog_Redux::get_default_setting( 'promo_popup_trigger_click_times' ),
			'required'   => array(
				[ 'promo_popup_trigger_on_click', '=', '1' ],
			),
			'class'      => 'redux-row-field-child',
		),
		array(
			'id'       => 'section_promo_popup_advanced_rules',
			'type'     => 'tm_heading',
			'title'    => __( 'Advanced Rules', 'minimog' ),
			'subtitle' => __( 'Requirements that have to be met for the popup to open.', 'minimog' ),
			'indent'   => true,
		),
		array(
			'id'      => 'promo_popup_rule_by_times',
			'type'    => 'button_set',
			'title'   => __( 'Show up to X times', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_rule_by_times' ),
			'class'   => 'redux-row-field-parent redux-row-field-first-parent',
		),
		array(
			'type'       => 'text',
			'id'         => 'promo_popup_rule_times_up_to',
			'title'      => __( 'Times', 'minimog' ),
			'attributes' => [
				'type' => 'number',
				'step' => 1,
				'min'  => 1,
				'max'  => 100,
			],
			'default'    => Minimog_Redux::get_default_setting( 'promo_popup_rule_times_up_to' ),
			'required'   => array(
				[ 'promo_popup_rule_by_times', '=', '1' ],
			),
			'class'      => 'redux-row-field-child',
		),
		array(
			'id'      => 'promo_popup_rule_show_by_page_views',
			'type'    => 'button_set',
			'title'   => __( 'Show after X page views', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_rule_show_by_page_views' ),
			'class'   => 'redux-row-field-parent',
		),
		array(
			'type'       => 'text',
			'id'         => 'promo_popup_rule_page_views_reach',
			'title'      => __( 'Page Views', 'minimog' ),
			'attributes' => [
				'type' => 'number',
				'step' => 1,
				'min'  => 1,
				'max'  => 100,
			],
			'default'    => Minimog_Redux::get_default_setting( 'promo_popup_rule_page_views_reach' ),
			'required'   => array(
				[ 'promo_popup_rule_show_by_page_views', '=', '1' ],
			),
			'class'      => 'redux-row-field-child',
		),
		array(
			'id'      => 'promo_popup_rule_hide_by_logged_in',
			'type'    => 'button_set',
			'title'   => __( 'Hide for logged in users', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'promo_popup_rule_hide_by_logged_in' ),
			'class'   => 'redux-row-field-parent',
		),
	),
) );
