<?php
/**
 * Miion Elementor Addon Campaigns
 *
 * @since 1.0.0
 */
class Elementor_Campaigns_Widget extends \Elementor\Widget_Base {
	
	private $excerpt_len;
	
	/**
	 * Get widget name.
	 *
	 * Retrieve Campaigns widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return "zozocampaigns";
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Campaigns widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( "Campaigns", "miion-core" );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Campaigns widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return "ti-money";
	}


	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Campaigns widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ "miion-elements" ];
	}

	/**
	 * Register Campaigns widget controls. 
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		//General Section
		$this->start_controls_section(
			"general_section",
			[
				"label"	=> esc_html__( "General", "miion-core" ),
				"tab"	=> \Elementor\Controls_Manager::TAB_CONTENT,
				"description"	=> esc_html__( "Default blog options.", "miion-core" ),
			]
		);
		$this->add_control(
			"extra_class",
			[
				"type"			=> \Elementor\Controls_Manager::TEXT,
				"label" 		=> esc_html__( "Extra Class", "miion-core" ),
				"description"	=> esc_html__( "Put extra class for some additional styles.", "miion-core" ),
			]
		);
		$this->add_control(
			"num_posts",
			[
				"type"			=> \Elementor\Controls_Manager::TEXT,
				"label"			=> esc_html__( "Campaigns per Page", "miion-core" ),
				"description"	=> esc_html__( "Here you set limited number of campaigns per page.", "miion-core" ),
				"default" 		=> "6"
			]
		);
		$this->end_controls_section();
		
		//Layouts Section
		$this->start_controls_section(
			"layouts_section",
			[
				"label"			=> esc_html__( "Layouts", "miion-core" ),
				"tab"			=> \Elementor\Controls_Manager::TAB_CONTENT,
				"description"	=> esc_html__( "Campaign layout options here available.", "miion-core" ),
			]
		);
		$this->add_control(
			"layout_style",
			[
				"label"			=> esc_html__( "Layouts", "miion-core" ),
				"type"			=> \Elementor\Controls_Manager::SELECT,
				"default"		=> "grid",
				"options"		=> [
					"grid"		=> esc_html__( "Grid", "miion-core" ),
					"list"		=> esc_html__( "List", "miion-core" )
				]
			]
		);
		$this->add_control(
			"columns",
			[
				"label"			=> esc_html__( "Layouts", "miion-core" ),
				"type"			=> \Elementor\Controls_Manager::SELECT,
				"default"		=> "2",
				"options"		=> [
					"2"		=> esc_html__( "Two Columns", "miion-core" ),
					"3"		=> esc_html__( "Three Columns", "miion-core" ),
					"4"		=> esc_html__( "Four Columns", "miion-core" )
				],
				"condition" 	=> [
					"layout_style" 	=> "grid"
				]
			]
		);
		$this->add_control(
			"include_categories",
			[
				"type"			=> \Elementor\Controls_Manager::TEXT,
				"label"			=> esc_html__( "Include Categories", "miion-core" ),
				"description"	=> esc_html__( "Enter the slug of a category. Seperate it by comma(,)", "miion-core" ),
				"default" 		=> ""
			]
		);
		$this->add_control(
			"camp_id",
			[
				"type"			=> \Elementor\Controls_Manager::TEXT,
				"label"			=> esc_html__( "Campaigns ID's", "miion-core" ),
				"description"	=> esc_html__( "Enter the ID of a Campaign (comma seperated) to pull campaigns. Example: 15, 12", "miion-core" ),
				"default" 		=> ""
			]
		);
		$this->add_control(
			"orderby",
			[
				"label"			=> esc_html__( "Order By", "miion-core" ),
				"type"			=> \Elementor\Controls_Manager::SELECT,
				"default"		=> "post_date",
				"options"		=> [
					"post_date"		=> esc_html__( "Post Date", "miion-core" ),
					"popular"		=> esc_html__( "popular Campaigns", "miion-core" ),
					"ending"		=> esc_html__( "Ending Campaigns", "miion-core" )
				]
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render Campaign widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();
		extract( $settings );

		$miion_attr = '';
		
		$class = isset( $extra_class ) && $extra_class != '' ? ' ' . $extra_class : '';		
		//Posts per page
		$miion_attr .= isset( $num_posts ) && $num_posts != '' ? 'number=' . absint($num_posts) . ' ' : '';
		//Layout
		if( isset( $layout_style ) && $layout_style != 'list' ) {
			add_filter( 'charitable_campaign_loop_thumbnail_size', array( $this, 'charitable_campaign_loop_thumbnail_size_thumbnail' ), 10 );
			$miion_attr .= isset( $columns ) && $columns != '' ? 'columns=' . absint($columns) . ' ' : '';
		}else{
			add_filter( 'charitable_campaign_loop_thumbnail_size', array( $this, 'charitable_campaign_loop_thumbnail_size_revert' ), 10 );
			$miion_attr .= isset( $columns ) && $columns != '' ? 'columns=1 ' : '';
		}

		//category
		$miion_attr .= isset( $include_categories ) && $include_categories != '' ? 'category=' . esc_attr($include_categories) . ' ' : '';

		//order
		$miion_attr .= isset( $orderby ) && $orderby != '' ? 'orderby=' . esc_attr($orderby) . ' ' : '';
		
		//Include id
		$miion_attr .= isset( $camp_id ) && $camp_id != '' ? 'id=' . absint($camp_id) . ' ' : '';
		
		echo '<div class="campaign-wrapper'. esc_attr( $class ) .'">';
			echo do_shortcode('[campaigns '. $miion_attr .']');
		echo '</div><!-- .campaign-wrapper -->';

	}

	public function charitable_campaign_loop_thumbnail_size_thumbnail( $size ){
		return 'large';
	}

	public function charitable_campaign_loop_thumbnail_size_revert( $size ){
		return $size;
	}
	
}