<?php
/**
 * Elementor themify icon control.
 *
 */
class Control_Themify_Icon extends \Elementor\Base_Data_Control {

	/**
	 * Get icon control type.
	 *
	 * Retrieve the control type, in this case `icon`.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Control type.
	 */
	public function get_type() {
		return 'themifyicon';
	}
	
	public function enqueue() {
		wp_register_style( 'themify-icons', get_theme_file_uri( '/assets/css/themify-icons.css' ), false, '1.0' );
		wp_enqueue_style( 'themify-icons' );
	}

	/**
	 * Get icons.
	 *
	 * Retrieve all the available icons.
	 *
	 * @since 1.0.0
	 * @access public
	 * @static
	 *
	 * @return array Available icons.
	 */
	public static function get_icons() {
		return [
			'ti-wand' => 'wand e600',
			'ti-volume' => 'volume e601',
			'ti-user' => 'user e602',
			'ti-unlock' => 'unlock e603',
			'ti-unlink' => 'unlink e604',
			'ti-trash' => 'trash e605',
			'ti-thought' => 'thought e606',
			'ti-target' => 'target e607',
			'ti-tag' => 'tag e608',
			'ti-tablet' => 'tablet e609',
			'ti-star' => 'star e60a',
			'ti-spray' => 'spray e60b',
			'ti-signal' => 'signal e60c',
			'ti-shopping-cart' => 'shopping-cart e60d',
			'ti-shopping-cart-full' => 'shopping-cart-full e60e',
			'ti-settings' => 'settings e60f',
			'ti-search' => 'search e610',
			'ti-zoom-in' => 'zoom-in e611',
			'ti-zoom-out' => 'zoom-out e612',
			'ti-cut' => 'cut e613',
			'ti-ruler' => 'ruler e614',
			'ti-ruler-pencil' => 'ruler-pencil e615',
			'ti-ruler-alt' => 'ruler-alt e616',
			'ti-bookmark' => 'bookmark e617',
			'ti-bookmark-alt' => 'bookmark-alt e618',
			'ti-reload' => 'reload e619',
			'ti-plus' => 'plus e61a',
			'ti-pin' => 'pin e61b',
			'ti-pencil' => 'pencil e61c',
			'ti-pencil-alt' => 'pencil-alt e61d',
			'ti-paint-roller' => 'paint-roller e61e',
			'ti-paint-bucket' => 'paint-bucket e61f',
			'ti-na' => 'na e620',
			'ti-mobile' => 'mobile e621',
			'ti-minus' => 'minus e622',
			'ti-medall' => 'medall e623',
			'ti-medall-alt' => 'medall-alt e624',
			'ti-marker' => 'marker e625',
			'ti-marker-alt' => 'marker-alt e626',
			'ti-arrow-up' => 'arrow-up e627',
			'ti-arrow-right' => 'arrow-right e628',
			'ti-arrow-left' => 'arrow-left e629',
			'ti-arrow-down' => 'arrow-down e62a',
			'ti-lock' => 'lock e62b',
			'ti-location-arrow' => 'location-arrow e62c',
			'ti-link' => 'link e62d',
			'ti-layout' => 'layout e62e',
			'ti-layers' => 'layers e62f',
			'ti-layers-alt' => 'layers-alt e630',
			'ti-key' => 'key e631',
			'ti-import' => 'import e632',
			'ti-image' => 'image e633',
			'ti-heart' => 'heart e634',
			'ti-heart-broken' => 'heart-broken e635',
			'ti-hand-stop' => 'hand-stop e636',
			'ti-hand-open' => 'hand-open e637',
			'ti-hand-drag' => 'hand-drag e638',
			'ti-folder' => 'folder e639',
			'ti-flag' => 'flag e63a',
			'ti-flag-alt' => 'flag-alt e63b',
			'ti-flag-alt-2' => 'flag-alt-2 e63c',
			'ti-eye' => 'eye e63d',
			'ti-export' => 'export e63e',
			'ti-exchange-vertical' => 'exchange-vertical e63f',
			'ti-desktop' => 'desktop e640',
			'ti-cup' => 'cup e641',
			'ti-crown' => 'crown e642',
			'ti-comments' => 'comments e643',
			'ti-comment' => 'comment e644',
			'ti-comment-alt' => 'comment-alt e645',
			'ti-close' => 'close e646',
			'ti-clip' => 'clip e647',
			'ti-angle-up' => 'angle-up e648',
			'ti-angle-right' => 'angle-right e649',
			'ti-angle-left' => 'angle-left e64a',
			'ti-angle-down' => 'angle-down e64b',
			'ti-check' => 'check e64c',
			'ti-check-box' => 'check-box e64d',
			'ti-camera' => 'camera e64e',
			'ti-announcement' => 'announcement e64f',
			'ti-brush' => 'brush e650',
			'ti-briefcase' => 'briefcase e651',
			'ti-bolt' => 'bolt e652',
			'ti-bolt-alt' => 'bolt-alt e653',
			'ti-blackboard' => 'blackboard e654',
			'ti-bag' => 'bag e655',
			'ti-move' => 'move e656',
			'ti-arrows-vertical' => 'arrows-vertical e657',
			'ti-arrows-horizontal' => 'arrows-horizontal e658',
			'ti-fullscreen' => 'fullscreen e659',
			'ti-arrow-top-right' => 'arrow-top-right e65a',
			'ti-arrow-top-left' => 'arrow-top-left e65b',
			'ti-arrow-circle-up' => 'arrow-circle-up e65c',
			'ti-arrow-circle-right' => 'arrow-circle-right e65d',
			'ti-arrow-circle-left' => 'arrow-circle-left e65e',
			'ti-arrow-circle-down' => 'arrow-circle-down e65f',
			'ti-angle-double-up' => 'angle-double-up e660',
			'ti-angle-double-right' => 'angle-double-right e661',
			'ti-angle-double-left' => 'angle-double-left e662',
			'ti-angle-double-down' => 'angle-double-down e663',
			'ti-zip' => 'zip e664',
			'ti-world' => 'world e665',
			'ti-wheelchair' => 'wheelchair e666',
			'ti-view-list' => 'view-list e667',
			'ti-view-list-alt' => 'view-list-alt e668',
			'ti-view-grid' => 'view-grid e669',
			'ti-uppercase' => 'uppercase e66a',
			'ti-upload' => 'upload e66b',
			'ti-underline' => 'underline e66c',
			'ti-truck' => 'truck e66d',
			'ti-timer' => 'timer e66e',
			'ti-ticket' => 'ticket e66f',
			'ti-thumb-up' => 'thumb-up e670',
			'ti-thumb-down' => 'thumb-down e671',
			'ti-text' => 'text e672',
			'ti-stats-up' => 'stats-up e673',
			'ti-stats-down' => 'stats-down e674',
			'ti-split-v' => 'split-v e675',
			'ti-split-h' => 'split-h e676',
			'ti-smallcap' => 'smallcap e677',
			'ti-shine' => 'shine e678',
			'ti-shift-right' => 'shift-right e679',
			'ti-shift-left' => 'shift-left e67a',
			'ti-shield' => 'shield e67b',
			'ti-notepad' => 'notepad e67c',
			'ti-server' => 'server e67d',
			'ti-quote-right' => 'quote-right e67e',
			'ti-quote-left' => 'quote-left e67f',
			'ti-pulse' => 'pulse e680',
			'ti-printer' => 'printer e681',
			'ti-power-off' => 'power-off e682',
			'ti-plug' => 'plug e683',
			'ti-pie-chart' => 'pie-chart e684',
			'ti-paragraph' => 'paragraph e685',
			'ti-panel' => 'panel e686',
			'ti-package' => 'package e687',
			'ti-music' => 'music e688',
			'ti-music-alt' => 'music-alt e689',
			'ti-mouse' => 'mouse e68a',
			'ti-mouse-alt' => 'mouse-alt e68b',
			'ti-money' => 'money e68c',
			'ti-microphone' => 'microphone e68d',
			'ti-menu' => 'menu e68e',
			'ti-menu-alt' => 'menu-alt e68f',
			'ti-map' => 'map e690',
			'ti-map-alt' => 'map-alt e691',
			'ti-loop' => 'loop e692',
			'ti-location-pin' => 'location-pin e693',
			'ti-list' => 'list e694',
			'ti-light-bulb' => 'light-bulb e695',
			'ti-Italic' => 'Italic e696',
			'ti-info' => 'info e697',
			'ti-infinite' => 'infinite e698',
			'ti-id-badge' => 'id-badge e699',
			'ti-hummer' => 'hummer e69a',
			'ti-home' => 'home e69b',
			'ti-help' => 'help e69c',
			'ti-headphone' => 'headphone e69d',
			'ti-harddrives' => 'harddrives e69e',
			'ti-harddrive' => 'harddrive e69f',
			'ti-gift' => 'gift e6a0',
			'ti-game' => 'game e6a1',
			'ti-filter' => 'filter e6a2',
			'ti-files' => 'files e6a3',
			'ti-file' => 'file e6a4',
			'ti-eraser' => 'eraser e6a5',
			'ti-envelope' => 'envelope e6a6',
			'ti-download' => 'download e6a7',
			'ti-direction' => 'direction e6a8',
			'ti-direction-alt' => 'direction-alt e6a9',
			'ti-dashboard' => 'dashboard e6aa',
			'ti-control-stop' => 'control-stop e6ab',
			'ti-control-shuffle' => 'control-shuffle e6ac',
			'ti-control-play' => 'control-play e6ad',
			'ti-control-pause' => 'control-pause e6ae',
			'ti-control-forward' => 'control-forward e6af',
			'ti-control-backward' => 'control-backward e6b0',
			'ti-cloud' => 'cloud e6b1',
			'ti-cloud-up' => 'cloud-up e6b2',
			'ti-cloud-down' => 'cloud-down e6b3',
			'ti-clipboard' => 'clipboard e6b4',
			'ti-car' => 'car e6b5',
			'ti-calendar' => 'calendar e6b6',
			'ti-book' => 'book e6b7',
			'ti-bell' => 'bell e6b8',
			'ti-basketball' => 'basketball e6b9',
			'ti-bar-chart' => 'bar-chart e6ba',
			'ti-bar-chart-alt' => 'bar-chart-alt e6bb',
			'ti-back-right' => 'back-right e6bc',
			'ti-back-left' => 'back-left e6bd',
			'ti-arrows-corner' => 'arrows-corner e6be',
			'ti-archive' => 'archive e6bf',
			'ti-anchor' => 'anchor e6c0',
			'ti-align-right' => 'align-right e6c1',
			'ti-align-left' => 'align-left e6c2',
			'ti-align-justify' => 'align-justify e6c3',
			'ti-align-center' => 'align-center e6c4',
			'ti-alert' => 'alert e6c5',
			'ti-alarm-clock' => 'alarm-clock e6c6',
			'ti-agenda' => 'agenda e6c7',
			'ti-write' => 'write e6c8',
			'ti-window' => 'window e6c9',
			'ti-widgetized' => 'widgetized e6ca',
			'ti-widget' => 'widget e6cb',
			'ti-widget-alt' => 'widget-alt e6cc',
			'ti-wallet' => 'wallet e6cd',
			'ti-video-clapper' => 'video-clapper e6ce',
			'ti-video-camera' => 'video-camera e6cf',
			'ti-vector' => 'vector e6d0',
			'ti-themify-logo' => 'themify-logo e6d1',
			'ti-themify-favicon' => 'themify-favicon e6d2',
			'ti-themify-favicon-alt' => 'themify-favicon-alt e6d3',
			'ti-support' => 'support e6d4',
			'ti-stamp' => 'stamp e6d5',
			'ti-split-v-alt' => 'split-v-alt e6d6',
			'ti-slice' => 'slice e6d7',
			'ti-shortcode' => 'shortcode e6d8',
			'ti-shift-right-alt' => 'shift-right-alt e6d9',
			'ti-shift-left-alt' => 'shift-left-alt e6da',
			'ti-ruler-alt-2' => 'ruler-alt-2 e6db',
			'ti-receipt' => 'receipt e6dc',
			'ti-pin2' => 'pin2 e6dd',
			'ti-pin-alt' => 'pin-alt e6de',
			'ti-pencil-alt2' => 'pencil-alt2 e6df',
			'ti-palette' => 'palette e6e0',
			'ti-more' => 'more e6e1',
			'ti-more-alt' => 'more-alt e6e2',
			'ti-microphone-alt' => 'microphone-alt e6e3',
			'ti-magnet' => 'magnet e6e4',
			'ti-line-double' => 'line-double e6e5',
			'ti-line-dotted' => 'line-dotted e6e6',
			'ti-line-dashed' => 'line-dashed e6e7',
			'ti-layout-width-full' => 'layout-width-full e6e8',
			'ti-layout-width-default' => 'layout-width-default e6e9',
			'ti-layout-width-default-alt' => 'layout-width-default-alt e6ea',
			'ti-layout-tab' => 'layout-tab e6eb',
			'ti-layout-tab-window' => 'layout-tab-window e6ec',
			'ti-layout-tab-v' => 'layout-tab-v e6ed',
			'ti-layout-tab-min' => 'layout-tab-min e6ee',
			'ti-layout-slider' => 'layout-slider e6ef',
			'ti-layout-slider-alt' => 'layout-slider-alt e6f0',
			'ti-layout-sidebar-right' => 'layout-sidebar-right e6f1',
			'ti-layout-sidebar-none' => 'layout-sidebar-none e6f2',
			'ti-layout-sidebar-left' => 'layout-sidebar-left e6f3',
			'ti-layout-placeholder' => 'layout-placeholder e6f4',
			'ti-layout-menu' => 'layout-menu e6f5',
			'ti-layout-menu-v' => 'layout-menu-v e6f6',
			'ti-layout-menu-separated' => 'layout-menu-separated e6f7',
			'ti-layout-menu-full' => 'layout-menu-full e6f8',
			'ti-layout-media-right-alt' => 'layout-media-right-alt e6f9',
			'ti-layout-media-right' => 'layout-media-right e6fa',
			'ti-layout-media-overlay' => 'layout-media-overlay e6fb',
			'ti-layout-media-overlay-alt' => 'layout-media-overlay-alt e6fc',
			'ti-layout-media-overlay-alt-2' => 'layout-media-overlay-alt-2 e6fd',
			'ti-layout-media-left-alt' => 'layout-media-left-alt e6fe',
			'ti-layout-media-left' => 'layout-media-left e6ff',
			'ti-layout-media-center-alt' => 'layout-media-center-alt e700',
			'ti-layout-media-center' => 'layout-media-center e701',
			'ti-layout-list-thumb' => 'layout-list-thumb e702',
			'ti-layout-list-thumb-alt' => 'layout-list-thumb-alt e703',
			'ti-layout-list-post' => 'layout-list-post e704',
			'ti-layout-list-large-image' => 'layout-list-large-image e705',
			'ti-layout-line-solid' => 'layout-line-solid e706',
			'ti-layout-grid4' => 'layout-grid4 e707',
			'ti-layout-grid3' => 'layout-grid3 e708',
			'ti-layout-grid2' => 'layout-grid2 e709',
			'ti-layout-grid2-thumb' => 'layout-grid2-thumb e70a',
			'ti-layout-cta-right' => 'layout-cta-right e70b',
			'ti-layout-cta-left' => 'layout-cta-left e70c',
			'ti-layout-cta-center' => 'layout-cta-center e70d',
			'ti-layout-cta-btn-right' => 'layout-cta-btn-right e70e',
			'ti-layout-cta-btn-left' => 'layout-cta-btn-left e70f',
			'ti-layout-column4' => 'layout-column4 e710',
			'ti-layout-column3' => 'layout-column3 e711',
			'ti-layout-column2' => 'layout-column2 e712',
			'ti-layout-accordion-separated' => 'layout-accordion-separated e713',
			'ti-layout-accordion-merged' => 'layout-accordion-merged e714',
			'ti-layout-accordion-list' => 'layout-accordion-list e715',
			'ti-ink-pen' => 'ink-pen e716',
			'ti-info-alt' => 'info-alt e717',
			'ti-help-alt' => 'help-alt e718',
			'ti-headphone-alt' => 'headphone-alt e719',
			'ti-hand-point-up' => 'hand-point-up e71a',
			'ti-hand-point-right' => 'hand-point-right e71b',
			'ti-hand-point-left' => 'hand-point-left e71c',
			'ti-hand-point-down' => 'hand-point-down e71d',
			'ti-gallery' => 'gallery e71e',
			'ti-face-smile' => 'face-smile e71f',
			'ti-face-sad' => 'face-sad e720',
			'ti-credit-card' => 'credit-card e721',
			'ti-control-skip-forward' => 'control-skip-forward e722',
			'ti-control-skip-backward' => 'control-skip-backward e723',
			'ti-control-record' => 'control-record e724',
			'ti-control-eject' => 'control-eject e725',
			'ti-comments-smiley' => 'comments-smiley e726',
			'ti-brush-alt' => 'brush-alt e727',
			'ti-youtube' => 'youtube e728',
			'ti-vimeo' => 'vimeo e729',
			'ti-twitter' => 'twitter e72a',
			'ti-time' => 'time e72b',
			'ti-tumblr' => 'tumblr e72c',
			'ti-skype' => 'skype e72d',
			'ti-share' => 'share e72e',
			'ti-share-alt' => 'share-alt e72f',
			'ti-rocket' => 'rocket e730',
			'ti-pinterest' => 'pinterest e731',
			'ti-new-window' => 'new-window e732',
			'ti-microsoft' => 'microsoft e733',
			'ti-list-ol' => 'list-ol e734',
			'ti-linkedin' => 'linkedin e735',
			'ti-layout-sidebar-2' => 'layout-sidebar-2 e736',
			'ti-layout-grid4-alt' => 'layout-grid4-alt e737',
			'ti-layout-grid3-alt' => 'layout-grid3-alt e738',
			'ti-layout-grid2-alt' => 'layout-grid2-alt e739',
			'ti-layout-column4-alt' => 'layout-column4-alt e73a',
			'ti-layout-column3-alt' => 'layout-column3-alt e73b',
			'ti-layout-column2-alt' => 'layout-column2-alt e73c',
			'ti-instagram' => 'instagram e73d',
			'ti-google' => 'google e73e',
			'ti-github' => 'github e73f',
			'ti-flickr' => 'flickr e740',
			'ti-facebook' => 'facebook e741',
			'ti-dropbox' => 'dropbox e742',
			'ti-dribbble' => 'dribbble e743',
			'ti-apple' => 'apple e744',
			'ti-android' => 'android e745',
			'ti-save' => 'save e746',
			'ti-save-alt' => 'save-alt e747',
			'ti-yahoo' => 'yahoo e748',
			'ti-wordpress' => 'wordpress e749',
			'ti-vimeo-alt' => 'vimeo-alt e74a',
			'ti-twitter-alt' => 'twitter-alt e74b',
			'ti-tumblr-alt' => 'tumblr-alt e74c',
			'ti-trello' => 'trello e74d',
			'ti-stack-overflow' => 'stack-overflow e74e',
			'ti-soundcloud' => 'soundcloud e74f',
			'ti-sharethis' => 'sharethis e750',
			'ti-sharethis-alt' => 'sharethis-alt e751',
			'ti-reddit' => 'reddit e752',
			'ti-pinterest-alt' => 'pinterest-alt e753',
			'ti-microsoft-alt' => 'microsoft-alt e754',
			'ti-linux' => 'linux e755',
			'ti-jsfiddle' => 'jsfiddle e756',
			'ti-joomla' => 'joomla e757',
			'ti-html5' => 'html5 e758',
			'ti-flickr-alt' => 'flickr-alt e759',
			'ti-email' => 'email e75a',
			'ti-drupal' => 'drupal e75b',
			'ti-dropbox-alt' => 'dropbox-alt e75c',
			'ti-css3' => 'css3 e75d',
			'ti-rss' => 'rss e75e',
			'ti-rss-alt' => 'rss-alt e75f'
		];
	}

	/**
	 * Get icons control default settings.
	 *
	 * Retrieve the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */
	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
			'include' => '',
			'exclude' => '',
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function content_template() {
		$control_uid = $this->get_control_uid();

		?>
		<div class="elementor-control-field">
			<label for="<?php echo $control_uid; ?>" class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">
				<select id="<?php echo $control_uid; ?>" class="elementor-control-ti-icon" data-setting="{{ data.name }}" data-placeholder="<?php echo __( 'Select Icon', 'miion-core' ); ?>" style="font-family: 'themify';">
					<?php
						$menu_ico = self::get_icons();
						foreach( $menu_ico as $key => $icons ){
							$icon_arr = explode( ' ', $icons );
							$icon_code = $icon_arr[1];
							$icon_name = str_replace( '-', ' ', $icon_arr[0] );
							?>
							<option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_attr( $icon_name .' &#x'. $icon_code .';' ); ?></option>
					<?php
						}
					?>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}
}
