<?php
/**
 * Elementor font awesome icon control.
 *
 */
class Control_FontAwesome_Icon extends \Elementor\Base_Data_Control {

	/**
	 * Get icon control type.
	 *
	 * Retrieve the control type, in this case `icon`.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Control type.
	 */
	public function get_type() {
		return 'fontawesomeicon';
	}
	
	public function enqueue() {
		wp_enqueue_style( 'font-awesome' );
	}

	/**
	 * Get icons.
	 *
	 * Retrieve all the available icons.
	 *
	 * @since 1.0.0
	 * @access public
	 * @static
	 *
	 * @return array Available icons.
	 */
	public static function get_icons() {
		return [
			'fa-glass' => 'glass f000',
			'fa-music' => 'music f001',
			'fa-search' => 'search f002',
			'fa-envelope-o' => 'envelope-o f003',
			'fa-heart' => 'heart f004',
			'fa-star' => 'star f005',
			'fa-star-o' => 'star-o f006',
			'fa-user' => 'user f007',
			'fa-film' => 'film f008',
			'fa-th-large' => 'th-large f009',
			'fa-th' => 'th f00a',
			'fa-th-list' => 'th-list f00b',
			'fa-check' => 'check f00c',
			'fa-times' => 'times f00d',
			'fa-search-plus' => 'search-plus f00e',
			'fa-search-minus' => 'search-minus f010',
			'fa-power-off' => 'power-off f011',
			'fa-signal' => 'signal f012',
			'fa-cog' => 'cog f013',
			'fa-trash-o' => 'trash-o f014',
			'fa-home' => 'home f015',
			'fa-file-o' => 'file-o f016',
			'fa-clock-o' => 'clock-o f017',
			'fa-road' => 'road f018',
			'fa-download' => 'download f019',
			'fa-arrow-circle-o-down' => 'arrow-circle-o-down f01a',
			'fa-arrow-circle-o-up' => 'arrow-circle-o-up f01b',
			'fa-inbox' => 'inbox f01c',
			'fa-play-circle-o' => 'play-circle-o f01d',
			'fa-repeat' => 'repeat f01e',
			'fa-refresh' => 'refresh f021',
			'fa-list-alt' => 'list-alt f022',
			'fa-lock' => 'lock f023',
			'fa-flag' => 'flag f024',
			'fa-headphones' => 'headphones f025',
			'fa-volume-off' => 'volume-off f026',
			'fa-volume-down' => 'volume-down f027',
			'fa-volume-up' => 'volume-up f028',
			'fa-qrcode' => 'qrcode f029',
			'fa-barcode' => 'barcode f02a',
			'fa-tag' => 'tag f02b',
			'fa-tags' => 'tags f02c',
			'fa-book' => 'book f02d',
			'fa-bookmark' => 'bookmark f02e',
			'fa-print' => 'print f02f',
			'fa-camera' => 'camera f030',
			'fa-font' => 'font f031',
			'fa-bold' => 'bold f032',
			'fa-italic' => 'italic f033',
			'fa-text-height' => 'text-height f034',
			'fa-text-width' => 'text-width f035',
			'fa-align-left' => 'align-left f036',
			'fa-align-center' => 'align-center f037',
			'fa-align-right' => 'align-right f038',
			'fa-align-justify' => 'align-justify f039',
			'fa-list' => 'list f03a',
			'fa-outdent' => 'outdent f03b',
			'fa-indent' => 'indent f03c',
			'fa-video-camera' => 'video-camera f03d',
			'fa-picture-o' => 'picture-o f03e',
			'fa-pencil' => 'pencil f040',
			'fa-map-marker' => 'map-marker f041',
			'fa-adjust' => 'adjust f042',
			'fa-tint' => 'tint f043',
			'fa-pencil-square-o' => 'pencil-square-o f044',
			'fa-share-square-o' => 'share-square-o f045',
			'fa-check-square-o' => 'check-square-o f046',
			'fa-arrows' => 'arrows f047',
			'fa-step-backward' => 'step-backward f048',
			'fa-fast-backward' => 'fast-backward f049',
			'fa-backward' => 'backward f04a',
			'fa-play' => 'play f04b',
			'fa-pause' => 'pause f04c',
			'fa-stop' => 'stop f04d',
			'fa-forward' => 'forward f04e',
			'fa-fast-forward' => 'fast-forward f050',
			'fa-step-forward' => 'step-forward f051',
			'fa-eject' => 'eject f052',
			'fa-chevron-left' => 'chevron-left f053',
			'fa-chevron-right' => 'chevron-right f054',
			'fa-plus-circle' => 'plus-circle f055',
			'fa-minus-circle' => 'minus-circle f056',
			'fa-times-circle' => 'times-circle f057',
			'fa-check-circle' => 'check-circle f058',
			'fa-question-circle' => 'question-circle f059',
			'fa-info-circle' => 'info-circle f05a',
			'fa-crosshairs' => 'crosshairs f05b',
			'fa-times-circle-o' => 'times-circle-o f05c',
			'fa-check-circle-o' => 'check-circle-o f05d',
			'fa-ban' => 'ban f05e',
			'fa-arrow-left' => 'arrow-left f060',
			'fa-arrow-right' => 'arrow-right f061',
			'fa-arrow-up' => 'arrow-up f062',
			'fa-arrow-down' => 'arrow-down f063',
			'fa-share' => 'share f064',
			'fa-expand' => 'expand f065',
			'fa-compress' => 'compress f066',
			'fa-plus' => 'plus f067',
			'fa-minus' => 'minus f068',
			'fa-asterisk' => 'asterisk f069',
			'fa-exclamation-circle' => 'exclamation-circle f06a',
			'fa-gift' => 'gift f06b',
			'fa-leaf' => 'leaf f06c',
			'fa-fire' => 'fire f06d',
			'fa-eye' => 'eye f06e',
			'fa-eye-slash' => 'eye-slash f070',
			'fa-exclamation-triangle' => 'exclamation-triangle f071',
			'fa-plane' => 'plane f072',
			'fa-calendar' => 'calendar f073',
			'fa-random' => 'random f074',
			'fa-comment' => 'comment f075',
			'fa-magnet' => 'magnet f076',
			'fa-chevron-up' => 'chevron-up f077',
			'fa-chevron-down' => 'chevron-down f078',
			'fa-retweet' => 'retweet f079',
			'fa-shopping-cart' => 'shopping-cart f07a',
			'fa-folder' => 'folder f07b',
			'fa-folder-open' => 'folder-open f07c',
			'fa-arrows-v' => 'arrows-v f07d',
			'fa-arrows-h' => 'arrows-h f07e',
			'fa-bar-chart' => 'bar-chart f080',
			'fa-twitter-square' => 'twitter-square f081',
			'fa-facebook-square' => 'facebook-square f082',
			'fa-camera-retro' => 'camera-retro f083',
			'fa-key' => 'key f084',
			'fa-cogs' => 'cogs f085',
			'fa-comments' => 'comments f086',
			'fa-thumbs-o-up' => 'thumbs-o-up f087',
			'fa-thumbs-o-down' => 'thumbs-o-down f088',
			'fa-star-half' => 'star-half f089',
			'fa-heart-o' => 'heart-o f08a',
			'fa-sign-out' => 'sign-out f08b',
			'fa-linkedin-square' => 'linkedin-square f08c',
			'fa-thumb-tack' => 'thumb-tack f08d',
			'fa-external-link' => 'external-link f08e',
			'fa-sign-in' => 'sign-in f090',
			'fa-trophy' => 'trophy f091',
			'fa-github-square' => 'github-square f092',
			'fa-upload' => 'upload f093',
			'fa-lemon-o' => 'lemon-o f094',
			'fa-phone' => 'phone f095',
			'fa-square-o' => 'square-o f096',
			'fa-bookmark-o' => 'bookmark-o f097',
			'fa-phone-square' => 'phone-square f098',
			'fa-twitter' => 'twitter f099',
			'fa-facebook' => 'facebook f09a',
			'fa-github' => 'github f09b',
			'fa-unlock' => 'unlock f09c',
			'fa-credit-card' => 'credit-card f09d',
			'fa-rss' => 'rss f09e',
			'fa-hdd-o' => 'hdd-o f0a0',
			'fa-bullhorn' => 'bullhorn f0a1',
			'fa-bell' => 'bell f0f3',
			'fa-certificate' => 'certificate f0a3',
			'fa-hand-o-right' => 'hand-o-right f0a4',
			'fa-hand-o-left' => 'hand-o-left f0a5',
			'fa-hand-o-up' => 'hand-o-up f0a6',
			'fa-hand-o-down' => 'hand-o-down f0a7',
			'fa-arrow-circle-left' => 'arrow-circle-left f0a8',
			'fa-arrow-circle-right' => 'arrow-circle-right f0a9',
			'fa-arrow-circle-up' => 'arrow-circle-up f0aa',
			'fa-arrow-circle-down' => 'arrow-circle-down f0ab',
			'fa-globe' => 'globe f0ac',
			'fa-wrench' => 'wrench f0ad',
			'fa-tasks' => 'tasks f0ae',
			'fa-filter' => 'filter f0b0',
			'fa-briefcase' => 'briefcase f0b1',
			'fa-arrows-alt' => 'arrows-alt f0b2',
			'fa-users' => 'users f0c0',
			'fa-link' => 'link f0c1',
			'fa-cloud' => 'cloud f0c2',
			'fa-flask' => 'flask f0c3',
			'fa-scissors' => 'scissors f0c4',
			'fa-files-o' => 'files-o f0c5',
			'fa-paperclip' => 'paperclip f0c6',
			'fa-floppy-o' => 'floppy-o f0c7',
			'fa-square' => 'square f0c8',
			'fa-bars' => 'bars f0c9',
			'fa-list-ul' => 'list-ul f0ca',
			'fa-list-ol' => 'list-ol f0cb',
			'fa-strikethrough' => 'strikethrough f0cc',
			'fa-underline' => 'underline f0cd',
			'fa-table' => 'table f0ce',
			'fa-magic' => 'magic f0d0',
			'fa-truck' => 'truck f0d1',
			'fa-pinterest' => 'pinterest f0d2',
			'fa-pinterest-square' => 'pinterest-square f0d3',
			'fa-google-plus-square' => 'google-plus-square f0d4',
			'fa-google-plus' => 'google-plus f0d5',
			'fa-money' => 'money f0d6',
			'fa-caret-down' => 'caret-down f0d7',
			'fa-caret-up' => 'caret-up f0d8',
			'fa-caret-left' => 'caret-left f0d9',
			'fa-caret-right' => 'caret-right f0da',
			'fa-columns' => 'columns f0db',
			'fa-sort' => 'sort f0dc',
			'fa-sort-desc' => 'sort-desc f0dd',
			'fa-sort-asc' => 'sort-asc f0de',
			'fa-envelope' => 'envelope f0e0',
			'fa-linkedin' => 'linkedin f0e1',
			'fa-undo' => 'undo f0e2',
			'fa-gavel' => 'gavel f0e3',
			'fa-tachometer' => 'tachometer f0e4',
			'fa-comment-o' => 'comment-o f0e5',
			'fa-comments-o' => 'comments-o f0e6',
			'fa-bolt' => 'bolt f0e7',
			'fa-sitemap' => 'sitemap f0e8',
			'fa-umbrella' => 'umbrella f0e9',
			'fa-clipboard' => 'clipboard f0ea',
			'fa-lightbulb-o' => 'lightbulb-o f0eb',
			'fa-exchange' => 'exchange f0ec',
			'fa-cloud-download' => 'cloud-download f0ed',
			'fa-cloud-upload' => 'cloud-upload f0ee',
			'fa-user-md' => 'user-md f0f0',
			'fa-stethoscope' => 'stethoscope f0f1',
			'fa-suitcase' => 'suitcase f0f2',
			'fa-bell-o' => 'bell-o f0a2',
			'fa-coffee' => 'coffee f0f4',
			'fa-cutlery' => 'cutlery f0f5',
			'fa-file-text-o' => 'file-text-o f0f6',
			'fa-building-o' => 'building-o f0f7',
			'fa-hospital-o' => 'hospital-o f0f8',
			'fa-ambulance' => 'ambulance f0f9',
			'fa-medkit' => 'medkit f0fa',
			'fa-fighter-jet' => 'fighter-jet f0fb',
			'fa-beer' => 'beer f0fc',
			'fa-h-square' => 'h-square f0fd',
			'fa-plus-square' => 'plus-square f0fe',
			'fa-angle-double-left' => 'angle-double-left f100',
			'fa-angle-double-right' => 'angle-double-right f101',
			'fa-angle-double-up' => 'angle-double-up f102',
			'fa-angle-double-down' => 'angle-double-down f103',
			'fa-angle-left' => 'angle-left f104',
			'fa-angle-right' => 'angle-right f105',
			'fa-angle-up' => 'angle-up f106',
			'fa-angle-down' => 'angle-down f107',
			'fa-desktop' => 'desktop f108',
			'fa-laptop' => 'laptop f109',
			'fa-tablet' => 'tablet f10a',
			'fa-mobile' => 'mobile f10b',
			'fa-circle-o' => 'circle-o f10c',
			'fa-quote-left' => 'quote-left f10d',
			'fa-quote-right' => 'quote-right f10e',
			'fa-spinner' => 'spinner f110',
			'fa-circle' => 'circle f111',
			'fa-reply' => 'reply f112',
			'fa-github-alt' => 'github-alt f113',
			'fa-folder-o' => 'folder-o f114',
			'fa-folder-open-o' => 'folder-open-o f115',
			'fa-smile-o' => 'smile-o f118',
			'fa-frown-o' => 'frown-o f119',
			'fa-meh-o' => 'meh-o f11a',
			'fa-gamepad' => 'gamepad f11b',
			'fa-keyboard-o' => 'keyboard-o f11c',
			'fa-flag-o' => 'flag-o f11d',
			'fa-flag-checkered' => 'flag-checkered f11e',
			'fa-terminal' => 'terminal f120',
			'fa-code' => 'code f121',
			'fa-reply-all' => 'reply-all f122',
			'fa-star-half-o' => 'star-half-o f123',
			'fa-location-arrow' => 'location-arrow f124',
			'fa-crop' => 'crop f125',
			'fa-code-fork' => 'code-fork f126',
			'fa-chain-broken' => 'chain-broken f127',
			'fa-question' => 'question f128',
			'fa-info' => 'info f129',
			'fa-exclamation' => 'exclamation f12a',
			'fa-superscript' => 'superscript f12b',
			'fa-subscript' => 'subscript f12c',
			'fa-eraser' => 'eraser f12d',
			'fa-puzzle-piece' => 'puzzle-piece f12e',
			'fa-microphone' => 'microphone f130',
			'fa-microphone-slash' => 'microphone-slash f131',
			'fa-shield' => 'shield f132',
			'fa-calendar-o' => 'calendar-o f133',
			'fa-fire-extinguisher' => 'fire-extinguisher f134',
			'fa-rocket' => 'rocket f135',
			'fa-maxcdn' => 'maxcdn f136',
			'fa-chevron-circle-left' => 'chevron-circle-left f137',
			'fa-chevron-circle-right' => 'chevron-circle-right f138',
			'fa-chevron-circle-up' => 'chevron-circle-up f139',
			'fa-chevron-circle-down' => 'chevron-circle-down f13a',
			'fa-html5' => 'html5 f13b',
			'fa-css3' => 'css3 f13c',
			'fa-anchor' => 'anchor f13d',
			'fa-unlock-alt' => 'unlock-alt f13e',
			'fa-bullseye' => 'bullseye f140',
			'fa-ellipsis-h' => 'ellipsis-h f141',
			'fa-ellipsis-v' => 'ellipsis-v f142',
			'fa-rss-square' => 'rss-square f143',
			'fa-play-circle' => 'play-circle f144',
			'fa-ticket' => 'ticket f145',
			'fa-minus-square' => 'minus-square f146',
			'fa-minus-square-o' => 'minus-square-o f147',
			'fa-level-up' => 'level-up f148',
			'fa-level-down' => 'level-down f149',
			'fa-check-square' => 'check-square f14a',
			'fa-pencil-square' => 'pencil-square f14b',
			'fa-external-link-square' => 'external-link-square f14c',
			'fa-share-square' => 'share-square f14d',
			'fa-compass' => 'compass f14e',
			'fa-caret-square-o-down' => 'caret-square-o-down f150',
			'fa-caret-square-o-up' => 'caret-square-o-up f151',
			'fa-caret-square-o-right' => 'caret-square-o-right f152',
			'fa-eur' => 'eur f153',
			'fa-gbp' => 'gbp f154',
			'fa-usd' => 'usd f155',
			'fa-inr' => 'inr f156',
			'fa-jpy' => 'jpy f157',
			'fa-rub' => 'rub f158',
			'fa-krw' => 'krw f159',
			'fa-btc' => 'btc f15a',
			'fa-file' => 'file f15b',
			'fa-file-text' => 'file-text f15c',
			'fa-sort-alpha-asc' => 'sort-alpha-asc f15d',
			'fa-sort-alpha-desc' => 'sort-alpha-desc f15e',
			'fa-sort-amount-asc' => 'sort-amount-asc f160',
			'fa-sort-amount-desc' => 'sort-amount-desc f161',
			'fa-sort-numeric-asc' => 'sort-numeric-asc f162',
			'fa-sort-numeric-desc' => 'sort-numeric-desc f163',
			'fa-thumbs-up' => 'thumbs-up f164',
			'fa-thumbs-down' => 'thumbs-down f165',
			'fa-youtube-square' => 'youtube-square f166',
			'fa-youtube' => 'youtube f167',
			'fa-xing' => 'xing f168',
			'fa-xing-square' => 'xing-square f169',
			'fa-youtube-play' => 'youtube-play f16a',
			'fa-dropbox' => 'dropbox f16b',
			'fa-stack-overflow' => 'stack-overflow f16c',
			'fa-instagram' => 'instagram f16d',
			'fa-flickr' => 'flickr f16e',
			'fa-adn' => 'adn f170',
			'fa-bitbucket' => 'bitbucket f171',
			'fa-bitbucket-square' => 'bitbucket-square f172',
			'fa-tumblr' => 'tumblr f173',
			'fa-tumblr-square' => 'tumblr-square f174',
			'fa-long-arrow-down' => 'long-arrow-down f175',
			'fa-long-arrow-up' => 'long-arrow-up f176',
			'fa-long-arrow-left' => 'long-arrow-left f177',
			'fa-long-arrow-right' => 'long-arrow-right f178',
			'fa-apple' => 'apple f179',
			'fa-windows' => 'windows f17a',
			'fa-android' => 'android f17b',
			'fa-linux' => 'linux f17c',
			'fa-dribbble' => 'dribbble f17d',
			'fa-skype' => 'skype f17e',
			'fa-foursquare' => 'foursquare f180',
			'fa-trello' => 'trello f181',
			'fa-female' => 'female f182',
			'fa-male' => 'male f183',
			'fa-gratipay' => 'gratipay f184',
			'fa-sun-o' => 'sun-o f185',
			'fa-moon-o' => 'moon-o f186',
			'fa-archive' => 'archive f187',
			'fa-bug' => 'bug f188',
			'fa-vk' => 'vk f189',
			'fa-weibo' => 'weibo f18a',
			'fa-renren' => 'renren f18b',
			'fa-pagelines' => 'pagelines f18c',
			'fa-stack-exchange' => 'stack-exchange f18d',
			'fa-arrow-circle-o-right' => 'arrow-circle-o-right f18e',
			'fa-arrow-circle-o-left' => 'arrow-circle-o-left f190',
			'fa-caret-square-o-left' => 'caret-square-o-left f191',
			'fa-dot-circle-o' => 'dot-circle-o f192',
			'fa-wheelchair' => 'wheelchair f193',
			'fa-vimeo-square' => 'vimeo-square f194',
			'fa-try' => 'try f195',
			'fa-plus-square-o' => 'plus-square-o f196',
			'fa-space-shuttle' => 'space-shuttle f197',
			'fa-slack' => 'slack f198',
			'fa-envelope-square' => 'envelope-square f199',
			'fa-wordpress' => 'wordpress f19a',
			'fa-openid' => 'openid f19b',
			'fa-university' => 'university f19c',
			'fa-graduation-cap' => 'graduation-cap f19d',
			'fa-yahoo' => 'yahoo f19e',
			'fa-google' => 'google f1a0',
			'fa-reddit' => 'reddit f1a1',
			'fa-reddit-square' => 'reddit-square f1a2',
			'fa-stumbleupon-circle' => 'stumbleupon-circle f1a3',
			'fa-stumbleupon' => 'stumbleupon f1a4',
			'fa-delicious' => 'delicious f1a5',
			'fa-digg' => 'digg f1a6',
			'fa-pied-piper-pp' => 'pied-piper-pp f1a7',
			'fa-pied-piper-alt' => 'pied-piper-alt f1a8',
			'fa-drupal' => 'drupal f1a9',
			'fa-joomla' => 'joomla f1aa',
			'fa-language' => 'language f1ab',
			'fa-fax' => 'fax f1ac',
			'fa-building' => 'building f1ad',
			'fa-child' => 'child f1ae',
			'fa-paw' => 'paw f1b0',
			'fa-spoon' => 'spoon f1b1',
			'fa-cube' => 'cube f1b2',
			'fa-cubes' => 'cubes f1b3',
			'fa-behance' => 'behance f1b4',
			'fa-behance-square' => 'behance-square f1b5',
			'fa-steam' => 'steam f1b6',
			'fa-steam-square' => 'steam-square f1b7',
			'fa-recycle' => 'recycle f1b8',
			'fa-car' => 'car f1b9',
			'fa-taxi' => 'taxi f1ba',
			'fa-tree' => 'tree f1bb',
			'fa-spotify' => 'spotify f1bc',
			'fa-deviantart' => 'deviantart f1bd',
			'fa-soundcloud' => 'soundcloud f1be',
			'fa-database' => 'database f1c0',
			'fa-file-pdf-o' => 'file-pdf-o f1c1',
			'fa-file-word-o' => 'file-word-o f1c2',
			'fa-file-excel-o' => 'file-excel-o f1c3',
			'fa-file-powerpoint-o' => 'file-powerpoint-o f1c4',
			'fa-file-image-o' => 'file-image-o f1c5',
			'fa-file-archive-o' => 'file-archive-o f1c6',
			'fa-file-audio-o' => 'file-audio-o f1c7',
			'fa-file-video-o' => 'file-video-o f1c8',
			'fa-file-code-o' => 'file-code-o f1c9',
			'fa-vine' => 'vine f1ca',
			'fa-codepen' => 'codepen f1cb',
			'fa-jsfiddle' => 'jsfiddle f1cc',
			'fa-life-ring' => 'life-ring f1cd',
			'fa-circle-o-notch' => 'circle-o-notch f1ce',
			'fa-rebel' => 'rebel f1d0',
			'fa-empire' => 'empire f1d1',
			'fa-git-square' => 'git-square f1d2',
			'fa-git' => 'git f1d3',
			'fa-hacker-news' => 'hacker-news f1d4',
			'fa-tencent-weibo' => 'tencent-weibo f1d5',
			'fa-qq' => 'qq f1d6',
			'fa-weixin' => 'weixin f1d7',
			'fa-paper-plane' => 'paper-plane f1d8',
			'fa-paper-plane-o' => 'paper-plane-o f1d9',
			'fa-history' => 'history f1da',
			'fa-circle-thin' => 'circle-thin f1db',
			'fa-header' => 'header f1dc',
			'fa-paragraph' => 'paragraph f1dd',
			'fa-sliders' => 'sliders f1de',
			'fa-share-alt' => 'share-alt f1e0',
			'fa-share-alt-square' => 'share-alt-square f1e1',
			'fa-bomb' => 'bomb f1e2',
			'fa-futbol-o' => 'futbol-o f1e3',
			'fa-tty' => 'tty f1e4',
			'fa-binoculars' => 'binoculars f1e5',
			'fa-plug' => 'plug f1e6',
			'fa-slideshare' => 'slideshare f1e7',
			'fa-twitch' => 'twitch f1e8',
			'fa-yelp' => 'yelp f1e9',
			'fa-newspaper-o' => 'newspaper-o f1ea',
			'fa-wifi' => 'wifi f1eb',
			'fa-calculator' => 'calculator f1ec',
			'fa-paypal' => 'paypal f1ed',
			'fa-google-wallet' => 'google-wallet f1ee',
			'fa-cc-visa' => 'cc-visa f1f0',
			'fa-cc-mastercard' => 'cc-mastercard f1f1',
			'fa-cc-discover' => 'cc-discover f1f2',
			'fa-cc-amex' => 'cc-amex f1f3',
			'fa-cc-paypal' => 'cc-paypal f1f4',
			'fa-cc-stripe' => 'cc-stripe f1f5',
			'fa-bell-slash' => 'bell-slash f1f6',
			'fa-bell-slash-o' => 'bell-slash-o f1f7',
			'fa-trash' => 'trash f1f8',
			'fa-copyright' => 'copyright f1f9',
			'fa-at' => 'at f1fa',
			'fa-eyedropper' => 'eyedropper f1fb',
			'fa-paint-brush' => 'paint-brush f1fc',
			'fa-birthday-cake' => 'birthday-cake f1fd',
			'fa-area-chart' => 'area-chart f1fe',
			'fa-pie-chart' => 'pie-chart f200',
			'fa-line-chart' => 'line-chart f201',
			'fa-lastfm' => 'lastfm f202',
			'fa-lastfm-square' => 'lastfm-square f203',
			'fa-toggle-off' => 'toggle-off f204',
			'fa-toggle-on' => 'toggle-on f205',
			'fa-bicycle' => 'bicycle f206',
			'fa-bus' => 'bus f207',
			'fa-ioxhost' => 'ioxhost f208',
			'fa-angellist' => 'angellist f209',
			'fa-cc' => 'cc f20a',
			'fa-ils' => 'ils f20b',
			'fa-meanpath' => 'meanpath f20c',
			'fa-buysellads' => 'buysellads f20d',
			'fa-connectdevelop' => 'connectdevelop f20e',
			'fa-dashcube' => 'dashcube f210',
			'fa-forumbee' => 'forumbee f211',
			'fa-leanpub' => 'leanpub f212',
			'fa-sellsy' => 'sellsy f213',
			'fa-shirtsinbulk' => 'shirtsinbulk f214',
			'fa-simplybuilt' => 'simplybuilt f215',
			'fa-skyatlas' => 'skyatlas f216',
			'fa-cart-plus' => 'cart-plus f217',
			'fa-cart-arrow-down' => 'cart-arrow-down f218',
			'fa-diamond' => 'diamond f219',
			'fa-ship' => 'ship f21a',
			'fa-user-secret' => 'user-secret f21b',
			'fa-motorcycle' => 'motorcycle f21c',
			'fa-street-view' => 'street-view f21d',
			'fa-heartbeat' => 'heartbeat f21e',
			'fa-venus' => 'venus f221',
			'fa-mars' => 'mars f222',
			'fa-mercury' => 'mercury f223',
			'fa-transgender' => 'transgender f224',
			'fa-transgender-alt' => 'transgender-alt f225',
			'fa-venus-double' => 'venus-double f226',
			'fa-mars-double' => 'mars-double f227',
			'fa-venus-mars' => 'venus-mars f228',
			'fa-mars-stroke' => 'mars-stroke f229',
			'fa-mars-stroke-v' => 'mars-stroke-v f22a',
			'fa-mars-stroke-h' => 'mars-stroke-h f22b',
			'fa-neuter' => 'neuter f22c',
			'fa-genderless' => 'genderless f22d',
			'fa-facebook-official' => 'facebook-official f230',
			'fa-pinterest-p' => 'pinterest-p f231',
			'fa-whatsapp' => 'whatsapp f232',
			'fa-server' => 'server f233',
			'fa-user-plus' => 'user-plus f234',
			'fa-user-times' => 'user-times f235',
			'fa-bed' => 'bed f236',
			'fa-viacoin' => 'viacoin f237',
			'fa-train' => 'train f238',
			'fa-subway' => 'subway f239',
			'fa-medium' => 'medium f23a',
			'fa-y-combinator' => 'y-combinator f23b',
			'fa-optin-monster' => 'optin-monster f23c',
			'fa-opencart' => 'opencart f23d',
			'fa-expeditedssl' => 'expeditedssl f23e',
			'fa-battery-full' => 'battery-full f240',
			'fa-battery-three-quarters' => 'battery-three-quarters f241',
			'fa-battery-half' => 'battery-half f242',
			'fa-battery-quarter' => 'battery-quarter f243',
			'fa-battery-empty' => 'battery-empty f244',
			'fa-mouse-pointer' => 'mouse-pointer f245',
			'fa-i-cursor' => 'i-cursor f246',
			'fa-object-group' => 'object-group f247',
			'fa-object-ungroup' => 'object-ungroup f248',
			'fa-sticky-note' => 'sticky-note f249',
			'fa-sticky-note-o' => 'sticky-note-o f24a',
			'fa-cc-jcb' => 'cc-jcb f24b',
			'fa-cc-diners-club' => 'cc-diners-club f24c',
			'fa-clone' => 'clone f24d',
			'fa-balance-scale' => 'balance-scale f24e',
			'fa-hourglass-o' => 'hourglass-o f250',
			'fa-hourglass-start' => 'hourglass-start f251',
			'fa-hourglass-half' => 'hourglass-half f252',
			'fa-hourglass-end' => 'hourglass-end f253',
			'fa-hourglass' => 'hourglass f254',
			'fa-hand-rock-o' => 'hand-rock-o f255',
			'fa-hand-paper-o' => 'hand-paper-o f256',
			'fa-hand-scissors-o' => 'hand-scissors-o f257',
			'fa-hand-lizard-o' => 'hand-lizard-o f258',
			'fa-hand-spock-o' => 'hand-spock-o f259',
			'fa-hand-pointer-o' => 'hand-pointer-o f25a',
			'fa-hand-peace-o' => 'hand-peace-o f25b',
			'fa-trademark' => 'trademark f25c',
			'fa-registered' => 'registered f25d',
			'fa-creative-commons' => 'creative-commons f25e',
			'fa-gg' => 'gg f260',
			'fa-gg-circle' => 'gg-circle f261',
			'fa-tripadvisor' => 'tripadvisor f262',
			'fa-odnoklassniki' => 'odnoklassniki f263',
			'fa-odnoklassniki-square' => 'odnoklassniki-square f264',
			'fa-get-pocket' => 'get-pocket f265',
			'fa-wikipedia-w' => 'wikipedia-w f266',
			'fa-safari' => 'safari f267',
			'fa-chrome' => 'chrome f268',
			'fa-firefox' => 'firefox f269',
			'fa-opera' => 'opera f26a',
			'fa-internet-explorer' => 'internet-explorer f26b',
			'fa-television' => 'television f26c',
			'fa-contao' => 'contao f26d',
			'fa-500px' => '500px f26e',
			'fa-amazon' => 'amazon f270',
			'fa-calendar-plus-o' => 'calendar-plus-o f271',
			'fa-calendar-minus-o' => 'calendar-minus-o f272',
			'fa-calendar-times-o' => 'calendar-times-o f273',
			'fa-calendar-check-o' => 'calendar-check-o f274',
			'fa-industry' => 'industry f275',
			'fa-map-pin' => 'map-pin f276',
			'fa-map-signs' => 'map-signs f277',
			'fa-map-o' => 'map-o f278',
			'fa-map' => 'map f279',
			'fa-commenting' => 'commenting f27a',
			'fa-commenting-o' => 'commenting-o f27b',
			'fa-houzz' => 'houzz f27c',
			'fa-vimeo' => 'vimeo f27d',
			'fa-black-tie' => 'black-tie f27e',
			'fa-fonticons' => 'fonticons f280',
			'fa-reddit-alien' => 'reddit-alien f281',
			'fa-edge' => 'edge f282',
			'fa-credit-card-alt' => 'credit-card-alt f283',
			'fa-codiepie' => 'codiepie f284',
			'fa-modx' => 'modx f285',
			'fa-fort-awesome' => 'fort-awesome f286',
			'fa-usb' => 'usb f287',
			'fa-product-hunt' => 'product-hunt f288',
			'fa-mixcloud' => 'mixcloud f289',
			'fa-scribd' => 'scribd f28a',
			'fa-pause-circle' => 'pause-circle f28b',
			'fa-pause-circle-o' => 'pause-circle-o f28c',
			'fa-stop-circle' => 'stop-circle f28d',
			'fa-stop-circle-o' => 'stop-circle-o f28e',
			'fa-shopping-bag' => 'shopping-bag f290',
			'fa-shopping-basket' => 'shopping-basket f291',
			'fa-hashtag' => 'hashtag f292',
			'fa-bluetooth' => 'bluetooth f293',
			'fa-bluetooth-b' => 'bluetooth-b f294',
			'fa-percent' => 'percent f295',
			'fa-gitlab' => 'gitlab f296',
			'fa-wpbeginner' => 'wpbeginner f297',
			'fa-wpforms' => 'wpforms f298',
			'fa-envira' => 'envira f299',
			'fa-universal-access' => 'universal-access f29a',
			'fa-wheelchair-alt' => 'wheelchair-alt f29b',
			'fa-question-circle-o' => 'question-circle-o f29c',
			'fa-blind' => 'blind f29d',
			'fa-audio-description' => 'audio-description f29e',
			'fa-volume-control-phone' => 'volume-control-phone f2a0',
			'fa-braille' => 'braille f2a1',
			'fa-assistive-listening-systems' => 'assistive-listening-systems f2a2',
			'fa-american-sign-language-interpreting' => 'american-sign-language-interpreting f2a3',
			'fa-deaf' => 'deaf f2a4',
			'fa-glide' => 'glide f2a5',
			'fa-glide-g' => 'glide-g f2a6',
			'fa-sign-language' => 'sign-language f2a7',
			'fa-low-vision' => 'low-vision f2a8',
			'fa-viadeo' => 'viadeo f2a9',
			'fa-viadeo-square' => 'viadeo-square f2aa',
			'fa-snapchat' => 'snapchat f2ab',
			'fa-snapchat-ghost' => 'snapchat-ghost f2ac',
			'fa-snapchat-square' => 'snapchat-square f2ad',
			'fa-pied-piper' => 'pied-piper f2ae',
			'fa-first-order' => 'first-order f2b0',
			'fa-yoast' => 'yoast f2b1',
			'fa-themeisle' => 'themeisle f2b2',
			'fa-google-plus-official' => 'google-plus-official f2b3',
			'fa-font-awesome' => 'font-awesome f2b4',
			'fa-handshake-o' => 'handshake-o f2b5',
			'fa-envelope-open' => 'envelope-open f2b6',
			'fa-envelope-open-o' => 'envelope-open-o f2b7',
			'fa-linode' => 'linode f2b8',
			'fa-address-book' => 'address-book f2b9',
			'fa-address-book-o' => 'address-book-o f2ba',
			'fa-address-card' => 'address-card f2bb',
			'fa-address-card-o' => 'address-card-o f2bc',
			'fa-user-circle' => 'user-circle f2bd',
			'fa-user-circle-o' => 'user-circle-o f2be',
			'fa-user-o' => 'user-o f2c0',
			'fa-id-badge' => 'id-badge f2c1',
			'fa-id-card' => 'id-card f2c2',
			'fa-id-card-o' => 'id-card-o f2c3',
			'fa-quora' => 'quora f2c4',
			'fa-free-code-camp' => 'free-code-camp f2c5',
			'fa-telegram' => 'telegram f2c6',
			'fa-thermometer-full' => 'thermometer-full f2c7',
			'fa-thermometer-three-quarters' => 'thermometer-three-quarters f2c8',
			'fa-thermometer-half' => 'thermometer-half f2c9',
			'fa-thermometer-quarter' => 'thermometer-quarter f2ca',
			'fa-thermometer-empty' => 'thermometer-empty f2cb',
			'fa-shower' => 'shower f2cc',
			'fa-bath' => 'bath f2cd',
			'fa-podcast' => 'podcast f2ce',
			'fa-window-maximize' => 'window-maximize f2d0',
			'fa-window-minimize' => 'window-minimize f2d1',
			'fa-window-restore' => 'window-restore f2d2',
			'fa-window-close' => 'window-close f2d3',
			'fa-window-close-o' => 'window-close-o f2d4',
			'fa-bandcamp' => 'bandcamp f2d5',
			'fa-grav' => 'grav f2d6',
			'fa-etsy' => 'etsy f2d7',
			'fa-imdb' => 'imdb f2d8',
			'fa-ravelry' => 'ravelry f2d9',
			'fa-eercast' => 'eercast f2da',
			'fa-microchip' => 'microchip f2db',
			'fa-snowflake-o' => 'snowflake-o f2dc',
			'fa-superpowers' => 'superpowers f2dd',
			'fa-wpexplorer' => 'wpexplorer f2de',
			'fa-meetup' => 'meetup f2e0'
		];
	}

	/**
	 * Get icons control default settings.
	 *
	 * Retrieve the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */
	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
			'include' => '',
			'exclude' => '',
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function content_template() {
		$control_uid = $this->get_control_uid();
		wp_enqueue_style( 'font-awesome' );
		?>
		<div class="elementor-control-field">
			<label for="<?php echo $control_uid; ?>" class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">
				<select id="<?php echo $control_uid; ?>" class="elementor-control-fa-icon" data-setting="{{ data.name }}" data-placeholder="<?php echo __( 'Select Icon', 'miion-core' ); ?>" style="font-family: 'FontAwesome';">
					<?php
						$menu_ico = self::get_icons();
						foreach( $menu_ico as $key => $icons ){
							$icon_arr = explode( ' ', $icons );
							$icon_code = $icon_arr[1];
							$icon_name = str_replace( '-', ' ', $icon_arr[0] );
							?>
							<option value="fa <?php echo esc_attr( $key ); ?>"><?php echo esc_attr( $icon_name .' &#x'. $icon_code .';' ); ?></option>
					<?php
						}
					?>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}
}
