<?php 
add_action( 'admin_menu', 'miion_admin_menu' );
function miion_admin_menu() {
	add_submenu_page(
		'miion',
		esc_html__( 'Elementor Settings', 'miion' ),
		esc_html__( 'Elementor Settings', 'miion' ),
		'administrator',
		'miion-addons',
		'classic_elementor_addon_admin_page'
	);
}

function change_admin_menu_name(){
	global $submenu;
	if(isset($submenu['miion-addons'])){
		$submenu['miion-addons'][0][0] = esc_html__( 'Widgets Settings', 'miion-core' );
	}
}
add_action( 'admin_menu', 'change_admin_menu_name');    

function classic_elementor_addon_admin_page(){
	?>
	<div class="miion-admin-wrap">
		<h1><?php esc_html_e( 'Miion Elementor Addons', 'miion-core' ); ?></h1>
		<p class="pa-title-sub"><?php esc_html_e( 'Thank you for using Miion Elementor Addons for Elementor. This plugin has been developed by ', 'miion-core' ); ?><strong><?php echo esc_html( 'zozothemes' ); ?></strong></p>
		
		<?php
			$shortcode_stat = array(
				'animated-text' 	=> esc_html__( 'Animated Text', 'miion-core' ),
				'circle-progress'	=> esc_html__( 'Circle Progress', 'miion-core' ),
				'contact-form' 		=> esc_html__( 'Contact Form', 'miion-core' ),
				'contact-info' 		=> esc_html__( 'Contact Info', 'miion-core' ),
				'content-carousel' 	=> esc_html__( 'Content Carousel', 'miion-core' ),
				'counter' 			=> esc_html__( 'Counter', 'miion-core' ),
				'day-counter' 		=> esc_html__( 'Day Counter', 'miion-core' ),
				'feature-box' 		=> esc_html__( 'Feature Box', 'miion-core' ),
				'flip-box' 			=> esc_html__( 'Flip Box', 'miion-core' ),
				'google-map' 		=> esc_html__( 'Google Map', 'miion-core' ),
				'icon' 				=> esc_html__( 'Icon', 'miion-core' ),
				'icon-list' 		=> esc_html__( 'Icon List', 'miion-core' ),
				'image-grid' 		=> esc_html__( 'Image Grid', 'miion-core' ),
				'modal-popup' 		=> esc_html__( 'Modal Popup', 'miion-core' ),
				'pricing-table' 	=> esc_html__( 'Pricing Table', 'miion-core' ),
				'section-title' 	=> esc_html__( 'Section Title', 'miion-core' ),
				'social-links' 		=> esc_html__( 'Social Links', 'miion-core' ),
				'timeline' 			=> esc_html__( 'Timeline', 'miion-core' ),
				'timeline-slide' 	=> esc_html__( 'Timeline Slide', 'miion-core' ),
				'chart' 			=> esc_html__( 'Chart', 'miion-core' ),
				'recent-popular' 	=> esc_html__( 'Recent/Popular Post', 'miion-core' ),
				'blog' 				=> esc_html__( 'Blog', 'miion-core' ),
				'portfolio' 		=> esc_html__( 'Portfolio', 'miion-core' ),
				'team' 				=> esc_html__( 'Team', 'miion-core' ),
				'event' 			=> esc_html__( 'Event', 'miion-core' ),
				'service' 			=> esc_html__( 'Service', 'miion-core' ),
				'testimonial' 		=> esc_html__( 'Testimonial', 'miion-core' ),
				'toggle-content' 	=> esc_html__( 'Toggle Content', 'miion-core' ),
				'mailchimp' 		=> esc_html__( 'Mailchimp', 'miion-core' ),
				'popup-anything' 	=> esc_html__( 'Popup Anything', 'miion-core' ),
				'popover' 			=> esc_html__( 'Popover', 'miion-core' ),
				'round-tab' 		=> esc_html__( 'Round Tab', 'miion-core' )
			);
			
			if ( isset( $_POST['save_miion_shortcodes_options'] ) && wp_verify_nonce( $_POST['save_miion_shortcodes_options'], 'miion_plugin_shortcodes_options' ) ) {
				update_option( 'miion_shortcodes', $_POST['miion_shortcodes'] );
			}
			$miion_shortcodes = get_option('miion_shortcodes');
			
		?>
		
		<div class="miion-admin-content-wrap">
			<form method="post" action="#" enctype="multipart/form-data" id="miion-plugin-form-wrapper">
				<?php wp_nonce_field( 'miion_plugin_shortcodes_options', 'save_miion_shortcodes_options' ); ?>
				<input class="miion-plugin-submit button button-primary" type="submit" value="<?php echo esc_attr__( 'Save', 'miion-core' ); ?>" />
				<div class="miion-shortcodes-container">
			<?php
				$row = 1;
				foreach( $shortcode_stat as $key => $value ){
				
					$shortcode_name = str_replace( "-", "_", $key );
					if( !empty( $miion_shortcodes ) ){
						if( isset( $miion_shortcodes[$shortcode_name] ) ){
							$saved_val = 'on';
						}else{
							$saved_val = 'off';
						}
					}else{
						$saved_val = 'on';
					}
					$checked_stat = $saved_val == 'on' ? 'checked="checked"' : '';
				
					if( $row % 4 == 1 ) echo '<div class="miion-row">';
					
						echo '
						<div class="miion-col-3">
							<div class="element-group">
								<h4>'. esc_html( $value ) .'</h4>
								<label class="switch">
									<input class="switch-checkbox" type="checkbox" name="miion_shortcodes['. esc_attr( $shortcode_name ) .']" '. $checked_stat .'>
									<span class="slider round"></span>
								</label>
							</div><!-- .element-group -->
						</div><!-- .miion-col-2 -->';
									
					if( $row % 4 == 0 ) echo '</div><!-- .miion-row -->';
					$row++;
				}
				
				if( $row % 4 != 1 ) echo '</div><!-- .miion-row unexpceted close -->';
			?>
				</div> <!-- .miion-shortcodes-container -->
			</form>
		</div><!-- .miion-admin-content-wrap -->
		
		<div class="miion-customizer-options-wrap">
			<h2><?php esc_html_e( 'Enable/Disable Customizer Auto Refresh Option', 'miion-core' ); ?></h2>
			<?php 
				$customizer_auto_load = get_option( 'miion_customizer_auto_load' );;
				$checked_stat = $customizer_auto_load == '1' ? 'checked="checked"' : '';
			?>
			<div class="miion-customizer-option">
				<label class="switch">
					<input class="switch-checkbox" type="checkbox" <?php echo ''. $checked_stat ?>>
					<span class="slider round"></span>
				</label>
			</div>
			<p><?php esc_html_e( 'If you want to live editor experience, Just turn on this option. No need to auto load customizer editor for every option change means turn off this option.' ); ?></p>
		</div><!-- .miion-customizer-options-wrap -->
		
	</div><!-- .miion-admin-wrap -->
	<?php
}

add_action('wp_ajax_miion-customizer-auto-load', 'miion_customizer_auto_load_option');
function miion_customizer_auto_load_option(){
	$nonce = $_POST['nonce'];
  
    if ( ! wp_verify_nonce( $nonce, 'miion-customizer-#$%&*(' ) )
        die ( esc_html__( 'Busted!', 'miion' ) );
	
	$auto_load = isset( $_POST['auto_load'] ) && $_POST['auto_load'] == '1' ? 1 : 0;
	update_option( 'miion_customizer_auto_load', $auto_load );
	echo 'success';
	exit;
}