<?php

class MiionShortcodes {

	public $event_title_tab;

	public $event_tab_key;

	public static $miion_footer_content = null;

	

	public function __construct(){

		

		self::$miion_footer_content = '';	

		

		//Scripts and styles		

		add_shortcode( 'soundcloud', array( $this, 'miionSoundcloud' ) );

		add_shortcode( 'videoframe', array( $this, 'miionVideoIframe' ) );

		add_shortcode( 'video', array( $this, 'miionVideo' ) );

		add_shortcode( 'videoframenon', array( $this, 'miionVideoIframeNonParam' ) );

		add_shortcode( 'popup_anything', array( $this, 'miionPopupAnything' ) );

		add_shortcode( 'miion_popover', array( $this, 'miionPopover' ) );

		add_shortcode( 'miion_sticky_element', array( $this, 'miionStickyElement' ) );

		add_shortcode( 'miion_popup_element', array( $this, 'miionPopupElement' ) );

    }



	public function miionSoundcloud( $atts ) {

		$atts = shortcode_atts( array(

			'url' => 'https://api.soundcloud.com/tracks/',

			'height' => '',

			'width' => '',

			'params' => ''

		), $atts );

		return '<iframe width="'. esc_attr( $atts['width'] ) .'" height="'. esc_attr( $atts['height'] ) .'" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url='. esc_url( $atts['url'] ) .'&amp;'. esc_url( $atts['params'] ) .'"></iframe>';

	}

	

	public function miionVideoIframe( $atts ) {

		$atts = shortcode_atts( array(

			'url' => '',

			'height' => '',

			'width' => '',

			'params' => ''

		), $atts );

		return '<iframe width="'. esc_attr( $atts['width'] ) .'" height="'. esc_attr( $atts['height'] ) .'" src="'. esc_url( $atts['url'] ) .'?'. esc_attr( $atts['params'] ) .'" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';

	}

	

	

	public function miionVideoIframeNonParam( $atts ) {

		$atts = shortcode_atts( array(

			'url' => '',

			'height' => '',

			'width' => '',

			'params' => '',

			'allowfullscreen' => ''

		), $atts );

		return '<iframe width="'. esc_attr( $atts['width'] ) .'" height="'. esc_attr( $atts['height'] ) .'" src="'. esc_url( $atts['url'] ) .'?'. esc_attr( $atts['params'] ) .'" '. esc_attr( $atts['allowfullscreen'] ) .'></iframe>';

	}

	

	public function miionVideo( $atts ) {

		$atts = shortcode_atts( array(

			'url' => '',

			'height' => '',

			'width' => '',

		), $atts );

		

		return '<video class="miion-custom-video" width="'. esc_attr( $atts['width'] ) .'" height="'. esc_attr( $atts['height'] ) .'" preload="true" style="max-width:100%;">

                    <source src="'. esc_url( $atts['url'] ) .'" type="video/mp4">

                </video>';

	}

		

	//[popup_anything icon_class="icon-control-play" video_url="https://www.youtube.com/watch?v=-hTVNidxg2s" img_url=""]

	public static function miionPopupAnything( $atts ) {

		$atts = shortcode_atts( array(

			'icon_class' => 'ti-control-play',

			'video_url' => 'https://www.youtube.com/watch?v=-hTVNidxg2s',

			'img_url' => ''

		), $atts );

		

		extract($atts);

		

		wp_enqueue_script( 'magnific-popup' );

		wp_enqueue_style( 'magnific-popup' );

		

		$output = '';

		if( $video_url ){

			$output = '<a class="popup-video-post" href="'. esc_url( $video_url ) .'">';

				if( $img_url ){

					$output .= '<img src="'. esc_url( $img_url ) .'" alt="'. esc_attr__( 'Video Trigger', 'miion' ) .'">';

				}else{

					$output .= '<div class="video-play-icon text-center"><span class="'. esc_attr( $icon_class ) .'"></span></div>';

				}

			$output .= '</a>';

		}

		return $output;

	}

	

	//[miion_popover class="btn" txt="Click to Popover" position="bottom" align="center"]This is sample content[/miion_popover]

	public static function miionPopover( $atts, $content = null ) {

	

		$atts = shortcode_atts( array(

			'txt' => esc_html__( 'Popover Me', 'miion-core' ),

			'position' => 'top',

			'align' => 'center'

		), $atts );

		

		extract($atts);

		

		$txt = isset( $txt ) && $txt != '' ? $txt : esc_html__( 'Popover Me', 'miion-core' );

		

		$class = isset( $class ) && $class != '' ? ' '. $class : '';

		$class .= isset( $align ) && $align != '' ? ' text-'. $align : ' text-center';

		$class .= isset( $position ) && $position != '' ? ' popover-'. $position : ' popover-top';

		$content = !empty( $content ) ? $content : esc_html__( 'Popover sample content', 'miion-core' );

		

		$output = '<div class="popover-wrapper'. esc_attr( $class ) .'">

			<a class="popover-trigger" href="#">'. esc_html( $txt ) .'</a>

			<div class="popover-content">

				<div class="arrow"></div>

				<div class="popover-message">'. do_shortcode( $content ) .'</div>

			</div>

		</div>';

		

		return $output;

	}

	

	//[miion_sticky_element align="center" width="300px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/miion_sticky_element]

	public static function miionStickyElement( $atts, $content = null ){

		$atts = shortcode_atts( array(

			'icon_class'	=> 'ti-settings',

			'icon_text'		=> '',

			'position'	=> 'middle',

			'align'	=> '',

			'width'	=> '300px',

			'extra_class' => ''

		), $atts );

		

		extract($atts);

		

		$icon_class = isset( $icon_class ) && $icon_class != '' ? $icon_class : '';

		$icon_text = isset( $icon_text ) && $icon_text != '' ? $icon_text : '';

		$left = isset( $left ) && $left != '' ? $left : '';

		$top = isset( $top ) && $top != '' ? $top : '';

		$width = isset( $width ) && $width != '' ? $width : '350px';

		$content = !empty( $content ) ? $content : esc_html__( 'Sticky sample content', 'miion-core' );

		

		// This is custom css options for main shortcode warpper

		$shortcode_css = '';

		$shortcode_rand_id = $rand_class = 'shortcode-rand-' . miion_shortcode_rand_id();

		if( $width ){

			$shortcode_css .= '.' . esc_attr( $rand_class ) . '.miion-sticky-wrapper { width: '. esc_attr( $width ) .'; right: -'. esc_attr( $width ) .'; }';

		}

		

		$class = isset( $extra_class ) && $extra_class != '' ? ' '. $extra_class : '';

		$class .= isset( $align ) && $align != '' ? ' text-'. $align : ' text-center';

		$class .= isset( $position ) && $position != '' ? ' position-'. $position : ' position-middle';

		if( $shortcode_css ) $class .= ' ' . $shortcode_rand_id . ' miion-inline-css';

		

		$output = '<div class="miion-sticky-wrapper'. esc_attr( $class ) .'" data-css="'. htmlspecialchars( json_encode( $shortcode_css ), ENT_QUOTES, 'UTF-8' ) .'">';

			if( $icon_text ){

				$output .= '<a class="miion-sticky-trigger" href="#">'. esc_html( $icon_text ) .'</a>';

			}else{

				$output .= '<a class="miion-sticky-trigger" href="#"><span class="'. esc_attr( $icon_class ) .'"></span></a>';

			}

			$output .= '

			<div class="miion-sticky-content">

				<div class="miion-sticky-message">'. do_shortcode( $content ) .'</div>

			</div>

		</div>';

		

		return $output;

	}

	

	//[miion_popup_element]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/miion_popup_element]

	public static function miionPopupElement( $atts, $content = null ){

		$atts = shortcode_atts( array(

			'icon_class'	=> 'ti-settings',

			'icon_text'		=> ''

		), $atts );

		

		extract($atts);

		

		wp_enqueue_script( 'magnific-popup' );

		wp_enqueue_style( 'magnific-popup' );

		

		$icon_class = isset( $icon_class ) && $icon_class != '' ? $icon_class : '';

		$icon_text = isset( $icon_text ) && $icon_text != '' ? $icon_text : '';

		$left = isset( $left ) && $left != '' ? $left : '';

		$top = isset( $top ) && $top != '' ? $top : '';

		$width = isset( $width ) && $width != '' ? $width : '350px';

		$content = !empty( $content ) ? $content : esc_html__( 'Popup sample content', 'miion-core' );

		

		// This is custom css options for main shortcode warpper

		$shortcode_css = '';

		$shortcode_rand_id = 'shortcode-rand-' . miion_shortcode_rand_id();

		$output = '<div class="miion-popup-wrapper">';

			if( $icon_text ){

				$output .= '<a class="miion-popup-trigger btn secondary-color" href="#miion-popup-'. esc_attr( $shortcode_rand_id ) .'">'. esc_html( $icon_text ) .'</a>';

			}else{

				$output .= '<a class="miion-popup-trigger" href="#miion-popup-'. esc_attr( $shortcode_rand_id ) .'"><span class="'. esc_attr( $icon_class ) .'"></span></a>';

			}

			if( $content ){

				$content_out = '

				<div class="mfp-hide white-popup-block miion-popup-content" id="miion-popup-'. esc_attr( $shortcode_rand_id ) .'">

					<a href="#" class="miion-popup-dismiss"><span class="ti-close"></span></a>

					<div class="miion-popup-message">'. do_shortcode( $content ) .'</div>

				</div>';

				//$output .= $content_out;

				self::$miion_footer_content .= $content_out;

				add_action( 'wp_footer', array( 'MiionShortcodes', 'miionFooterAction' ) );

			}

		$output .= '</div>';

		

		return $output;

	}



	public static function miionFooterAction(){

		echo self::$miion_footer_content;

	}

} // Shortcode class end

$miionsc = new MiionShortcodes;