<?php
/**
 * The template for displaying all custom post types
 */
 
get_header(); 
$ahe = new MiionHeaderElements;
$aps = new MiionPostSettings;
$post_type = get_post_type();
$template = str_replace( "miion-", "", $post_type ); // template id
$aps->miionSetPostTemplate( $template );
$template_class = $aps->miionTemplateContentClass();
$full_width_class = '';
$acpt = new MiionCPT;
?>
<div class="miion-content <?php echo esc_attr( 'miion-' . $template ); ?> miion-page">
		
		<?php $ahe->miionHeaderSlider('bottom'); ?>
		
		<?php $ahe->miionPageTitle( 'page' ); ?>
		<div class="miion-content-inner">
			<div class="container">
	
				<div class="row">
					
					<div class="<?php echo esc_attr( $template_class['content_class'] ); ?>">
						<div id="primary" class="content-area">
							<?php
								$acpt->miionCPTCallTemplate( $post_type );
							?>				
						</div><!-- #primary -->
					</div><!-- main col -->
					
					<?php if( $template_class['lsidebar_class'] != '' ) : ?>
					<div class="<?php echo esc_attr( $template_class['lsidebar_class'] ); ?>">
						<aside class="widget-area left-widget-area<?php echo esc_attr( $template_class['sticky_class'] ); ?>">
							<?php dynamic_sidebar( $template_class['left_sidebar'] ); ?>
						</aside>
					</div><!-- sidebar col -->
					<?php endif; ?>
					
					<?php if( $template_class['rsidebar_class'] != '' ) : ?>
					<div class="<?php echo esc_attr( $template_class['rsidebar_class'] ); ?>">
						<aside class="widget-area right-widget-area<?php echo esc_attr( $template_class['sticky_class'] ); ?>">
							<?php dynamic_sidebar( $template_class['right_sidebar'] ); ?>
						</aside>
					</div><!-- sidebar col -->
					<?php endif; ?>
					
				</div><!-- row -->
			
		</div><!-- .container -->
	</div><!-- .miion-content-inner -->
</div><!-- .miion-content -->
<?php get_footer();