<?php 
if( !class_exists( "MiionThemeStyles" ) ){
	require_once MIION_INC . '/theme-class/theme-style-class.php';
}
$ats = new MiionThemeStyles;
echo "
/*
 * Miion theme custom style
 */\n\n";

echo "\n/* General Styles */\n";
$ats->miion_custom_font_check( 'body-typography' );
echo 'body{';
	$ats->miion_typo_ouput( 'body-typography' );
	$ats->miion_bg_settings( 'body-background' );
echo '
}';
$ats->miion_custom_font_check( 'h1-typography' );
echo 'h1{';
	$ats->miion_typo_ouput( 'h1-typography' );
echo '
}';
$ats->miion_custom_font_check( 'h2-typography' );
echo 'h2{';
	$ats->miion_typo_ouput( 'h2-typography' );
echo '
}';
$ats->miion_custom_font_check( 'h3-typography' );
echo 'h3{';
	$ats->miion_typo_ouput( 'h3-typography' );
echo '
}';
$ats->miion_custom_font_check( 'h4-typography' );
echo 'h4{';
	$ats->miion_typo_ouput( 'h4-typography' );
echo '
}';
$ats->miion_custom_font_check( 'h5-typography' );
echo 'h5{';
	$ats->miion_typo_ouput( 'h5-typography' );
echo '
}';
$ats->miion_custom_font_check( 'h6-typography' );
echo 'h6{';
	$ats->miion_typo_ouput( 'h6-typography' );
echo '
}';
$gen_link = MiionThemeStyles::miionStaticThemeMod('theme-link-color');
if( $gen_link ):
echo 'a{';
	$ats->miion_link_color( 'theme-link-color', 'regular' );
echo '
}';
echo 'a:hover{';
	$ats->miion_link_color( 'theme-link-color', 'hover' );
echo '
}';
echo 'a:active{';
	$ats->miion_link_color( 'theme-link-color', 'active' );
echo '
}';
endif;
echo "\n/* Widget Typography Styles */\n";
$ats->miion_custom_font_check( 'widgets-content' );
echo '.widget{';
	$ats->miion_typo_ouput( 'widgets-content' );
echo '
}';
$ats->miion_custom_font_check( 'widgets-title' );
echo '.widget .widget-title{';
	$ats->miion_typo_ouput( 'widgets-title' );
echo '
}';

$page_loader = MiionThemeStyles::miionStaticThemeMod( 'page-loader' );
if( $page_loader ):
	$page_loader_img = MiionThemeStyles::miionStaticThemeMod( 'page-loader-img' );
	$page_loader_img_url = isset( $page_loader_img['url'] ) ? $page_loader_img['url'] : '';
	echo ".page-loader {background: url('". esc_url( $page_loader_img_url ). "') 50% 50% no-repeat rgb(249,249,249);}";
endif;
echo '.container, .boxed-container, .boxed-container .site-footer.footer-fixed, .custom-container {
	width: '. $ats->miion_container_width() .';
}';
echo 'body .elementor-section.elementor-section-boxed>.elementor-container {
	max-width: '. $ats->miion_container_width() .';
}';
echo '.miion-content > .miion-content-inner{';
	$ats->miion_padding_settings( 'page-content-padding' );
echo '
}';
echo "\n/* Header Styles */\n";
$logo_height = MiionThemeStyles::miionStaticThemeMod( 'logo-height' );
if( $logo_height ):
	echo '.header-inner .main-logo img { max-height: '. esc_attr( $logo_height ) .'px; }';
endif;

$sticky_logo_height = MiionThemeStyles::miionStaticThemeMod( 'sticky-logo-height' );
if( $sticky_logo_height ):
	echo '.header-inner .sticky-logo img { max-height: '. esc_attr( $sticky_logo_height ) .'px; }';
endif;

$mobile_logo_height = MiionThemeStyles::miionStaticThemeMod( 'mobile-logo-height' );
if( $mobile_logo_height ):
	echo '.mobile-header-inner .mobile-logo img { max-height: '. esc_attr( $mobile_logo_height ) .'px; }';
endif;

echo 'header.miion-header {';
	$ats->miion_bg_settings('header-background');
echo '}';
echo "\n/* Topbar Styles */\n";

$topbar_height = MiionThemeStyles::miionStaticThemeMod( 'header-topbar-height' );
$topbar_sticky_height = MiionThemeStyles::miionStaticThemeMod( 'header-topbar-sticky-height' );

$ats->miion_custom_font_check( 'header-topbar-typography' );
echo '.topbar{';
	$ats->miion_typo_ouput( 'header-topbar-typography' );
	$ats->miion_bg_rgba( 'header-topbar-background' );
	$ats->miion_border_settings( 'header-topbar-border' );
	$ats->miion_padding_settings( 'header-topbar-padding' );
echo '
}';
echo '.topbar a, .mobile-topbar-wrap a {';
	$ats->miion_link_color( 'header-topbar-link-color', 'regular' );
echo '
}';
echo '.topbar a:hover, .mobile-topbar-wrap a:hover {';
	$ats->miion_link_color( 'header-topbar-link-color', 'hover' );
echo '
}';
echo '.topbar a:active,.topbar a:focus, .mobile-topbar-wrap a:focus, .mobile-topbar-wrap a:active {';
	$ats->miion_link_color( 'header-topbar-link-color', 'active' );
echo '
}';
echo '.mobile-topbar-wrap {';
	$ats->miion_typo_ouput( 'header-topbar-typography' );
	$ats->miion_bg_rgba( 'header-topbar-background' );
echo '
}';
if( $topbar_height ) {
	echo '
	.topbar-items > li{
		height: '. esc_attr( $topbar_height ) .'px ;
		line-height: '. esc_attr( $topbar_height ) .'px ;
	}';
}	
if( $topbar_sticky_height ) {
	echo '
	.header-sticky .topbar-items > li,
	.sticky-scroll.show-menu .topbar-items > li{
		height: '. esc_attr( $topbar_sticky_height ) .'px ;
		line-height: '. esc_attr( $topbar_sticky_height ) .'px ;
	}';
}
if( $topbar_height ) {	
	echo '
	.topbar-items > li img{
		max-height: '. esc_attr(  $topbar_height ) .'px ;
	}';
}
echo "\n/* Logobar Styles */\n";

$logobar_height = MiionThemeStyles::miionStaticThemeMod( 'header-logobar-height' );
$logobar_sticky_height = MiionThemeStyles::miionStaticThemeMod( 'header-logobar-sticky-height' );

$ats->miion_custom_font_check( 'header-logobar-typography' );
echo '.logobar{';
	$ats->miion_typo_ouput( 'header-logobar-typography' );
	$ats->miion_bg_rgba( 'header-logobar-background' );
	$ats->miion_border_settings( 'header-logobar-border' );
	$ats->miion_padding_settings( 'header-logobar-padding' );
echo '
}';
echo '.logobar a{';
	$ats->miion_link_color( 'header-logobar-link-color', 'regular' );
echo '
}';
echo '.logobar a:hover{';
	$ats->miion_link_color( 'header-logobar-link-color', 'hover' );
echo '
}';
echo '.logobar a:active,
.logobar a:focus, .logobar .miion-main-menu > li.current-menu-item > a, .logobar .miion-main-menu > li.current-menu-ancestor > a, .logobar a.active {';
	$ats->miion_link_color( 'header-logobar-link-color', 'active' );
echo '
}';
if( $logobar_height ) {
	echo '
	.logobar-items > li{
		height: '. esc_attr( $logobar_height ) .'px ;
		line-height: '. esc_attr( $logobar_height ) .'px ;
	}';
}
if( $logobar_sticky_height ) {
	echo '.header-sticky .logobar-items > li,
	.sticky-scroll.show-menu .logobar-items > li{
		height: '. esc_attr( $logobar_sticky_height ) .'px ;
		line-height: '. esc_attr( $logobar_sticky_height ) .'px ;
	}';
}
if( $logobar_height ) {
	echo '
	.logobar-items > li img{
		max-height: '. esc_attr( $logobar_height ) .'px ;
	}';
}
echo "\n/* Logobar Sticky Styles */\n";
$color = MiionThemeStyles::miionStaticThemeMod('sticky-header-logobar-color');
echo '.header-sticky .logobar, .sticky-scroll.show-menu .logobar{
	'. ( $color != '' ? 'color: '. $color .';' : '' );
	$ats->miion_bg_rgba( 'sticky-header-logobar-background' );
	$ats->miion_border_settings( 'sticky-header-logobar-border' );
	$ats->miion_padding_settings( 'sticky-header-logobar-padding' );
echo '
}';
echo '.header-sticky .logobar a, .sticky-scroll.show-menu .logobar a{';
	$ats->miion_link_color( 'sticky-header-logobar-link-color', 'regular' );
echo '
}';
echo '.header-sticky .logobar a:hover, .sticky-scroll.show-menu .logobar a:hover{';
	$ats->miion_link_color( 'sticky-header-logobar-link-color', 'hover' );
echo '
}';
echo '.header-sticky .logobar a:active, .sticky-scroll.show-menu .logobar a:active,
.header-sticky .logobar .miion-main-menu .current-menu-item > a, .header-sticky .logobar .miion-main-menu .current-menu-ancestor > a,
.sticky-scroll.show-menu .logobar .miion-main-menu .current-menu-item > a, .sticky-scroll.show-menu .logobar .miion-main-menu .current-menu-ancestor > a ,
.header-sticky .logobar a.active, .sticky-scroll.show-menu .logobar a.active{';
	$ats->miion_link_color( 'sticky-header-logobar-link-color', 'active' );
echo '
}';
if( $logobar_sticky_height ) {
	echo '
	.header-sticky .logobar img.custom-logo, .sticky-scroll.show-menu .logobar img.custom-logo{
		max-height: '. esc_attr( $logobar_sticky_height ) .'px ;
	}';
}
echo "\n/* Navbar Styles */\n";

$navbar_height = MiionThemeStyles::miionStaticThemeMod( 'header-navbar-height' );
$navbar_sticky_height = MiionThemeStyles::miionStaticThemeMod( 'header-navbar-sticky-height' );

$ats->miion_custom_font_check( 'header-navbar-typography' );
echo '.navbar{';
	$ats->miion_typo_ouput( 'header-navbar-typography' );
	$ats->miion_bg_rgba( 'header-navbar-background' );
	$ats->miion_border_settings( 'header-navbar-border' );
	$ats->miion_padding_settings( 'header-navbar-padding' );
echo '
}';
echo '.navbar a{';
	$ats->miion_link_color( 'header-navbar-link-color', 'regular' );
echo '
}';
echo '.navbar a:hover{';
	$ats->miion_link_color( 'header-navbar-link-color', 'hover' );
echo '
}';
echo '.navbar a:active,.navbar a:focus, .navbar .miion-main-menu > .current-menu-item > a, .navbar .miion-main-menu > .current-menu-ancestor > a, .navbar a.active {';
	$ats->miion_link_color( 'header-navbar-link-color', 'active' );
echo '
}';
$color = MiionThemeStyles::miionStaticThemeMod( 'header-navbar-typography' );
$color = isset( $color['color'] ) && $color['color'] != '' ? $color['color'] : '';
$scolor = MiionThemeStyles::miionStaticThemeMod( 'sticky-header-navbar-color' );
if( $navbar_height ) {
	echo '
	.navbar-items > li{
		height: '. esc_attr( $navbar_height ) .'px ;
		line-height: '. esc_attr( $navbar_height ) .'px ;
	}';
}
if( $navbar_sticky_height ) {
	echo '.header-sticky .navbar-items > li,
	.sticky-scroll.show-menu .navbar-items > li{
		height: '. esc_attr( $navbar_sticky_height ) .'px ;
		line-height: '. esc_attr( $navbar_sticky_height ) .'px ;
	}';
}
if( $navbar_height ) {
	echo '
	.navbar-items > li img{
		max-height: '. esc_attr( $navbar_height ) .'px ;
	}';
}
echo "\n/* Navbar Sticky Styles */\n";
$color = MiionThemeStyles::miionStaticThemeMod('sticky-header-navbar-color');
echo '.header-sticky .navbar, .sticky-scroll.show-menu .navbar{
	'. ( $color != '' ? 'color: '. $color .';' : '' );
	$ats->miion_bg_rgba( 'sticky-header-navbar-background' );
	$ats->miion_border_settings( 'sticky-header-navbar-border' );
	$ats->miion_padding_settings( 'sticky-header-navbar-padding' );
echo '
}';
echo '.header-sticky .navbar a, .sticky-scroll.show-menu .navbar a {';
	$ats->miion_link_color( 'sticky-header-navbar-link-color', 'regular' );
echo '
}';
echo '.header-sticky .navbar a:hover, .sticky-scroll.show-menu .navbar a:hover {';
	$ats->miion_link_color( 'sticky-header-navbar-link-color', 'hover' );
echo '
}';
echo '.header-sticky .navbar a:active, .sticky-scroll.show-menu .navbar a:active,
.header-sticky .navbar .miion-main-menu .current-menu-item > a, .header-sticky .navbar .miion-main-menu .current-menu-ancestor > a,
.sticky-scroll.show-menu .navbar .miion-main-menu .current-menu-item > a, .sticky-scroll.show-menu .navbar .miion-main-menu .current-menu-ancestor > a,
.header-sticky .navbar a.active, .sticky-scroll.show-menu .navbar a.active {';
	$ats->miion_link_color( 'sticky-header-navbar-link-color', 'active' );
echo '
}';
if( $navbar_sticky_height ) {
	echo '
	.sticky-scroll.show-menu .navbar img.custom-logo{
		max-height: '. esc_attr( $navbar_sticky_height ) .'px ;
	}';
}
echo "\n/* Secondary Menu Space Styles */\n";

$sec_space_width = MiionThemeStyles::miionStaticThemeMod( 'secondary-menu-space-width' );

$sec_menu_type = MiionThemeStyles::miionStaticThemeMod('secondary-menu-type');
$ats->miion_custom_font_check( 'secondary-space-typography' );
if( $sec_space_width ){
	echo '.secondary-menu-area {';
		echo 'width: '. esc_attr( $sec_space_width ) .'px ;';
	echo '}';
}
echo '.secondary-menu-area {';
	$ats->miion_border_settings( 'secondary-space-border' );
	$ats->miion_typo_ouput( 'secondary-space-typography' );
	$ats->miion_bg_settings('secondary-space-background');
	if( $sec_space_width ){
		if( $sec_menu_type == 'left-overlay' || $sec_menu_type == 'left-push' ){
			echo 'left: -' . esc_attr( $sec_space_width ) . 'px;';
		}elseif( $sec_menu_type == 'right-overlay' || $sec_menu_type == 'right-push' ){
			echo 'right: -' . esc_attr( $sec_space_width ) . 'px;';
		}
	}
echo '
}';
if( $sec_space_width ){
	echo '.secondary-menu-area.left-overlay, .secondary-menu-area.left-push{';
		if( $sec_menu_type == 'left-overlay' || $sec_menu_type == 'left-push' ){
			echo 'left: -' . esc_attr( $sec_space_width ) . 'px;';
		}
	echo '
	}';
	echo '.secondary-menu-area.right-overlay, .secondary-menu-area.right-push{';
		if( $sec_menu_type == 'right-overlay' || $sec_menu_type == 'right-push' ){
			echo 'right: -' . esc_attr( $sec_space_width ) . 'px;';
		}
	echo '
	}';
}
echo '.secondary-menu-area .secondary-menu-area-inner{';
	$ats->miion_padding_settings( 'secondary-space-padding' );
echo '
}';
echo '.secondary-menu-area a{';
	$ats->miion_link_color( 'secondary-space-link-color', 'regular' );
echo '
}';
echo '.secondary-menu-area a:hover{';
	$ats->miion_link_color( 'secondary-space-link-color', 'hover' );
echo '
}';
echo '.secondary-menu-area a:active{';
	$ats->miion_link_color( 'secondary-space-link-color', 'active' );
echo '
}';
echo "\n/* Sticky Header Styles */\n";
$header_type = MiionThemeStyles::miionStaticThemeMod('header-type');
if( $header_type != 'default' ):
	$sticky_width = MiionThemeStyles::miionStaticThemeMod( 'header-fixed-width' );
	if( $sticky_width ){
		echo '.sticky-header-space{
			width: '. esc_attr( $sticky_width ) .'px;
		}';
		if( MiionThemeStyles::miionStaticThemeMod('header-type') == 'left-sticky' ):
			echo 'body, .top-sliding-bar{
				padding-left: '. esc_attr( $sticky_width ) .'px;
			}';
			else:
			echo 'body, .top-sliding-bar{
				padding-right: '. esc_attr( $sticky_width ) .'px;
			}';
		endif;
	}
endif;
$ats->miion_custom_font_check( 'header-fixed-typography' );
echo '.sticky-header-space{';
	$ats->miion_typo_ouput( 'header-fixed-typography' );
	$ats->miion_bg_settings( 'header-fixed-background' );
	$ats->miion_border_settings( 'header-fixed-border' );
	$ats->miion_padding_settings( 'header-fixed-padding' );
echo '
}';
echo '.sticky-header-space li a{';
	$ats->miion_link_color( 'header-fixed-link-color', 'regular' );
echo '
}';
echo '.sticky-header-space li a:hover{';
	$ats->miion_link_color( 'header-fixed-link-color', 'hover' );
echo '
}';
echo '.sticky-header-space li a:active{';
	$ats->miion_link_color( 'header-fixed-link-color', 'active' );
echo '
}';
echo "\n/* Mobile Header Styles */\n";

$mobile_header_hgt = MiionThemeStyles::miionStaticThemeMod( 'mobile-header-height' );
$mobile_header_sticky_hgt = MiionThemeStyles::miionStaticThemeMod( 'mobile-header-sticky-height' );

if( $mobile_header_hgt ){
	echo '
	.mobile-header-items > li{
		height: '. esc_attr( $mobile_header_hgt ) .'px ;
		line-height: '. esc_attr( $mobile_header_hgt ) .'px ;
	}';
}
echo '.mobile-header{';
	$ats->miion_bg_rgba('mobile-header-background');
echo '
}';
echo '.mobile-header-items li a{';
	$ats->miion_link_color( 'mobile-header-link-color', 'regular' );
echo '
}';
echo '.mobile-header-items li a:hover{';
	$ats->miion_link_color( 'mobile-header-link-color', 'hover' );
echo '
}';
echo '.mobile-header-items li a:active{';
	$ats->miion_link_color( 'mobile-header-link-color', 'active' );
echo '
}';
if( $mobile_header_sticky_hgt ){
	echo '
	.header-sticky .mobile-header-items > li, .show-menu .mobile-header-items > li{
		height: '. esc_attr( $mobile_header_sticky_hgt ) .'px;
		line-height: '. esc_attr( $mobile_header_sticky_hgt ) .'px;
	}';
}
echo '.mobile-header .header-sticky, .mobile-header .show-menu{';
	$ats->miion_bg_rgba('mobile-header-sticky-background');
echo '}';
echo '.header-sticky .mobile-header-items li a, .show-menu .mobile-header-items li a{';
	$ats->miion_link_color( 'mobile-header-sticky-link-color', 'regular' );
echo '
}';
echo '.header-sticky .mobile-header-items li a:hover, .show-menu .mobile-header-items li a:hover{';
	$ats->miion_link_color( 'mobile-header-sticky-link-color', 'hover' );
echo '
}';
echo '.header-sticky .mobile-header-items li a:hover, .show-menu .mobile-header-items li a:hover{';
	$ats->miion_link_color( 'mobile-header-sticky-link-color', 'active' );
echo '
}';
$mm_max = MiionThemeStyles::miionStaticThemeMod( 'mobile-menu-max-width' );
if( $mm_max ):
echo '.mobile-bar, .mobile-bar .container{
	max-width: '. $mm_max .'px;
}';
endif;
echo "\n/* Mobile Bar Styles */\n";
$ats->miion_custom_font_check( 'mobile-menu-typography' );
echo '.mobile-bar{';
	$ats->miion_typo_ouput( 'mobile-menu-typography' );
	$ats->miion_bg_settings( 'mobile-menu-background' );
	$ats->miion_border_settings( 'mobile-menu-border' );
	$ats->miion_padding_settings( 'mobile-menu-padding' );
echo '
}';
echo '.mobile-bar li a{';
	$ats->miion_link_color( 'mobile-menu-link-color', 'regular' );
echo '
}';
echo '.mobile-bar li a:hover{';
	$ats->miion_link_color( 'mobile-menu-link-color', 'hover' );
echo '
}';
echo '.mobile-bar li a:active, ul > li.current-menu-item > a, 
ul > li.current-menu-parent > a, ul > li.current-menu-ancestor > a,
.miion-mobile-menu li.menu-item a.active {';
	$ats->miion_link_color( 'mobile-menu-link-color', 'active' );
echo '
}';
echo "\n/* Top Sliding Bar Styles */\n";
$ats->miion_custom_font_check( 'top-sliding-typography' );
if( MiionThemeStyles::miionStaticThemeMod( 'header-top-sliding-switch' ) ):
echo '.top-sliding-bar-inner{';
	$ats->miion_typo_ouput( 'top-sliding-typography' );
	$ats->miion_bg_rgba( 'top-sliding-background' );
	$ats->miion_border_settings( 'top-sliding-border' );
	$ats->miion_padding_settings( 'top-sliding-padding' );
echo '
}';
$ts_bg = MiionThemeStyles::miionStaticThemeMod( 'top-sliding-background' );
if( !empty( $ts_bg ) ){
	echo '.top-sliding-toggle{
		'. ( $ts_bg != '' ? 'border-top-color: '. esc_attr( $ts_bg ) . ';' : '' ) .'
	}';
}
echo '.top-sliding-bar-inner li a{';
	$ats->miion_link_color( 'top-sliding-link-color', 'regular' );
echo '
}';
echo '.top-sliding-bar-inner li a:hover{';
	$ats->miion_link_color( 'top-sliding-link-color', 'hover' );
echo '
}';
echo '.top-sliding-bar-inner li a:active{';
	$ats->miion_link_color( 'top-sliding-link-color', 'active' );
echo '
}';
endif;
echo "\n/* General Menu Styles */\n";
$menu_tag_hot_bg = MiionThemeStyles::miionStaticThemeMod( 'menu-tag-hot-bg' );
if( $menu_tag_hot_bg ) {
	echo '.menu-tag-hot{
		background-color: '. $menu_tag_hot_bg .';
	}';
}	
$menu_tag_new_bg = MiionThemeStyles::miionStaticThemeMod( 'menu-tag-new-bg' );
if( $menu_tag_new_bg ) {
	echo '.menu-tag-new{
		background-color: '. $menu_tag_new_bg .';
	}';
}
$menu_tag_trend_bg = MiionThemeStyles::miionStaticThemeMod( 'menu-tag-trend-bg' );
if( $menu_tag_trend_bg ) {
	echo '.menu-tag-trend{
		background-color: '. $menu_tag_trend_bg .';
	}';
}
echo "\n/* Main Menu Styles */\n";
$ats->miion_custom_font_check( 'main-menu-typography' );
echo 'ul.miion-main-menu > li > a,
ul.miion-main-menu > li > .main-logo{';
	$ats->miion_typo_ouput( 'main-menu-typography' );
echo '
}';
echo "\n/* Dropdown Menu Styles */\n";
echo 'ul.dropdown-menu{';
	$ats->miion_bg_rgba( 'dropdown-menu-background' );
	$ats->miion_border_settings( 'dropdown-menu-border' );
echo '
}';
$ats->miion_custom_font_check( 'dropdown-menu-typography' );
echo 'ul.dropdown-menu > li{';
	$ats->miion_typo_ouput( 'dropdown-menu-typography' );
echo '
}';
echo 'ul.dropdown-menu > li a,
ul.mega-child-dropdown-menu > li a,
.header-sticky ul.dropdown-menu > li a, .sticky-scroll.show-menu ul.dropdown-menu > li a,
.header-sticky ul.mega-child-dropdown-menu > li a, .sticky-scroll.show-menu ul.mega-child-dropdown-menu > li a {';
	$ats->miion_link_color( 'dropdown-menu-link-color', 'regular' );
echo '
}';
echo 'ul.dropdown-menu > li a:hover,
ul.mega-child-dropdown-menu > li a:hover,
.header-sticky ul.dropdown-menu > li a:hover, .sticky-scroll.show-menu ul.dropdown-menu > li a:hover,
.header-sticky ul.mega-child-dropdown-menu > li a:hover, .sticky-scroll.show-menu ul.mega-child-dropdown-menu > li a:hover {';
	$ats->miion_link_color( 'dropdown-menu-link-color', 'hover' );
echo '
}';
echo 'ul.dropdown-menu > li a:active,
ul.mega-child-dropdown-menu > li a:active,
.header-sticky ul.dropdown-menu > li a:active, .sticky-scroll.show-menu ul.dropdown-menu > li a:active,
.header-sticky ul.mega-child-dropdown-menu > li a:active, .sticky-scroll.show-menu ul.mega-child-dropdown-menu > li a:active,
ul.dropdown-menu > li.current-menu-item > a, ul.dropdown-menu > li.current-menu-parent > a, ul.dropdown-menu > li.current-menu-ancestor > a,
ul.mega-child-dropdown-menu > li.current-menu-item > a {';
	$ats->miion_link_color( 'dropdown-menu-link-color', 'active' );
echo '
}';
/* Template Page Title Styles */
echo "\n/* Template Page Title Styles */\n";
miionPostTitileStyle( 'single-post', $ats );
miionPostTitileStyle( 'blog', $ats );
miionPostTitileStyle( 'page', $ats );
miionPostTitileStyle( 'woo', $ats );
miionPostTitileStyle( 'single-product', $ats );
$actived_tmplt = MiionThemeStyles::miionStaticThemeMod('theme-templates');
if( !empty( $actived_tmplt ) && is_array( $actived_tmplt ) ){
	foreach( $actived_tmplt as $template ){
		miionPostTitileStyle( $template, $ats );
	}
}

function miionPostTitileStyle( $field, $ats ){
	$font_color = MiionThemeStyles::miionStaticThemeMod( 'template-'. $field .'-color' );
	echo '.miion-'. $field .' .page-title-wrap-inner{'.
		( $font_color != '' ? ' color: '. esc_attr( $font_color ) .';' : '' );
		$ats->miion_bg_settings( 'template-'. $field .'-background-all' );
		$ats->miion_border_settings( 'template-'. $field .'-border' );
		$ats->miion_padding_settings( 'template-'. $field .'-padding' );
	echo '
	}';
	echo '.miion-'. $field .' .page-title-wrap a{';
		$ats->miion_link_color( 'template-'. $field .'-link-color', 'regular' );
	echo '
	}';
	echo '.miion-'. $field .' .page-title-wrap a:hover{';
		$ats->miion_link_color( 'template-'. $field .'-link-color', 'hover' );
	echo '
	}';
	echo '.miion-'. $field .' .page-title-wrap a:active{';
		$ats->miion_link_color( 'template-'. $field .'-link-color', 'active' );
	echo '
	}';
	echo '.miion-'. $field .' .page-title-wrap-inner > .page-title-overlay{';
		$ats->miion_bg_rgba( $field .'-page-title-overlay' );
	echo '
	}';
}
/* Template Article Styles */
echo "\n/* Template Article Styles */\n";
miionPostArticleStyle( 'single-post', $ats );
miionPostArticleStyle( 'blog', $ats );
miionPostArticleStyle( 'archive', $ats );

function miionPostArticleStyle( $field, $ats ){
	
	$article_css = '';
	
	$font_color = MiionThemeStyles::miionStaticThemeMod( $field .'-article-color' );
	$bg_color = MiionThemeStyles::miionStaticThemeMod( $field .'-article-background' );
	
	$article_css .= $font_color != '' ? ' color: '. esc_attr( $font_color ) .';' : '';
	$article_css .= $bg_color != '' ? ' background-color: '. esc_attr( $bg_color ) .';' : '';
	$article_css .= $ats->miion_border_settings( $field .'-article-border', false );
	$article_css .= $ats->miion_padding_settings( $field .'-article-padding', false );
	echo !empty( $article_css ) ? '.'. $field .'-template article.post{'. $article_css .'}' : '';
	
	$article_css = $ats->miion_link_color( $field .'-article-link-color', 'regular', false );
	echo !empty( $article_css ) ? '.'. $field .'-template article.post a{'. $article_css .'}' : '';
	
	$article_css = $ats->miion_link_color( $field .'-article-link-color', 'hover', false );
	echo !empty( $article_css ) ? '.'. $field .'-template article.post a:hover{'. $article_css .'}' : '';
	
	$article_css = $ats->miion_link_color( $field .'-article-link-color', 'active', false );
	echo !empty( $article_css ) ? '.'. $field .'-template article.post a:active{'. $article_css .'}' : '';
	
	$post_thumb_margin = MiionThemeStyles::miionStaticThemeMod( $field .'-article-padding' );
	if( $post_thumb_margin ):
		echo '.'. $field .'-template .post-format-wrap{
			'. ( isset( $post_thumb_margin['padding-left'] ) && $post_thumb_margin['padding-left'] != '' ? 'margin-left: -' . $post_thumb_margin['padding-left'] .';' : '' ) .'
			'. ( isset( $post_thumb_margin['padding-right'] ) && $post_thumb_margin['padding-right'] != '' ? 'margin-right: -' . $post_thumb_margin['padding-right'] .';' : '' ) .'
		}';
		echo '.'. $field .'-template .post-quote-wrap > .blockquote, .'. $field .'-template .post-link-inner, .'. $field .'-template .post-format-wrap .post-audio-wrap{
			'. ( isset( $post_thumb_margin['padding-left'] ) && $post_thumb_margin['padding-left'] != '' ? 'padding-left: ' . $post_thumb_margin['padding-left'] .';' : '' ) .'
			'. ( isset( $post_thumb_margin['padding-right'] ) && $post_thumb_margin['padding-right'] != '' ? 'padding-right: ' . $post_thumb_margin['padding-right'] .';' : '' ) .'
		}';
	endif;
}
$theme_color = $ats->miionThemeColor();
$secondary_color = $ats->miionSecondaryColor();
echo "\n/* Blockquote / Audio / Link Styles */\n";
echo '.post-quote-wrap > .blockquote{
	border-left-color: '. esc_attr( $theme_color ) .';
}';
$rgba_08 = $ats->miion_hex2rgba( $theme_color, '0.8' );
// Single Post Blockquote
$blockquote_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'single-post-quote-format' );
miionQuoteDynamicStyle( 'single-post', $blockquote_bg_opt, $theme_color, $rgba_08 );
// Blog Blockquote
$blockquote_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'blog-quote-format' );
miionQuoteDynamicStyle( 'blog', $blockquote_bg_opt, $theme_color, $rgba_08 );
// Archive Blockquote
$blockquote_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'archive-quote-format' );
miionQuoteDynamicStyle( 'archive', $blockquote_bg_opt, $theme_color, $rgba_08 );
// Category Blockquote
$blockquote_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'category-quote-format' );
miionQuoteDynamicStyle( 'category', $blockquote_bg_opt, $theme_color, $rgba_08 );

function miionQuoteDynamicStyle( $field, $value, $theme_color, $rgba_08 ){
	if( $value == 'none' ):
		echo '.'. $field .'-template .post-quote-wrap > .blockquote{
			background-color: #333;
		}';
	elseif( $value == 'theme' ):
		echo '.'. $field .'-template .post-quote-wrap > .blockquote{
			background-color: '. $theme_color .';
			border-left-color: #333;
		}';
	elseif( $value == 'theme-overlay' ):
		echo '.'. $field .'-template .post-quote-wrap > .blockquote{
			background-color: '. $rgba_08 .';
		}';
	elseif( $value == 'featured' ):
		echo '.'. $field .'-template .post-quote-wrap > .blockquote{
			background-color: rgba(0, 0, 0, 0.7);
		}';
	endif;
}
/* Single Post Link */
$link_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'single-post-link-format' );
miionLinkDynamicStyle( 'single-post', $link_bg_opt, $theme_color, $rgba_08 );
/* Blog Link */
$link_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'blog-link-format' );
miionLinkDynamicStyle( 'blog', $link_bg_opt, $theme_color, $rgba_08 );
/* Archive Link */
$link_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'archive-link-format' );
miionLinkDynamicStyle( 'archive', $link_bg_opt, $theme_color, $rgba_08 );
/* Catgeory Link */
$link_bg_opt = MiionThemeStyles::miionStaticThemeMod( 'category-link-format' );
miionLinkDynamicStyle( 'category', $link_bg_opt, $theme_color, $rgba_08 );

function miionLinkDynamicStyle( $field, $value, $theme_color, $rgba_08 ){
	if( $value == 'none' ):
		echo '.'. $field .'-template .post-link-inner{
			background-color: #333;
		}';
	elseif( $value == 'theme' ):
		echo '.'. $field .'-template .post-link-inner{
			background-color: '. $theme_color .';
		}';
	elseif( $value == 'theme-overlay' ):
		echo '.'. $field .'-template .post-link-inner{
			background-color: '. $rgba_08 .';
		}';
	elseif( $value == 'featured' ):
		echo '.'. $field .'-template .post-link-inner{
			background-color: rgba(0, 0, 0, 0.7);
		}';
	endif;
}
echo "\n/* Post Item Overlay Styles */\n";
$article_overlay_color = MiionThemeStyles::miionStaticThemeMod( 'single-post-article-overlay-color' );
echo '.post-overlay-items{';
	echo !empty( $article_overlay_color ) ? ' color: '. $article_overlay_color . ';}' : '';
	$ats->miion_bg_rgba( 'single-post-article-overlay-background' );
	$ats->miion_border_settings( 'single-post-article-overlay-border' );
	$ats->miion_padding_settings( 'single-post-article-overlay-padding' );
	$ats->miion_margin_settings( 'single-post-article-overlay-margin' );
	
echo '
}';
echo '.post-overlay-items a{';
	$ats->miion_link_color( 'single-post-article-overlay-link-color', 'regular' );
echo '
}';
echo '.post-overlay-items a:hover{';
	$ats->miion_link_color( 'single-post-article-overlay-link-color', 'hover' );
echo '
}';
echo '.post-overlay-items a:hover{';
	$ats->miion_link_color( 'single-post-article-overlay-link-color', 'active' );
echo '
}';
/* Extra Styles */
echo "\n/* Footer Styles */\n";
$ats->miion_custom_font_check( 'footer-typography' );
echo '.site-footer{';
	$ats->miion_typo_ouput( 'footer-typography' );
	$ats->miion_bg_settings( 'footer-background' );
	$ats->miion_border_settings( 'footer-border' );
	$ats->miion_padding_settings( 'footer-padding' );
echo '
}';
echo '.site-footer .widget{';
	$ats->miion_typo_ouput( 'footer-typography' );
echo '
}';
$bg_overlay = MiionThemeStyles::miionStaticThemeMod( 'footer-background-overlay' );
if( isset( $bg_overlay ) && !empty( $bg_overlay ) ):
echo '
footer.site-footer:before {
	position: absolute;
	height: 100%;
	width: 100%;
	top: 0;
	left: 0;
	content: "";
	'. ( !empty( $bg_overlay ) ? 'background-color: '. esc_attr( $bg_overlay ) .';' : '' ) .'}';
endif;
echo '.site-footer a{';
	$ats->miion_link_color( 'footer-link-color', 'regular' );
echo '
}';
echo '.site-footer a:hover{';
	$ats->miion_link_color( 'footer-link-color', 'hover' );
echo '
}';
echo '.site-footer a:hover{';
	$ats->miion_link_color( 'footer-link-color', 'active' );
echo '
}';
echo "\n/* Footer Top Styles */\n";
$ats->miion_custom_font_check( 'footer-top-typography' );
echo '.footer-top-wrap{';
	$ats->miion_typo_ouput( 'footer-top-typography' );
	$ats->miion_bg_settings( 'footer-top-background' );
	$ats->miion_border_settings( 'footer-top-border' );
	$ats->miion_padding_settings( 'footer-top-padding' );
	$ats->miion_margin_settings( 'footer-top-margin' );
echo '
}';
$top_bg_overlay = MiionThemeStyles::miionStaticThemeMod( 'footer-top-background-overlay' );
if( isset( $top_bg_overlay ) && !empty( $top_bg_overlay ) ):
	echo '
	.footer-top-wrap:before {
		position: absolute;
		height: 100%;
		width: 100%;
		top: 0;
		left: 0;
		content: "";
		'. ( !empty( $top_bg_overlay ) ? 'background-color: '. esc_attr( $top_bg_overlay ) .';' : '' ) .'}';
endif;
echo '.footer-top-wrap .widget{';
	$ats->miion_typo_ouput( 'footer-top-typography' );
echo '
}';
echo '.footer-top-wrap a{';
	$ats->miion_link_color( 'footer-top-link-color', 'regular' );
echo '
}';
echo '.footer-top-wrap a:hover{';
	$ats->miion_link_color( 'footer-top-link-color', 'hover' );
echo '
}';
echo '.footer-top-wrap a:hover{';
	$ats->miion_link_color( 'footer-top-link-color', 'active' );
echo '
}';

$tit_clr = MiionThemeStyles::miionStaticThemeMod( 'footer-top-title-color' );
echo !empty( $tit_clr ) ? '.footer-top-wrap .widget .widget-title { color: '. esc_attr( $tit_clr ) .'; }' : '';
echo "\n/* Footer Middle Styles */\n";
$ats->miion_custom_font_check( 'footer-middle-typography' );
echo '.footer-middle-wrap{';
	$ats->miion_typo_ouput( 'footer-middle-typography' );
	$ats->miion_bg_settings( 'footer-middle-background' );
	$ats->miion_border_settings( 'footer-middle-border' );
	$ats->miion_padding_settings( 'footer-middle-padding' );
	$ats->miion_margin_settings( 'footer-middle-margin' );
echo '
}';

$middle_bg_overlay = MiionThemeStyles::miionStaticThemeMod( 'footer-middle-background-overlay' );
if( isset( $middle_bg_overlay ) && !empty( $middle_bg_overlay ) ):
	echo '
	.footer-middle-wrap:before {
		position: absolute;
		height: 100%;
		width: 100%;
		top: 0;
		left: 0;
		content: "";
		background-color: '. esc_attr( $middle_bg_overlay ) .';
	}';
endif;

echo '.footer-middle-wrap .widget{';
	$ats->miion_typo_ouput( 'footer-middle-typography' );
echo '
}';
echo '.footer-middle-wrap a{';
	$ats->miion_link_color( 'footer-middle-link-color', 'regular' );
echo '
}';
echo '.footer-middle-wrap a:hover{';
	$ats->miion_link_color( 'footer-middle-link-color', 'hover' );
echo '
}';
echo '.footer-middle-wrap a:active{';
	$ats->miion_link_color( 'footer-middle-link-color', 'active' );
echo '
}';

$tit_clr = MiionThemeStyles::miionStaticThemeMod( 'footer-middle-title-color' );
echo !empty( $tit_clr ) ? '.footer-middle-wrap .widget .widget-title { color: '. esc_attr( $tit_clr ) .'; }' : '';
echo "\n/* Footer Bottom Styles */\n";
$ats->miion_custom_font_check( 'footer-bottom-typography' );
echo '.footer-bottom{';
	$ats->miion_typo_ouput( 'footer-bottom-typography' );
	$ats->miion_bg_settings( 'footer-bottom-background' );
	$ats->miion_border_settings( 'footer-bottom-border' );
	$ats->miion_padding_settings( 'footer-bottom-padding' );
	$ats->miion_margin_settings( 'footer-bottom-margin' );
echo '
}';
echo '.footer-bottom .widget{';
	$ats->miion_typo_ouput( 'footer-bottom-typography' );
echo '
}';
echo '.footer-bottom a{';
	$ats->miion_link_color( 'footer-bottom-link-color', 'regular' );
echo '
}';
echo '.footer-bottom a:hover{';
	$ats->miion_link_color( 'footer-bottom-link-color', 'hover' );
echo '
}';
echo '.footer-bottom a:active{';
	$ats->miion_link_color( 'footer-bottom-link-color', 'active' );
echo '
}';

$tit_clr = MiionThemeStyles::miionStaticThemeMod( 'footer-bottom-title-color' );
echo !empty( $tit_clr ) ? '.footer-bottom-wrap .widget .widget-title { color: '. esc_attr( $tit_clr ) .'; }' : '';
echo "\n/* Theme Extra Styles */\n";
//Here your code
$theme_link_color = $ats->miion_link_color( 'theme-link-color', 'regular', false );
$theme_link_hover = $ats->miion_link_color( 'theme-link-color', 'hover', false );
$theme_link_active = $ats->miion_link_color( 'theme-link-color', 'active', false );
$rgb = $ats->miion_hex2rgba( $theme_color, 'none' );
/*
 * Theme Color -> $theme_color
 * Secondary Color -> $secondary_color
 * Theme RGBA -> $rgb example -> echo 'body{ background: rgba('. esc_attr( $rgb ) .', 0.5); }';
 * Link Colors -> $theme_link_color, $theme_link_hover, $theme_link_active
 */
echo '.theme-color {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.gradient-bg {
	background: -webkit-linear-gradient(-155deg, '. esc_attr( $theme_color ) .' 0%, '. esc_attr( $secondary_color ) .' 100%);
	background: linear-gradient(-155deg, '. esc_attr( $theme_color ) .' 0%, '. esc_attr( $secondary_color ) .' 100%);
}';
if( $secondary_color ){
	echo '.theme-color-bg {
		background-color: '. esc_attr( $theme_color ) .';
	}';
	echo '.theme-color-hbg:hover {
		background-color: '. esc_attr( $theme_color ) .' !important;
	}';
}else{
	echo '.theme-color-bg {
		background-color: '. esc_attr( $theme_color ) .';
	}';
}
echo '.secondary-color {
	color: '. esc_attr( $secondary_color ) .';
}';
echo '.default-color {
	color: '. esc_attr( $theme_color ) .' !important;
}';
echo "\n/*----------- General Style----------- */\n";
echo '::selection {
	background : '. esc_attr( $theme_color ) .';
}';
echo 'b {
	color : '. esc_attr( $theme_color ) .';
}';
echo 'b {
	color : '. esc_attr( $theme_color ) .';
}';
echo '.error-404 .page-title {
	text-shadow : -1px -1px 0 '. esc_attr( $theme_color ) .', 1px -1px 0 '. esc_attr( $theme_color ) .', -1px 1px 0 #000, 1px 1px 0 #000;
}';
echo '.top-sliding-toggle.fa-minus {
	border-top-color : '. esc_attr( $theme_color ) .';
}';
echo '.owl-dot.active span {
	background : '. esc_attr( $theme_color ) .';
	border-color : '. esc_attr( $theme_color ) .';
}';
echo '.owl-prev, .owl-next {
	color : '. esc_attr( $theme_color ) .';
}';
echo '.owl-prev:hover, .owl-next:hover {
	color : '. esc_attr( $theme_color ) .';
}';
echo '.typo-a-white a:hover {
	color : '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Header ----------- */\n";
echo '.header-button a {
	background-color : '. esc_attr( $theme_color ) .';
}';
echo '.classic-navbar .miion-main-menu {
	background : '. esc_attr( $theme_color ) .';
}';
echo '.classic-navbar .miion-main-menu:before {
	border-bottom-color : '. esc_attr( $theme_color ) .';
}';
echo '.topbar-items .header-phone span,
.topbar-items .header-email span,
.topbar-items .header-address span,
ul.mobile-topbar-items.nav li span {
	color : '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Header Logobar ----------- */\n";
echo '.header-inner .logobar-inner .media i {
	color : '. esc_attr( $theme_color ) .';
}';
echo '.header-inner .logobar-inner .media i:after {
	background : '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Menu----------- */\n";
echo '.dropdown:hover > .dropdown-menu {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.navbar ul ul ul.dropdown-menu li .nav-link:focus, 
ul.nav ul ul.dropdown-menu li .nav-link:focus {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.navbar ul ul li.menu-btn a {
	color: '. esc_attr( $theme_color ) .';
}';

echo "\n/*----------- Footer ----------- */\n";
echo '.widget .widget-title::before {
	background: '. esc_attr( $theme_color ) .';
}';


echo "\n/*----------- Search Style----------- */\n";
echo '.search-form .input-group input.form-control::-webkit-input-placeholder,
.search-form .input-group input.form-control::-moz-placeholder,
.search-form .input-group input.form-control::-ms-input-placeholder,
.search-form .input-group input.form-control:-moz-placeholder {
	color: '. esc_attr( $theme_color ) .' !important;
}';
echo 'input[type="submit"] {
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Button Style----------- */\n";
echo '.btn, button , .btn.bordered:hover{
	background: '. esc_attr( $theme_color ) .';
}';
echo '.btn.classic:hover {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.btn.link {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.btn.bordered {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.btn.inverse:hover {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.btn.btn-default.theme-color {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.btn.btn-default.secondary-color {
	background: '. esc_attr( $secondary_color ) .';
}';
echo '.rev_slider_wrapper .btn.btn-outline:hover {
	background-color: '. esc_attr( $theme_color ) .';
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.rev_slider .btn.btn-default {
	border-color: '. esc_attr( $theme_color ) .' !important;
}';
echo "\n/*----------- Select Style ----------- */\n";
echo 'select:focus {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Header Styles---------------- */\n";
echo '.close:before, .close:after { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.nav-link:focus, .nav-link:hover { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.zmm-dropdown-toggle { 
	color: '. esc_attr( $theme_color ) .';
}';
echo 'ul li.theme-color a {
	color: '. esc_attr( $theme_color ) .' !important;
}';
echo "\n/*----------- Post Style----------- */\n";
echo '.top-meta ul li a.read-more, 
.bottom-meta ul li a.read-more { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.single-post-template blockquote { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.single-post .post-meta li i.before-icon::before { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.single-post .entry-meta ul li a:hover { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.post-comments-wrapper p.form-submit input {
	background-color: '. esc_attr( $theme_color ) .';
	border-color: '. esc_attr( $theme_color ) .' !important;
}';
echo '.single-post .author-info {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Post Navigation ---------*/\n";
echo '.post-navigation .nav-links .nav-next a, .post-navigation .nav-links .nav-previous a {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.post-navigation .nav-links .nav-next a:hover, .post-navigation .nav-links .nav-previous a:hover {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.custom-post-nav > .prev-nav-link > a:hover,
.custom-post-nav > .next-nav-link > a:hover {
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Calender---------------- */\n";
echo '.calendar_wrap th ,tfoot td { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.widget_calendar caption {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Archive---------------- */\n";
echo '.widget_archive li:before { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.site-footer .widget_archive li:before { 
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Tag widget---------------- */\n";
echo '.widget.widget_tag_cloud a.tag-cloud-link:hover {
	background: '. esc_attr( $theme_color ) .';
	border-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Instagram widget---------------- */\n";
echo '.null-instagram-feed p a { 
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Service Menu---------------- */\n";
echo '.widget .menu-item-object-miion-services a { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.site-footer .widget .menu-item-object-miion-services.current-menu-item a:hover {
	color: '. esc_attr( $theme_color ) .';	
}';

echo '.widget-area .widget .menu-item-object-miion-services.current-menu-item a,
 .widget-area .widget .menu-item-object-miion-services a:hover {
	border-left-color: '. esc_attr( $theme_color ) .';	
}';
echo "\n/*----------- Service Menu---------------- */\n";
echo '.widget .menu-item-object-miion-service a { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Post ---------------- */\n";
echo '.grid-layout .article-inner .top-meta a.read-more::before,
.grid-layout .article-inner .entry-footer .bottom-meta a.read-more::before,
.miion-single-post .post-comments .comment-reply-link:before,
.comment-meta .comment-reply-link:before  { 
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Post Nav---------------- */\n";
echo '.zozo_advance_tab_post_widget .nav-tabs .nav-item.show .nav-link, .widget .nav-tabs .nav-link.active { 
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Back to top---------------- */\n";
echo '.back-to-top > i { 
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Shortcodes---------------- */\n";
echo '.entry-title a:hover { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.title-separator.separator-border { 
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.section-title-wrapper .title-wrap > .sub-title::before { 
	background-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Twitter---------------- */\n";
echo '.twitter-3 .tweet-info { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.twitter-wrapper.twitter-dark a { 
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*----------- Pricing table---------------- */\n";
echo '.price-text { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.pricing-style-1.pricing-list-active .pricing-inner-wrapper,
.pricing-style-1 .btn-default:hover { 
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.pricing-style-1 .pricing-table-info .price-text,
.pricing-style-1 .pricing-table-info > .price-before {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.pricing-style-3 .pricing-inner-wrapper,
.pricing-style-1 .btn-default:hover { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.pricing-style-2 .price-text p { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.pricing-style-3 .pricing-title::before,
.pricing-style-3 .pricing-title::after,
.pricing-style-2 .pricing-table-info:after,
.pricing-style-3 ul.pricing-features-list li:before { 
	background-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Call To Action ---------------- */\n";
echo '.theme-gradient-bg {
	background: -webkit-linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%) !important;
	background: linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%) !important;
}';
echo "\n/*-----------Compare Pricing table---------------- */\n";
echo '.compare-pricing-wrapper .pricing-table-head, .compare-features-wrap { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.compare-pricing-style-3.compare-pricing-wrapper .btn:hover { 
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Counter Style---------------- */\n";
echo '.counter-wrapper.dashed-secondary-color.counter-style-1 {
    border-color: '. esc_attr( $theme_color ) .';
}';
echo '.counter-wrapper.dashed-theme-color.counter-style-1 {
    border-color: '. esc_attr( $theme_color ) .';
}';
echo '.counter-value span.counter-suffix {
    color: '. esc_attr( $theme_color ) .';
}';
echo '.counter-wrapper.counter-style-2 .counter-value h3 { 
	background: -webkit-linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%);
	background: linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%);
	-webkit-background-clip: text;
	-webkit-text-fill-color: transparent;
}';

echo "\n/*-----------day Style---------------- */\n";
echo '.day-counter-modern .day-counter > *:after {
    background: rgba('. esc_attr( $rgb ) .', 0.1);
}';
echo "\n/*-----------day Style---------------- */\n";
echo 'span.typing-text,
.typed-cursor {
    color: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Testimonials---------------- */\n";
echo '.testimonial-light .client-name:hover { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.testimonial-wrapper.testimonial-1 a.client-name:hover,
.testimonial-wrapper.testimonial-1 .client-designation { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.testimonial-wrapper.testimonial-1 .testimonial-inner::after,
.testimonial-wrapper.testimonial-modern .testimonial-inner:after,
.testimonial-wrapper.testimonial-default .owl-item .testimonial-inner,
.testimonial-list .testimonial-list-item .testimonial-thumb:before,
.single-miion-testimonial .testimonial-info .testimonial-img:before { 
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.miion-content .testimonial-2 .testimonial-inner:hover, .miion-content .testimonial-2 .testimonial-inner:hover .testimonial-thumb img {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.testimonial-wrapper.testimonial-3 .testimonial-inner .testimonial-info .client-name, 
.testimonial-wrapper.testimonial-3 .testimonial-inner .testimonial-excerpt .testimonial-excerpt-icon i,.testimonial-wrapper.testimonial-default .testimonial-inner > *.testimonial-excerpt:before { 
	color: '. esc_attr( $theme_color ) .' !important;
}';
echo "\n/*-----------Events---------------- */\n";
echo '.events-date { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.event-inner .event-schedule-inner .tab-content i {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.event-details-wrap ul li:before {
	background: -webkit-linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%);
    background: linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%);
}';
echo '.event-details-wrap ul li:after {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.event-info h4, .event-venue h4, .event-contact-title h4, .event-contact h4, .event-map h4 {
	background: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Pagination---------------- */\n";
echo '.nav.pagination > li.nav-item.active a,
.nav.pagination > li.nav-item span,
.nav.pagination > li.nav-item a,
.nav.pagination > li.nav-item:focus a {
	background: '. esc_attr( $theme_color ) .';
	border-color: '. esc_attr( $theme_color ) .';
}';

echo '.miion-sticky-wrapper.text_trigger a,a.miion-sticky-trigger {
	background: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Team---------------- */\n";
echo '.team-wrapper.team-default .team-inner .team-designation h6,
.team-info .team-title h2,.team-default .client-name { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.team-modern .team-name a::after,
span.animate-bubble-box:before{ 
	background: '. esc_attr( $theme_color ) .';
	filter: drop-shadow(0px 1px 2px rgba('. esc_attr( $rgb ) .', 0.5));
}';
echo 'span.animate-bubble-box:after { 
	background: '. esc_attr( $theme_color ) .';
	filter: drop-shadow(0px 1px 2px rgba('. esc_attr( $rgb ) .', 0.5));
}';

echo 'span.animate-bubble-box { 	
	box-shadow: 0px 0px 1px 0px rgba('. esc_attr( $rgb ) .',0.1), 0px 0px 1px 0px rgba('. esc_attr( $rgb ) .',0.1) inset;
}';



echo '.team-wrapper.team-modern .team-inner > .team-thumb { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.team-wrapper.team-modern .team-inner:hover > .team-designation h6 { 
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Timeline---------------- */\n";
echo '.timeline-style-2 .timeline > li > .timeline-panel { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.timeline-sep-title { 
	color: '. esc_attr( $theme_color ) .';
}';

echo '.timeline-style-2 .timeline > li > .timeline-panel:before { 
	border-left-color: '. esc_attr( $theme_color ) .';
	border-right-color: '. esc_attr( $theme_color ) .';
}';
echo '.timeline-style-2 .timeline > li > .timeline-panel:after { 
	border-left-color: '. esc_attr( $theme_color ) .';
	border-right-color: '. esc_attr( $theme_color ) .';
}';
echo '.timeline-style-3 .timeline > li > .timeline-sep-title { 
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Timeline Slide---------------- */\n";
echo '.cd-horizontal-timeline .events { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.cd-horizontal-timeline .events a.selected::after { 
	background-color: '. esc_attr( $theme_color ) .';
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.cd-timeline-navigation a { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.cd-horizontal-timeline .events-content em { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.cd-horizontal-timeline .events-content li { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.cd-horizontal-timeline .events-content li .tl-triangle { 
	border-bottom-color: '. esc_attr( $theme_color ) .';
}';
echo '.cd-horizontal-timeline .events-content li > h2 { 
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Portfolio---------------- */\n";
echo '.portfolio-wrapper.portfolio-style-modern .post-overlay-items a:hover,
.portfolio-meta-list>li a:hover {
	color: '. esc_attr( $theme_color ) .' !important;
}';
echo '.portfolio-masonry-layout .portfolio-angle .portfolio-title h4:after {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-style-classic .post-overlay-items > .portfolio-popup-icon a,
.portfolio-style-classic .post-overlay-items > .portfolio-link-icon a,
.portfolio-style-modern .post-overlay-items> .portfolio-link-icon a,
.portfolio-style-modern .post-overlay-items> .portfolio-popup-icon a {
	 background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-default .portfolio-wrap .portfolio-content-wrap {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-default .portfolio-overlay .portfolio-title a:after {
	background-color: rgba('. esc_attr( $rgb ) .', 0.5);
}';
echo '.portfolio-style-default .portfolio-link-icon a,
.portfolio-style-default .portfolio-popup-icon a {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-classic .portfolio-wrap .portfolio-content-wrap .portfolio-read-more a,
.portfolio-angle .portfolio-wrap .portfolio-content-wrap .portfolio-read-more a {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-classic .portfolio-wrap .portfolio-content-wrap .portfolio-read-more a:hover,
.portfolio-angle .portfolio-wrap .portfolio-content-wrap .portfolio-read-more a:hover {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-single.portfolio-model-2 .portfolio-details .portfolio-meta-wrap {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-model-4 .portfolio-info .portfolio-meta .portfolio-meta-list > li ul.portfolio-categories a:hover {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.single-miion-portfolio .portfolio-title h3::after,
.single-miion-portfolio .portfolio-related-slider h4::after,
.portfolio-related-slider .related-title {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-creative .portfolio-wrap:hover .portfolio-content-wrap {
	background-color: '. esc_attr( $theme_color ) .';
}';
/*Meta Icon*/
echo 'span.portfolio-meta-icon {
	color: '. esc_attr( $theme_color ) .';
}';
/*CPT Filter Styles*/
echo '.portfolio-filter.filter-1 ul > li.active > a, .portfolio-filter.filter-1 ul > li > a:hover {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-filter.filter-1 ul > li > a, .portfolio-filter.filter-1 ul > li > a:hover {
	border: solid 1px '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-filter.filter-1 ul > li > a {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-filter.filter-1 a.portfolio-filter-item {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-masonry-layout .portfolio-classic .portfolio-content-wrap {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-filter.filter-2 .active a.portfolio-filter-item {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-filter.filter-2 li a:after {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-slide .portfolio-content-wrap {
	background: '. esc_attr( $theme_color ) .';
}'; 
echo '.portfolio-minimal .portfolio-overlay-wrap:before,
.portfolio-minimal .portfolio-overlay-wrap:after { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-classic .portfolio-overlay-wrap:before {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-archive-title a:hover {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-filter.filter-3 a.portfolio-filter-item {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.portfolio-filter.filter-3 li.active a.portfolio-filter-item {
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Feature Box---------------- */\n";
echo '.icon-theme-color { 
	color: '. esc_attr( $theme_color ) .';
}';

echo '.feature-box-wrapper .btn.bordered:hover {
    border-color: '. esc_attr( $theme_color ) .';
}';

echo '.feature-box-wrapper.feature-ser:hover .feature-box-btn .btn.link,
.feature-box-wrapper.feature-ser:hover .feature-box-btn .btn.link:after {
    color: '. esc_attr( $theme_color ) .';
}';

echo '.feature-ser:hover .feature-box-btn .btn.link::after {
	background: '. esc_attr( $theme_color ) .';
}';


echo '.feature-box-wrapper.border-hover-color:hover {
    border-bottom-color: '. esc_attr( $theme_color ) .' !important;
}';
echo '.feature-box-wrapper > .feature-box-title .section-title .title-bottom-line {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.feature-box-btn .btn.link {
    color: '. esc_attr( $theme_color ) .';
}';
echo '.feature-box-btn .btn.link::after {
    color: '. esc_attr( $theme_color ) .';
}';
echo '.feature-box-wrapper.radius-design:hover,
.feature-box-wrapper.radius-design.section-active {
	background-color: '. esc_attr( $theme_color ) .' !important;
	border-color: '. esc_attr( $theme_color ) .' !important;
}';
echo '.feature-box-wrapper.radius-design .invisible-number {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.feature-box-style-1 .feature-box-btn .btn.link:hover, 
.feature-box-style-1 .feature-box-btn .btn.link:hover::after {
    color: '. esc_attr( $theme_color ) .';
}';
echo '.feature-box-style-2:hover {
    background-color: '. esc_attr( $theme_color ) .';
}';
echo '.feature-box-style-3 .invisible-number {
    color: '. esc_attr( $theme_color ) .';
}';
echo '.feature-box-style-3::after {
    background-color: '. esc_attr( $theme_color ) .';
}';
if( $secondary_color ){
	echo '.feature-box-wrapper:hover .feature-box-icon.theme-hcolor-bg {
		background: -webkit-linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%);
		background: linear-gradient(-150deg, '. esc_attr( $secondary_color ) .' 35%, '. esc_attr( $theme_color ) .' 65%);
	}';
}else{
	echo '.feature-box-wrapper:hover .feature-box-icon.theme-hcolor-bg {
		background-color: '. esc_attr( $theme_color ) .';
	}';
}
echo "\n/*-----------Flipbox---------------- */\n";
echo "[class^='imghvr-shutter-out-']:before, [class*=' imghvr-shutter-out-']:before,
[class^='imghvr-shutter-in-']:after, [class^='imghvr-shutter-in-']:before, [class*=' imghvr-shutter-in-']:after, [class*=' imghvr-shutter-in-']:before,
[class^='imghvr-reveal-']:before, [class*=' imghvr-reveal-']:before {
	background-color: ". esc_attr( $theme_color ) .";
}";

echo "\n/*-----------Flipbox---------------- */\n";
echo '.image-grid-inner:after {
	background: '. esc_attr( $theme_color ) .';
}';


echo "\n/*-----------Services---------------- */\n";
echo '.service-wrapper a.read-more.btn {
	color: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Hove Box---------------- */\n";
echo '.active .round-tab-head {
	background-image: -webkit-linear-gradient(0deg, '. esc_attr( $theme_color ) .' 0%, rgba('. esc_attr( $rgb ) .',0.4) 100%);	
}';
echo "\n/*-----------Blog---------------- */\n";
echo '.top-meta ul li i, .bottom-meta ul li i { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.blog-style-3 .post-thumb { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.blog-wrapper .blog-inner .top-meta a.read-more::before,
.blog-wrapper .blog-inner .bottom-meta a.read-more::before,
 article.post .bottom-meta a.read-more::before,
 .services-read-more .read-more::before { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.blog-wrapper .blog-inner .top-meta a.read-more::after, .blog-wrapper .blog-inner .bottom-meta a.read-more::after,.services-read-more .read-more::after { 
	background: -webkit-linear-gradient(left, '. esc_attr( $theme_color ) .' 0%,rgba(237,66,102,0) 100%);
	background: linear-gradient(to right, '. esc_attr( $theme_color ) .' 0%,rgba(237,66,102,0) 100%);
	background: -moz-linear-gradient(left, '. esc_attr( $theme_color ) .' 0%,rgba(237,66,102,0) 100%);
}';
echo '.sticky-date .post-date,
.miion-toggle-post-wrap .switch input:checked + .slider {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.miion-toggle-post-wrap .switch input:focus + .slider {
	box-shadow: 0 0 1px '. esc_attr( $theme_color ) .';
}';
echo '.blog-style-classic-pro .post-date a,
.blog-style-list .post-date a { 
	background: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Contact Info---------------- */\n";
echo '.contact-widget-info > p > span:before,
.contact-info-wrapper .icons::before {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.contact-info-wrapper.contact-info-style-2 .contact-mail a:hover { 
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Contact Form---------------- */\n";
echo '.contact-form-wrapper .wpcf7 input[type="submit"],
.wpcf7 input[type="submit"] {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.contact-form-grey .wpcf7 input.wpcf7-submit, 
.contact-form-classic .wpcf7 input[type="submit"] {
	background: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Contact Form---------------- */\n";
echo '.content-carousel-wrapper .owl-nav > *:hover  {
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Shape Arrow---------------- */\n";
echo '.shape-arrow .wpb_column:nth-child(2) .feature-box-wrapper, 
.shape-arrow .wpb_column:last-child .feature-box-wrapper { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.shape-arrow .wpb_column:first-child .feature-box-wrapper::before,
.shape-arrow .wpb_column:nth-child(3) .feature-box-wrapper::before { 
	border-top-color: '. esc_attr( $theme_color ) .';
	border-bottom-color: '. esc_attr( $theme_color ) .';
}';
echo '.shape-arrow .wpb_column .feature-box-wrapper::before,
.shape-arrow .wpb_column .feature-box-wrapper::after,
.shape-arrow .wpb_column:nth-child(2) .feature-box-wrapper::before,
.shape-arrow .wpb_column:nth-child(2) .feature-box-wrapper::after,
.shape-arrow .wpb_column:last-child .feature-box-wrapper::before, 
.shape-arrow .wpb_column:last-child .feature-box-wrapper::after { 
	border-left-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Booking Calendar Form---------------- */\n";
echo '.wpbc_booking_form_structure .wpbc_structure_form .form-group .btn-default {
	background: -webkit-linear-gradient(-144deg, '. esc_attr( $secondary_color ) .' 15%, '. esc_attr( $theme_color ) .' 85%);
	background: linear-gradient(-144deg, '. esc_attr( $secondary_color ) .' 15%, '. esc_attr( $theme_color ) .' 85%);
}';
echo "\n/*-----------Woocommerce---------------- */\n";
echo '.woocommerce p.stars a { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce .product .onsale { 
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce ul.products li.product .price, .woocommerce .product .price, 
.woocommerce .product .price ins, .woocommerce.single .product .price ins { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce div.product .product_title {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce .product .button, 
.woocommerce.single .product .button,
.woocommerce #review_form #respond .form-submit input,
.woocommerce button.button,
.woocommerce button.button.disabled,
.woocommerce button.button.alt.disabled,
.woocommerce ul.products li.product .woo-thumb-wrap .button:hover,
.woocommerce ul.products li.product .woo-thumb-wrap .added_to_cart,
.woocommerce ul.products li.product .woo-thumb-wrap .added_to_cart:hover {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce .widget_price_filter .ui-slider .ui-slider-range { 
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.dropdown-menu.cart-dropdown-menu .mini-view-cart a, .miion-sticky-cart .mini-view-cart a, .dropdown-menu.wishlist-dropdown-menu .mini-view-wishlist a, .miion-sticky-wishlist .mini-view-wishlist a {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce #content input.button, .woocommerce #respond input#submit, 
.woocommerce a.button, .woocommerce button.button, .woocommerce input.button, 
.woocommerce-page #content input.button, .woocommerce-page #respond input#submit, 
.woocommerce-page a.button, .woocommerce-page button.button, .woocommerce-page input.button,
.woocommerce input.button.alt, .woocommerce input.button.disabled, .woocommerce input.button:disabled[disabled],
.cart_totals .wc-proceed-to-checkout a.checkout-button,
.woocommerce button.button.alt {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce-info,
.woocommerce-message {
	border-top-color: '. esc_attr( $theme_color ) .';
}';
echo '.woocommerce-info::before,
.woocommerce-message::before {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.form-control:focus {
	border-color: '. esc_attr( $theme_color ) .' !important;
}';
echo '.woocommerce nav.woocommerce-pagination ul li,
.woocommerce nav.woocommerce-pagination ul li a:active, 
.woocommerce nav.woocommerce-pagination ul li a:focus{
	background-color: '. esc_attr( $theme_color ) .';
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.woo-top-meta select {     background-image: url('. esc_url( MIION_ASSETS . '/images/icon-select.png' ) .'); }';

echo "\n/*-----------Widget---------------- */\n";
echo '.widget-area .widget-title::after {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.widget_categories ul li a:before, 
.widget_meta ul li a:before {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.widget_categories ul li a:hover,
.widget_meta ul li a:hover,
.widget_archive ul li a:hover,
.widget_recent_entries ul li a:hover,
.widget-area .widget_pages li a:hover,
.widget_recent_entries ul li > .post-date {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.miion_latest_post_widget li a:hover, 
.miion_popular_post_widget li a:hover {
	color: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Mailchimp Widget---------------- */\n";
echo '.anim .popup-video-post.popup-trigger-icon:after,
.anim .popup-video-post.popup-trigger-icon:before,
.anim .popup-video-post.popup-trigger-icon,
span.popup-modal-dismiss.ti-close,
.contact-info-wrapper .contact-info-title:after {
	background-color: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Modal Box---------------- */\n";
echo 'a.modal-box-trigger.modal-trigger-icon {
	color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Rounded Tab---------------- */\n";
echo '.round-tab-wrapper,.elementor-widget-container.round-tab-wrapper:after,
 .elementor-widget-container.round-tab-wrapper:before {
	border-color: '. esc_attr( $theme_color ) .';
}';


echo "\n/*-----------Mailchimp Widget---------------- */\n";
echo '.miion_mailchimp_widget input.zozo-mc.btn {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.mailchimp-wrapper.mailchimp-light .input-group .input-group-btn .mc-submit-btn {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo "\n/*-----------Footer---------------- */\n";
echo '.widget .footer-info .media::before {
	color : '. esc_attr( $theme_color ) .';
}';
echo '.custom-top-footer .primary-bg {
	background-color: '. esc_attr( $theme_color ) .';
}';
echo '.custom-top-footer .secondary-bg {
	background-color: '. esc_attr( $secondary_color ) .';
}';
echo '.current_page_item a { 
	color: '. esc_attr( $theme_color ) .';
}';
echo '.mptt-shortcode-wrapper ul.mptt-menu.mptt-navigation-tabs li.active a, .mptt-shortcode-wrapper ul.mptt-menu.mptt-navigation-tabs li:hover a { 
	border-color: '. esc_attr( $theme_color ) .';
}';

echo '.booking_form .datepick-inline .calendar-links,
.booking_form .datepick-inline td.datepick-days-cell.date2approve {
	background: '. esc_attr( $theme_color ) .';
}';
echo 'ul.social-icons.social-hbg-theme > li a:hover {
	background: '. esc_attr( $theme_color ) .';
}';
echo '.woo-icon-count {
	background: '. esc_attr( $theme_color ) .';
}';
echo 'footer .widget .btn.link.before-icon { 
	color: '. esc_attr( $theme_color ) .';
}';

echo "\n/*-----------Related Slider---------------- */\n";
echo '.related-slider-content-wrap:hover .related-slider-content {
	background: rgba('. esc_attr( $rgb ) .', 0.8);
}';

echo "\n/*-----------404---------------- */\n";
echo '.error-404-area .page-title-default .breadcrumb a:hover { 
	color: '. esc_attr( $theme_color ) .';
}';

echo '@media only screen and (max-width : 991px) {
.bg-after-991 {
	background: '. esc_attr( $theme_color ) .';
}	
}';
echo "\n/*-----------Custom---------------- */\n";
echo '.post-comments span.author {
	color: '. esc_attr( $theme_color ) .';
}';
echo '.page-links > span.page-number,
a span.page-number:hover,
a span.page-number:active,
a span.page-number:focus {
	border-color: '. esc_attr( $theme_color ) .';
}';
echo 'span.page-number,
a span.page-number:hover {
	background: '. esc_attr( $theme_color ) .';
}';

echo "\n/*----------- Gutenberg ---------------- */\n";
echo '.wp-block-button__link,.wp-block-file .wp-block-file__button { 
	background: '. esc_attr( $theme_color ) .';
}';
echo '.wp-block-quote,blockquote.wp-block-quote.is-style-large,
.wp-block-quote[style*="text-align:right"], .wp-block-quote[style*="text-align: right"] { 
	border-color: '. esc_attr( $theme_color ) .';
}';
echo '.is-style-outline { 
	color: '. esc_attr( $theme_color ) .';
}';