<?php
/**
 * Enqueue Google Web Fonts.
 */
function miion_theme_default_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'miion' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Poppins:400,600&amp;subset=latin' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}
function miion_enqueue_google_web_fonts() {
	wp_enqueue_style( 'miion-google-fonts', miion_theme_default_fonts_url(), array(), null, 'all' );
}
function miion_default_theme_options(){
	$cur_theme = wp_get_theme();	
	if ( $cur_theme->get( 'Name' ) == 'Miion' || $cur_theme->get( 'Name' ) == 'Miion Child' ){
		$input_val = miion_default_theme_values();
		$miion_default_options = json_decode( $input_val, true );
		update_option( 'miion_theme_options_new', $miion_default_options );
	}
}

function miion_set_google_fonts(){
	if( !class_exists( "MiionThemeStyles" ) ){
		require_once MIION_INC . '/theme-class/theme-style-class.php';
	}
	//Save Google Fonts
	$ats = new MiionThemeStyles;
	$ats->miion_typo_generate( 'body-typography' );
	$ats->miion_typo_generate( 'h1-typography' );
	$ats->miion_typo_generate( 'h2-typography' );
	$ats->miion_typo_generate( 'h3-typography' );
	$ats->miion_typo_generate( 'h4-typography' );
	$ats->miion_typo_generate( 'h5-typography' );
	$ats->miion_typo_generate( 'h6-typography' );
	$ats->miion_typo_generate( 'widgets-content' );
	$ats->miion_typo_generate( 'widgets-title' );
	$ats->miion_typo_generate( 'header-topbar-typography' );
	$ats->miion_typo_generate( 'header-logobar-typography' );
	$ats->miion_typo_generate( 'header-navbar-typography' );
	$ats->miion_typo_generate( 'secondary-space-typography' );
	$ats->miion_typo_generate( 'header-fixed-typography' );
	$ats->miion_typo_generate( 'mobile-menu-typography' );
	$ats->miion_typo_generate( 'top-sliding-typography' );
	$ats->miion_typo_generate( 'main-menu-typography' );
	$ats->miion_typo_generate( 'dropdown-menu-typography' );
	$ats->miion_typo_generate( 'footer-typography' );
	$ats->miion_typo_generate( 'footer-top-typography' );
	$ats->miion_typo_generate( 'footer-middle-typography' );
	$ats->miion_typo_generate( 'footer-bottom-typography' );
	
	update_option( 'miion_custom_google_fonts', MiionThemeStyles::$embrad_gf_array );
	$google_fonts = get_option( 'miion_custom_google_fonts' );
	return $google_fonts;
}

function miion_default_font_and_styles( $return = false ){
	
	//Set google fonts
	miion_set_google_fonts();
	
	$custom_css = miion_get_dynamic_styles();
	update_option( 'miion_theme_custom_styles', $custom_css );

}

if ( ! class_exists( 'MiionFamework' ) ) {
	add_action("after_switch_theme", "miion_default_theme_options", 10);
	add_action("after_switch_theme", "miion_default_font_and_styles", 900);
	add_action( 'wp_enqueue_scripts', 'miion_enqueue_google_web_fonts' );
}
function miion_default_theme_values(){
	$theme_opt_def =  '{"page-layout":"wide","site-width":"1170","page-content-padding":{"left":"","right":"","top":"","bottom":""},"cpt-opts":["portfolio","team","testimonial","events","services"],"page-loader":"1","page-loader-img":{"id":"9641","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/09\/lg.ball-swing-preloader-gif.gif"},"infinite-loader-img":{"id":"","url":""},"logo":{"id":"6044","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/07\/logo.png"},"sticky-logo":{"id":"6044","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/07\/logo.png"},"mobile-logo":{"id":"6044","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/07\/logo.png"},"mailchimp-api":"25ca1be75621ff1722f3df3e5e1f5976471174c9c97333f6093487ca33-us982dc57-us14","google-api":"AIzaSyD1x_aF8IGXLev81GnJm1B1hX2Ug_Ud8No","comments-type":"wp","comments-like":"0","comments-share":"0","fb-developer-key":"","fb-comments-number":"5","smooth-opt":"1","scroll-time":"600","scroll-distance":"40","miion-grid-large":{"width":"440","height":"260"},"miion-grid-small":{"width":"220","height":"130"},"miion-team-medium":{"width":"300","height":"300"},"rtl":"0","theme-color":"#e9204f","secondary-color":"#e9204f","theme-link-color":{"regular":"#000000","hover":"#e9204f","active":"#e9204f"},"body-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"body-typography":{"font_family":"Poppins","font_weight":"400","font_sub":"latin","text_align":"","text_transform":"","font_size":"14","line_height":"27","letter_spacing":"","font_color":"#8d9297"},"h1-typography":{"font_family":"Poppins","font_weight":"600","font_sub":"","text_align":"","text_transform":"","font_size":"36","line_height":"44","letter_spacing":"","font_color":""},"h2-typography":{"font_family":"Poppins","font_weight":"600","font_sub":"","text_align":"","text_transform":"","font_size":"30","line_height":"38","letter_spacing":"","font_color":""},"h3-typography":{"font_family":"Poppins","font_weight":"600","font_sub":"","text_align":"","text_transform":"","font_size":"28","line_height":"36","letter_spacing":"","font_color":""},"h4-typography":{"font_family":"Poppins","font_weight":"600","font_sub":"","text_align":"","text_transform":"","font_size":"23","line_height":"29","letter_spacing":"","font_color":""},"h5-typography":{"font_family":"Poppins","font_weight":"600","font_sub":"","text_align":"","text_transform":"","font_size":"20","line_height":"30","letter_spacing":"","font_color":""},"h6-typography":{"font_family":"Poppins","font_weight":"600","font_sub":"","text_align":"","text_transform":"","font_size":"16","line_height":"26","letter_spacing":"","font_color":""},"widgets-title":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"21","line_height":"","letter_spacing":"","font_color":""},"widgets-content":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#8d9297"},"main-menu-typography":{"font_family":"Poppins","font_weight":"600","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#000000"},"dropdown-menu-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"top-sliding-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"header-topbar-typography":{"font_family":"Poppins","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"header-logobar-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"header-navbar-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#000000"},"header-fixed-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"mobile-menu-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"footer-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"footer-top-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#ffffff"},"footer-middle-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"footer-bottom-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"header-layout":"wide","header-template":"custom","header-type":"default","header-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"header-items":{"Sticky":{"header-nav":"Nav Bar"},"disabled":{"header-logo":"Logo Section","header-topbar":"Top Bar"}},"header-address-label":"Address","header-address-text":"4b, Walse Street , USA","header-phone-label":"Phone","header-phone-text":" (155)56554515","header-email-label":"Email","header-email-text":"info@example.com","header-slider-position":"bottom","header-absolute":"0","sticky-part":"1","sticky-part-scrollup":"0","mainmenu-menutype":"advanced","dropdown-menu-background":"","dropdown-menu-link-color":{"regular":"#000000","hover":"#e9204f","active":"#e9204f"},"dropdown-menu-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"menu-tag":"1","menu-tag-hot-text":"Hot","menu-tag-hot-bg":"","menu-tag-new-text":"New","menu-tag-new-bg":"","menu-tag-trend-text":"Trend","menu-tag-trend-bg":"","secondary-menu":"1","secondary-menu-type":"left-push","secondary-menu-space-width":"350","header-top-sliding-switch":"0","header-top-sliding-device":["desktop","tab"],"header-top-sliding-cols":"3","header-top-sliding-sidebar-1":"","header-top-sliding-sidebar-2":"","header-top-sliding-sidebar-3":"","header-top-sliding-sidebar-4":"","top-sliding-background":"","top-sliding-link-color":{"regular":"","hover":"","active":""},"top-sliding-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"top-sliding-padding":{"left":"","right":"","top":"","bottom":""},"search-toggle-form":"3","header-topbar-height":"50","header-topbar-background":"#000000","header-topbar-link-color":{"regular":"#ffffff","hover":"#e9204f","active":"#e9204f"},"header-topbar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"header-topbar-padding":{"left":"","right":"","top":"","bottom":""},"header-topbar-text-1":"Welcome to Miion","header-topbar-text-2":"","header-topbar-text-3":"","header-topbar-date":"l, F j, Y","header-topbar-items":{"disabled":{"header-topbar-text-2":"Custom Text 2","header-topbar-text-3":"Custom Text 3","header-topbar-search":"Search","header-cart":"Cart","header-topbar-date":"Date","header-topbar-search-toggle":"Search Toggle","header-topbar-menu":"Top Bar Menu","header-topbar-social":"Social"},"Left":{"header-topbar-text-1":"Custom Text 1"},"Right":{"header-address":"Address Text","header-phone":"Phone Number","header-email":"Email"}},"header-logobar-height":"100","header-logobar-sticky-height":"80","header-logobar-background":"","header-logobar-link-color":{"regular":"","hover":"","active":""},"header-logobar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"header-logobar-padding":{"left":"","right":"","top":"","bottom":""},"sticky-header-logobar-color":"","sticky-header-logobar-background":"","sticky-header-logobar-link-color":{"regular":"","hover":"","active":""},"sticky-header-logobar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"sticky-header-logobar-padding":{"left":"","right":"","top":"","bottom":""},"header-logobar-text-1":"4b, Walse Street , USA","header-logobar-text-2":" (155)56554515","header-logobar-text-3":"info@example.com","header-logobar-items":{"disabled":{"header-logobar-secondary-toggle":"Secondary Toggle","header-logobar-menu":"Main Menu","header-logobar-search-toggle":"Search Toggle","header-cart":"Cart","header-phone":"Phone Number","header-address":"Address Text","header-logobar-sticky-logo":"Sticky Logo","header-email":"Email","header-logobar-text-1":"Custom Text 1","header-logobar-text-3":"Custom Text 3","header-logobar-search":"Search","header-logobar-social":"Social","header-logobar-text-2":"Custom Text 2"},"Left":{"header-logobar-logo":"Logo"},"Right":{"multi-info":"Address, Phone, Email"}},"header-navbar-height":"80","header-navbar-sticky-height":"70","header-navbar-background":"#ffffff","header-navbar-link-color":{"regular":"#000000","hover":"#e9204f","active":"#e9204f"},"header-navbar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"header-navbar-padding":{"left":"","right":"","top":"","bottom":""},"sticky-header-navbar-color":"#000000","sticky-header-navbar-link-color":{"regular":"","hover":"","active":""},"sticky-header-navbar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"sticky-header-navbar-padding":{"left":"","right":"","top":"","bottom":""},"header-navbar-text-1":"","header-navbar-text-2":"","header-navbar-text-3":"","header-navbar-items":{"disabled":{"header-navbar-text-1":"Custom Text 1","header-navbar-text-2":"Custom Text 2","header-navbar-text-3":"Custom Text 3","header-navbar-social":"Social","header-navbar-search":"Search","header-phone":"Phone Number","header-cart":"Cart","header-address":"Address Text","header-navbar-secondary-toggle":"Secondary Toggle","header-email":"Email","header-wishlist":"Wishlist"},"Left":{"header-navbar-logo":"Logo","header-navbar-sticky-logo":"Stikcy Logo"},"Right":{"header-navbar-menu":"Main Menu","header-navbar-search-toggle":"Search Toggle"}},"header-fixed-width":"350","header-fixed-link-color":{"regular":"","hover":"","active":""},"header-fixed-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"header-fixed-padding":{"left":"","right":"","top":"","bottom":""},"header-fixed-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"header-fixed-text-1":"","header-fixed-text-2":"","header-fixed-items":{"disabled":{"header-fixed-text-1":"Custom Text 1","header-fixed-text-2":"Custom Text 2","header-fixed-search":"Search Form","header-fixed-social":"Social"},"Top":{"header-fixed-logo":"Logo"},"Middle":{"header-fixed-menu":"Menu"}},"mobile-topbar-opt":"0","mobile-topbar-text-1":"","mobile-header-from":"1025","mobile-header-from-custom":"767","mobile-header-height":"60","mobile-header-background":"#ffffff","mobile-header-link-color":{"regular":"","hover":"","active":""},"mobile-header-sticky":"1","mobile-header-sticky-scrollup":"0","mobile-header-sticky-height":"60","mobile-header-sticky-background":"#ffffff","mobile-header-sticky-link-color":{"regular":"","hover":"","active":""},"mobile-header-items":{"disabled":{"mobile-header-cart":"Cart Icon"},"Left":{"mobile-header-menu":"Menu Icon"},"Center":{"mobile-header-logo":"Logo"},"Right":{"mobile-header-search":"Search Icon"}},"mobile-menu-max-width":"","mobile-menu-link-color":{"regular":"","hover":"","active":""},"mobile-menu-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"mobile-menu-padding":{"left":"","right":"","top":"","bottom":""},"mobile-menu-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"mobile-menu-animate-from":"left","mobile-menu-text-1":"","mobile-menu-text-2":"","mobile-menu-items":{"disabled":{"mobile-menu-text-1":"Custom Text 1","mobile-menu-text-2":"Custom Text 2","mobile-menu-social":"Social"},"Top":{"mobile-menu-logo":"Logo"},"Middle":{"mobile-menu-mainmenu":"Menu"},"Bottom":{"mobile-menu-search":"Search Form"}},"footer-layout":"wide","footer-template":"custom","back-to-top":"1","back-to-top-position":"right","hidden-footer":"0","footer-link-color":{"regular":"","hover":"","active":""},"footer-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"footer-padding":{"left":"","right":"","top":"","bottom":""},"footer-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"footer-background-overlay":"","footer-items":{"Enabled":{"footer-top":"Footer Top","footer-middle":"Footer Middle","footer-bottom":"Footer Bottom"}},"footer-top-container":"boxed","footer-top-layout":"6-6","footer-top-sidebar-1":"zozo-custom-footer-top-1","footer-top-sidebar-2":"zozo-custom-footer-top-2","footer-top-sidebar-3":"","footer-top-sidebar-4":"","footer-top-sidebar-5":"","footer-top-link-color":{"regular":"","hover":"","active":""},"footer-top-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"footer-top-padding":{"left":"15","right":"15","top":"40","bottom":"40"},"footer-top-margin":{"left":"","right":"","top":"","bottom":"-60"},"footer-top-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"5472","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/05\/footer-top-1-1.jpg"},"bg_color":"","bg_transparent":""},"footer-top-background-overlay":"","footer-top-title-color":"#ffffff","footer-middle-container":"wide","footer-middle-layout":"3-3-3-3","footer-middle-sidebar-1":"sidebar-2","footer-middle-sidebar-2":"sidebar-3","footer-middle-sidebar-3":"sidebar-4","footer-middle-sidebar-4":"sidebar-5","footer-middle-sidebar-5":"","footer-middle-link-color":{"regular":"#8d9297","hover":"#e9204f","active":"#e9204f"},"footer-middle-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"footer-middle-padding":{"left":"","right":"","top":"140","bottom":""},"footer-middle-margin":{"left":"","right":"","top":"0px","bottom":""},"footer-middle-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"footer-middle-background-overlay":"","footer-middle-title-color":"#ffffff","footer-bottom-container":"wide","copyright-text":"Copyright 2019 Theme by <a href=\"https:\/\/zozothemes.com\/\" target=\"_blank\">zozothemes<\/a>","footer-bottom-fixed":"0","footer-bottom-widget":"","footer-bottom-items":{"disabled":{"social":"Footer Social Links","menu":"Footer Menu","widget":"Custom Widget"},"Center":{"copyright":"Copyright Text"}},"footer-bottom-link-color":{"regular":"#e9204f","hover":"#e9204f","active":"#ffffff"},"footer-bottom-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"footer-bottom-padding":{"left":"","right":"","top":"","bottom":""},"footer-bottom-margin":{"left":"","right":"","top":"","bottom":""},"footer-bottom-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"footer-bottom-background-overlay":"","footer-bottom-title-color":"","search-content":"all","page-page-title-opt":"1","template-page-color":"#ffffff","template-page-link-color":{"regular":"#e9204f","hover":"#e9204f","active":"#e9204f"},"template-page-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-page-padding":{"left":"","right":"","top":"90","bottom":"0"},"template-page-background-all":{"bg_repeat":"","bg_size":"cover","bg_attachment":"","bg_position":"","bg_media":{"id":"5418","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/04\/page-title-bar-1-1.jpg"},"bg_color":"","bg_transparent":""},"page-page-title-parallax":"1","page-page-title-bg":"1","page-page-title-video":"","page-page-title-overlay":"","template-page-page-title-items-opt":"1","template-page-pagetitle-items":{"Left":{"breadcrumb":"Breadcrumb","title":"Page Title Text"}},"page-page-template":"no-sidebar","page-left-sidebar":"","page-right-sidebar":"sidebar-1","page-sidebar-sticky":"1","page-page-hide-sidebar":"1","blog-page-title-opt":"1","template-blog-color":"#ffffff","template-blog-link-color":{"regular":"#e9204f","hover":"#e9204f","active":"#e9204f"},"template-blog-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-blog-padding":{"left":"","right":"","top":"90","bottom":"0"},"template-blog-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"5418","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/04\/page-title-bar-1-1.jpg"},"bg_color":"","bg_transparent":""},"blog-page-title-parallax":"1","blog-page-title-bg":"0","blog-page-title-video":"","blog-page-title-overlay":"","blog-page-title":"Latest Posts","blog-page-desc":"","template-blog-page-title-items-opt":"0","template-blog-pagetitle-items":{"disabled":{"description":"Page Title Description"},"Left":{"breadcrumb":"Breadcrumb","title":"Page Title Text"}},"blog-featured-slider":"0","blog-article-color":"","blog-article-link-color":{"regular":"","hover":"","active":""},"blog-article-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"blog-article-padding":{"left":"","right":"","top":"","bottom":""},"blog-article-background":"","blog-video-format":"onclick","blog-quote-format":"featured","blog-link-format":"featured","blog-gallery-format":"default","blog-page-template":"right-sidebar","blog-left-sidebar":"sidebar-1","blog-right-sidebar":"sidebar-1","blog-sidebar-sticky":"0","blog-page-hide-sidebar":"1","blog-post-template":"grid","blog-top-standard-post":"0","blog-grid-cols":"2","blog-grid-gutter":"33","blog-grid-type":"isotope","blog-infinite-scroll":"0","blog-more-text":"Read More","blog-excerpt":"15","blog-topmeta-items":{"Left":{"date":"Date"},"Right":{"category":"Category"},"disabled":{"social":"Social Share","comments":"Comments","likes":"Likes","author":"Author","views":"Views","more":"Read More","favourite":"Favourite"}},"blog-bottommeta-items":{"Left":{"more":"Read More"},"disabled":{"comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","author":"Author","views":"Views","date":"Date","favourite":"Favourite"}},"blog-items":{"Enabled":{"thumb":"Thumbnail","title":"Title","top-meta":"Top Meta","content":"Content","bottom-meta":"Bottom Meta"}},"blog-overlay-opt":"0","blog-overlay-items":{"Enabled":{"top-meta":"Top Meta"},"disabled":{"bottom-meta":"Bottom Meta","title":"Title"}},"archive-page-title-opt":"1","template-archive-color":"#ffffff","template-archive-link-color":{"regular":"#e9204f","hover":"#e9204f","active":"#e9204f"},"template-archive-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-archive-padding":{"left":"","right":"","top":"90","bottom":"0"},"template-archive-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"5418","url":""},"bg_color":"","bg_transparent":""},"archive-page-title-parallax":"1","archive-page-title-bg":"0","archive-page-title-video":"","archive-page-title-overlay":"","template-archive-page-title-items-opt":"1","template-archive-pagetitle-items":{"Left":{"breadcrumb":"Breadcrumb","title":"Page Title Text"}},"archive-featured-slider":"0","archive-article-color":"","archive-article-link-color":{"regular":"","hover":"","active":""},"archive-article-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"archive-article-padding":{"left":"","right":"","top":"","bottom":""},"archive-article-background":"","archive-video-format":"onclick","archive-quote-format":"featured","archive-link-format":"featured","archive-gallery-format":"default","archive-page-template":"right-sidebar","archive-left-sidebar":"sidebar-1","archive-right-sidebar":"sidebar-1","archive-sidebar-sticky":"0","archive-page-hide-sidebar":"1","archive-post-template":"standard","archive-top-standard-post":"0","archive-grid-cols":"2","archive-grid-gutter":"30","archive-grid-type":"normal","archive-infinite-scroll":"0","archive-more-text":"Read More","archive-excerpt":"15","archive-topmeta-items":{"Left":{"date":"Date"},"Right":{"category":"Category"},"disabled":{"social":"Social Share","comments":"Comments","likes":"Likes","author":"Author","views":"Views","more":"Read More","favourite":"Favourite"}},"archive-bottommeta-items":{"Left":{"more":"Read More"},"disabled":{"comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","author":"Author","views":"Views","date":"Date","favourite":"Favourite"}},"archive-items":{"Enabled":{"title":"Title","top-meta":"Top Meta","thumb":"Thumbnail","content":"Content","bottom-meta":"Bottom Meta"}},"archive-overlay-opt":"0","archive-overlay-items":{"Enabled":{"title":"Title"},"disabled":{"top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"single-post-page-title-opt":"1","template-single-post-color":"#ffffff","template-single-post-link-color":{"regular":"#e9204f","hover":"#e9204f","active":"#e9204f"},"template-single-post-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-single-post-padding":{"left":"","right":"","top":"90","bottom":"0"},"template-single-post-background-all":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"5418","url":""},"bg_color":"","bg_transparent":""},"single-post-page-title-parallax":"1","single-post-page-title-bg":"0","single-post-page-title-video":"","single-post-page-title-overlay":"","template-single-post-page-title-items-opt":"1","template-single-post-pagetitle-items":{"Left":{"breadcrumb":"Breadcrumb","title":"Page Title Text"}},"single-post-featured-slider":"0","single-post-article-color":"","single-post-article-link-color":{"regular":"","hover":"","active":""},"single-post-article-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"single-post-article-padding":{"left":"","right":"","top":"","bottom":""},"single-post-article-background":"","single-post-article-overlay-color":"","single-post-article-overlay-link-color":{"regular":"","hover":"","active":""},"single-post-article-overlay-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"single-post-article-overlay-padding":{"left":"","right":"","top":"","bottom":""},"single-post-article-overlay-background":"","single-post-video-format":"onclick","single-post-quote-format":"featured","single-post-link-format":"featured","single-post-gallery-format":"default","single-post-page-template":"right-sidebar","single-post-left-sidebar":"sidebar-1","single-post-right-sidebar":"sidebar-1","single-post-sidebar-sticky":"0","single-post-page-hide-sidebar":"0","single-post-full-wrap":"0","single-post-topmeta-items":{"Left":{"category":"Category","author":"Author"},"Right":{"date":"Date"},"disabled":{"social":"Social Share","author":"Author","likes":"Likes","views":"Views","tag":"Tags","favourite":"Favourite","comments":"Comments"}},"single-post-bottommeta-items":{"Left":{"tag":"Tags","comments":"Comments"},"Right":{"social":"Social Share"},"disabled":{"date":"Date","likes":"Likes","author":"Author","category":"Category","views":"Views","favourite":"Favourite"}},"single-post-items":{"Enabled":{"thumb":"Thumbnail","top-meta":"Top Meta","content":"Content","bottom-meta":"Bottom Meta"},"disabled":{"title":"Title"}},"single-post-overlay-opt":"0","single-post-overlay-items":{"Enabled":{"title":"Title"},"disabled":{"top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"single-post-page-items":{"Enabled":{"post-items":"Post Items","author-info":"Author Info","post-nav":"Post Navigation","comment":"Comment"},"disabled":{"related-slider":"Related Slider"}},"related-max-posts":"5","related-posts-filter":"category","featured-slide-items":"3","featured-slide-tab":"1","featured-slide-mobile":"1","featured-slide-scrollby":"1","featured-slide-autoplay":"0","featured-slide-center":"0","featured-slide-duration":"5000","featured-slide-smartspeed":"250","featured-slide-margin":"10","featured-slide-pagination":"0","featured-slide-navigation":"0","featured-slide-autoheight":"0","related-slide-items":"3","related-slide-tab":"1","related-slide-mobile":"1","related-slide-scrollby":"1","related-slide-autoplay":"0","related-slide-center":"0","related-slide-duration":"5000","related-slide-smartspeed":"250","related-slide-margin":"10","related-slide-pagination":"0","related-slide-navigation":"0","related-slide-autoheight":"0","blog-slide-items":"3","blog-slide-tab":"1","blog-slide-mobile":"1","blog-slide-scrollby":"1","blog-slide-autoplay":"0","blog-slide-center":"0","blog-slide-duration":"5000","blog-slide-smartspeed":"250","blog-slide-margin":"10","blog-slide-pagination":"0","blog-slide-navigation":"0","blog-slide-autoheight":"0","single-slide-items":"3","single-slide-tab":"1","single-slide-mobile":"1","single-slide-scrollby":"1","single-slide-autoplay":"0","single-slide-center":"0","single-slide-duration":"5000","single-slide-smartspeed":"250","single-slide-margin":"10","single-slide-pagination":"0","single-slide-navigation":"0","single-slide-autoheight":"0","social-icons-type":"circled","social-icons-type-footer":"circled","social-icons-fore":"white","social-icons-hfore":"h-own","social-icons-bg":"bg-own","social-icons-hbg":"hbg-white","social-fb":"","social-twitter":"","social-instagram":"","social-pinterest":"","social-gplus":"","social-youtube":"","social-vimeo":"","social-soundcloud":"","social-yahoo":"","social-tumblr":"","social-mailto":"","social-flickr":"","social-dribbble":"","social-linkedin":"","social-rss":"","team-page-template":"no-sidebar","team-left-sidebar":"","team-right-sidebar":"sidebar-1","team-title-opt":"1","cpt-team-slug":"team","cpt-team-layout":"default","maintenance-mode":"0","maintenance-type":"cs","maintenance-custom":"","maintenance-phone":"","maintenance-email":"","maintenance-address":"","mobile-topbar-items":{"disabled":{"custom-1":"Custom Text","address":"Address"},"Enabled":{"phone":"Phone","mail":"Mail"}},"comments-social-shares":{"fb":"fb","twitter":"twitter","linkedin":"linkedin","gplus":"gplus","pinterest":"pinterest"},"testimonial-page-template":"no-sidebar","testimonial-left-sidebar":"sidebar-1","testimonial-right-sidebar":"sidebar-1","testimonial-title-opt":"1","cpt-testimonial-slug":"testimonial","events-page-template":"no-sidebar","events-left-sidebar":"","events-right-sidebar":"sidebar-1","event-title-opt":"1","cpt-events-slug":"event","cpt-event-layout":"1","services-page-template":"right-sidebar","services-left-sidebar":"sidebar-1","services-right-sidebar":"zozo-custom-services-sidebar","service-title-opt":"0","cpt-services-slug":"service","portfolio-page-template":"no-sidebar","portfolio-left-sidebar":"","portfolio-right-sidebar":"sidebar-1","portfolio-title-opt":"0","cpt-portfolio-slug":"portfolio","cpt-portfolio-category-slug":"portfolio-category","cpt-portfolio-tag-slug":"portfolio-tag","portfolio-meta-items":{"Enabled":{"date":"Date","client":"Client","duration":"Duration","category":"Category","tag":"Tags","share":"Share"},"Disabled":{"estimation":"Estimation","url":"Url","place":"Place"}},"portfolio-client-label":"Client","portfolio-date-label":"Date","portfolio-duration-label":"Duration","portfolio-estimation-label":"Estimation","portfolio-place-label":"Place","portfolio-url-label":"URL","portfolio-category-label":"Category","portfolio-tags-label":"Tags","portfolio-share-label":"Share","portfolio-layout":"2","portfolio-grid-cols":"boxed","portfolio-grid-gutter":"20","portfolio-grid-type":"isotope","portfolio-related-opt":"0","portfolio-related-slide-items":"3","portfolio-related-slide-tab":"1","portfolio-related-slide-mobile":"1","portfolio-related-slide-scrollby":"1","portfolio-related-slide-autoplay":"0","portfolio-related-slide-center":"0","portfolio-related-slide-duration":"5000","portfolio-related-slide-smartspeed":"250","portfolio-related-slide-margin":"10","portfolio-related-slide-pagination":"0","portfolio-related-slide-navigation":"0","portfolio-related-slide-autoheight":"0","portfolio-single-slider-opt":"0","portfolio-single-slide-items":"3","portfolio-single-slide-tab":"1","portfolio-single-slide-mobile":"1","portfolio-single-slide-scrollby":"1","portfolio-single-slide-autoplay":"0","portfolio-single-slide-center":"0","portfolio-single-slide-duration":"5000","portfolio-single-slide-smartspeed":"250","portfolio-single-slide-margin":"10","portfolio-single-slide-pagination":"0","portfolio-single-slide-navigation":"0","portfolio-single-slide-autoheight":"0","logo-height":"50","sticky-logo-height":"45","mobile-logo-height":"45","header-topbar-sticky-height":"45","woo-page-title-opt":"1","template-woo-color":"#ffffff","template-woo-link-color":{"regular":"#ffffff","hover":"#e9204f","active":"#e9204f"},"template-woo-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-woo-padding":{"left":"","right":"","top":"90","bottom":"0"},"template-woo-background-all":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"5418","url":"http:\/\/demo.zozothemes.com\/miion\/wp-content\/uploads\/sites\/39\/2019\/04\/page-title-bar-1-1.jpg"},"bg_color":"","bg_transparent":""},"woo-page-title-parallax":"1","woo-page-title-bg":"","woo-page-title-video":"","woo-page-title-overlay":"","template-woo-page-title-items-opt":"1","template-woo-pagetitle-items":{"Left":{"breadcrumb":"Breadcrumb","title":"Page Title Text"}},"wooarchive-page-template":"no-sidebar","wooarchive-left-sidebar":"","wooarchive-right-sidebar":"","woo-shop-archive-columns":"4","woo-page-template":"no-sidebar","woo-left-sidebar":"","woo-right-sidebar":"","woo-shop-columns":"4","woo-shop-ppp":"12","woo-related-ppp":"3","woo-related-slide-items":"4","woo-related-slide-tab":"1","woo-related-slide-mobile":"1","woo-related-slide-scrollby":"1","woo-related-slide-autoplay":"1","woo-related-slide-center":"0","woo-related-slide-duration":"5000","woo-related-slide-smartspeed":"250","woo-related-slide-margin":"30","woo-related-slide-pagination":"1","woo-related-slide-navigation":"0","woo-related-slide-autoheight":"0","woo-related-slide-infinite":"0","single-product-page-title-opt":"0","template-single-color":"","template-single-link-color":{"regular":"","hover":"","active":""},"template-single-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-single-padding":{"left":"","right":"","top":"","bottom":""},"template-single-background-all":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"single-product-page-title-parallax":"0","single-product-page-title-bg":"","single-product-page-title-video":"","single-product-page-title-overlay":"","template-single-product-page-title-items-opt":"1","template-single-product-pagetitle-items":{"Left":{"title":"Page Title Text"},"Right":{"breadcrumb":"Breadcrumb"}}}'; //Here Theme Default Values
	return $theme_opt_def;
}