<?php

//Theme Option -> Skin
$theme_skin_panel = new Miion_WP_Customize_Panel( $wp_customize, 'theme_skin_panel', array(
	'title'			=> esc_html__( 'Skin', 'miion' ),
	'description'	=> esc_html__( 'These are theme skin/color options', 'miion' ),
	'priority'		=> 3,
	'panel'			=> 'miion_theme_panel'
));
$wp_customize->add_panel( $theme_skin_panel );

//General -> Theme Skin
$miion_theme_skin_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_theme_skin_section', array(
	'title'			=> esc_html__( 'Theme Skin', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for theme skin', 'miion' ),
	'priority'		=> 1,
	'panel'			=> 'theme_skin_panel'
));
$wp_customize->add_section( $miion_theme_skin_section );

//Theme Skin
$wp_customize->add_setting('ajax_trigger_miion_theme_skin_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_theme_skin_section', array(
	'section'		=> 'miion_theme_skin_section'
)));

//General -> Body Background
$miion_body_skin_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_body_skin_section', array(
	'title'			=> esc_html__( 'Body Background', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for theme body background.', 'miion' ),
	'priority'		=> 2,
	'panel'			=> 'theme_skin_panel'
));
$wp_customize->add_section( $miion_body_skin_section );

//Body Background
$wp_customize->add_setting('ajax_trigger_miion_body_skin_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_body_skin_section', array(
	'section'		=> 'miion_body_skin_section'
)));