<?php

//Maintenance Mode Option
$settings = array(
	'id'			=> 'maintenance-mode',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Maintenance Mode Option', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable maintenance mode.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Maintenance Type
$settings = array(
	'id'			=> 'maintenance-type',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Maintenance Type', 'miion' ),
	'description'	=> esc_html__( 'Select maintenance mode page coming soon or maintenance.', 'miion' ),
	'choices'		=> array(
		'cs'		=> esc_html__( 'Coming Soon', 'miion' ),
		'mn'		=> esc_html__( 'Maintenance', 'miion' ),
		'cus'		=> esc_html__( 'Custom', 'miion' )
	),
	'default'		=> 'cs',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Maintenance Custom Page
$settings = array(
	'id'			=> 'maintenance-custom',
	'type'			=> 'pages',
	'title'			=> esc_html__( 'Maintenance Custom Page', 'miion' ),
	'description'	=> esc_html__( 'Enter service slug for register custom post type.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Phone Number
$settings = array(
	'id'			=> 'maintenance-phone',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Phone Number', 'miion' ),
	'description'	=> esc_html__( 'Enter phone number shown on when maintenance mode actived', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Email Id
$settings = array(
	'id'			=> 'maintenance-email',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Email Id', 'miion' ),
	'description'	=> esc_html__( 'Enter email id shown on when maintenance mode actived', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Address
$settings = array(
	'id'			=> 'maintenance-address',
	'type'			=> 'textarea',
	'title'			=> esc_html__( 'Address', 'miion' ),
	'description'	=> esc_html__( 'Place here your address and info', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );