<?php
/*
 * The header for miion theme
 */
$ahe = new MiionHeaderElements;
$protocal = is_ssl() ? 'https' : 'http';

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="<?php echo esc_attr( $protocal ); ?>://gmpg.org/xfn/11">
<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php endif; ?>
<?php wp_head(); ?>
</head>
<?php
	$smooth_scroll = MiionThemeOpt::miionStaticThemeMod('smooth-opt');
	$scroll_time = $scroll_dist = '';
	if( $smooth_scroll ){
		$scroll_time = MiionThemeOpt::miionStaticThemeMod('scroll-time');
		$scroll_dist = MiionThemeOpt::miionStaticThemeMod('scroll-distance');
	}
	
	$res_from = MiionThemeOpt::miionStaticThemeMod('mobile-header-from');
	$res_width = $res_from == 'c' ? MiionThemeOpt::miionStaticThemeMod('mobile-header-from-custom') : $res_from;
	$res_width = $res_width ? absint( $res_width ) : 360;

	$miion_body_atts = array(
		'scroll_time' => $scroll_time,
		'scroll_dist' => $scroll_dist,
		'res_width' => $res_width,
	);
	
	if( is_page() ){
		$menu_offset = get_post_meta( get_the_ID(), 'miion_page_one_page_menu_offset', true );
		$miion_body_atts['menu_offset'] = $menu_offset ? $menu_offset : 60;
		$mobile_menu_offset = get_post_meta( get_the_ID(), 'miion_page_one_page_mobmenu_offset', true );
		$miion_body_atts['mobile_menu_offset'] = $mobile_menu_offset ? $mobile_menu_offset : 60;
	}
	
	/*
	 * Sttaic Template Options - miion_demo_header - 10
	 */
	do_action('miion_before_body_action');
?>
<body <?php body_class(); ?> data-miion="<?php echo htmlspecialchars( json_encode( $miion_body_atts ), ENT_QUOTES, 'UTF-8' ); ?>">
<?php if( $ahe->miionPageLoader() ) : ?>
	<div class="page-loader"></div>
<?php endif; ?>
<?php
	/*
	 * Mobile Header - miionMobileHeader - 10
	 * Mobile Bar - miionMobileBar - 20
	 * Secondary Menu Space - miionHeaderSecondarySpace - 30
	 * Top Sliding Bar - miionHeaderTopSliding - 40
	 */
	do_action('miion_body_action');
	
?>

<div id="page" class="miion-wrapper<?php $ahe->miionThemeLayout(); ?>">
	<?php $ahe->miionHeaderSlider('top'); ?>
	<header class="miion-header<?php $ahe->miionHeaderLayout(); ?>">
		
			<?php $ahe->miionHeaderBar(); ?>
		
	</header>
	<div class="miion-content-wrapper">