<?php

//Theme Option -> Theme Template
$theme_template_panel = new Miion_WP_Customize_Panel( $wp_customize, 'theme_template_panel', array(
	'title'			=> esc_html__( 'Theme Template', 'miion' ),
	'description'	=> esc_html__( 'These is the template settings for page.', 'miion' ),
	'priority'		=> 7,
	'panel'			=> 'miion_theme_panel'
));
$wp_customize->add_panel( $theme_template_panel );

//Theme Template -> Template General
$miion_general_template_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_general_template_section', array(
	'title'			=> esc_html__( 'Template General', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for template general.', 'miion' ),
	'priority'		=> 1,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $miion_general_template_section );

//Template General
$wp_customize->add_setting('ajax_trigger_miion_general_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_general_template_section', array(
	'section'		=> 'miion_general_template_section'
)));

//Theme Template -> Page Template
$miion_page_template_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_page_template_section', array(
	'title'			=> esc_html__( 'Page Template', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for page template.', 'miion' ),
	'priority'		=> 2,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $miion_page_template_section );

//Page Template
$wp_customize->add_setting('ajax_trigger_miion_page_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_page_template_section', array(
	'section'		=> 'miion_page_template_section'
)));

//Theme Template -> Blog Template
$miion_blog_template_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_blog_template_section', array(
	'title'			=> esc_html__( 'Blog Template', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for blog template.', 'miion' ),
	'priority'		=> 3,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $miion_blog_template_section );

//Blog Template
$wp_customize->add_setting('ajax_trigger_miion_blog_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_blog_template_section', array(
	'section'		=> 'miion_blog_template_section'
)));

//Theme Template -> Archive Template
$miion_archive_template_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_archive_template_section', array(
	'title'			=> esc_html__( 'Archive Template', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for archive template.', 'miion' ),
	'priority'		=> 4,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $miion_archive_template_section );

//Archive Template
$wp_customize->add_setting('ajax_trigger_miion_archive_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_archive_template_section', array(
	'section'		=> 'miion_archive_template_section'
)));

//Theme Template -> Single Post Template
$miion_single_post_template_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_single_post_template_section', array(
	'title'			=> esc_html__( 'Single Post Template', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for single post template.', 'miion' ),
	'priority'		=> 9,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $miion_single_post_template_section );

//Single Post Template
$wp_customize->add_setting('ajax_trigger_miion_single_post_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_single_post_template_section', array(
	'section'		=> 'miion_single_post_template_section'
)));