<?php

//Theme Option -> Social
$theme_social_panel = new Miion_WP_Customize_Panel( $wp_customize, 'theme_social_panel', array(
	'title'			=> esc_html__( 'Social', 'miion' ),
	'description'	=> esc_html__( 'These are the social settings of miion Theme', 'miion' ),
	'priority'		=> 9,
	'panel'			=> 'miion_theme_panel'
));
$wp_customize->add_panel( $theme_social_panel );

//Header -> Social Links
$miion_social_links_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_social_links_section', array(
	'title'			=> esc_html__( 'Social Links', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for social links.', 'miion' ),
	'priority'		=> 1,
	'panel'			=> 'theme_social_panel'
));
$wp_customize->add_section( $miion_social_links_section );

//Social Links
$wp_customize->add_setting('ajax_trigger_miion_social_links_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_social_links_section', array(
	'section'		=> 'miion_social_links_section'
)));

//Header -> Social Share
$miion_social_share_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_social_share_section', array(
	'title'			=> esc_html__( 'Social Share', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for social share.', 'miion' ),
	'priority'		=> 2,
	'panel'			=> 'theme_social_panel'
));
$wp_customize->add_section( $miion_social_share_section );

//Social Share
$wp_customize->add_setting('ajax_trigger_miion_social_share_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_social_share_section', array(
	'section'		=> 'miion_social_share_section'
)));