<?php

//Theme Option -> Import and Export
$theme_import_export_panel = new Miion_WP_Customize_Panel( $wp_customize, 'theme_import_export_panel', array(
	'title'			=> esc_html__( 'Import and Export', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for import or export of current site theme options.', 'miion' ),
	'priority'		=> 14,
	'panel'			=> 'miion_theme_panel'
));
$wp_customize->add_panel( $theme_import_export_panel );

//Import and Export -> Import
$miion_import_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_import_section', array(
	'title'			=> esc_html__( 'Import', 'miion' ),
	'description'	=> esc_html__( 'This is the import setting for current theme option values.', 'miion' ),
	'priority'		=> 1,
	'panel'			=> 'theme_import_export_panel'
));
$wp_customize->add_section( $miion_import_section );

//Import
$wp_customize->add_setting('ajax_trigger_miion_import_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_import_section', array(
	'section'		=> 'miion_import_section'
)));

//Import and Export -> Export
$miion_export_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_export_section', array(
	'title'			=> esc_html__( 'Export', 'miion' ),
	'description'	=> esc_html__( 'This is the export setting for current theme option values.', 'miion' ),
	'priority'		=> 2,
	'panel'			=> 'theme_import_export_panel'
));
$wp_customize->add_section( $miion_export_section );

//Export
$wp_customize->add_setting('ajax_trigger_miion_export_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_export_section', array(
	'section'		=> 'miion_export_section'
)));