<?php

//Woo Page Title Option
$settings = array(
	'id'			=> 'woo-page-title-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Woo Page Title Option', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable woo page title.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Woo Page Title Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Woo Page Title Settings', 'miion' ),
	'description'	=> esc_html__( 'This is woo page title style settings for page template.', 'miion' ),
	'section_stat'	=> true,
	'required'		=> array( 'woo-page-title-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Font Color
$settings = array(
	'id'			=> 'template-woo-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Font Color', 'miion' ),
	'description'	=> esc_html__( 'This is font color for current field.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Template Link Color
$settings = array(
	'id'			=> 'template-woo-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Page Template Link Color', 'miion' ),
	'description'	=> esc_html__( 'Choose Woocommerce page title bar link color.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Template Border
$settings = array(
	'id'			=> 'template-woo-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Page Template Border', 'miion' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put units like px, em etc. Example 1 1 1 1.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Template Padding Option
$settings = array(
	'id'			=> 'template-woo-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Page Template Padding Option', 'miion' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Template Background
$settings = array(
	'id'			=> 'template-woo-background-all',
	'type'			=> 'background',
	'title'			=> esc_html__( 'Page Template Background', 'miion' ),
	'description'	=> esc_html__( 'This is settings for footer background.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 0
);
MiionCustomizerConfig::buildFields( $settings );

//Background Parallax
$settings = array(
	'id'			=> 'woo-page-title-parallax',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Parallax', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title background parallax.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Background Video
$settings = array(
	'id'			=> 'woo-page-title-bg',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Video', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title background video.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Background Video
$settings = array(
	'id'			=> 'woo-page-title-video',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Page Title Background Video', 'miion' ),
	'description'	=> esc_html__( 'Set page title background video for page. Only allowed youtube video id. Example: UWF7dZTLW4c', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-bg', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );


//Page Title Overlay
$settings = array(
	'id'			=> 'woo-page-title-overlay',
	'type'			=> 'alpha',
	'title'			=> esc_html__( 'Page Title Overlay', 'miion' ),
	'description'	=> esc_html__( 'Choose page title overlay rgba color.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Woo Page Title Items Option
$settings = array(
	'id'			=> 'template-woo-page-title-items-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Woo Page Title Items Option', 'miion' ),
	'description'	=> esc_html__( 'Enable to make woo page title items custom layout.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'woo-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Items
$settings = array(
	'id'			=> 'template-woo-pagetitle-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Woo Page Title Items', 'miion' ),
	'description'	=> esc_html__( 'Needed items for page title wrap, drag from disabled and put enabled.', 'miion' ),
	'default' 		=> array(
		'disabled' 	=> array(),
		'Left'  	=> array(
			'title' => esc_html__( 'Page Title Text', 'miion' ),
		),
		'Center'  	=> array(),
		'Right'  	=> array(
			'breadcrumb'	=> esc_html__( 'Breadcrumb', 'miion' )
		)
	),
	'required'		=> array( 'template-woo-page-title-items-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Woo Page Title Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false,
	'required'		=> array( 'woo-page-title-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Woocommerce Archive Template
$settings = array(
	'id'			=> 'wooarchive-page-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Woocommerce Archive Template', 'miion' ),
	'description'	=> esc_html__( 'Choose your current Woocommerce Archive page template.', 'miion' ),
	'default'		=> 'no-sidebar',
	'items' 		=> array(
		'no-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/1.png',
		'right-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/2.png',
		'left-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/3.png',
		'both-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/4.png'		
	),
	'cols'			=> '4',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Left Sidebar
$settings = array(
	'id'			=> 'wooarchive-left-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Left Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing woocommerce archive template on left sidebar.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Right Sidebar
$settings = array(
	'id'			=> 'wooarchive-right-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Right Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing woocommerce archive template on right sidebar.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Product Archive Columns
$settings = array(
	'id'			=> 'woo-shop-archive-columns',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Product Archive Columns', 'miion' ),
	'description'	=> esc_html__( 'This is column settings woocommerce product archive columns.', 'miion' ),
	'choices'		=> array(
		'2'		=> esc_html__( '2 Columns', 'miion' ),
		'3'		=> esc_html__( '3 Columns', 'miion' ),
		'4'		=> esc_html__( '4 Columns', 'miion' ),
		'5'		=> esc_html__( '5 Columns', 'miion' ),
		'6'		=> esc_html__( '6 Columns', 'miion' ),
	),
	'default'		=> '4',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );