<?php

//Layout Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Layout', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Option
$settings = array(
	'id'			=> 'archive-page-title-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Page Title Option', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title.', 'miion' ),
	'default'		=> 1,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Items
$settings = array(
	'id'			=> 'template-archive-pagetitle-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Page Title Items', 'miion' ),
	'description'	=> esc_html__( 'Needed items for page title wrap, drag from disabled and put enabled.', 'miion' ),
	'default' 		=> array(
		'disabled' => array(),
		'Left'  => array(
			'title' => esc_html__( 'Page Title Text', 'miion' ),
		),
		'Center' => array(),
		'Right'  => array(
			'breadcrumb'	=> esc_html__( 'Breadcrumb', 'miion' )
		)
	),
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Template
$settings = array(
	'id'			=> 'archive-page-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Archive Template', 'miion' ),
	'description'	=> esc_html__( 'Choose your current archive page template.', 'miion' ),
	'default'		=> 'right-sidebar',
	'items' 		=> array(
		'no-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/1.png',
		'right-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/2.png',
		'left-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/3.png',
		'both-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/4.png'		
	),
	'cols'			=> '4',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Left Sidebar
$settings = array(
	'id'			=> 'archive-left-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Left Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing on left side.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 0
);
MiionCustomizerConfig::buildFields( $settings );

//Right Sidebar
$settings = array(
	'id'			=> 'archive-right-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Right Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing on right side.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 0
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Archive Settings', 'miion' ),
	'description'	=> esc_html__( 'This is settings for archive page layout, sidebar sticky and etc.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Post Template
$settings = array(
	'id'			=> 'archive-post-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Archive Post Template', 'miion' ),
	'description'	=> esc_html__( 'Choose your current archive post template.', 'miion' ),
	'default'		=> 'standard',
	'items' 		=> array(
		'standard'	=> MIION_ADMIN_URL . '/customizer/assets/images/post-layouts/1.png',
		'grid'		=> MIION_ADMIN_URL . '/customizer/assets/images/post-layouts/2.png',
		'list'		=> MIION_ADMIN_URL . '/customizer/assets/images/post-layouts/3.png'		
	),
	'cols'			=> '3',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Top Standard Post
$settings = array(
	'id'			=> 'archive-top-standard-post',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Top Standard Post', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable to show top post layout standard others selected layout.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Grid Columns
$settings = array(
	'id'			=> 'archive-grid-cols',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Grid Columns', 'miion' ),
	'description'	=> esc_html__( 'Select grid columns.', 'miion' ),
	'choices'		=> array(
		'4'		=> esc_html__( '4 Columns', 'miion' ),
		'3'		=> esc_html__( '3 Columns', 'miion' ),
		'2'		=> esc_html__( '2 Columns', 'miion' ),
	),
	'default'		=> '2',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Post Grid Gutter
$settings = array(
	'id'			=> 'archive-grid-gutter',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Archive Post Grid Gutter', 'miion' ),
	'description'	=> esc_html__( 'Enter grid gutter size. Example 20', 'miion' ),
	'default'		=> '30',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Grid Type
$settings = array(
	'id'			=> 'archive-grid-type',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Grid Type', 'miion' ),
	'description'	=> esc_html__( 'Select grid type normal or isotope.', 'miion' ),
	'choices'		=> array(
		'normal'		=> esc_html__( 'Normal Grid', 'miion' ),
		'isotope'		=> esc_html__( 'Isotope Grid', 'miion' ),
	),
	'default'		=> 'normal',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Infinite Scroll
$settings = array(
	'id'			=> 'archive-infinite-scroll',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Infinite Scroll', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable infinite scroll for archive post.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );



//Post Excerpt Length
$settings = array(
	'id'			=> 'archive-excerpt',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Post Excerpt Length', 'miion' ),
	'description'	=> esc_html__( 'Set archive post excerpt length. Example 15', 'miion' ),
	'default'		=> '15',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Post Top Meta Items
$settings = array(
	'id'			=> 'archive-topmeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Archive Post Top Meta Items', 'miion' ),
	'description'	=> esc_html__( 'Needed archive post top meta items drag from disabled and put enabled part. ie: Left or Right.', 'miion' ),
	'default' 		=> array(
		'Left'  => array(
			'date'		=> esc_html__( 'Date', 'miion' )
		),
		'Right'  => array(
			'category'	=> esc_html__( 'Category', 'miion' )
		),
		'disabled' => array(
			'social'	=> esc_html__( 'Social Share', 'miion' ),
			'comments'	=> esc_html__( 'Comments', 'miion' ),
			'likes'		=> esc_html__( 'Likes', 'miion' ),
			'author'	=> esc_html__( 'Author', 'miion' ),
			'views'		=> esc_html__( 'Views', 'miion' ),
			'more'		=> esc_html__( 'Read More', 'miion' ),
			'favourite'	=> esc_html__( 'Favourite', 'miion' )
		)
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Post Bottom Meta Items
$settings = array(
	'id'			=> 'archive-bottommeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Archive Post Bottom Meta Items', 'miion' ),
	'description'	=> esc_html__( 'Needed archive post bottom meta items drag from disabled and put enabled part. ie: Left or Right.', 'miion' ),
	'default' 		=> array(
		'Left'  => array(
			'more'		=> esc_html__( 'Read More', 'miion' ),
		),
		'Right'  => array(),
		'disabled' => array(
			'comments'	=> esc_html__( 'Comments', 'miion' ),
			'category'	=> esc_html__( 'Category', 'miion' ),
			'social'	=> esc_html__( 'Social Share', 'miion' ),
			'comments'	=> esc_html__( 'Comments', 'miion' ),
			'likes'		=> esc_html__( 'Likes', 'miion' ),
			'author'	=> esc_html__( 'Author', 'miion' ),
			'views'		=> esc_html__( 'Views', 'miion' ),
			'date'		=> esc_html__( 'Date', 'miion' ),
			'favourite'	=> esc_html__( 'Favourite', 'miion' )
		)
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Post Items
$settings = array(
	'id'			=> 'archive-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Archive Post Items', 'miion' ),
	'description'	=> esc_html__( 'Needed archive post items drag from disabled and put enabled part. Thumbnail part covers the post format either image/audio/video/gallery/quote/link.', 'miion' ),
	'default' 		=> array(
		'Enabled'  		=> array(
			'title'			=> esc_html__( 'Title', 'miion' ),
			'top-meta'		=> esc_html__( 'Top Meta', 'miion' ),
			'thumb'			=> esc_html__( 'Thumbnail', 'miion' ),
			'content'		=> esc_html__( 'Content', 'miion' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'miion' )
		),
		'disabled' => array()
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Post Overlay
$settings = array(
	'id'			=> 'archive-overlay-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Archive Post Overlay', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable archive post overlay.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Post Overlay Items
$settings = array(
	'id'			=> 'archive-overlay-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Archive Post Overlay Items', 'miion' ),
	'description'	=> esc_html__( 'Needed archive post overlay items drag from disabled and put enabled part.', 'miion' ),
	'default' 		=> array(
		'Enabled'  	=> array(
			'title'			=> esc_html__( 'Title', 'miion' ),
		),
		'disabled' => array(
			'top-meta'		=> esc_html__( 'Top Meta', 'miion' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'miion' )
		)
	),
	'required'		=> array( 'archive-overlay-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Layout End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Style Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Style', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Page Title Settings', 'miion' ),
	'description'	=> esc_html__( 'This is page title style settings shows only when page title option active.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Font Color
$settings = array(
	'id'			=> 'template-archive-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Font Color', 'miion' ),
	'description'	=> esc_html__( 'This is font color for current field.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Template Link Color
$settings = array(
	'id'			=> 'template-archive-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Archive Template Link Color', 'miion' ),
	'description'	=> esc_html__( 'Choose archive template link color.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Template Border
$settings = array(
	'id'			=> 'template-archive-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Archive Template Border', 'miion' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Template Padding Option
$settings = array(
	'id'			=> 'template-archive-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Archive Template Padding Option', 'miion' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Template Background
$settings = array(
	'id'			=> 'template-archive-background-all',
	'type'			=> 'background',
	'title'			=> esc_html__( 'Archive Template Background', 'miion' ),
	'description'	=> esc_html__( 'This is settings for footer background.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Background Parallax
$settings = array(
	'id'			=> 'archive-page-title-parallax',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Parallax', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title background parallax.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Background Video
$settings = array(
	'id'			=> 'archive-page-title-bg',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Video', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title background video.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Background Video
$settings = array(
	'id'			=> 'archive-page-title-video',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Page Title Background Video', 'miion' ),
	'description'	=> esc_html__( 'Set page title background video for page. Only allowed youtube video id. Example: UWF7dZTLW4c', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'archive-page-title-bg', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Overlay
$settings = array(
	'id'			=> 'archive-page-title-overlay',
	'type'			=> 'alpha',
	'title'			=> esc_html__( 'Page Title Overlay', 'miion' ),
	'description'	=> esc_html__( 'Choose page title overlay rgba color.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'archive-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false,
	'required'		=> array( 'archive-page-title-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Article Skin Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Archive Article Skin Settings', 'miion' ),
	'description'	=> esc_html__( 'This is skin settings for each archive article.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Article Font Color
$settings = array(
	'id'			=> 'archive-article-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Font Color', 'miion' ),
	'description'	=> esc_html__( 'This is font color for archive article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Link Color
$settings = array(
	'id'			=> 'archive-article-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Article Link Color', 'miion' ),
	'description'	=> esc_html__( 'Choose article link color for archive article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Border
$settings = array(
	'id'			=> 'archive-article-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Article Border', 'miion' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Padding Option
$settings = array(
	'id'			=> 'archive-article-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Article Padding Option', 'miion' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Background Color
$settings = array(
	'id'			=> 'archive-article-background',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Background Color', 'miion' ),
	'description'	=> esc_html__( 'This is background color for archive article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Article Skin Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Style End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Text Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Custom Text', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Post Read More Text
$settings = array(
	'id'			=> 'archive-more-text',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Post Read More Text', 'miion' ),
	'description'	=> esc_html__( 'Set archive post read more text. Example Read More', 'miion' ),
	'default'		=> esc_html__( 'Read More', 'miion' ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Text End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Advanced Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Advanced', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Post Format Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Post Format Settings', 'miion' ),
	'description'	=> esc_html__( 'This is post format settings for archive.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Video Format
$settings = array(
	'id'			=> 'archive-video-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Video Format', 'miion' ),
	'description'	=> esc_html__( 'Choose archive page video post format settings.', 'miion' ),
	'choices'		=> array(
		'onclick' 	=> esc_html__( 'On Click Run Video', 'miion' ),
		'overlay' 	=> esc_html__( 'Modal Box Video', 'miion' ),
		'direct' 	=> esc_html__( 'Direct Video', 'miion' )
	),
	'default'		=> 'onclick',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Quote Format
$settings = array(
	'id'			=> 'archive-quote-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Quote Format', 'miion' ),
	'description'	=> esc_html__( 'Choose archive page quote post format settings.', 'miion' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'miion' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'miion' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'miion' ),
		'none' 			=> esc_html__( 'None', 'miion' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Link Format
$settings = array(
	'id'			=> 'archive-link-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Link Format', 'miion' ),
	'description'	=> esc_html__( 'Choose archive page link post format settings.', 'miion' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'miion' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'miion' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'miion' ),
		'none' 			=> esc_html__( 'None', 'miion' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Gallery Format
$settings = array(
	'id'			=> 'archive-gallery-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Gallery Format', 'miion' ),
	'description'	=> esc_html__( 'Choose archive page gallery post format settings.', 'miion' ),
	'choices'		=> array(
		'default'	=> esc_html__( 'Default Gallery', 'miion' ),
		'popup' 	=> esc_html__( 'Popup Gallery', 'miion' ),
		'grid' 		=> esc_html__( 'Grid Popup Gallery', 'miion' )
	),
	'default'		=> 'default',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Post Format Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Featured Slider
$settings = array(
	'id'			=> 'archive-featured-slider',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Archive Featured Slider', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable archive featured slider.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Sidebar Sticky
$settings = array(
	'id'			=> 'archive-sidebar-sticky',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar Sticky', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable sidebar sticky.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Sidebar on Mobile
$settings = array(
	'id'			=> 'archive-page-hide-sidebar',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar on Mobile', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable to show or hide sidebar on mobile.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Advanced End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );