<?php
class CEAShortcodes {
	
	public function __construct(){
		add_shortcode( 'videoframe', array( $this, 'miionVideoIframe' ) );
		add_shortcode( 'video', array( $this, 'miionVideo' ) );
		add_shortcode( 'videoframenon', array( $this, 'miionVideoIframeNonParam' ) );
		
		//Event Schortcode
		add_shortcode( 'miion_tab_events', array( $this, 'miionTabEvents' ) );
		add_shortcode( 'miion_tab_day_events', array( $this, 'miionTabDailyEvents' ) );
		add_shortcode( 'miion_tab_event', array( $this, 'miionTabEvent' ) );
    }
		
	public function miionVideoIframe( $atts ) {
		$atts = shortcode_atts( array(
			'url' => '',
			'height' => '',
			'width' => '',
			'params' => ''
		), $atts );
		return '<iframe width="'. esc_attr( $atts['width'] ) .'" height="'. esc_attr( $atts['height'] ) .'" src="'. esc_url( $atts['url'] ) .'?'. esc_attr( $atts['params'] ) .'" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
	}
	
	
	public function miionVideoIframeNonParam( $atts ) {
		$atts = shortcode_atts( array(
			'url' => '',
			'height' => '',
			'width' => '',
			'params' => '',
			'allowfullscreen' => ''
		), $atts );
		return '<iframe width="'. esc_attr( $atts['width'] ) .'" height="'. esc_attr( $atts['height'] ) .'" src="'. esc_url( $atts['url'] ) .'?'. esc_attr( $atts['params'] ) .'" '. esc_attr( $atts['allowfullscreen'] ) .'></iframe>';
	}
	
	public function miionVideo( $atts ) {
		$atts = shortcode_atts( array(
			'url' => '',
			'height' => '',
			'width' => '',
		), $atts );
		
		return '<video class="miion-custom-video" width="'. esc_attr( $atts['width'] ) .'" height="'. esc_attr( $atts['height'] ) .'" preload="true" style="max-width:100%;">
                    <source src="'. esc_url( $atts['url'] ) .'" type="video/mp4">
                </video>';
	}
	
} // Shortcode class end
$miionsc = new CEAShortcodes;