<?php
/* Miion Page Options */
$prefix = 'miion_post_';
$fields = array(
	array( 
		'label'	=> esc_html__( 'Post General Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are single post general settings.', 'miion-core' ), 
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Post Layout', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post layout for current post single view.', 'miion-core' ), 
		'id'	=> $prefix.'layout',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'wide' => esc_html__( 'Wide', 'miion-core' ),
			'boxed' => esc_html__( 'Boxed', 'miion-core' )			
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Content Padding Option', 'miion-core' ),
		'id'	=> $prefix.'content_padding_opt',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Content Padding', 'miion-core' ), 
		'desc'	=> esc_html__( 'Set the top/right/bottom/left padding of post content.', 'miion-core' ),
		'id'	=> $prefix.'content_padding',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'space',
		'required'	=> array( $prefix.'content_padding_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Template Option', 'miion-core' ),
		'id'	=> $prefix.'template_opt',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Template', 'miion-core' ),
		'id'	=> $prefix.'template',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'image_select',
		'options' => array(
			'no-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/1.png' ), 
			'right-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/2.png' ), 
			'left-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/3.png' ), 
			'both-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/4.png' ), 
		),
		'default'	=> 'right-sidebar',
		'required'	=> array( $prefix.'template_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Left Sidebar', 'miion-core' ),
		'id'	=> $prefix.'left_sidebar',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'template_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Right Sidebar', 'miion-core' ),
		'id'	=> $prefix.'right_sidebar',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'template_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Sidebar On Mobile', 'miion-core' ),
		'id'	=> $prefix.'sidebar_mobile',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Show', 'miion-core' ),
			'0' => esc_html__( 'Hide', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Featured Slider', 'miion-core' ),
		'id'	=> $prefix.'featured_slider',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Full Width Wrap', 'miion-core' ),
		'id'	=> $prefix.'full_wrap',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Items Option', 'miion-core' ),
		'id'	=> $prefix.'items_opt',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Items', 'miion-core' ),
		'desc'	=> esc_html__( 'Needed single post items drag from disabled and put enabled part.', 'miion-core' ),
		'id'	=> $prefix.'items',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'dragdrop',
		'options' => array ( 
			'all' => array( 'title', 'top-meta', 'thumb', 'content', 'bottom-meta' ),
			'items' => array( 
				'title' 	=> esc_html__( 'Title', 'miion-core' ),
				'top-meta'	=> esc_html__( 'Top Meta', 'miion-core' ),
				'thumb' 	=> esc_html__( 'Thumbnail', 'miion-core' ),
				'content' 	=> esc_html__( 'Content', 'miion-core' ),
				'bottom-meta'		=> esc_html__( 'Bottom Meta', 'miion-core' )
			)
		),
		'default'	=> 'title,top-meta,thumb,content,bottom-meta',
		'required'	=> array( $prefix.'items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Overlay', 'miion-core' ),
		'id'	=> $prefix.'overlay_opt',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Overlay Items', 'miion-core' ),
		'desc'	=> esc_html__( 'Needed overlay post items drag from disabled and put enabled part.', 'miion-core' ),
		'id'	=> $prefix.'overlay_items',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'dragdrop',
		'options' => array ( 
			'all' => array( 'title', 'top-meta', 'bottom-meta' ),
			'items' => array( 
				'title' 	=> esc_html__( 'Title', 'miion-core' ),
				'top-meta'	=> esc_html__( 'Top Meta', 'miion-core' ),
				'bottom-meta'		=> esc_html__( 'Bottom Meta', 'miion-core' )
			)
		),
		'default'	=> 'title',
		'required'	=> array( $prefix.'overlay_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Page Items Option', 'miion-core' ),
		'id'	=> $prefix.'page_items_opt',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Page Items', 'miion-core' ),
		'desc'	=> esc_html__( 'Needed post page items drag from disabled and put enabled part.', 'miion-core' ),
		'id'	=> $prefix.'page_items',
		'tab'	=> esc_html__( 'General', 'miion-core' ),
		'type'	=> 'dragdrop',
		'options' => array ( 
			'all' => array( 'post-items', 'author-info', 'related-slider', 'post-nav', 'comment' ),
			'items' => array( 
				'post-items' 	=> esc_html__( 'Post Items', 'miion-core' ),
				'author-info'	=> esc_html__( 'Author Info', 'miion-core' ),
				'related-slider'=> esc_html__( 'Related Slider', 'miion-core' ),
				'post-nav' 	=> esc_html__( 'Post Nav', 'miion-core' ),
				'comment' 	=> esc_html__( 'Comment', 'miion-core' )
			)
		),
		'default'	=> 'post-items,author-info,related-slider,post-nav,comment',
		'required'	=> array( $prefix.'page_items_opt', 'custom' )
	),
	//Header
	array( 
		'label'	=> esc_html__( 'Header General Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header general settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Layout', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post layout for current post header layout.', 'miion-core' ), 
		'id'	=> $prefix.'header_layout',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'wide' => esc_html__( 'Wide', 'miion-core' ),
			'boxed' => esc_html__( 'Boxed', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Type', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post layout for current post header type.', 'miion-core' ), 
		'id'	=> $prefix.'header_type',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'default' => esc_html__( 'Default', 'miion-core' ),
			'left-sticky' => esc_html__( 'Left Sticky', 'miion-core' ),
			'right-sticky' => esc_html__( 'Right Sticky', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Background Image', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header background image for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'image',
		'id'	=> $prefix.'header_bg_img',
		'required'	=> array( $prefix.'header_type', 'default' )
	),
	array( 
		'label'	=> esc_html__( 'Header Items Options', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
		'id'	=> $prefix.'header_items_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header general items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_items',
		'dd_fields' => array ( 
			'Normal' => array( 
				'header-topbar' 	=> esc_html__( 'Topbar', 'miion-core' ),
				'header-logo'	=> esc_html__( 'Logo Bar', 'miion-core' )
			),
			'Sticky' => array( 
				'header-nav' 	=> esc_html__( 'Navbar', 'miion-core' )
			),
			'disabled' => array()
		),
		'required'	=> array( $prefix.'header_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Absolute Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header absolute to change header look transparent.', 'miion-core' ), 
		'id'	=> $prefix.'header_absolute_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header sticky options.', 'miion-core' ), 
		'id'	=> $prefix.'header_sticky_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'sticky' => esc_html__( 'Header Sticky Part', 'miion-core' ),
			'sticky-scroll' => esc_html__( 'Sticky Scroll Up', 'miion-core' ),
			'none' => esc_html__( 'None', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Options', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
		'id'	=> $prefix.'header_topbar_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Height', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar height for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_topbar_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Height', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar sticky height for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_topbar_sticky_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header topbar skin settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header topbar skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'header_topbar_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_topbar_font',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_topbar_bg',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_topbar_link',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_topbar_border',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_topbar_padding',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header top bar sticky skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'header_topbar_sticky_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_topbar_sticky_font',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_topbar_sticky_bg',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_topbar_sticky_link',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_topbar_sticky_border',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_topbar_sticky_padding',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Items Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header topbar items enable options.', 'miion-core' ), 
		'id'	=> $prefix.'header_topbar_items_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header topbar items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_topbar_items',
		'dd_fields' => array ( 
			'Left'  => array(
				'header-topbar-date' => esc_html__( 'Date', 'miion-core' ),						
			),
			'Center' => array(),
			'Right' => array(),
			'disabled' => array(
				'header-topbar-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
				'header-topbar-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),
				'header-topbar-text-3'	=> esc_html__( 'Custom Text 3', 'miion-core' ),
				'header-topbar-menu'    => esc_html__( 'Top Bar Menu', 'miion-core' ),
				'header-topbar-social'	=> esc_html__( 'Social', 'miion-core' ),
				'header-topbar-search'	=> esc_html__( 'Search', 'miion-core' )
			)
		),
		'required'	=> array( $prefix.'header_topbar_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Options', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
		'id'	=> $prefix.'header_logo_bar_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Height', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar height for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_logo_bar_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Height', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky height for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_logo_bar_sticky_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header logo bar skin settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header logo bar skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'header_logo_bar_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_logo_bar_font',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_logo_bar_bg',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_logo_bar_link',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_logo_bar_border',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_logo_bar_padding',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header logo bar sticky skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'header_logobar_sticky_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_logobar_sticky_font',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_logobar_sticky_bg',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_logobar_sticky_link',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_logobar_sticky_border',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_logobar_sticky_padding',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Items Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header logo bar items enable options.', 'miion-core' ), 
		'id'	=> $prefix.'header_logo_bar_items_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_logo_bar_items',
		'dd_fields' => array ( 
			'Left'  => array(),
			'Center' => array(
				'header-logobar-logo'	=> esc_html__( 'Logo', 'miion-core' ),
			),
			'Right' => array(),
			'disabled' => array(
				'header-logobar-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
				'header-logobar-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),
				'header-logobar-text-3'	=> esc_html__( 'Custom Text 3', 'miion-core' ),
				'header-logobar-menu'    => esc_html__( 'Main Menu', 'miion-core' ),
				'header-logobar-social'	=> esc_html__( 'Social', 'miion-core' ),
				'header-logobar-search'	=> esc_html__( 'Search', 'miion-core' ),
				'header-logobar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'miion-core' ),
				'header-logobar-search-toggle'	=> esc_html__( 'Search Toggle', 'miion-core' ),
				'header-cart'   		=> esc_html__( 'Cart', 'miion-core' )
			)
		),
		'required'	=> array( $prefix.'header_logo_bar_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Options', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
		'id'	=> $prefix.'header_navbar_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Height', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar height for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_navbar_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Height', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky height for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_navbar_sticky_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header navbar skin settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header navbar skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'header_navbar_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_navbar_font',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_navbar_bg',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_navbar_link',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_navbar_border',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_navbar_padding',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header navbar sticky skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'header_navbar_sticky_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_navbar_sticky_font',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_navbar_sticky_bg',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_navbar_sticky_link',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_navbar_sticky_border',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_navbar_sticky_padding',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Items Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header navbar items enable options.', 'miion-core' ), 
		'id'	=> $prefix.'header_navbar_items_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header navbar items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_navbar_items',
		'dd_fields' => array ( 
			'Left'  => array(											
				'header-navbar-menu'    => esc_html__( 'Main Menu', 'miion-core' ),
			),
			'Center' => array(
			),
			'Right' => array(
				'header-navbar-search'	=> esc_html__( 'Search', 'miion-core' ),
			),
			'disabled' => array(
				'header-navbar-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
				'header-navbar-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),
				'header-navbar-text-3'	=> esc_html__( 'Custom Text 3', 'miion-core' ),
				'header-navbar-logo'	=> esc_html__( 'Logo', 'miion-core' ),
				'header-navbar-social'	=> esc_html__( 'Social', 'miion-core' ),
				'header-navbar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'miion-core' ),
				'header-navbar-search-toggle'	=> esc_html__( 'Search Toggle', 'miion-core' ),
				'header-navbar-sticky-logo'	=> esc_html__( 'Stikcy Logo', 'miion-core' ),
				'header-cart'   		=> esc_html__( 'Cart', 'miion-core' )
			)
		),
		'required'	=> array( $prefix.'header_navbar_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header sticky settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Options', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header sticky part option.', 'miion-core' ), 
		'id'	=> $prefix.'header_stikcy_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Width', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky part width for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_stikcy_width',
		'property' => 'width',
		'required'	=> array( $prefix.'header_stikcy_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header Sticky skin settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header Sticky skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'header_stikcy_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_stikcy_font',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_stikcy_bg',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_stikcy_link',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',

		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_stikcy_border',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_stikcy_padding',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Items Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose header Sticky items enable options.', 'miion-core' ), 
		'id'	=> $prefix.'header_stikcy_items_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_stikcy_items',
		'dd_fields' => array ( 
			'Top'  => array(
				'header-fixed-logo' => esc_html__( 'Logo', 'miion-core' )
			),
			'Middle'  => array(
				'header-fixed-menu'	=> esc_html__( 'Menu', 'miion-core' )					
			),
			'Bottom'  => array(
				'header-fixed-social'	=> esc_html__( 'Social', 'miion-core' )					
			),
			'disabled' => array(
				'header-fixed-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
				'header-fixed-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),				
				'header-fixed-search'	=> esc_html__( 'Search Form', 'miion-core' )
			)
		),
		'required'	=> array( $prefix.'header_stikcy_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Bar', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title bar settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Post Title Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post title enable or disable.', 'miion-core' ), 
		'id'	=> $prefix.'header_post_title_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Title Text', 'miion-core' ),
		'desc'	=> esc_html__( 'If this post title is empty, then showing current post default title.', 'miion-core' ), 
		'id'	=> $prefix.'header_post_title_text',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'text',
		'default'	=> '',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Description', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter post title description.', 'miion-core' ), 
		'id'	=> $prefix.'header_post_title_desc',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'textarea',
		'default'	=> '',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Parallax', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post title background parallax.', 'miion-core' ), 
		'id'	=> $prefix.'header_post_title_parallax',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Video Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post title background video option.', 'miion-core' ), 
		'id'	=> $prefix.'header_post_title_video_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Video', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter youtube video ID. Example: ZSt9tm3RoUU.', 'miion-core' ), 
		'id'	=> $prefix.'header_post_title_video',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'text',
		'default'	=> '',
		'required'	=> array( $prefix.'header_post_title_video_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Bar Items Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post title bar items option.', 'miion-core' ), 
		'id'	=> $prefix.'post_title_items_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Bar Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title bar items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'post_title_items',
		'dd_fields' => array ( 
			'Left'  => array(
				'title' => esc_html__( 'Post Title Text', 'miion-core' ),
			),
			'Center'  => array(
				
			),
			'Right'  => array(
				'breadcrumb'	=> esc_html__( 'Breadcrumb', 'miion-core' )
			),
			'disabled' => array()
		),
		'required'	=> array( $prefix.'post_title_items_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are post title skin settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'label',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose post title skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'post_title_skin_opt',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'post_title_font',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'post_title_bg',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Image', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter post title background image url.', 'miion-core' ), 
		'id'	=> $prefix.'post_title_bg_img',
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'url',
		'default'	=> '',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'post_title_link',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'post_title_border',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'post_title_padding',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Overlay', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are post title overlay color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Header', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'post_title_overlay',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	//Footer
	array( 
		'label'	=> 'Footer General',
		'desc'	=> esc_html__( 'These all are header footer settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer layout for current post.', 'miion-core' ), 
		'id'	=> $prefix.'footer_layout',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'wide' => esc_html__( 'Wide', 'miion-core' ),
			'boxed' => esc_html__( 'Boxed', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Hidden Footer', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose hidden footer option.', 'miion-core' ), 
		'id'	=> $prefix.'hidden_footer',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are footer skin settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Skin Settings', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer skin settings options.', 'miion-core' ), 
		'id'	=> $prefix.'footer_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_font',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Background Image', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer background image for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'image',
		'id'	=> $prefix.'footer_bg_img',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Background Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_bg',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Background Overlay', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer background overlay color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_bg_overlay',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_link',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_border',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_padding',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Items Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer items enable options.', 'miion-core' ), 
		'id'	=> $prefix.'footer_items_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'footer_items',
		'dd_fields' => array ( 
			'Enabled'  => array(
				'footer-bottom'	=> esc_html__( 'Footer Bottom', 'miion-core' )
			),
			'disabled' => array(
				'footer-top' => esc_html__( 'Footer Top', 'miion-core' ),
				'footer-middle'	=> esc_html__( 'Footer Middle', 'miion-core' )
			)
		),
		'required'	=> array( $prefix.'footer_items_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Top',
		'desc'	=> esc_html__( 'These all are footer top settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Skin', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer top skin options.', 'miion-core' ), 
		'id'	=> $prefix.'footer_top_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer top font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_top_font',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Widget Title color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer top widget title color.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_top_widget_title_color',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_top_bg',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer top link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_top_link',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer top border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_top_border',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer top padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_top_padding',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Top Columns and Sidebars Settings',
		'desc'	=> esc_html__( 'These all are footer top columns and sidebar settings.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer layout option.', 'miion-core' ), 
		'id'	=> $prefix.'footer_top_layout_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout', 'miion-core' ),
		'id'	=> $prefix.'footer_top_layout',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'image_select',
		'options' => array(
			'3-3-3-3'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
			'4-4-4'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
			'3-6-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
			'6-6'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
			'9-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
			'3-9'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
			'4-2-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
			'6-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
			'12'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
		),
		'default'	=> '4-4-4',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer First Column',
		'desc'	=> esc_html__( 'Select footer first column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_top_sidebar_1',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Second Column',
		'desc'	=> esc_html__( 'Select footer second column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_top_sidebar_2',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Third Column',
		'desc'	=> esc_html__( 'Select footer third column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_top_sidebar_3',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Fourth Column',
		'desc'	=> esc_html__( 'Select footer fourth column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_top_sidebar_4',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Middle',
		'desc'	=> esc_html__( 'These all are footer middle settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Skin', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer middle skin options.', 'miion-core' ), 
		'id'	=> $prefix.'footer_middle_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer middle font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_middle_font',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Widget Title Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer middle widget title color.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_middle_widget_title_color',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_middle_bg',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer middle link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_middle_link',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer middle border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_middle_border',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer middle padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_middle_padding',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Middle Columns and Sidebars Settings',
		'desc'	=> esc_html__( 'These all are footer middle columns and sidebar settings.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer layout option.', 'miion-core' ), 
		'id'	=> $prefix.'footer_middle_layout_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout', 'miion-core' ),
		'id'	=> $prefix.'footer_middle_layout',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'image_select',
		'options' => array(
			'3-3-3-3'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
			'4-4-4'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
			'3-6-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
			'6-6'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
			'9-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
			'3-9'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
			'4-2-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
			'6-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
			'12'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
		),
		'default'	=> '4-4-4',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer First Column',
		'desc'	=> esc_html__( 'Select footer first column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_1',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Second Column',
		'desc'	=> esc_html__( 'Select footer second column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_2',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Third Column',
		'desc'	=> esc_html__( 'Select footer third column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_3',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Fourth Column',
		'desc'	=> esc_html__( 'Select footer fourth column widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_4',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Bottom',
		'desc'	=> esc_html__( 'These all are footer bottom settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Fixed', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom fixed option.', 'miion-core' ), 
		'id'	=> $prefix.'footer_bottom_fixed',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'1' => esc_html__( 'Enable', 'miion-core' ),
			'0' => esc_html__( 'Disable', 'miion-core' )			
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are footer bottom skin settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Skin', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom skin options.', 'miion-core' ), 
		'id'	=> $prefix.'footer_bottom_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Font Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom font color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_bottom_font',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Background', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom background color for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_bottom_bg',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Link Color', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom link color settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_bottom_link',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Border', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom border settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_bottom_border',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Padding', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom padding settings for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_bottom_padding',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Widget Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom widget options.', 'miion-core' ), 
		'id'	=> $prefix.'footer_bottom_widget_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> 'Footer Bottom Widget',
		'desc'	=> esc_html__( 'Select footer bottom widget.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'id'	=> $prefix.'footer_bottom_widget',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_bottom_widget_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Items Option', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom items options.', 'miion-core' ), 
		'id'	=> $prefix.'footer_bottom_items_opt',
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'custom' => esc_html__( 'Custom', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Items', 'miion-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom items for current post.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Footer', 'miion-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'footer_bottom_items',
		'dd_fields' => array ( 
			'Left'  => array(
				'copyright' => esc_html__( 'Copyright Text', 'miion-core' )
			),
			'Center'  => array(
				'menu'	=> esc_html__( 'Footer Menu', 'miion-core' )
			),
			'Right'  => array(),
			'disabled' => array(
				'social'	=> esc_html__( 'Footer Social Links', 'miion-core' ),
				'widget'	=> esc_html__( 'Custom Widget', 'miion-core' )
			)
		),
		'required'	=> array( $prefix.'footer_bottom_items_opt', 'custom' )
	),
	//Header Slider
	array( 
		'label'	=> esc_html__( 'Slider', 'miion-core' ),
		'desc'	=> esc_html__( 'This header slider settings.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Slider', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Slider Option', 'miion-core' ),
		'id'	=> $prefix.'header_slider_opt',
		'tab'	=> esc_html__( 'Slider', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'bottom' => esc_html__( 'Below Header', 'miion-core' ),
			'top' => esc_html__( 'Above Header', 'miion-core' ),
			'none' => esc_html__( 'None', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Slider Shortcode', 'miion-core' ),
		'desc'	=> esc_html__( 'This is the place for enter slider shortcode. Example revolution slider shortcodes.', 'miion-core' ), 
		'id'	=> $prefix.'header_slider',
		'tab'	=> esc_html__( 'Slider', 'miion-core' ),
		'type'	=> 'textarea',
		'default'	=> ''
	),
	//Post Format
	array( 
		'label'	=> esc_html__( 'Video', 'miion-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed video format, then you must choose video type and give video id.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Video Modal', 'miion-core' ),
		'id'	=> $prefix.'video_modal',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'onclick' => esc_html__( 'On Click Run Video', 'miion-core' ),
			'overlay' => esc_html__( 'Modal Box Video', 'miion-core' ),
			'direct' => esc_html__( 'Direct Video', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Video Type', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose video type.', 'miion-core' ), 
		'id'	=> $prefix.'video_type',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'' => esc_html__( 'None', 'miion-core' ),
			'youtube' => esc_html__( 'Youtube', 'miion-core' ),
			'vimeo' => esc_html__( 'Vimeo', 'miion-core' ),
			'custom' => esc_html__( 'Custom Video', 'miion-core' )
		),
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'Video ID', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter Video ID Example: ZSt9tm3RoUU. If you choose custom video type then you enter custom video url and video must be mp4 format.', 'miion-core' ), 
		'id'	=> $prefix.'video_id',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'miion-core' )
	),
	array( 
		'label'	=> esc_html__( 'Audio', 'miion-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed audio format, then you must give audio id.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Audio Type', 'miion-core' ),
		'desc'	=> esc_html__( 'Choose audio type.', 'miion-core' ), 
		'id'	=> $prefix.'audio_type',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'' => esc_html__( 'None', 'miion-core' ),
			'soundcloud' => esc_html__( 'Soundcloud', 'miion-core' ),
			'custom' => esc_html__( 'Custom Audio', 'miion-core' )
		),
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'Audio ID', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter soundcloud audio ID. Example: 315307209.', 'miion-core' ), 
		'id'	=> $prefix.'audio_id',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'miion-core' )
	),
	array( 
		'label'	=> esc_html__( 'Gallery', 'miion-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed gallery format, then you must choose gallery images here.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Gallery Modal', 'miion-core' ),
		'id'	=> $prefix.'gallery_modal',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'default' => esc_html__( 'Default Gallery', 'miion-core' ),
			'popup' => esc_html__( 'Popup Gallery', 'miion-core' ),
			'grid' => esc_html__( 'Grid Popup Gallery', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Choose Gallery Images', 'miion-core' ),
		'id'	=> $prefix.'gallery',
		'type'	=> 'gallery',
		'tab'	=> esc_html__( 'Format', 'miion-core' )
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'miion-core' )
	),
	array( 
		'label'	=> esc_html__( 'Quote', 'miion-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed quote format, then you must fill the quote text and author name box.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Quote Modal', 'miion-core' ),
		'id'	=> $prefix.'quote_modal',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'featured' => esc_html__( 'Dark Overlay', 'miion-core' ),
			'theme-overlay' => esc_html__( 'Theme Overlay', 'miion-core' ),
			'theme' => esc_html__( 'Theme Color Background', 'miion-core' ),
			'none' => esc_html__( 'None', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Quote Text', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter quote text.', 'miion-core' ), 
		'id'	=> $prefix.'quote_text',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'textarea',
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'Quote Author', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter quote author name.', 'miion-core' ), 
		'id'	=> $prefix.'quote_author',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'miion-core' )
	),
	array( 
		'label'	=> esc_html__( 'Link', 'miion-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed link format, then you must fill the external link box.', 'miion-core' ), 
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Link Modal', 'miion-core' ),
		'id'	=> $prefix.'link_modal',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
			'featured' => esc_html__( 'Dark Overlay', 'miion-core' ),
			'theme-overlay' => esc_html__( 'Theme Overlay', 'miion-core' ),
			'theme' => esc_html__( 'Theme Color Background', 'miion-core' ),
			'none' => esc_html__( 'None', 'miion-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Link Text', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter link text to show.', 'miion-core' ), 
		'id'	=> $prefix.'link_text',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'External Link', 'miion-core' ),
		'desc'	=> esc_html__( 'Enter external link.', 'miion-core' ), 
		'id'	=> $prefix.'extrenal_link',
		'tab'	=> esc_html__( 'Format', 'miion-core' ),
		'type'	=> 'url',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'miion-core' )
	),
	
);
/**
 * Instantiate the class with all variables to create a meta box
 * var $id string meta box id
 * var $title string title
 * var $fields array fields
 * var $page string|array post type to add meta box to
 * var $js bool including javascript or not
 */
 
$post_box = new Custom_Add_Meta_Box( 'miion_post_metabox', esc_html__( 'Miion Post Options', 'miion-core' ), $fields, 'post', true );

/* Miion Page Options */
function miionMetaboxFields( $prefix ){
	
	$miion_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
	$miion_nav_menus = array( "none" => esc_html__( "None", "miion" ) );
	foreach( $miion_menus as $menu ){
		$miion_nav_menus[$menu->slug] = $menu->name;
	}
			
	$fields = array(
		array( 
			'label'	=> esc_html__( 'Page General Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page general settings.', 'miion-core' ), 
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Page Layout', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page layout for current post single view.', 'miion-core' ), 
			'id'	=> $prefix.'layout',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'wide' => esc_html__( 'Wide', 'miion-core' ),
				'boxed' => esc_html__( 'Boxed', 'miion-core' )			
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Page Content Padding Option', 'miion-core' ),
			'id'	=> $prefix.'content_padding_opt',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'		
		),
		array( 
			'label'	=> esc_html__( 'Page Content Padding', 'miion-core' ), 
			'desc'	=> esc_html__( 'Set the top/right/bottom/left padding of page content.', 'miion-core' ),
			'id'	=> $prefix.'content_padding',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'space',
			'required'	=> array( $prefix.'content_padding_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Background Color', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose color setting for current page background.', 'miion-core' ),
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'main_bg_color'
		),
		array( 
				'label'	=> esc_html__( 'Page Background Image', 'miion-core' ),
				'desc'	=> esc_html__( 'Choose custom logo image for current page.', 'miion-core' ), 
				'tab'	=> esc_html__( 'General', 'miion-core' ),
				'type'	=> 'image',
				'id'	=> $prefix.'main_bg_image'
			),
		array( 
			'label'	=> esc_html__( 'Page Margin', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are margin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'main_margin'
		),
		array( 
			'label'	=> esc_html__( 'Page Template Option', 'miion-core' ),
			'id'	=> $prefix.'template_opt',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'		
		),
		array( 
			'label'	=> esc_html__( 'Page Template', 'miion-core' ),
			'id'	=> $prefix.'template',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'no-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/1.png' ), 
				'right-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/2.png' ), 
				'left-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/3.png' ), 
				'both-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/4.png' ), 
			),
			'default'	=> 'right-sidebar',
			'required'	=> array( $prefix.'template_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Left Sidebar', 'miion-core' ),
			'id'	=> $prefix.'left_sidebar',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'template_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Right Sidebar', 'miion-core' ),
			'id'	=> $prefix.'right_sidebar',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'template_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Sidebar On Mobile', 'miion-core' ),
			'id'	=> $prefix.'sidebar_mobile',
			'tab'	=> esc_html__( 'General', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'1' => esc_html__( 'Show', 'miion-core' ),
				'0' => esc_html__( 'Hide', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header General Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header general settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Extra Class', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter extra class name for additional class name for header.', 'miion-core' ), 
			'id'	=> $prefix.'header_extra_class',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Header Layout', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page layout for current page header layout.', 'miion-core' ), 
			'id'	=> $prefix.'header_layout',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'wide' => esc_html__( 'Wide', 'miion-core' ),
				'boxed' => esc_html__( 'Boxed', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Type', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page layout for current page header type.', 'miion-core' ), 
			'id'	=> $prefix.'header_type',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'default' => esc_html__( 'Default', 'miion-core' ),
				'left-sticky' => esc_html__( 'Left Sticky', 'miion-core' ),
				'right-sticky' => esc_html__( 'Right Sticky', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Background Image', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header background image for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'header_bg_img',
			'required'	=> array( $prefix.'header_type', 'default' )
		),
		array( 
			'label'	=> esc_html__( 'Header Items Options', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
			'id'	=> $prefix.'header_items_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header general items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_items',
			'dd_fields' => array ( 
				'Normal' => array( 
					'header-topbar' 	=> esc_html__( 'Topbar', 'miion-core' ),
					'header-logo'	=> esc_html__( 'Logo Bar', 'miion-core' )
				),
				'Sticky' => array( 
					'header-nav' 	=> esc_html__( 'Navbar', 'miion-core' )
				),
				'disabled' => array()
			),
			'required'	=> array( $prefix.'header_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Absolute Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header absolute to change header look transparent.', 'miion-core' ), 
			'id'	=> $prefix.'header_absolute_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'1' => esc_html__( 'Enable', 'miion-core' ),
				'0' => esc_html__( 'Disable', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header sticky options.', 'miion-core' ), 
			'id'	=> $prefix.'header_sticky_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'sticky' => esc_html__( 'Header Sticky Part', 'miion-core' ),
				'sticky-scroll' => esc_html__( 'Sticky Scroll Up', 'miion-core' ),
				'none' => esc_html__( 'None', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Secondary Space Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose secondary space option for enable secondary menu space for current page.', 'miion-core' ), 
			'id'	=> $prefix.'header_secondary_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'enable' => esc_html__( 'Enable', 'miion-core' ),
				'disable' => esc_html__( 'Disable', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Secondary Space Animate Type', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose secondary space option animate type for current page.', 'miion-core' ), 
			'id'	=> $prefix.'header_secondary_animate',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array(
				'left-push'		=> esc_html__( 'Left Push', 'miion-core' ),
				'left-overlay'	=> esc_html__( 'Left Overlay', 'miion-core' ),
				'right-push'	=> esc_html__( 'Right Push', 'miion-core' ),
				'right-overlay'	=> esc_html__( 'Right Overlay', 'miion-core' ),
				'full-overlay'	=> esc_html__( 'Full Page Overlay', 'miion-core' ),
			),
			'default'	=> 'left-push',
			'required'	=> array( $prefix.'header_secondary_opt', 'enable' )
		),
		array( 
			'label'	=> esc_html__( 'Secondary Space Width', 'miion-core' ),
			'desc'	=> esc_html__( 'Set secondary space width for current page. Example 300', 'miion-core' ), 
			'id'	=> $prefix.'header_secondary_width',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'header_secondary_opt', 'enable' )
		),
		array( 
			'label'	=> esc_html__( 'Custom Logo', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose custom logo image for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'custom_logo',
		),
		array( 
			'label'	=> esc_html__( 'Custom Sticky Logo', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose custom sticky logo image for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'custom_sticky_logo',
		),
		array( 
			'label'	=> esc_html__( 'Select Navigation Menu', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose navigation menu for current page.', 'miion-core' ), 
			'id'	=> $prefix.'nav_menu',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => $miion_nav_menus
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Options', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
			'id'	=> $prefix.'header_topbar_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Height', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar height for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_topbar_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Height', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar sticky height for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_topbar_sticky_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header topbar skin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header topbar skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'header_topbar_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_topbar_font',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_topbar_bg',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_topbar_link',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_topbar_border',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_topbar_padding',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header top bar sticky skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'header_topbar_sticky_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky font color for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_topbar_sticky_font',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky background color for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_topbar_sticky_bg',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky link color settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_topbar_sticky_link',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky border settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_topbar_sticky_border',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky padding settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_topbar_sticky_padding',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Items Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header topbar items enable options.', 'miion-core' ), 
			'id'	=> $prefix.'header_topbar_items_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header topbar items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_topbar_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'header-topbar-date' => esc_html__( 'Date', 'miion-core' ),						
				),
				'Center' => array(),
				'Right' => array(),
				'disabled' => array(
					'header-topbar-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
					'header-topbar-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),
					'header-topbar-text-3'	=> esc_html__( 'Custom Text 3', 'miion-core' ),
					'header-topbar-menu'    => esc_html__( 'Top Bar Menu', 'miion-core' ),
					'header-topbar-social'	=> esc_html__( 'Social', 'miion-core' ),
					'header-topbar-search'	=> esc_html__( 'Search', 'miion-core' ),
					'header-topbar-search-toggle'	=> esc_html__( 'Search Toggle', 'miion-core' ),
					'header-cart'   		=> esc_html__( 'Cart', 'miion-core' )
				)
			),
			'required'	=> array( $prefix.'header_topbar_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Options', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
			'id'	=> $prefix.'header_logo_bar_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Height', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar height for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_logo_bar_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Height', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky height for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_logo_bar_sticky_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header logo bar skin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header logo bar skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'header_logo_bar_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_logo_bar_font',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_logo_bar_bg',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_logo_bar_link',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_logo_bar_border',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_logo_bar_padding',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header logo bar sticky skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'header_logobar_sticky_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky font color for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_logobar_sticky_font',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky background color for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_logobar_sticky_bg',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky link color settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_logobar_sticky_link',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky border settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_logobar_sticky_border',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky padding settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_logobar_sticky_padding',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Items Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header logo bar items enable options.', 'miion-core' ), 
			'id'	=> $prefix.'header_logo_bar_items_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_logo_bar_items',
			'dd_fields' => array ( 
				'Left'  => array(),
				'Center' => array(
					'header-logobar-logo'	=> esc_html__( 'Logo', 'miion-core' ),
				),
				'Right' => array(),
				'disabled' => array(
					'header-logobar-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
					'header-logobar-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),
					'header-logobar-text-3'	=> esc_html__( 'Custom Text 3', 'miion-core' ),
					'header-logobar-menu'    => esc_html__( 'Main Menu', 'miion-core' ),
					'header-logobar-social'	=> esc_html__( 'Social', 'miion-core' ),
					'header-logobar-search'	=> esc_html__( 'Search', 'miion-core' ),
					'header-logobar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'miion-core' ),
					'header-logobar-search-toggle'	=> esc_html__( 'Search Toggle', 'miion-core' ),
					'header-cart'   		=> esc_html__( 'Cart', 'miion-core' )
				)
			),
			'required'	=> array( $prefix.'header_logo_bar_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Options', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'miion-core' ), 
			'id'	=> $prefix.'header_navbar_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Height', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar height for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_navbar_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Height', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky height for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_navbar_sticky_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header navbar skin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header navbar skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'header_navbar_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_navbar_font',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_navbar_bg',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_navbar_link',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_navbar_border',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_navbar_padding',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header navbar sticky skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'header_navbar_sticky_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky font color for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_navbar_sticky_font',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky background color for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_navbar_sticky_bg',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky link color settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_navbar_sticky_link',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky border settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_navbar_sticky_border',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky padding settings for current post.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_navbar_sticky_padding',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Items Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header navbar items enable options.', 'miion-core' ), 
			'id'	=> $prefix.'header_navbar_items_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header navbar items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_navbar_items',
			'dd_fields' => array ( 
				'Left'  => array(											
					'header-navbar-menu'    => esc_html__( 'Main Menu', 'miion-core' ),
				),
				'Center' => array(
				),
				'Right' => array(
					'header-navbar-search'	=> esc_html__( 'Search', 'miion-core' ),
				),
				'disabled' => array(
					'header-navbar-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
					'header-navbar-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),
					'header-navbar-text-3'	=> esc_html__( 'Custom Text 3', 'miion-core' ),
					'header-navbar-logo'	=> esc_html__( 'Logo', 'miion-core' ),
					'header-navbar-social'	=> esc_html__( 'Social', 'miion-core' ),
					'header-navbar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'miion-core' ),
					'header-navbar-search-toggle'	=> esc_html__( 'Search Toggle', 'miion-core' ),
					'header-navbar-sticky-logo'	=> esc_html__( 'Stikcy Logo', 'miion-core' ),
					'header-cart'   		=> esc_html__( 'Cart', 'miion-core' )
				)
			),
			'required'	=> array( $prefix.'header_navbar_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header sticky settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Options', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header sticky part option.', 'miion-core' ), 
			'id'	=> $prefix.'header_stikcy_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Width', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header sticky part width for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_stikcy_width',
			'property' => 'width',
			'required'	=> array( $prefix.'header_stikcy_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header sticky skin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header sticky skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'header_stikcy_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header sticky font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_stikcy_font',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header sticky background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_stikcy_bg',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header Sticky link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_stikcy_link',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header sticky border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_stikcy_border',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header sticky padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_stikcy_padding',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Items Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose header sticky items enable options.', 'miion-core' ), 
			'id'	=> $prefix.'header_stikcy_items_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are header sticky items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_stikcy_items',
			'dd_fields' => array ( 
				'Top'  => array(
					'header-fixed-logo' => esc_html__( 'Logo', 'miion-core' )
				),
				'Middle'  => array(
					'header-fixed-menu'	=> esc_html__( 'Menu', 'miion-core' )					
				),
				'Bottom'  => array(
					'header-fixed-social'	=> esc_html__( 'Social', 'miion-core' )					
				),
				'disabled' => array(
					'header-fixed-text-1'	=> esc_html__( 'Custom Text 1', 'miion-core' ),
					'header-fixed-text-2'	=> esc_html__( 'Custom Text 2', 'miion-core' ),					
					'header-fixed-search'	=> esc_html__( 'Search Form', 'miion-core' )
				)
			),
			'required'	=> array( $prefix.'header_stikcy_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Bar', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title bar settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Page Title Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page title enable or disable.', 'miion-core' ), 
			'id'	=> $prefix.'header_page_title_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'1' => esc_html__( 'Enable', 'miion-core' ),
				'0' => esc_html__( 'Disable', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Page Title Text', 'miion-core' ),
			'desc'	=> esc_html__( 'If this page title is empty, then showing current page default title.', 'miion-core' ), 
			'id'	=> $prefix.'header_page_title_text',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Description', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter page title description.', 'miion-core' ), 
			'id'	=> $prefix.'header_page_title_desc',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'textarea',
			'default'	=> '',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Parallax', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page title background parallax.', 'miion-core' ), 
			'id'	=> $prefix.'header_page_title_parallax',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'1' => esc_html__( 'Enable', 'miion-core' ),
				'0' => esc_html__( 'Disable', 'miion-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Video Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page title background video option.', 'miion-core' ), 
			'id'	=> $prefix.'header_page_title_video_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'1' => esc_html__( 'Enable', 'miion-core' ),
				'0' => esc_html__( 'Disable', 'miion-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Video', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter youtube video ID. Example: ZSt9tm3RoUU.', 'miion-core' ), 
			'id'	=> $prefix.'header_page_title_video',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'header_page_title_video_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Bar Items Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page title bar items option.', 'miion-core' ), 
			'id'	=> $prefix.'page_title_items_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Bar Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title bar items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'page_title_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'title' => esc_html__( 'Page Title Text', 'miion-core' ),
				),
				'Center'  => array(
					
				),
				'Right'  => array(
					'breadcrumb'	=> esc_html__( 'Breadcrumb', 'miion-core' )
				),
				'disabled' => array(
					'description' => esc_html__( 'Page Title Description', 'miion-core' )
				)
			),
			'required'	=> array( $prefix.'page_title_items_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are page title skin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'label',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose page title skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'page_title_skin_opt',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'page_title_font',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Description Color', 'miion-core' ),
			'desc'	=> esc_html__( 'This is page title description color.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'page_title_desc_color',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'page_title_bg',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Image', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter page title background image url.', 'miion-core' ), 
			'id'	=> $prefix.'page_title_bg_img',
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> '',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'page_title_link',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'page_title_border',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'page_title_padding',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Overlay', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are page title overlay color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Header', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'page_title_overlay',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer General',
			'desc'	=> esc_html__( 'These all are header footer settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer layout for current page.', 'miion-core' ), 
			'id'	=> $prefix.'footer_layout',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'wide' => esc_html__( 'Wide', 'miion-core' ),
				'boxed' => esc_html__( 'Boxed', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Hidden Footer', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose hidden footer option.', 'miion-core' ), 
			'id'	=> $prefix.'hidden_footer',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'1' => esc_html__( 'Enable', 'miion-core' ),
				'0' => esc_html__( 'Disable', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are footer skin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Skin Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer skin settings options.', 'miion-core' ), 
			'id'	=> $prefix.'footer_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_font',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Background Image', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer background image for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'footer_bg_img',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Background Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_bg',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Background Overlay', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer background overlay color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_bg_overlay',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_link',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_border',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_padding',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Items Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer items enable options.', 'miion-core' ), 
			'id'	=> $prefix.'footer_items_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'footer_items',
			'dd_fields' => array ( 
				'Enabled'  => array(
					'footer-bottom'	=> esc_html__( 'Footer Bottom', 'miion-core' )
				),
				'disabled' => array(
					'footer-top' => esc_html__( 'Footer Top', 'miion-core' ),
					'footer-middle'	=> esc_html__( 'Footer Middle', 'miion-core' )
				)
			),
			'required'	=> array( $prefix.'footer_items_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Top',
			'desc'	=> esc_html__( 'These all are footer top settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Skin', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer top skin options.', 'miion-core' ), 
			'id'	=> $prefix.'footer_top_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer top font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_top_font',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Widget Title color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer top widget title color.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_top_widget_title_color',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_top_bg',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer top link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_top_link',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer top border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_top_border',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer top padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_top_padding',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Top Columns and Sidebars Settings',
			'desc'	=> esc_html__( 'These all are footer top columns and sidebar settings.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer layout option.', 'miion-core' ), 
			'id'	=> $prefix.'footer_top_layout_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout', 'miion-core' ),
			'id'	=> $prefix.'footer_top_layout',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'3-3-3-3'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
				'4-4-4'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
				'3-6-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
				'6-6'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
				'9-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
				'3-9'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
				'4-2-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
				'6-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
				'12'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
			),
			'default'	=> '4-4-4',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer First Column',
			'desc'	=> esc_html__( 'Select footer first column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_top_sidebar_1',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Second Column',
			'desc'	=> esc_html__( 'Select footer second column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_top_sidebar_2',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Third Column',
			'desc'	=> esc_html__( 'Select footer third column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_top_sidebar_3',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Fourth Column',
			'desc'	=> esc_html__( 'Select footer fourth column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_top_sidebar_4',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Middle',
			'desc'	=> esc_html__( 'These all are footer middle settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Skin', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer middle skin options.', 'miion-core' ), 
			'id'	=> $prefix.'footer_middle_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer middle font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_middle_font',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Widget Title Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer middle widget title color.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_middle_widget_title_color',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_middle_bg',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer middle link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_middle_link',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer middle border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_middle_border',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer middle padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_middle_padding',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Middle Columns and Sidebars Settings',
			'desc'	=> esc_html__( 'These all are footer middle columns and sidebar settings.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer layout option.', 'miion-core' ), 
			'id'	=> $prefix.'footer_middle_layout_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout', 'miion-core' ),
			'id'	=> $prefix.'footer_middle_layout',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'3-3-3-3'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
				'4-4-4'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
				'3-6-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
				'6-6'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
				'9-3'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
				'3-9'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
				'4-2-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
				'6-2-2-2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
				'12'		=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
			),
			'default'	=> '4-4-4',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer First Column',
			'desc'	=> esc_html__( 'Select footer first column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_1',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Second Column',
			'desc'	=> esc_html__( 'Select footer second column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_2',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Third Column',
			'desc'	=> esc_html__( 'Select footer third column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_3',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Fourth Column',
			'desc'	=> esc_html__( 'Select footer fourth column widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_4',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Bottom',
			'desc'	=> esc_html__( 'These all are footer bottom settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Fixed', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom fixed option.', 'miion-core' ), 
			'id'	=> $prefix.'footer_bottom_fixed',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'1' => esc_html__( 'Enable', 'miion-core' ),
				'0' => esc_html__( 'Disable', 'miion-core' )			
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are footer bottom skin settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Skin', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom skin options.', 'miion-core' ), 
			'id'	=> $prefix.'footer_bottom_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Font Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom font color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_bottom_font',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Background', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom background color for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_bottom_bg',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Link Color', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom link color settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_bottom_link',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Border', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom border settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_bottom_border',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Padding', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom padding settings for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_bottom_padding',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Widget Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom widget options.', 'miion-core' ), 
			'id'	=> $prefix.'footer_bottom_widget_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> 'Footer Bottom Widget',
			'desc'	=> esc_html__( 'Select footer bottom widget.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'id'	=> $prefix.'footer_bottom_widget',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_bottom_widget_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Items Option', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom items options.', 'miion-core' ), 
			'id'	=> $prefix.'footer_bottom_items_opt',
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom items for current page.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Footer', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'footer_bottom_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'copyright' => esc_html__( 'Copyright Text', 'miion-core' )
				),
				'Center'  => array(
					'menu'	=> esc_html__( 'Footer Menu', 'miion-core' )
				),
				'Right'  => array(),
				'disabled' => array(
					'social'	=> esc_html__( 'Footer Social Links', 'miion-core' ),
					'widget'	=> esc_html__( 'Custom Widget', 'miion-core' )
				)
			),
			'required'	=> array( $prefix.'footer_bottom_items_opt', 'custom' )
		),
		//Header Slider
		array( 
			'label'	=> esc_html__( 'Slider', 'miion-core' ),
			'desc'	=> esc_html__( 'This header slider settings.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Slider', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Slider Option', 'miion-core' ),
			'id'	=> $prefix.'header_slider_opt',
			'tab'	=> esc_html__( 'Slider', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'bottom' => esc_html__( 'Below Header', 'miion-core' ),
				'top' => esc_html__( 'Above Header', 'miion-core' ),
				'none' => esc_html__( 'None', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Slider Shortcode', 'miion-core' ),
			'desc'	=> esc_html__( 'This is the place for enter slider shortcode. Example revolution slider shortcodes.', 'miion-core' ), 
			'id'	=> $prefix.'header_slider',
			'tab'	=> esc_html__( 'Slider', 'miion-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
	);
	return $fields;
}
$page_fields = miionMetaboxFields( 'miion_page_' );
$page_box = new Custom_Add_Meta_Box( 'miion_page_metabox', esc_html__( 'Miion Page Options', 'miion-core' ), $page_fields, 'page', true );

/* Custom Post Type Options */
$miion_cpt = MiionFamework::miionStaticThemeMod( 'cpt-opts' );

// Portfolio Options
if( is_array( $miion_cpt ) && in_array( "portfolio", $miion_cpt ) ){
	
	// CPT Portfolio Metabox
	$prefix = 'miion_portfolio_';
	$portfolio_fields = array(
		array( 
			'label'	=> esc_html__( 'Portfolio General Settings', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are single portfolio general settings.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Layout Option', 'miion-core' ),
			'id'	=> $prefix.'layout_opt',
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'		
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Layout', 'miion-core' ),
			'id'	=> $prefix.'layout',
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'1'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/1.png', 
				'2'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/2.png',
				'3'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/3.png',
				'4'	=> MIION_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/4.png'
	
			),
			'default'	=> '1',
			'required'	=> array( $prefix.'layout_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Sticky Column', 'miion-core' ),
			'id'	=> $prefix.'sticky',
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'none' => esc_html__( 'None', 'miion-core' ),
				'right' => esc_html__( 'Right Column', 'miion-core' ),
				'left' => esc_html__( 'Left Column', 'miion-core' )
			),
			'default'	=> 'none'		
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Format', 'miion-core' ),
			'id'	=> $prefix.'format',
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'standard' => esc_html__( 'Standard', 'miion-core' ),
				'video' => esc_html__( 'Video', 'miion-core' ),
				'audio' => esc_html__( 'Audio', 'miion-core' ),
				'gallery' => esc_html__( 'Gallery', 'miion-core' ),
				'gmap' => esc_html__( 'Google Map', 'miion-core' )
			),
			'default'	=> 'standard'		
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Meta Items Options', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose portfolio meta items option.', 'miion-core' ), 
			'id'	=> $prefix.'items_opt',
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'miion-core' ),
				'custom' => esc_html__( 'Custom', 'miion-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Meta Items', 'miion-core' ),
			'desc'	=> esc_html__( 'These all are meta items for portfolio. drag and drop needed items from disabled part to enabled.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'items',
			'dd_fields' => array ( 
				'Enabled'  => array(
					'date'		=> esc_html__( 'Date', 'miion-core' ),
					'client'	=> esc_html__( 'Client', 'miion-core' ),
					'category'	=> esc_html__( 'Category', 'miion-core' ),
					'share'		=> esc_html__( 'Share', 'miion-core' ),
				),
				'disabled' => array(
					'tag'		=> esc_html__( 'Tags', 'miion-core' ),
					'duration'	=> esc_html__( 'Duration', 'miion-core' ),
					'url'		=> esc_html__( 'URL', 'miion-core' ),
					'place'		=> esc_html__( 'Place', 'miion-core' ),
					'estimation'=> esc_html__( 'Estimation', 'miion-core' ),
				)
			),
			'required'	=> array( $prefix.'items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Custom Redirect URL', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter url for custom webpage redirection. This link only for portfolio archive layout not for single portfolio.', 'miion-core' ), 
			'id'	=> $prefix.'custom_url',
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Custom Redirect URL Target', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose custom url page navigate to blank or same page.', 'miion-core' ), 
			'id'	=> $prefix.'custom_url_target',
			'tab'	=> esc_html__( 'Portfolio', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'_blank' => esc_html__( 'Blank', 'miion-core' ),
				'_self' => esc_html__( 'Self', 'miion-core' )
			),
			'default'	=> '_blank'
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Date', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose/Enter portfolio date.', 'miion-core' ), 
			'id'	=> $prefix.'date',
			'tab'	=> esc_html__( 'Info', 'miion-core' ),
			'type'	=> 'date',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Date Format', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter date format to show selcted portfolio date. Example: F j, Y', 'miion-core' ), 
			'id'	=> $prefix.'date_format',
			'tab'	=> esc_html__( 'Info', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> 'F j, Y'
		),
		array( 
			'label'	=> esc_html__( 'Client Name', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter client name.', 'miion-core' ), 
			'id'	=> $prefix.'client_name',
			'tab'	=> esc_html__( 'Info', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Duration', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter duration years or months.', 'miion-core' ), 
			'id'	=> $prefix.'duration',
			'tab'	=> esc_html__( 'Info', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Estimation', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter project estimation.', 'miion-core' ), 
			'id'	=> $prefix.'estimation',
			'tab'	=> esc_html__( 'Info', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Place', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter project place.', 'miion-core' ), 
			'id'	=> $prefix.'place',
			'tab'	=> esc_html__( 'Info', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'URL', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter project URL.', 'miion-core' ), 
			'id'	=> $prefix.'url',
			'tab'	=> esc_html__( 'Info', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		//Portfolio Format
		array( 
			'label'	=> esc_html__( 'Video', 'miion-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed video format, then you must choose video type and give video id.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Video Modal', 'miion-core' ),
			'id'	=> $prefix.'video_modal',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'onclick' => esc_html__( 'On Click Run Video', 'miion-core' ),
				'overlay' => esc_html__( 'Modal Box Video', 'miion-core' ),
				'direct' => esc_html__( 'Direct Video', 'miion-core' )
			),
			'default'	=> 'direct'
		),
		array( 
			'label'	=> esc_html__( 'Video Type', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose video type.', 'miion-core' ), 
			'id'	=> $prefix.'video_type',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'' => esc_html__( 'None', 'miion-core' ),
				'youtube' => esc_html__( 'Youtube', 'miion-core' ),
				'vimeo' => esc_html__( 'Vimeo', 'miion-core' ),
				'custom' => esc_html__( 'Custom Video', 'miion-core' )
			),
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Video ID', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter Video ID Example: ZSt9tm3RoUU. If you choose custom video type then you enter custom video url and video must be mp4 format.', 'miion-core' ), 
			'id'	=> $prefix.'video_id',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'miion-core' )
		),
		array( 
			'label'	=> esc_html__( 'Audio', 'miion-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed audio format, then you must give audio id.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Audio Type', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose audio type.', 'miion-core' ), 
			'id'	=> $prefix.'audio_type',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'' => esc_html__( 'None', 'miion-core' ),
				'soundcloud' => esc_html__( 'Soundcloud', 'miion-core' ),
				'custom' => esc_html__( 'Custom Audio', 'miion-core' )
			),
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Audio ID', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter soundcloud audio ID. Example: 315307209.', 'miion-core' ), 
			'id'	=> $prefix.'audio_id',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'miion-core' )
		),
		array( 
			'label'	=> esc_html__( 'Gallery', 'miion-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed gallery format, then you must choose gallery images here.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Gallery Modal', 'miion-core' ),
			'id'	=> $prefix.'gallery_modal',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'default' => esc_html__( 'Default Gallery', 'miion-core' ),
				'normal' => esc_html__( 'Normal Gallery', 'miion-core' ),
				'grid' => esc_html__( 'Grid/Masonry Gallery', 'miion-core' )
			),
			'default'	=> 'default'
		),
		array( 
			'label'	=> esc_html__( 'Grid Gutter Size', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter gallery grid gutter size. Example 20', 'miion-core' ), 
			'id'	=> $prefix.'grid_gutter',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'gallery_modal', 'grid' )
		),
		array( 
			'label'	=> esc_html__( 'Grid Columns', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter gallery grid columns count. Example 2', 'miion-core' ), 
			'id'	=> $prefix.'grid_cols',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'gallery_modal', 'grid' )
		),
		array( 
			'label'	=> esc_html__( 'Choose Gallery Images', 'miion-core' ),
			'id'	=> $prefix.'gallery',
			'type'	=> 'gallery',
			'tab'	=> esc_html__( 'Format', 'miion-core' )
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'miion-core' )
		),
		array( 
			'label'	=> esc_html__( 'Google Map', 'miion-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed google map format, then you must give google map lat, lang and map style.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Google Map Latitude', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter google latitude.', 'miion-core' ), 
			'id'	=> $prefix.'gmap_latitude',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Longitude', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter google longitude.', 'miion-core' ), 
			'id'	=> $prefix.'gmap_longitude',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Marker URL', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter google map custom marker url.', 'miion-core' ), 
			'id'	=> $prefix.'gmap_marker',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Style', 'miion-core' ),
			'id'	=> $prefix.'gmap_style',
			'tab'	=> esc_html__( 'Format', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'standard' => esc_html__( 'Standard', 'miion-core' ),
				'silver' => esc_html__( 'Silver', 'miion-core' ),
				'retro' => esc_html__( 'Retro', 'miion-core' ),
				'dark' => esc_html__( 'Dark', 'miion-core' ),
				'night' => esc_html__( 'Night', 'miion-core' ),
				'aubergine' => esc_html__( 'Aubergine', 'miion-core' )
			),
			'default'	=> 'standard'
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'miion-core' )
		),
	);
	// CPT Portfolio Options
	$portfolio_box = new Custom_Add_Meta_Box( 'miion_portfolio_metabox', esc_html__( 'Miion Portfolio Options', 'miion-core' ), $portfolio_fields, 'miion-portfolio', true );
	
	// CPT Portfolio Page Options
	$portfolio_page_box = new Custom_Add_Meta_Box( 'miion_portfolio_page_metabox', esc_html__( 'Miion Page Options', 'miion-core' ), $page_fields, 'miion-portfolio', true );
} // In theme option CPT option if portfolio exists
// Testimonial Options
if( is_array( $miion_cpt ) && in_array( "testimonial", $miion_cpt ) ){
	
	$prefix = 'miion_testimonial_';
	$testimonial_fields = array(	
		array( 
			'label'	=> esc_html__( 'Author Designation', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter author designation.', 'miion-core' ), 
			'id'	=> $prefix.'designation',
			'tab'	=> esc_html__( 'Testimonial', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Company Name', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter company name.', 'miion-core' ), 
			'id'	=> $prefix.'company_name',
			'tab'	=> esc_html__( 'Testimonial', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Company URL', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter company URL.', 'miion-core' ), 
			'id'	=> $prefix.'company_url',
			'tab'	=> esc_html__( 'Testimonial', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Rating', 'miion-core' ),
			'desc'	=> esc_html__( 'Set user rating.', 'miion-core' ), 
			'id'	=> $prefix.'rating',
			'tab'	=> esc_html__( 'Testimonial', 'miion-core' ),
			'type'	=> 'rating',
			'default'	=> ''
		)
	);
	
	// CPT Testimonial Options
	$testimonial_box = new Custom_Add_Meta_Box( 'miion_testimonial_metabox', esc_html__( 'Miion Testimonial Options', 'miion-core' ), $testimonial_fields, 'miion-testimonial', true );
	
	// CPT Testimonial Page Options
	$testimonial_page_box = new Custom_Add_Meta_Box( 'miion_testimonial_page_metabox', esc_html__( 'Miion Page Options', 'miion-core' ), $page_fields, 'miion-testimonial', true );
	
} // In theme option CPT option if testimonial exists
// Team Options
if( is_array( $miion_cpt ) && in_array( "team", $miion_cpt ) ){
	
	$prefix = 'miion_team_';
	$team_fields = array(	
		array( 
			'label'	=> esc_html__( 'Member Designation', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter member designation.', 'miion-core' ), 
			'id'	=> $prefix.'designation',
			'tab'	=> esc_html__( 'Team', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Member Email', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter member email.', 'miion-core' ), 
			'id'	=> $prefix.'email',
			'tab'	=> esc_html__( 'Team', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Link Target', 'miion-core' ),
			'id'	=> $prefix.'link_target',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'_blank' => esc_html__( 'New Window', 'miion-core' ),
				'_self' => esc_html__( 'Self Window', 'miion-core' )
			),
			'default'	=> '_blank'
		),
		array( 
			'label'	=> esc_html__( 'Facebook', 'miion-core' ),
			'desc'	=> esc_html__( 'Facebook profile link.', 'miion-core' ), 
			'id'	=> $prefix.'facebook',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Twitter', 'miion-core' ),
			'desc'	=> esc_html__( 'Twitter profile link.', 'miion-core' ), 
			'id'	=> $prefix.'twitter',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Instagram', 'miion-core' ),
			'desc'	=> esc_html__( 'Instagram profile link.', 'miion-core' ), 
			'id'	=> $prefix.'instagram',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Linkedin', 'miion-core' ),
			'desc'	=> esc_html__( 'Linkedin profile link.', 'miion-core' ), 
			'id'	=> $prefix.'linkedin',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Pinterest', 'miion-core' ),
			'desc'	=> esc_html__( 'Pinterest profile link.', 'miion-core' ), 
			'id'	=> $prefix.'pinterest',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Dribbble', 'miion-core' ),
			'desc'	=> esc_html__( 'Dribbble profile link.', 'miion-core' ), 
			'id'	=> $prefix.'dribbble',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Flickr', 'miion-core' ),
			'desc'	=> esc_html__( 'Flickr profile link.', 'miion-core' ), 
			'id'	=> $prefix.'flickr',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Youtube', 'miion-core' ),
			'desc'	=> esc_html__( 'Youtube profile link.', 'miion-core' ), 
			'id'	=> $prefix.'youtube',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Vimeo', 'miion-core' ),
			'desc'	=> esc_html__( 'Vimeo profile link.', 'miion-core' ), 
			'id'	=> $prefix.'vimeo',
			'tab'	=> esc_html__( 'Social', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		)
	);
	
	// CPT Team Options
	$team_box = new Custom_Add_Meta_Box( 'miion_team_metabox', esc_html__( 'Miion Team Options', 'miion-core' ), $team_fields, 'miion-team', true );
	
	// CPT Team Page Options
	$team_page_box = new Custom_Add_Meta_Box( 'miion_team_page_metabox', esc_html__( 'Miion Page Options', 'miion-core' ), $page_fields, 'miion-team', true );
	
} // In theme option CPT option if team exists
// Event Options
if( is_array( $miion_cpt ) && in_array( "events", $miion_cpt ) ){
	
	$prefix = 'miion_event_';
	$event_fields = array(	
		array( 
			'label'	=> esc_html__( 'Event Organiser Name', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event organiser name.', 'miion-core' ), 
			'id'	=> $prefix.'organiser_name',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Organiser Designation', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event organiser designation.', 'miion-core' ), 
			'id'	=> $prefix.'organiser_designation',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Start Date', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event start date.', 'miion-core' ), 
			'id'	=> $prefix.'start_date',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'date',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event End Date', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event end date.', 'miion-core' ), 
			'id'	=> $prefix.'end_date',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'date',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Date Format', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter date format to show selcted event date. Example: F j, Y', 'miion-core' ), 
			'id'	=> $prefix.'date_format',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> 'F j, Y'
		),
		array( 
			'label'	=> esc_html__( 'Event Start Time', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event start time.', 'miion-core' ), 
			'id'	=> $prefix.'time',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Cost', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event cost.', 'miion-core' ), 
			'id'	=> $prefix.'cost',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Custom Link for Event Item', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter custom link to redirect custom event page.', 'miion-core' ), 
			'id'	=> $prefix.'link',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Custom Link Target', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose custom link target to new window or self window.', 'miion-core' ), 
			'id'	=> $prefix.'link_target',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'_blank' => esc_html__( 'New Window', 'miion-core' ),
				'_self' => esc_html__( 'Self Window', 'miion-core' )
			),
			'default'	=> '_blank'
		),
		array( 
			'label'	=> esc_html__( 'Custom Link Button Text', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter custom link buttom text: Example More About Event.', 'miion-core' ), 
			'id'	=> $prefix.'link_text',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Schedule Content', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event schedule content. You can place here Shortcodes.', 'miion-core' ), 
			'id'	=> $prefix.'schedule_content',
			'tab'	=> esc_html__( 'Events', 'miion-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Venue Name', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event venue name.', 'miion-core' ), 
			'id'	=> $prefix.'venue_name',
			'tab'	=> esc_html__( 'Address', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Venue Address', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event venue address.', 'miion-core' ), 
			'id'	=> $prefix.'venue_address',
			'tab'	=> esc_html__( 'Address', 'miion-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'E-mail', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter email id for clarification about event.', 'miion-core' ), 
			'id'	=> $prefix.'email',
			'tab'	=> esc_html__( 'Address', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Phone', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter phone number for contact about event.', 'miion-core' ), 
			'id'	=> $prefix.'phone',
			'tab'	=> esc_html__( 'Address', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Website', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter event website.', 'miion-core' ), 
			'id'	=> $prefix.'website',
			'tab'	=> esc_html__( 'Address', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Latitude', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter map latitude.', 'miion-core' ), 
			'id'	=> $prefix.'gmap_latitude',
			'tab'	=> esc_html__( 'GMap', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Longitude', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter map longitude.', 'miion-core' ), 
			'id'	=> $prefix.'gmap_longitude',
			'tab'	=> esc_html__( 'GMap', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Marker URL', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter google map custom marker url.', 'miion-core' ), 
			'id'	=> $prefix.'gmap_marker',
			'tab'	=> esc_html__( 'GMap', 'miion-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Style', 'miion-core' ),
			'id'	=> $prefix.'gmap_style',
			'tab'	=> esc_html__( 'GMap', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'standard' => esc_html__( 'Standard', 'miion-core' ),
				'silver' => esc_html__( 'Silver', 'miion-core' ),
				'retro' => esc_html__( 'Retro', 'miion-core' ),
				'dark' => esc_html__( 'Dark', 'miion-core' ),
				'night' => esc_html__( 'Night', 'miion-core' ),
				'aubergine' => esc_html__( 'Aubergine', 'miion-core' )
			),
			'default'	=> 'standard'
		),
		array( 
			'label'	=> esc_html__( 'Google Map Height', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter map height in values. Example 400', 'miion-core' ), 
			'id'	=> $prefix.'gmap_height',
			'tab'	=> esc_html__( 'GMap', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> '400'
		),
		array( 
			'label'	=> esc_html__( 'Contact Form', 'miion-core' ),
			'desc'	=> esc_html__( 'Contact form shortcode here.', 'miion-core' ), 
			'id'	=> $prefix.'contact_form',
			'tab'	=> esc_html__( 'Contact', 'miion-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Info Columns', 'miion-core' ),
			'desc'	=> esc_html__( 'Enter column division values like given format. Example 3-3-6', 'miion-core' ), 
			'id'	=> $prefix.'col_layout',
			'tab'	=> esc_html__( 'Layout', 'miion-core' ),
			'type'	=> 'text',
			'default'	=> '3-3-6'
		),
		array( 
			'label'	=> esc_html__( 'Event Detail Items', 'miion-core' ),
			'desc'	=> esc_html__( 'This is layout settings for event.', 'miion-core' ), 
			'tab'	=> esc_html__( 'Layout', 'miion-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'event_info_items',
			'dd_fields' => array ( 
				'Enable'  => array(
					'event-details' => esc_html__( 'Event Details', 'miion-core' ),
					'event-venue' => esc_html__( 'Event Venue', 'miion-core' ),
					'event-map' => esc_html__( 'Event Map', 'miion-core' )
				),
				'disabled' => array(
					'event-form'	=> esc_html__( 'Event Form', 'miion-core' ),
				)
			),
		),
		array( 
			'label'	=> esc_html__( 'Navigation', 'miion-core' ),
			'id'	=> $prefix.'nav_position',
			'tab'	=> esc_html__( 'Layout', 'miion-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'top' => esc_html__( 'Top', 'miion-core' ),
				'bottom' => esc_html__( 'Bottom', 'miion-core' )
			),
			'default'	=> 'top'
		),
	);
	
	// CPT Events Options
	$event_box = new Custom_Add_Meta_Box( 'miion_event_metabox', esc_html__( 'Miion Event Options', 'miion-core' ), $event_fields, 'miion-events', true );
	
	// CPT Events Page Options
	$event_page_box = new Custom_Add_Meta_Box( 'miion_event_page_metabox', esc_html__( 'Miion Page Options', 'miion-core' ), $page_fields, 'miion-events', true );
	
} // In theme option CPT option if event exists
// Service Options
if( is_array( $miion_cpt ) && in_array( "services", $miion_cpt ) ){
	
	$prefix = 'miion_service_';
	
	$service_fields = array(	
		array( 
			'label'	=> esc_html__( 'Service Image', 'miion-core' ),
			'desc'	=> esc_html__( 'Choose service image for show front.', 'miion-core' ), 
			'id'	=> $prefix.'title_img',
			'tab'	=> esc_html__( 'Service', 'miion-core' ),
			'type'	=> 'image',
			'default'	=> ''
		)
	);
	
	// CPT Service Options
	$service_box = new Custom_Add_Meta_Box( 'miion_service_metabox', esc_html__( 'Miion Service Options', 'miion-core' ), $service_fields, 'miion-services', true );
	
	// CPT Events Page Options
	$service_page_box = new Custom_Add_Meta_Box( 'miion_service_page_metabox', esc_html__( 'Miion Page Options', 'miion-core' ), $page_fields, 'miion-services', true );
	
}