<?php
/**
 * Return the default options of the theme
 * 
 * @return  void
 */

function themesflat_customize_default($key) {
	$default = array(
		'social_links'	=> array ("facebook" => '#', "twitter" => '#', "instagram" => '#', "linkedin"  => '#'),
		'show_social_share' => 1,
		'show_popular_tag'	 => 1,	
		'social_footer' => 0,
		'go_top' => 1,
		'topbar_background_color'	=> '#fff',
		'message_background_color'	=> '',
		'topbar_textcolor'	=> '#666B68',
		'topbar_link_color' => '#0C171A',
		'topbar_link_color_hover' => '#FF3F25',
		'message_textcolor'	=> '',
		'message_link_color' => '',
		'message_link_color_hover' => '',
		'topbar_show' => 1 ,
		'header_message' => 0 ,
		'topbar_address_title' => 'Address',
        'topbar_address1' => 'Need professional medical & health Care?',
		'topbar_address2' => '<i class="icon-micare-phone"></i> Call : <span>+1 (234) 5688 9990<span>',
		'topbar_address3' => '<i class="icon-micare-mail"></i> Email :  <span>support@gmail.com<span>',
		'topbar_address4' => '<i class="icon-micare-clock"></i> Working Hours : <span>Mon-Friday, 08am - 09pm<span>',


		'social_topbar' => 1,
		'social_header' => 1,
		'typography_topbar' => array(
			'family' => 'Rethink Sans',
			'style'  => '400',
			'size'   => '16',
			'line_height'=>'1.5',
			'letter_spacing' => '',
		),
		'topbar_controls' => array('padding-top' => 0,'padding-bottom' => 0),
		'logo_controls' => array('padding-top' => '','padding-bottom' => ''),
		'style_header'	=> 'header-default',	
		'style_topbar'	=> 'topbar-default',	
		'header_backgroundcolor'=>'#ffffff',
		'header_background_bottom_color'=>'',
		'header_sticky' => 0,
		'header_search_box' => 0,
		'header_content_right' => '',
		'header_absolute'	=> 0,		
		'header_sidebar_toggler' => 0,
		'header_button'=>1,
		'header_button_text' => 'Make Appointment',
		'header_button_url' => '',


		'show_post_navigator' => 0,
		'logo_width' => 147,
		'menu_location_primary' => 'primary',
		'site_logo'	=> THEMESFLAT_LINK . 'images/logo.png',
		'site_logo_sticky'	=> THEMESFLAT_LINK . 'images/logo.png',
		'site_logo_fixed'	=> THEMESFLAT_LINK . 'images/logo.png',
		'site_logo_mobile'	=> THEMESFLAT_LINK . 'images/logo.png',	
		'header_color_sticky' => '',
		'show_bottom' => 1,		
		'header_backgroundcolor_sticky'=>'#fff',	

		'primary_color'=>'#0C171A',
		'secondary_color'=>'#FF3F25',
		'accent_color'=>'#0B55E5',
		
		'typography_body' => array(
			'family' => 'Rethink Sans',
			'style'  => '400',
			'size'   => '16',
			'line_height'=>'26px',
			'letter_spacing' => '0px',
		),
		'body_text_color'=>'#666B68',
		'body_background_color' => '',
		'page_sidebar_layout' => 'sidebar-right',
		'content_controls' => array('padding-top' => 130,'padding-bottom' => 130),

		'typography_menu' => array(
			'family' => 'Rethink Sans',
			'style'  => '500',
			'size'   => '18',
			'line_height'=>'70px',
			'letter_spacing' => '0px',
		), 
		'mainnav_color'		=> '#0C171A',
		'mainnav_hover_color'=>'#FF3F25',
		'mainnav_active_color'=>'#FF3F25',
		'sub_sub_nav_color'=>' #0C171A',
		'sub_sub_nav_background'=>'#FFFFFF',
		'sub_sub_nav_color_hover'=>'#FF3F25',
		'sub_sub_nav_background_hover'=>'',
		'menu_distance_between' => 24,
		'typography_sub_menu' => array(
			'family' => 'Rethink Sans',
			'style'  => '500',
			'size'   => '16',
			'line_height'=>'24px',
			'letter_spacing' => '0px',
		),
		'sub_nav_color'		=>'#0C171A',		
		'sub_nav_color_hover'	=>	'#FF3F25',
		'sub_nav_background'=>'#FFFFFF',
		'sub_nav_background_hover'=>'',
		'sub_nav_border_color' => '',
		'typography_headings'	=> array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'line_height'=>'1.333',
			'letter_spacing' => '0px'		
		),
		'h1_size' => 75,
		'h2_size' => 48,
		'h3_size' => 27,
		'h4_size' => 24,
		'h5_size' => 22,
		'h6_size' => 20,
		'typography_blockquote' => array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'size'   => '24',
			'line_height'=>'32px',
			'letter_spacing' => '0px',
		),	
		'typography_blog_post_title' => array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'size'   => '35',
			'line_height'=>'40px',
			'letter_spacing' => '',
		),
		'typography_blog_post_meta' => array(
			'family' => 'Rethink Sans',
			'style'  => '400',
			'size'   => '16',
			'line_height'=>'26px',
			'letter_spacing' => '',
		),
		'typography_blog_post_buttons' => array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'size'   => '14',
			'line_height'=>'22px',
			'letter_spacing' => '0px',
		),
		'typography_blog_single_title' => array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'size'   => '48',
			'line_height'=>'55px',
			'letter_spacing' => '',
		),
		'typography_blog_single_comment_title' => array(
			'family' => 'Rethink Sans',
			'style'  => '500',
			'size'   => '32',
			'line_height'=>'40px',
			'letter_spacing' => '0px',
		),
		'typography_sidebar_widget_title' => array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'size'   => '22',
			'line_height'=>'28px',
			'letter_spacing' => '0px',
		),	
		'typography_footer_widget_title' => array(
			'family' => 'Rethink Sans',
			'style'  => '600',
			'size'   => '22',
			'line_height'=>'20px',
			'letter_spacing' => '',
		),	
		'typography_page_title'	=> array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'size'   => '60',
			'line_height'=>'80px',
			'letter_spacing' => '-1.2px',
		),
		'page_title_background_color' => '',
		'page_title_background_color_opacity' => '',
		'page_title_text_color' => '',		
		'page_title_controls' => array('padding-top' => 174, 'padding-bottom' => 208),
		'page_title_background_image'=> THEMESFLAT_LINK . 'images/page_title.jpg',
		'page_title_image_size' => 'cover',
		'page_title_heading_enabled' => 1,
		'typography_breadcrumb'	=> array(
			'family' => 'Rethink Sans',
			'style'  => '600',
			'size'   => '16',
			'line_height'=>'1.5',
			'letter_spacing' => '0px',
		),
		'bread_crumb_prefix' =>'',
		'bread_crumb_description' =>'',
		'breadcrumb_separator' =>  '',
		'breadcrumb_color' => '#FFFFFF',

		'typography_buttons' => array(
			'family' => 'Rethink Sans',
			'style'  => '700',
			'size'   => '14',
			'line_height'=>'22px',
			'letter_spacing' => '0px',
		),
		'typography_pagination'	=> array(
			'family' => 'Rethink Sans',
			'style'  => '600',
			'size'   => '18',
			'line_height'=>'24px',
			'letter_spacing' => '0px',
		),		
		'typography_bottom_menu' => array(
			'family' => 'Rethink Sans',
			'style'  => '400',
			'size'   => '16',
			'line_height'=>'24px',
			'letter_spacing' => '0px',
		),
		'breadcrumb_enabled' => 1,
		'show_post_paginator' => 1,
		'blog_grid_columns' => 2,
		'post_content_elements' => 'meta,title,excerpt_content,readmore',
		'meta_elements' => 'author,date,comment',
		'blog_archive_exclude' => '',
		'blog_featured_title' => 'Blog Details',
		'style_blog_single' => 'content-single',
		'sidebar_layout' => 'sidebar-right',
		'blog_archive_layout' => 'blog-list',
		'related_post_style'	=> 'blog-grid',
		'grid_columns_post_related' => 2,
		'number_related_post' => 2,
		'blog_sidebar_list'		  => 'blog-sidebar',	
		'blog_archive_readmore' => 1,
		'blog_archive_post_excepts_length' => 25,
		'blog_archive_readmore_text' => 'Read more <i class="icon-micare-arrow-right"></i>',
		'blog_archive_pagination_style' => 'pager-numeric',
		'blog_posts_per_page'	=> 3,
		'blog_order_by'	=> 'date',
		'blog_order_direction' => 'DESC',
		'page_sidebar_list'	=> 'blog-sidebar',	

		'doctor_slug' => '',
		'doctor_name' => '',
		'doctor_show_filter' => 0,
		'doctor_grid_columns' => 3,
		'doctor_number_post'=> 9,
		'doctor_filter_category_order' => '',
		'doctor_order_by' => 'author,date,comment',
		'doctor_order_direction' => 'DESC',
		'doctor_exclude' => '',
		'doctor_layout' => 'fullwidth',
		'doctor_show_post_navigator' => 0,
		'doctor_show_entry_footer_content'	=> 0,
		'doctor_show_related' => 0,
		'doctor_related_grid_columns' => 3,
		'doctor_sidebar_list' => 'blog-sidebar',
		'doctor_post_image'	=> THEMESFLAT_LINK . 'images/logo.png',
		'number_related_post_doctor' => 3,
		'doctor_featured_title' => 'Doctor Details',

		'portfolio_slug' => '',
		'portfolio_number_post' => 4,


		'services_slug' => '',
		'style_archive' => '',
		'services_name' => '',
		'services_show_filter' => 0,
		'services_grid_columns' => 3,
		'services_number_post'=> 4,
		'services_archive_pagination_style' => 'pager-numeric',
		'services_filter_category_order' => '',
		'services_order_by' => 'date',
		'services_order_direction' => 'DESC',
		'services_exclude' => '',
		'services_layout' => 'sidebar-left',
		'services_sidebar_list' => 'themesflat-custom-sidebar-servicessidebar',
		'services_show_post_navigator' => 0,
		'services_show_related' => 0,
		'services_related_grid_columns' => 3,
		'number_related_post_services' => 3,
		'services_featured_title' => '',
		'services_title_single' => 1,
		'services_single_style' => 'default',

		'portfolio_slug' => '',
		'portfolio_name' => '',
		'portfolio_show_filter' => 0,
		'portfolio_grid_columns' => 3,
		'portfolio_number_post'=> 12,
		'portfolio_archive_pagination_style' => 'pager-numeric',
		'portfolio_filter_category_order' => '',
		'portfolio_order_by' => 'date',
		'portfolio_order_direction' => 'DESC',
		'portfolio_exclude' => '',
		'portfolio_layout' => 'fullwidth',
		'portfolio_sidebar_list' => 'themesflat-custom-sidebar-portfoliosidebar',
		'portfolio_show_post_navigator' => 0,
		'portfolio_show_related' => 0,
		'portfolio_related_grid_columns' => 3,
		'number_related_post_portfolio' => 3,
		'portfolio_featured_title' => '',
		'portfolio_title_single' => 1,
		'portfolio_single_style' => 'default',

		
		'typography_footer' => array(
			'family' => 'Rethink Sans',
			'style'  => '400',
			'size'   => '16',
			'line_height'=>'24px',
			'letter_spacing' => '',
		),
		'footer_background_color'	=> '#0C171A',
		'footer_title_widget_color' => '#fff',
		'footer_text_color'			=> '#A2A3AB',
		'footer_text_color_hover'   => '#FF3F25',
		'footer_widget_areas' => 2,
		'footer_controls' => array('padding-top' => '100', 'padding-bottom' =>'' ),
		'footer1' => 'footer-1',
		'footer2' => 'footer-2',
		'footer3' => 'footer-3',
		'footer4' => 'footer-4',
		'footer_background_image' => '',
		'enable_footer_fixed' => 0,
		'footer_image_size' => 'cover',
		'typography_bottom_copyright' => array(
			'family' => 'Rethink Sans',
			'style'  => '400',
			'size'   => '16',
			'line_height'=>'22px',
			'letter_spacing' => '',
		),
	
		'bottom_background_color'	=> '#0C171A',
		'bottom_text_color'			=> '#A2A3AB',
		'bottom_link_color'         => '#ffffff',
		'bottom_text_color_hover'   => '',		
		'social_bottom'   => 0,		
		'layout_version'			=> 'wide',		
		'footer_copyright'			=> '©<a href="https://themeforest.net/user/themesflat/portfolio">Themesflat </a>, All rights reserved',
		'enable_smooth_scroll'	=> 0,
		'enable_preload' => 1,
		'preload' => 'preload-6',
		'page_title_styles' => 'default',
		'page_title_alignment' => 'left',
		'page_title_video_url' => '',

        'show_partner'	=> 1,
		'img_partner' => '',
		'show_number_img_partner_desktop' => 6,
		'show_number_img_partner_tablet' => 4,
		'show_number_img_partner_mobile' => 2,
		'gap_img_partner' => 30,
		'partner_box_controls' => array('padding-top' => 67,'padding-bottom' => 64),
		'partner_box_background_color' => '#f2f7f5',
        'show_footer_info'	=> 0,
        'footer_info_text' => 'Solve Your IT Needs Today!',
		'footer_info_button_url' => '/contact-us',
        'footer_info_button' => 'GET SOLUTIONS',
	);
	return $default[$key];
}