<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package tophive
 */

get_header(); ?>
	<div class="content-inner">
		<?php
		do_action( 'tophive/content/before' );
		tophive_blog_posts_heading();
		$searchtext = $_GET['s'];
		$topics_wp_query = new WP_Query( array(
		    'post_type' => 'topic',
		    'posts_per_page' => 3,
		    'orderby'=> 'post_date',
		    's'=> $searchtext,
		    'post_status' => 'publish'
		));

		$topics = '';
		if( $topics_wp_query->have_posts() ){
			$topics .= '<div class="search-sections">';
				$topics .= '<h6>'. esc_html__( 'Topics', 'metafans' ) .'</h6>';
				while( $topics_wp_query->have_posts() ){
					$topics_wp_query->the_post();
					$topics .= '<p><a href="'. get_the_permalink() .'">' . get_the_title( get_the_ID() ) . '</a></p>';
				}
			$topics .= '</div>';
		}
		$forum_wp_query = new WP_Query( array(
		    'post_type' => 'forum',
		    'posts_per_page' => 3,
		    'orderby'=> 'post_date',
		    's'=> $searchtext,
		    'post_status' => 'publish'
		));

		$forum = '';
		if( $forum_wp_query->have_posts() ){
			$forum .= '<div class="search-sections">';
				$forum .= '<h6>'. esc_html__( 'Forum', 'metafans' ) .'</h6>';
				while( $forum_wp_query->have_posts() ){
					$forum_wp_query->the_post();
					$forum .= '<p><a href="'. get_the_permalink() .'">' . get_the_title( get_the_ID() ) . '</a></p>';
				}
			$forum .= '</div>';
		}

		$user_query = new WP_User_Query( 
			array(  
				'search' => '*' . $searchtext . '*',
				'search_columns' => array( 'user_nicename', 'user_login' ),
				'number' => 3,
			)
		);
		$members = '';
		if( $user_query->get_results() ){
			$members .= '<div class="search-sections">';
				$members .= '<h6>'. esc_html__( 'User', 'metafans' ) .'</h6>';
				foreach( $user_query->get_results() as $user ){
					$members .= '<p><a href="'. bp_core_get_user_domain( $user->ID ) .'">' . $user->display_name . '</a></p>';
				}
			$members .= '</div>';
		}
		

		$response = '<div class="main-search-page">' . $topics . $forum . $members . '</div>';

		if( empty($response) ){
			$response = '<p class="ec-mb-0">' . esc_html__( 'Nothing Found for your search', 'metafans' ) . '</p>';
		}
		echo tophive_sanitize_filter($response);
		do_action( 'tophive/content/after' );
		?>
	</div><!-- #.content-inner -->
<?php
get_footer();
