<?php
/**
 * Template Name: Buddypress Photos
 * The templates for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package tophive
 */

get_header(); ?>
	<div class="content-inner">
		<?php
			$all_images = [];
			do_action( 'tophive/content/before' );
			if( class_exists('BuddyPress') ){
				global $wpdb;
				$activities = $wpdb->get_results("SELECT id from {$wpdb->base_prefix}bp_activity", ARRAY_A);
				foreach( $activities as $id ){
					$activity_id = $id['id'];
					$images = bp_activity_get_meta( $activity_id, 'activity_media', false );

		 			if( !empty($images) ){
			 			$newImages = $images[0];
		 				foreach( $newImages as $newImage  ){
	 						$newImage['activity_id'] = $activity_id;
	 						array_push($all_images, $newImage);
		 				}
		 			}
				}
				array_filter($all_images);
			}
			

			$media_html = '<div class="ec-row bp-image-previewer">';
			$i = 1;
			
			foreach ($all_images as $url) {
				if( !empty($url['thumb']) ){
					$media_html .= '<div class="ec-col-md-3 bp-image-single" id="'. $i .'">';
						$media_html .= '<div class="post-media-single">';
							$media_html .= '<a class="media-popup-thumbnail" href="'. $url['thumb'][0] .'" data-id="'. $url['id'] .'" data-activity="'. $url['activity_id'] .'"><img src="'. $url['full'] .'" alt="gm"></a>';
						$media_html .= '</div>';
					$media_html .= '</div>';
				}
				$i++;
			}
			$media_html .= '</div>';
			echo tophive_sanitize_filter( $media_html );
			do_action( 'tophive/content/after' );
		?>
	</div><!-- #.content-inner -->
<?php
get_footer();
