<?php 
/**
 * MetaFans Integration for BuddyBress, Buddypress-gammiperss, Buddypress-learnpress
 */
class Tophive_BP
{
    static $_instance;

	static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	function is_active() {
		return tophive_metafans()->is_buddypress_active();
	}
	function __construct(){
		if( $this->is_active() ){
			require 'dom-parser.php';
			require 'inc/profile.php';
			require 'inc/activity.php';
			require 'inc/members.php';
			require 'inc/notification.php';
			add_action( 'tophive/sidebar-id', array($this, 'th_bp_sidebar_id'), 10, 3 );
	        add_action( 'wp_enqueue_scripts', array($this, 'load_scripts') );
			add_action( 'bp_core_setup_globals', array( $this, 'tophive_bp_set_default_component') );
			add_action( 'bp_actions', array( $this, 'tophive_bp_reorder_buddypress_profile_tabs'), 999 );
			add_action( 'upload_mimes', array( $this, 'add_file_types_to_uploads'));
			add_action( 'learn-press/buddypress/profile-tabs', array( $this, 'tophive_reorder_buddypress_lp_tabs'), 10, 1 );
			add_filter( 'bp_activity_allowed_tags', array($this, 'tophive_bp_activity_allowed_tags') );
			add_filter( 'bp_groups_default_extension', array( $this, 'th_groups_default_home') );
			add_action( 'bp_get_the_notification_action_links', array($this, 'th_bp_notification_action_links'), 10, 2 );
			add_action( 'bp_setup_nav', array($this, 'profile_tab_photos') );

			add_action( 'wp_ajax_th_bp_bb_social_search', array($this, 'buddypress_bbpress_social_search') );
			add_action( 'wp_ajax_nopriv_th_bp_bb_social_search', array($this, 'buddypress_bbpress_social_search') );

	        add_action( 'wp_footer', array( $this, 'tophive_bp_media_viewer' ) );
	        add_action( 'wp_footer', array( $this, 'tophive_bp_activity_reactions_viewer' ) );
		}
	}
	function th_groups_default_home( $default ) {
	    return 'activity';
	}
	function profile_tab_photos() {
      global $bp;
 
      bp_core_new_nav_item( array( 
            'name' => esc_html__( 'Photos', 'metafans' ), 
            'slug' => 'photos', 
            'screen_function' => array($this,'photos_screen'), 
            'position' => 40,
            'parent_url'      => bp_loggedin_user_domain() . '/photos/',
            'parent_slug'     => $bp->profile->slug,
            'default_subnav_slug' => 'photos'
      ) );
	}
	 
	function photos_screen() {
	    add_action( 'bp_template_content', array($this, 'photo_tab_content') );
	    bp_core_load_template( 'buddypress/members/single/plugins' );
	}
	function photo_tab_content() { 
	    $html = '';

	    $html .= '<div class="bp-profile-custom-page photos-page">';
		    $html .= '<div class="section-heading">';
		    $html .= '<h5 class="title">' . esc_html__('Photos', 'metafans') . '</h5>';
		    $html .= '</div>';
		    $html .= '<div class="section-content">';
		    $html .= apply_filters( 'tophive/buddypress/profile/photos', false );
		    $html .= '</div>';
	    $html .= '</div>';
	    echo $html;
	}

	function buddypress_bbpress_social_search(){
		$searchtext = $_REQUEST['text'];
		$topics_wp_query = new WP_Query( array(
		    'post_type' => 'topic',
		    'posts_per_page' => 3,
		    'orderby'=> 'post_date',
		    's'=> $searchtext,
		    'post_status' => 'publish'
		));

		$topics = '';
		if( $topics_wp_query->have_posts() ){
			$topics .= '<div>';
				$topics .= '<h6>'. esc_html__( 'Topics', 'metafans' ) .'</h6>';
				while( $topics_wp_query->have_posts() ){
					$topics_wp_query->the_post();
					$topics .= '<p><a href="'. get_the_permalink() .'">' . get_the_title( get_the_ID() ) . '</a></p>';
				}
			$topics .= '</div>';
		}
		$forum_wp_query = new WP_Query( array(
		    'post_type' => 'forum',
		    'posts_per_page' => 3,
		    'orderby'=> 'post_date',
		    's'=> $searchtext,
		    'post_status' => 'publish'
		));

		$forum = '';
		if( $forum_wp_query->have_posts() ){
			$forum .= '<div>';
				$forum .= '<h6>'. esc_html__( 'Forum', 'metafans' ) .'</h6>';
				while( $forum_wp_query->have_posts() ){
					$forum_wp_query->the_post();
					$forum .= '<p><a href="'. get_the_permalink() .'">' . get_the_title( get_the_ID() ) . '</a></p>';
				}
			$forum .= '</div>';
		}

		$user_query = new WP_User_Query( 
			array(  
				'search' => '*' . $searchtext . '*',
				'search_columns' => array( 'user_nicename', 'user_login' ),
				'number' => 3,
			)
		);
		$members = '';
		if( $user_query->get_results() ){
			$members .= '<div>';
				$members .= '<h6>'. esc_html__( 'User', 'metafans' ) .'</h6>';
				foreach( $user_query->get_results() as $user ){
					$members .= '<p><a href="'. bp_core_get_user_domain( $user->ID ) .'">' . $user->display_name . '</a></p>';
				}
			$members .= '</div>';
		}
		

		$response = $topics . $forum . $members;

		if( empty($response) ){
			$response = '<p class="ec-mb-0">' . esc_html__( 'Nothing Found for your search', 'metafans' ) . '</p>';
		}

		wp_send_json( $response, 200 );
	}
	function tophive_bp_activity_reactions_viewer(){
		if( is_user_logged_in() ){
			?>
				<div class="th-activity-reaction-viewer">
					<span class="close">✕</span>
					<div class="reactions"></div>
				</div>
			<?php
		}
	}
	function tophive_bp_media_viewer(){
		if(!is_user_logged_in()){
			return;
		}
		?>
			<div class="th-media-viewer-container">
				<div class="th-media-viewer">
					<span class="close">
						<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
						  <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
						</svg>
					</span>
					<span class="image-viewer-next-prev">
						<span class="img-prev">
							<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16">
							  <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/>
							</svg>
						</span>
						<span class="img-next">
							<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
							  <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
							</svg>
						</span>
					</span>
					<div class="th-media-view"></div>
					<div class="th-media-comments">
						<div class="author_section"></div>
						<div class="comment_section"></div>
					</div>
				</div>
			</div>
		<?php
	}


	function add_file_types_to_uploads($file_types){
		$new_filetypes = array();
	    $new_filetypes['svg'] = 'image/svg';
	    $new_filetypes['svg'] = 'image/svg+xml';
	    $file_types = array_merge($file_types, $new_filetypes );

	    return $file_types;
	}
	function th_bp_notification_action_links( $retval, $r ){
		$r = wp_parse_args( $args, array(
			'before' => '',
			'after'  => '',
			'sep'    => '  ',
			'links'  => array(
				bp_get_the_notification_mark_link( $user_id ),
				bp_get_the_notification_delete_link( $user_id )
			)
		) );
		$retval = $r['before'] . implode( $r['sep'], $r['links'] ) . $r['after'];
		return $retval;
	}
	function tophive_bp_get_context_user_id( $user_id = 0 ) {
 
	    if ( bp_is_my_profile() || ! is_user_logged_in() ) {
	        return 0;
	    }
	    if ( ! $user_id ) {
	        $user_id = bp_get_member_user_id();
	    }
	    if ( ! $user_id && bp_is_user() ) {
	        $user_id = bp_displayed_user_id();
	    }
	 
	    return apply_filters( 'tophive/buddypress/user/id', $user_id );
	}

	function tophive_bp_set_default_component () {
        define ( 'BP_DEFAULT_COMPONENT', 'activity' );
	}
	function tophive_reorder_buddypress_lp_tabs() {
		return array(
			array(
				'name'                    => __( 'Courses', 'metafans' ),
				'slug'                    => $this->get_tab_courses_slug(),
				'show_for_displayed_user' => true,
				'screen_function'         => array( $this, 'bp_tab_content' ),
				'default_subnav_slug'     => 'all',
				'position'                => 20
			),
			array(
				'name'                    => __( 'Quizzes', 'metafans' ),
				'slug'                    => $this->get_tab_quizzes_slug(),
				'show_for_displayed_user' => true,
				'screen_function'         => array( $this, 'bp_tab_content' ),
				'default_subnav_slug'     => 'all',
				'position'                => 20
			)
		);
	}
	public function get_tab_quizzes_slug() {
		$slugs = LP()->settings->get( 'profile_endpoints' );
		$slug  = '';
		if ( isset( $slugs['profile-quizzes'] ) ) {
			$slug = $slugs['profile-quizzes'];
		}
		if ( ! $slug ) {
			$slug = 'quizzes';
		}

		return sanitize_title(apply_filters( 'learn_press_bp_tab_quizzes_slug', $slug ));
	}
	public function bp_tab_content() {
		global $bp;
		$type = '';
		$current_component = $bp->current_component;
		$slugs = LP()->settings->get( 'profile_endpoints' );
		$tab_slugs_default = array( 'profile-courses', 'profile-quizzes', 'profile-orders' );
		$tab_slugs = array_keys( $slugs, $current_component );
		$tab_slugs = wp_parse_args($tab_slugs, $tab_slugs_default);
		$tab_slug = array_shift( $tab_slugs );
		if ( in_array( $tab_slug, $tab_slugs_default ) ) {
			switch ( $current_component ) {
				case  $this->get_tab_courses_slug():
					$type = 'courses';
					break;
				case  $this->get_tab_quizzes_slug():
					$type = 'quizzes';
					break;
				case  $this->get_tab_orders_slug():
					$type = 'orders';
					break;
				default:
					break;
			}
			if ( $type ) {
				add_action( 'bp_template_content', array( $this, "bp_tab_{$type}_content" ) );
				bp_core_load_template( apply_filters( 'bp_core_template_plugin', 'members/single/plugins' ) );
			}
		}
		do_action( 'learn-press/buddypress/bp-tab-content', $current_component );
	}
	public function bp_tab_courses_content() {
		$args = array( 'user' => learn_press_get_current_user() );
		learn_press_get_template( 'profile/courses.php', $args, learn_press_template_path() . '/addons/buddypress/', LP_ADDON_BUDDYPRESS_PATH . '/templates' );
	}
	public function bp_tab_quizzes_content() {
		$args = array( 'user' => learn_press_get_current_user() );
		learn_press_get_template( 'profile/tabs/quizzes.php', $args );
	}
	public function get_tab_courses_slug() {
		$slugs = LP()->settings->get( 'profile_endpoints' );
		$slug  = '';
		if ( isset( $slugs['profile-courses'] ) ) {
			$slug = $slugs['profile-courses'];
		}
		if ( ! $slug ) {
			$slug = 'courses';
		}

		return sanitize_title(apply_filters( 'learn_press_bp_tab_courses_slug', $slug ));
	}
	function tophive_bp_reorder_buddypress_profile_tabs() {
	    $nav = buddypress()->members->nav;

	    $nav_items = array(
	        'activity' => 10,
	        'friends'  => 40,
	        'messages' => 50,
	        'groups'   => 60,
	        'blogs'    => 70,
	        'profile'  => 80,
	        'settings' => 90,
	    );
	 
	    foreach ( $nav_items as $nav_item => $position ) {
	        $nav->edit_nav( array( 'position' => $position ), $nav_item );
	    }
	    return $nav;
	}
	
	function th_bp_sidebar_id( $id, $sidebar_type = null, $bp_type = null ){
		if( $this->is_active() ){
			if( bp_current_component() !== false ){
				if( bp_is_user() && $bp_type == 'activity' ){
					switch ($sidebar_type) {
						case 'secondary':
								return 'buddy-press-profile-left';
							break;
						case 'primary':
								return 'buddy-press-profile-right';
							break;
						
						default:
								return 'buddy-press-profile-right';
							break;
					}
				}else{
					if( $bp_type == 'activity' ){
						switch ($sidebar_type) {
							case 'secondary':
									return 'buddy-press-activity-left';
								break;
							
							default:
									return 'buddy-press-activity-right';
								break;
						}
					}elseif( $bp_type == 'groups' ){
						switch ($sidebar_type) {
							case 'secondary':
									return 'buddy-press-groups-left';
								break;
							
							default:
									return 'buddy-press-groups-right';
								break;
						}
					}elseif( $bp_type == 'members' ){
						switch ($sidebar_type) {
							case 'secondary':
									return 'buddy-press-members-left';
								break;
							
							default:
									return 'buddy-press-members-right';
								break;
						}
					}elseif( $bp_type == 'profile' ){
						switch ($sidebar_type) {
							case 'secondary':
									return 'buddy-press-profile-left';
								break;
							
							default:
									return 'buddy-press-profile-right';
								break;
						}
					}
				}
			}else{
				return $id;
			}
		}
		return $id;
	}
	function load_scripts(){
		wp_enqueue_style( 'th-buddypress', get_template_directory_uri() . '/assets/css/compatibility/buddypress.css', $deps = array(), $ver = false, $media = 'all' );
		wp_enqueue_script('th-buddyrpess', get_template_directory_uri() . '/assets/js/compatibility/buddypress.js', array('jquery'), false, false);
	}

	function tophive_bp_activity_allowed_tags(){
		return array(
			'div' => array(
				'class' => array(),
				'id' 	=> array()
			),
			'a' => array(
				'aria-label'      => array(),
				'class'           => array(),
				'data-bp-tooltip' => array(),
				'id'              => array(),
				'rel'             => array(),
				'target'          => array(),
				'href'          => array(),
			),
			'iframe' => array(
				'class' 		=> array(),
				'id' 		=> array(),
				'src' 		=> array(),
			),
			'img' => array(
				'src'    => array(),
				'alt'    => array(),
				'width'  => array(),
				'height' => array(),
				'class'  => array(),
				'id'     => array(),
			),
			'span'=> array(
				'class'          => array(),
				'data-livestamp' => array(),
			),
			'ul' => array(),
			'ol' => array(),
			'li' => array(),
		);
	}
}
function Tophive_BP() {
	return Tophive_BP::get_instance();
}

if ( tophive_metafans()->is_buddypress_active() ) {
	Tophive_BP();
}	