
<?php
/**
 * BuddyPress - Activity Stream (Single Item)
 *
 * This template is used by activity-loop.php and AJAX functions to show
 * each activity.
 *
 * @since 3.0.0
 * @version 3.0.0
 */

bp_nouveau_activity_hook( 'before', 'entry' ); 
$activity = new BP_Activity_Activity( (int) bp_get_activity_id() );

$content_class = bp_get_activity_type() === 'activity_share' ? ' activity-sharing' : '';

?>

<li class="<?php bp_activity_css_class(); ?>" id="activity-<?php bp_activity_id(); ?>" data-bp-activity-id="<?php bp_activity_id(); ?>" data-bp-timestamp="<?php bp_nouveau_activity_timestamp(); ?>">

	<div class="activity-avatar item-avatar">

		<a href="<?php bp_activity_user_link(); ?>">

			<?php bp_activity_avatar( array( 'type' => 'full' ) ); ?>

		</a>

	</div>

	<div class="activity-content<?php echo $content_class; ?>">

		<div class="activity-header">
			<?php do_action( 'tophive/buddypress/activity/header' ); ?>
			<?php if( is_user_logged_in() ){ ?>
				<div class="activity-extension-links">
					<span class="open-button">•••</span>
					<ul>
						<?php 
								if ( bp_activity_user_can_delete( $activity ) ) {	
							?>
							<li>
								<a class="button item-button bp-secondary-action bp-tooltip delete-activity confirm" href="<?php echo bp_get_activity_delete_url(); ?>">
									<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash-fill" viewBox="0 0 16 16">
									  <path d="M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 1 0z"/>
									</svg>
									<?php esc_html_e( 'Move to trash', 'metafans' ); ?>
								</a>
							</li>
							<?php 
								}
						?>
						<li><a class="button bp-secondary-action bp-tooltip" href="<?php echo bp_get_activity_favorite_link(); ?>">
							<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bookmark-star-fill" viewBox="0 0 16 16">
							  <path fill-rule="evenodd" d="M2 15.5V2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.74.439L8 13.069l-5.26 2.87A.5.5 0 0 1 2 15.5zM8.16 4.1a.178.178 0 0 0-.32 0l-.634 1.285a.178.178 0 0 1-.134.098l-1.42.206a.178.178 0 0 0-.098.303L6.58 6.993c.042.041.061.1.051.158L6.39 8.565a.178.178 0 0 0 .258.187l1.27-.668a.178.178 0 0 1 .165 0l1.27.668a.178.178 0 0 0 .257-.187L9.368 7.15a.178.178 0 0 1 .05-.158l1.028-1.001a.178.178 0 0 0-.098-.303l-1.42-.206a.178.178 0 0 1-.134-.098L8.16 4.1z"/>
							</svg>
							<?php esc_html_e( 'Mark as favourite', 'metafans' ); ?></a>
						</li>
					</ul>
				</div>
			<?php } ?>
		</div>
		<?php  
			if( bp_get_activity_type() === 'new_avatar' ){
				?>
				<?php 
					// Get the Cover Image
					$cover_src = bp_attachments_get_attachment( 'url', array(
						'item_id' => bp_get_activity_user_id()
					) );
			    ?>
			 
					<div class="bp-activity-avatar-change">
			      		<img class="image-cover" src="<?php echo tophive_sanitize_filter($cover_src); ?>" alt="imgur"/>
						<?php bp_activity_avatar( array( 'type' => 'full' ) ); ?>				
					</div>
				<?php
			}
		?>
		<?php if ( bp_nouveau_activity_has_content() ) : ?>

			<div class="activity-inner">
				<?php 
					echo bp_nouveau_activity_content();
					// do_action( 'tophive/buddypress/activity/content', bp_get_activity_id() );
					do_action( 'tophive/buddypress/activity/media', bp_get_activity_id() );
					if( bp_get_activity_type() === 'activity_share' ){
						$share_id = bp_activity_get_meta( bp_get_activity_id(), 'shared_activity_id', true );
						do_action( 'tophive/buddypress/activity/share-activity', $share_id );
					}
				?>
			</div>

		<?php endif; ?>
		<div class="activity-footer-links">
			<?php do_action( 'bp_footer_actions' ); ?>
		</div>

	</div>

	<?php bp_nouveau_activity_hook( 'before', 'entry_comments' ); ?>

	<?php if ( bp_activity_get_comment_count() || ( is_user_logged_in() && ( bp_activity_can_comment() || bp_is_single_activity() ) ) ) : ?>

		<div class="activity-comments">

			<?php do_action( 'tophive/buddypress/activity/comments' ); ?>

		</div>

	<?php endif; ?>

	<?php bp_nouveau_activity_hook( 'after', 'entry_comments' ); ?>

</li>

<?php
bp_nouveau_activity_hook( 'after', 'entry' );
