/**
 * Tophive theme javaScript.
 *
 * @since 0.2.6
 *
 * Copyright 2020, Tophive
 */

"use strict"; // prevent global namespace pollution
(function(elmPrototype, docPrototype) {
	var scopeRegex = /:scope\b/gi;

	function patchElement(method) {
		var native = elmPrototype[method];

		elmPrototype[method] = function(selector) {
			var element = this;
			var id = element.id || "qsid" + new Date().getTime();
			var needsId = !element.id;
			var hasScope = scopeRegex.test(selector);

			try {
				if (hasScope) {
					if (needsId) {
						element.id = id;
					}

					selector = selector.replace(scopeRegex, "#" + id);
				}

				return native.call(this, selector);
			} finally {
				if (needsId) {
					element.id = null;
				}
			}
		};
	}

	function patchDocument(method) {
		var native = docPrototype[method];
		docPrototype[method] = function(selector) {
			// In context of document, :scope is the same
			// as :root so can just be stripped
			// https://www.w3.org/TR/selectors4/#scope-pseudo
			return native.call(this, selector.replace(scopeRegex, ""));
		};
	}

	try {
		document.querySelector(":scope");
	} catch (err) {
		patchElement("querySelector");
		patchElement("querySelectorAll");
		patchDocument("querySelector");
		patchDocument("querySelectorAll");
	}
})(Element.prototype, Document.prototype);

(function(arr) {
	arr.forEach(function(item) {
		if (item.hasOwnProperty("append")) {
			return;
		}
		Object.defineProperty(item, "append", {
			configurable: true,
			enumerable: true,
			writable: true,
			value: function append() {
				var argArr = Array.prototype.slice.call(arguments),
					docFrag = document.createDocumentFragment();

				argArr.forEach(function(argItem) {
					var isNode = argItem instanceof Node;
					docFrag.appendChild(
						isNode
							? argItem
							: document.createTextNode(String(argItem))
					);
				});

				this.appendChild(docFrag);
			}
		});
	});
})([Element.prototype, Document.prototype, DocumentFragment.prototype]);
(function () {
    if ( typeof NodeList.prototype.forEach === "function" ) return false;
    NodeList.prototype.forEach = Array.prototype.forEach;
})();

/**
 * matches() pollyfil
 * @see https://developer.mozilla.org/en-US/docs/Web/API/Element/closest#Polyfill
 */
if (!Element.prototype.matches) {
	Element.prototype.matches =
		Element.prototype.msMatchesSelector ||
		Element.prototype.webkitMatchesSelector;
}

/**
 * closest() pollyfil
 * @see https://developer.mozilla.org/en-US/docs/Web/API/Element/closest#Polyfill
 */
if (!Element.prototype.closest) {
	Element.prototype.closest = function(s) {
		var el = this;
		if (!document.documentElement.contains(el)) {
			return null;
		}
		do {
			if (el.matches(s)) {
				return el;
			}
			el = el.parentElement || el.parentNode;
		} while (el !== null && el.nodeType === 1);
		return null;
	};
}

/**
 * Main Tophive Scripts
 */
(function() {
	var Tophive = function() {
		this.options = {
			menuToggleDuration: 300
		};

		this.menuSidebarState = "closed";
		this.isPreviewing = document.body.classList.contains(
			"customize-previewing"
		);

		this.init();
	};

	/**
	 * Add body class to check touch screen.
	 */
	Tophive.prototype.checkTouchScreen = function() {
		if ("ontouchstart" in document.documentElement) {
			document.body.classList.add("ontouch-screen");
		} else {
			document.body.classList.add("not-touch-screen");
		}
	};

	/**
	 * Check if current mobile viewing.
	 *
	 * @return bool
	 */
	Tophive.prototype.isMobile = function() {
		if (
			navigator.userAgent.match(/Android/i) ||
			navigator.userAgent.match(/webOS/i) ||
			navigator.userAgent.match(/iPhone/i) ||
			navigator.userAgent.match(/iPad/i) ||
			navigator.userAgent.match(/iPod/i) ||
			navigator.userAgent.match(/BlackBerry/i) ||
			navigator.userAgent.match(/Windows Phone/i)
		) {
			return true;
		} else {
			return false;
		}
	};

	/**
	 * Init mobile sidebar.
	 *
	 * @todo Move menu sidebar to body.
	 * @todo Add events to menu buttons.
	 */
	Tophive.prototype.initMenuSidebar = function() {
		var themeMenuSidebar;
		if (document.body.classList.contains("menu_sidebar_dropdown")) {
			// $( '#header-menu-sidebar' ).insertAfter( "#masthead" );
		} else {
			themeMenuSidebar = document.getElementById("header-menu-sidebar");
			if (themeMenuSidebar) {
				document.body.append(themeMenuSidebar);
			}
		}

		document.addEventListener(
			"customize_section_opened",
			function(e) {
				if (e.detail === "header_sidebar") {
					this.toggleMenuSidebar(false);
				}
			}.bind(this)
		);

		var menuMobileToggleButtons = document.querySelectorAll(
			".menu-mobile-toggle"
		);
		/**
		 * When click to toggle buttons.
		 */
		this.addEvent(
			menuMobileToggleButtons,
			"click",
			function(e) {
				e.preventDefault();
				this.toggleMenuSidebar();
			}.bind(this)
		);

		var closeButtons = document.querySelectorAll(
			"#header-menu-sidebar .close-panel, .close-sidebar-panel"
		);

		/**
		 * When click close buttons.
		 */
		this.addEvent(
			closeButtons,
			"click",
			function(e) {
				e.preventDefault();
				this.closeMenuSidebar();
			}.bind(this)
		);

		/**
		 * When click to ouside of menu sidebar.
		 */
		this.addEvent(
			document,
			"click",
			function(e) {
				if (document.body.classList.contains("is-menu-sidebar")) {
					var menuSidebar = document.getElementById(
						"header-menu-sidebar"
					);
					var buttons = document.querySelectorAll(
						".menu-mobile-toggle"
					);
					var outside = false;
					// If the click happened inside the the container, bail
					if (
						!e.target.closest("#header-menu-sidebar") &&
						e.target !== menuSidebar
					) {
						// Outside menu sidebar.
						outside = true;
					}

					// Check if not click to menu toggle buttons.
					var onButton = false;
					if (buttons.length) {
						for (var i = 0; i < buttons.length; i++) {
							// If click on toggle button.
							if (
								e.target.closest(".menu-mobile-toggle") ||
								e.target === buttons[i]
							) {
								onButton = true;
							}
						}
					}

					if (outside && !onButton) {
						this.closeMenuSidebar();
					}
				}
			}.bind(this)
		);

		this.addEvent(
			document,
			"keyup",
			function(e) {
				if (e.keyCode === 27) {
					this.closeMenuSidebar();
				}
			}.bind(this)
		);
	};

	/**
	 * Init mobile search form
	 *
	 * @todo Need check
	 */
	Tophive.prototype.initMobieSearchForm = function() {
		var mobileSearchForm = document.querySelector(".search-form--mobile");
		if (mobileSearchForm) {
			mobileSearchForm.classList.add(
				"mobile-search-form-sidebar menu-sidebar-panel"
			);
			mobileSearchForm.classList.remove("hide-on-mobile hide-on-tablet");
			document.body.prepend(mobileSearchForm);
		}
	};

	Tophive.prototype.toggleMobileSubmenu = function(e) {
		e.preventDefault();
		var that = this;
		var li = e.target.closest("li");
		var firstSubmenu = li.querySelectorAll(
			":scope  > .sub-menu, .sub-lv-0"
		);

		if (!li.classList.contains("open-sub")) {
			// Show the sub menu.
			li.classList.add("open-sub");
			if (firstSubmenu.length) {
				for (var i = 0; i < firstSubmenu.length; i++) {
					that.slideDown(
						firstSubmenu[i],
						this.options.menuToggleDuration,
						function() {
							li.classList.add("open-sub");
						}
					);
				}
			}
		} else {
			// Hide the sub menu.
			if (firstSubmenu.length) {
				for (var i = 0; i < firstSubmenu.length; i++) {
					that.slideUp(
						firstSubmenu[i],
						this.options.menuToggleDuration,
						function() {
							li.classList.remove("open-sub");
						}
					);
				}
			}
		}
	};

	/**
	 * Add events listener for mobile toggle button.
	 *
	 * @param Element toggleIcon
	 */
	Tophive.prototype.toggleMobileSubmenuEvents = function(toggleIcon) {
		toggleIcon.addEventListener(
			"click",
			this.toggleMobileSubmenu.bind(this)
		);
	};

	/**
	 * Inital mobile submenu.
	 */
	Tophive.prototype.initMobileSubMenu = function() {
		var menuChildren = document.querySelectorAll(
			"#header-menu-sidebar .nav-menu-mobile .menu-item-has-children"
		);

		if (menuChildren.length) {
			for (var i = 0; i < menuChildren.length; i++) {
				var child = menuChildren[i];

				if (!child.classList.contains("toggle--added")) {
					child.classList.add("toggle--added");

					var fistLink = child.querySelector(":scope > a");
					var d = fistLink.cloneNode(true);

					if (this.isPreviewing) {
					}

					var toggleButton = document.createElement("span");
					toggleButton.classList.add("nav-toggle-icon");
					toggleButton.innerHTML = '<i class="nav-icon-angle"></i>';

					fistLink.parentNode.insertBefore(toggleButton, fistLink);
					var submenu = child.querySelector(":scope > .sub-menu");
					if ("1" !== Tophive_JS.sidebar_menu_no_duplicator) {
						submenu.prepend(d);
					}
					var firstSubmenu = child.querySelectorAll(
						":scope  > .sub-menu, .sub-lv-0"
					);
					if (firstSubmenu.length) {
						for (var j = 0; j < firstSubmenu.length; j++) {
							this.slideUp(firstSubmenu[j], 0);
						}
					}
					if ("1" !== Tophive_JS.sidebar_menu_no_duplicator) {
						var dWrapper = document.createElement("li");
						d.parentNode.prepend(dWrapper);
						dWrapper.appendChild(d);
					}
					this.toggleMobileSubmenuEvents(toggleButton);
				}
			}
		}
	};

	/**
	 * SideUp
	 *
	 * @param Element element
	 * @param number duration
	 * @param function callBack
	 */
	Tophive.prototype.slideUp = function(element, duration, callBack) {
		if (typeof duration !== "number") {
			duration = 0;
		}


		if (element._slideDownTimeOut) {
			clearTimeout(element._slideDownTimeOut);
			element._slideDownTimeOut = false;
		}

		// Get orignal height.
		var offset = element.getBoundingClientRect();
		// Back to default.
		element.style.overflow = "hidden";
		element.style.height = offset.height + "px";
		element.style.transition = "height " + duration + "ms linear";
		setTimeout(function() {
			element.style.height = "0px";
		}, 20);

		element._sideUpTimeOut = setTimeout(function() {
			element.style.transition = "";
			if (typeof callBack === "function") {
				callBack.call(this);
			}
		}, duration + 20);
	};

	/**
	 *
	 * @param Element element
	 * @param number duration
	 * @param function callBack
	 */
	Tophive.prototype.slideDown = function(element, duration, callBack) {
		if (typeof duration !== "number") {
			duration = 0;
		}

		if (element._sideUpTimeOut) {
			clearTimeout(element._sideUpTimeOut);
			element._sideUpTimeOut = false;
		}

		// Reset element styling to get orignal height.
		element.style.height = "initial";
		element.style.overflow = "initial";
		element.style.transition = "";
		// Get orignal height.
		var offset = element.getBoundingClientRect();
		// Back to default.
		element.style.height = "0px";
		element.style.overflow = "hidden";
		element.style.transition = "height " + duration + "ms linear";
		setTimeout(function() {
			element.style.height = offset.height + "px";
		}, 50);

		element._sideUpTimeOut = setTimeout(function() {
			element.style.height = "";
			element.style.overflow = "";
			element.style.transition = "";
			if (typeof callBack === "function") {
				callBack.call(this);
			}
		}, duration);
	};

	Tophive.prototype.insertMenuOverlayClass = function() {
		var navMobile = document.querySelector(".nav-menu-mobile");
		if (navMobile) {
			if (
				document.body.classList.contains("menu_sidebar_slide_overlay")
			) {
				navMobile.classList.add("nav-menu-overlay");
			} else {
				navMobile.classList.remove("nav-menu-overlay");
			}
		}
	};

	Tophive.prototype.setupMobileItemAnimations = function(element) {
		var h = window.height;
		if (typeof element === "undefined") {
			element = document.getElementById("header-menu-sidebar");
		}

		var t = 0.2;
		var index = 0;
		var itemsInner = element.querySelectorAll(".item--inner");
		if (itemsInner.length) {
			for (var i = 0; i < itemsInner.length; i++) {
				index++;
				itemsInner[i].style.transitionDelay = index * t + "s";
			}
		}
	};

	/**
	 * Toogle Element class name.
	 *
	 * @param Element element
	 * @param string className
	 */
	Tophive.prototype.toggleClass = function(element, className) {
		if (element instanceof NodeList) {
			for (var i = 0; i < element.length; i++) {
				if (element[i].classList.contains(className)) {
					element[i].classList.remove(className);
				} else {
					element[i].classList.add(className);
				}
			}
		} else if (element instanceof Node || element instanceof Element) {
			if (element.classList.contains(className)) {
				element.classList.remove(className);
			} else {
				element.classList.add(className);
			}
		}
	};

	/**
	 * Add class to element.
	 *
	 * @param Element element
	 * @param string className
	 */
	Tophive.prototype.addClass = function(element, className) {
		if (element instanceof NodeList) {
			for (var i = 0; i < element.length; i++) {
				element[i].classList.add(className);
			}
		} else if (element instanceof Node || element instanceof Element) {
			element.classList.add(className);
		}
	};

	/**
	 * Remove class name from element.
	 *
	 * @param Element element
	 * @param string className
	 */
	Tophive.prototype.removeClass = function(element, className) {
		// Split each class by space.
		var classes = className.split(" ");
		if (element instanceof NodeList) {
			for (var i = 0; i < element.length; i++) {
				for (var j = 0; j < classes.length; j++) {
					element[i].classList.remove(classes[j]);
				}
			}
		} else if (element instanceof Node || element instanceof Element) {
			for (var j = 0; j < classes.length; j++) {
				element.classList.remove(classes[j]);
			}
		}
	};

	/**
	 * Add event handle to elements.
	 *
	 * @param Element element
	 * @param string event
	 * @param function callBack
	 */
	Tophive.prototype.addEvent = function(element, event, callBack) {
		if (element instanceof NodeList) {
			for (var i = 0; i < element.length; i++) {
				element[i].addEventListener(event, callBack);
			}
		} else if (element instanceof Node || element instanceof Element) {
			element.addEventListener(event, callBack);
		}
	};

	/**
	 * Close menu sidebar.
	 */
	Tophive.prototype.closeMenuSidebar = function() {
		document.body.classList.add("hiding-header-menu-sidebar");
		document.body.classList.remove("is-menu-sidebar");
		var toggleButtons = document.querySelectorAll(
			".menu-mobile-toggle, .menu-mobile-toggle .hamburger"
		);
		this.removeClass(toggleButtons, "is-active");

		/**
		 * For dropdown sidebar.
		 */
		if (document.body.classList.contains("menu_sidebar_dropdown")) {
			this.removeClass(document.body, "hiding-header-menu-sidebar");
			var menuSidebar = document.getElementById("header-menu-sidebar");
			var menuSidebarInner = document.getElementById(
				"header-menu-sidebar-inner"
			);
			var offset = menuSidebarInner.getBoundingClientRect();
			var h = offset.height;

			this.slideUp(
				menuSidebar,
				300,
				function() {
					menuSidebar.style.height = 0;
					menuSidebar.style.display = "block";
				}.bind(this)
			);
		} else {
			// Else slide sidebar.
			setTimeout(
				function() {
					this.removeClass(
						document.body,
						"hiding-header-menu-sidebar"
					);
				}.bind(this),
				1000
			);
		}
	};

	/**
	 * Toggle menu sidebar.
	 *
	 * @param bool open use animation or not.
	 */
	Tophive.prototype.toggleMenuSidebar = function(toggle) {
		if (typeof toggle === "undefined") {
			toggle = true;
		}

		document.body.classList.remove("hiding-header-menu-sidebar");

		if (!toggle) {
			document.body.classList.add("is-menu-sidebar");
		} else {
			this.toggleClass(document.body, "is-menu-sidebar");
		}

		if (document.body.classList.contains("menu_sidebar_dropdown")) {
			var buttons = document.querySelectorAll(
				".menu-mobile-toggle, .menu-mobile-toggle .hamburger, .hamburger"
			);
			if (toggle) {
				this.toggleClass(buttons, "is-active");
			} else {
				this.addClass(buttons, "is-active");
			}

			if (document.body.classList.contains("is-menu-sidebar")) {
				var menuSidebar = document.getElementById(
					"header-menu-sidebar"
				);
				var menuSidebarInner = document.getElementById(
					"header-menu-sidebar-inner"
				);
				var offset = menuSidebarInner.getBoundingClientRect();
				var h = offset.height;

				this.slideDown(menuSidebar, 300, function() {
					menuSidebar.style.height = h + "px";
				});
			} else {
				if (toggle) {
					this.closeMenuSidebar();
				}
			}
		}
	};

	/**
	 * Auto align search form.
	 */
	Tophive.prototype.searchFormAutoAlign = function() {
		var searchItems = document.querySelectorAll(".header-search_icon-item");
		var w = window.innerWidth;

		for (var i = 0; i < searchItems.length; i++) {
			var container = searchItems[i];
			var button = container.querySelector(".search-icon");
			var buttonOffset = button.getBoundingClientRect();
			this.removeClass(container, "search-right search-left");
			if (buttonOffset.left > w / 2) {
				if (Tophive_JS.is_rtl) {
					this.removeClass(container, "search-left");
					this.addClass(container, "search-right");
				} else {
					this.removeClass(container, "search-right");
					this.addClass(container, "search-left");
				}
			} else {
				if (Tophive_JS.is_rtl) {
					this.removeClass(container, "search-right");
					this.addClass(container, "search-left");
				} else {
					this.removeClass(container, "search-left");
					this.addClass(container, "search-right");
				}
			}
		}
	};

	/**
	 * Search form.
	 */
	Tophive.prototype.initSearchForm = function() {
		var searchItems = document.querySelectorAll(".header-search_icon-item");
		var that = this;
		searchItems.forEach(function(container) {
			if ( ! container.classList.contains( 'js-added' ) ) {
				that.addClass(container, "js-added");
				that.removeClass(container, "active");
				var icon = container.querySelector(".search-icon");
	
				var iconSearchClick = function(e) {
					e.preventDefault();
					var inputField = container.querySelector(".search-field");
					if (!container.classList.contains("active")) {
						container.classList.add("active");
						inputField.blur();
					} else {
						this.removeClass(container, "active");
						inputField.focus();
					}
				};
	
				var clickOutSideSearchIcon = function(e) {
					// if the target of the click isn't the container nor a descendant of the container
					if (
						!(container === e.target) &&
						!container.contains(e.target)
					) {
						that.removeClass(container, "active");
					}
				};
	
				icon.removeEventListener("click", iconSearchClick);
				//document.removeEventListener("click", clickOutSideSearchIcon);
				/**
				 * Add event handle when click to icon.
				 */
				that.addEvent(icon, "click", iconSearchClick.bind(that));
	
				/**
				 * When click outside search form.
				 */
				that.addEvent(
					document,
					"click",
					clickOutSideSearchIcon.bind(that)
				);
			}
			
		});

		that.searchFormAutoAlign();
	};

	/**
	 * Wrapper element
	 *
	 * @param Element element
	 * @param strig tag Tag name.
	 *
	 * @return Element
	 */
	Tophive.prototype.wrapper = function(element, tag) {
		if (typeof tag === "undefined") {
			tag = "div";
		}
		var wrapper = document.createElement(tag);
		element.parentNode.replaceChild(wrapper, element);
		wrapper.appendChild(element);
		return wrapper;
	};

	/**
	 * Responsive table.
	 */
	Tophive.prototype.responsiveTable = function() {
		var tables = document.querySelectorAll(".entry-content table");
		for (var i = 0; i < tables.length; i++) {
			if (!tables[i].parentNode.classList.contains("table-wrapper")) {
				// Wrap table by each div.table-wrapper
				var dWrapper = document.createElement("div");
				dWrapper.classList.add("table-wrapper");
				tables[i].parentNode.replaceChild(dWrapper, tables[i]);
				dWrapper.appendChild(tables[i]);
			}
		}
	};

	/**
	 * Reponsive video style.
	 */
	Tophive.prototype.responsiveVideos = function() {};

	/**
	 * Inittial
	 */
	Tophive.prototype.init = function() {
		this.checkTouchScreen();
		this.initMobieSearchForm();
		this.initMobileSubMenu();
		this.insertMenuOverlayClass();
		this.setupMobileItemAnimations();
		this.initMenuSidebar();
		this.initSearchForm();
		this.responsiveTable();
		this.responsiveVideos();

		/**
		 * Add action when Header Panel rendered by customizer.
		 */
		document.addEventListener(
			"header_builder_panel_changed",
			function() {
				this.initMobileSubMenu();
				this.insertMenuOverlayClass();
			}.bind(this)
		);
		// Add actions when window resize.
		var tf;
		window.addEventListener(
			"resize",
			function() {
				// Resetup mobile animations
				this.setupMobileItemAnimations();

				// Resetup search form alignmenet.
				this.removeClass(
					document.querySelectorAll(".header-search_icon-item"),
					"active"
				);
				if (tf) {
					clearTimeout(tf);
				}
				tf = setTimeout(this.searchFormAutoAlign.bind(this), 100);
			}.bind(this)
		);

		document.addEventListener(
			"selective-refresh-content-rendered",
			function(e) {
				console.log("e.detail", e.detail);

				if ("tophive_customize_render_header" === e.detail) {
					var oldMenu =  document.querySelector( 'body > .header-menu-sidebar' );
					oldMenu.remove();
					this.initMobieSearchForm();
					this.initMobileSubMenu();
					this.insertMenuOverlayClass();
					this.setupMobileItemAnimations();
					this.initMenuSidebar();
					this.initSearchForm();
					console.log( 'header_change' );
				}

				if ("Tophive_Builder_Item_Search_Icon__render" === e.detail) {
					this.initMobieSearchForm();
					this.initSearchForm();
					this.setupMobileItemAnimations();
				}
			}.bind(this)
		);
	};

	/**
	 * Check is mobile.
	 * This may use in plugins.
	 *
	 * @deprecated 0.2.6
	 */
	function tophive_is_mobile() {
		return Tophive.isMobile();
	}

	window.tophive_is_mobile = tophive_is_mobile;
	window.Tophive = new Tophive();

	/**
	 * Fix viewport units on Mobile.
	 */
	(function() {
		if (window.Tophive.isMobile()) {
			/**
			 * https://css-tricks.com/the-trick-to-viewport-units-on-mobile/
			 */
			// First we get the viewport height and we multiple it by 1% to get a value for a vh unit
			var vh = window.innerHeight * 0.01;
			var vw = window.innerWidth * 0.01;
			// Then we set the value in the --vh, --vw custom property to the root of the document
			document.documentElement.style.setProperty("--vh", vh + "px");
			document.documentElement.style.setProperty("--vw", vw + "px");

			window.addEventListener("resize", function() {
				var vh = window.innerHeight * 0.01;
				var vw = window.innerWidth * 0.01;
				document.documentElement.style.setProperty("--vh", vh + "px");
				document.documentElement.style.setProperty("--vw", vw + "px");
			});
		}
	})();
})();

/**
 *
 * Handles toggling the navigation menu for small screens and enables TAB key
 * navigation support for dropdown menus.
 */
(function() {
	var container, button, menu, links, i, len;

	container = document.getElementById("site-navigation-main-desktop");
	if (!container) {
		return;
	}

	menu = container.getElementsByTagName("ul")[0];
	// Hide menu toggle button if menu is empty and return early.
	if ("undefined" === typeof menu) {
		return;
	}

	menu.setAttribute("aria-expanded", "false");
	if (-1 === menu.className.indexOf("nav-menu")) {
		menu.className += " nav-menu";
	}

	// Get all the link elements within the menu.
	links = menu.getElementsByTagName("a");

	// Each time a menu link is focused or blurred, toggle focus.
	for (i = 0, len = links.length; i < len; i++) {
		links[i].addEventListener("focus", toggleFocus, true);
		links[i].addEventListener("blur", toggleFocus, true);
	}

	/**
	 * Sets or removes .focus class on an element.
	 */
	function toggleFocus() {
		var self = this;

		// Move up through the ancestors of the current link until we hit .nav-menu.
		while (-1 === self.className.indexOf("nav-menu")) {
			// On li elements toggle the class .focus.
			if ("li" === self.tagName.toLowerCase()) {
				if (-1 !== self.className.indexOf("focus")) {
					self.className = self.className.replace(" focus", "");
				} else {
					self.className += " focus";
				}
			}

			self = self.parentElement;
		}
	}

	/**
	 * Toggles `focus` class to allow submenu access on tablets.
	 */
	(function(container) {
		var touchStartFn,
			i,
			parentLink = container.querySelectorAll(
				".menu-item-has-children > a, .page_item_has_children > a"
			);

		if ("ontouchstart" in window) {
			touchStartFn = function(e) {
				var menuItem = this.parentNode,
					i;

				if (!menuItem.classList.contains("focus")) {
					e.preventDefault();
					for (i = 0; i < menuItem.parentNode.children.length; ++i) {
						if (menuItem === menuItem.parentNode.children[i]) {
							continue;
						}
						menuItem.parentNode.children[i].classList.remove(
							"focus"
						);
					}
					menuItem.classList.add("focus");
				} else {
					menuItem.classList.remove("focus");
				}
			};

			for (i = 0; i < parentLink.length; ++i) {
				parentLink[i].addEventListener(
					"touchstart",
					touchStartFn,
					false
				);
			}
		}
	})(container);
})();

/**
 *
 * Helps with accessibility for keyboard only users.
 *
 * Learn more: https://git.io/vWdr2
 */
(function() {
	var isIe = /(trident|msie)/i.test(navigator.userAgent);

	if (isIe && document.getElementById && window.addEventListener) {
		window.addEventListener(
			"hashchange",
			function() {
				var id = location.hash.substring(1),
					element;

				if (!/^[A-z0-9_-]+$/.test(id)) {
					return;
				}

				element = document.getElementById(id);

				if (element) {
					if (
						!/^(?:a|select|input|button|textarea)$/i.test(
							element.tagName
						)
					) {
						element.tabIndex = -1;
					}

					element.focus();
				}
			},
			false
		);
	}
})();
var x, i, j, l, ll, selElmnt, a, b, c;
x = document.getElementsByClassName("woocommerce-ordering");
l = x.length;
for (i = 0; i < l; i++) {
  selElmnt = x[i].getElementsByTagName("select")[0];
  ll = selElmnt.length;
  a = document.createElement("DIV");
  a.setAttribute("class", "select-selected");
  a.innerHTML = selElmnt.options[selElmnt.selectedIndex].innerHTML;
  x[i].appendChild(a);
  b = document.createElement("DIV");
  b.setAttribute("class", "select-items select-hide");
  for (j = 0; j < ll; j++) {
    c = document.createElement("DIV");
    c.innerHTML = selElmnt.options[j].innerHTML;
    c.addEventListener("click", function(e) {
        var y, i, k, s, h, sl, yl;
        s = this.parentNode.parentNode.getElementsByTagName("select")[0];
        sl = s.length;
        h = this.parentNode.previousSibling;
        var url = window.location.href.split('?')[0];
        console.log(url);
        for (i = 0; i < sl; i++) {
	        if (s.options[i].innerHTML == this.innerHTML) {
            	var iv = s.options[i].value;
            	var t_url = url + '?orderby=' + iv;
            	h.innerHTML = this.innerHTML;
            	y = this.parentNode.getElementsByClassName("same-as-selected");
	            yl = y.length;
	            for (k = 0; k < yl; k++) {
	              y[k].removeAttribute("class");
	            }
	            this.setAttribute("class", "same-as-selected");
			    location.href = t_url;
	            break;
          	}
    	}
        h.click();
    });
    b.appendChild(c);
  }
  x[i].appendChild(b);
  a.addEventListener("click", function(e) {
      e.stopPropagation();
      closeAllSelect(this);
      this.nextSibling.classList.toggle("select-hide");
      this.classList.toggle("select-arrow-active");
    });
}
function closeAllSelect(elmnt) {
  var x, y, i, xl, yl, arrNo = [];
  x = document.getElementsByClassName("select-items");
  y = document.getElementsByClassName("select-selected");
  xl = x.length;
  yl = y.length;
  for (i = 0; i < yl; i++) {
    if (elmnt == y[i]) {
      arrNo.push(i)
    } else {
      y[i].classList.remove("select-arrow-active");
    }
  }
  for (i = 0; i < xl; i++) {
    if (arrNo.indexOf(i)) {
      x[i].classList.add("select-hide");
    }
  }
}
document.addEventListener("click", closeAllSelect);

jQuery(document).ready(function($){
	jQuery('form.th-modal-login').on('submit', function(e){
		e.preventDefault();
		var form = jQuery(this);
		form.find('button').addClass('loading');
		var formData = form.serialize();
		$.ajax({
			url: Tophive_JS.ajaxurl,
			type: 'POST',
			data: {
				'action' : 'th_ajax_login',
				'formdata' : formData 
			},
			success : function( data ){
				if(data.loggedin){
					window.location.href = Tophive_JS.redirecturl;
					form.find('.login-notices').removeClass('ec-text-danger').addClass('ec-text-success').html(data.message);
					form.find('button').removeClass('loading');
				}else{
					form.find('.login-notices').addClass('ec-text-danger').html(data.message);
					form.find('button').removeClass('loading');
				}
			},
			error: function(xhr, ajaxOptions, thrownError){
				console.log(xhr.responseText);
	        }
		})
	});
	$(document).on('click', '.switch-register', function(e){
		e.preventDefault();
		$('.signup-segment').fadeIn().removeClass('ec-d-none').addClass('ec-d-block');
		$('.login-segment').fadeOut().removeClass('ec-d-block').addClass('ec-d-none');
	} );
	$(document).on('click', '.switch-login', function(e){
		e.preventDefault();
		$('.signup-segment').fadeOut().removeClass('ec-d-block').addClass('ec-d-none');
		$('.login-segment').fadeIn().removeClass('ec-d-none').addClass('ec-d-block');
	});
	$(document).on('click', '.show-signup-form-modal', function(e){
		e.preventDefault();
		$('.signup-segment').fadeIn().removeClass('ec-d-none').addClass('ec-d-block');
		$('.login-segment').fadeOut().removeClass('ec-d-block').addClass('ec-d-none');
		$('#tophive-signin-signup').addClass('open');
	});

	$(document).on('click', '.show-signin-form-modal', function(e){
		e.preventDefault();
		$('.login-segment').fadeIn().removeClass('ec-d-none').addClass('ec-d-block');
		$('.signup-segment').fadeOut().removeClass('ec-d-block').addClass('ec-d-none');
		$('#tophive-signin-signup').addClass('open');
	});
	$(document).on('click', '.tophive-popup-modal-close', function(e){
		e.preventDefault();
		$('.tophive-popup-modal').removeClass('open');
	});

	$('.tophive-popup-window-button').on('click', function(e){
		e.preventDefault();
		$('.tophive-instructor-request-form-popup').addClass('open');
	})
	jQuery('form.th-modal-register').on('submit', function(e){
		e.preventDefault();
		var form = jQuery(this);
		form.find('button').addClass('loading');
		var formData = form.serialize();
		$.ajax({
			url: Tophive_JS.ajaxurl,
			type: 'POST',
			data: {
				'action' : 'th_ajax_register',
				'formdata' : formData 
			},
			success : function( data ){
				if(data.loggedin){
					form.find('.login-notices').removeClass('ec-text-danger').addClass('ec-text-success').html(data.message);
					form.find('button').removeClass('loading');
					window.location.href = Tophive_JS.redirecturl;
				}else{
					form.find('.login-notices').addClass('ec-text-danger').html(data.message);
					form.find('button').removeClass('loading');
				}
			},
			error: function(xhr, ajaxOptions, thrownError){
				console.log(xhr.responseText);
	        }
		})
	});
	if( $('#page').hasClass('footer-fixed') ){
		var mb = $('.site-footer').outerHeight();
		$('.site-content').css('margin-bottom', mb);	
	}
});

$(function () {
  
  var msie6 = $.browser == 'msie' && $.browser.version < 7;
  
  if (!msie6 && $('.sidebar-secondary-inner').offset()!=null) {
    var top = $('.sidebar-secondary-inner').offset().top - parseFloat($('.sidebar-secondary-inner').css('margin-top').replace(/auto/, 0));
	var height = $('.sidebar-secondary-inner').height();
	var winHeight = $(window).height();	
	var footerTop = $('#site-footer').offset().top - parseFloat($('#site-footer').css('margin-top').replace(/auto/, 0));
	
	var gap = 30;
    $(window).scroll(function (event) {
      // what the y position of the scroll is
      var y = $(this).scrollTop();
      
      // whether that's below the form
      if (y+winHeight >= top+ height+gap && y+winHeight<=footerTop) {
        // if so, ad the fixed class
        $('.sidebar-secondary-inner').addClass('sidebarfixed').css('top',winHeight-height-gap +'px');
      } 
	  else if (y+winHeight>footerTop) {
        // if so, ad the fixed class
       $('.sidebar-secondary-inner').addClass('sidebarfixed').css('top',footerTop-height-y-gap+'px');
      } 
	  else 	  
	  {
        // otherwise remove it
        $('.sidebar-secondary-inner').removeClass('sidebarfixed').css('top','0px');
      }
    });
  }  
});