<?php
/**
 * Plugin Name: Tophive Messenger For BuddyPress
 * Plugin URI: 
 * Description: This a plugin for buddypress messaging system developed by tophive themes
 * Author: Muaz Hesam Musa
 * Author URI: http://facebook.com/musaMhesam
 * Version: 1.0
 */

namespace TophiveBpMessenger;

// use TophiveBpMessenger\inc\TophiveEximHelper;
// use TophiveBpMessenger\inc\TophiveEximDatabase;
// use TophiveBpMessenger\inc\TophiveEximImport;
use TophiveBpMessenger\inc\TophiveBPMProcessAjax;
use TophiveBpMessenger\inc\TophiveBPMFrontend;
use TophiveBpMessenger\inc\TophiveBPMBackend;

/**
 * summary
 */
class TophiveBuddyPressMessenger
{

	private static $instance = null;

	public static function constants()
	{
		define( 'WP_TH_BPM_VERSION' , 	'1.0');
		define( 'WP_TH_BPM_PREFIX' , 	'thbpm');
		define( 'WP_TH_BPM_SLUG' , 	'tophivebpm');

		// Need to add extra links on plugin activation
		define( 'WP_TH_BPM_BASENAME', plugin_basename( __FILE__ ));

		define( 'WP_TH_BPM_ROOT', __FILE__);
		define( 'WP_TH_BPM_ROOT_DIR', dirname(WP_TH_BPM_ROOT));

		define( 'WP_TH_BPM_PATH', plugin_dir_path(WP_TH_BPM_ROOT));
		define( 'WP_TH_BPM_URL', plugin_dir_url(WP_TH_BPM_ROOT));

		define( 'WP_TH_BPM_JS_URL', 	trailingslashit(WP_TH_BPM_URL . 'js'));
		define( 'WP_TH_BPM_CSS_URL', 	trailingslashit(WP_TH_BPM_URL . 'css'));
		define( 'WP_TH_BPM_FONTS_URL', 	trailingslashit(WP_TH_BPM_URL . 'fonts'));
		define( 'WP_TH_BPM_IMAGES_URL', trailingslashit(WP_TH_BPM_URL . 'images'));
	}
    public static function init(){
    	self::constants();
		add_action( 'wp_enqueue_scripts', array(self::getInstance(), 'frontendassets'));
		add_action( 'wp_ajax_nopriv_tophive_bpm_post_message', array( self::getInstance() ,'postMessage' ) );
		add_action( 'wp_ajax_tophive_bpm_post_message', array( self::getInstance() ,'postMessage' ) );
		add_shortcode( 'tophive_bp_messenger', array( self::getInstance(), 'getShortCode' ) );
		add_action( 'wp_ajax_nopriv_tophive_bpm_live_update_conversation', array( self::getInstance() ,'liveConvUpdate' ) );
		add_action( 'wp_ajax_tophive_bpm_live_update_conversation', array( self::getInstance() ,'liveConvUpdate' ) );
		add_action( 'wp_ajax_nopriv_tophive_fetch_conversations', array( self::getInstance() ,'updateConversation' ) );
		add_action( 'wp_ajax_tophive_fetch_conversations', array( self::getInstance() ,'updateConversation' ) );
		add_action( 'tophive/buddypress/messenger', array(self::getInstance(), 'tophive_bp_profile_messenger') );
		add_action( 'tophive/buddypress/header/messenger', array(self::getInstance(), 'tophive_bp_header_messenger') );
		add_action('wp_ajax_user_last_active_time', array( self::getInstance(), 'update_user_last_active_time' ));
		add_action('wp_ajax_nopriv_user_last_active_time', array( self::getInstance(), 'update_user_last_active_time' ));
		add_action('wp_ajax_tophive_bpm_update_chat_list', array( self::getInstance(), 'update_user_last_chat_list' ));
		add_action('wp_ajax_nopriv_tophive_bpm_update_chat_list', array( self::getInstance(), 'update_user_last_chat_list' ));
		add_action('wp_ajax_tophive_search_chat_members', array( self::getInstance(), 'search_users_metafans' ));
		add_action('wp_ajax_nopriv_tophive_search_chat_members', array( self::getInstance(), 'search_users_metafans' ));
		add_action('wp_ajax_tophive_fetch_new_conversations', array( self::getInstance(), 'tophive_fetch_new_conversations' ));
		add_action('wp_ajax_nopriv_tophive_fetch_new_conversations', array( self::getInstance(), 'tophive_fetch_new_conversations' ));
		add_action( 'wp_footer', array(self::getInstance(), 'sticky_messenger') );
    }
    public function sticky_messenger(){
    	if( !is_user_logged_in() ){
    		return;
    	}
    	echo TophiveBPMFrontend::makeMessengerSticky();
    }
    public function tophive_fetch_new_conversations(){
	    if( !is_user_logged_in() ){
    		return;
    	}
    	$r = $_REQUEST['recipients'];
    	$response = TophiveBPMFrontend::newConversationContent($r);

    	wp_send_json( $response, 200 );
    }
    public function search_users_metafans(){
    	if( !is_user_logged_in() ){
    		return;
    	}
    	$text = $_REQUEST['s'];
    	$response = TophiveBPMProcessAjax::searchMembers($text);

    	wp_send_json( $response, 200 );
    }
    public function update_user_last_chat_list(){
 		$response = TophiveBPMProcessAjax::updateUserChatList();
 		wp_send_json( $response, 200 );
    }
    public function update_user_last_active_time() {
		$user_id = get_current_user_id();
		update_user_meta( $user_id, 'user_last_active', time() );
		$res = get_user_meta( $user_id, 'user_last_active', true );
		wp_send_json( $res, 200 );
	}
    public static function updateConversation(){
    	if( !is_user_logged_in() ){
    		return;
    	}
		$thread_id = $_REQUEST['thread_id'];
		$recipients = $_REQUEST['recipients'];

 		$response = TophiveBPMProcessAjax::updateConversation( $thread_id, $recipients );
 		wp_send_json( $response );
    }
    public function tophive_bp_header_messenger(){
    	echo TophiveBPMFrontend::getChatList();
    }
    public function tophive_bp_profile_messenger(){
    	echo TophiveBPMFrontend::getFrontEnd();
    }
    public function getShortCode($atts){
    	return TophiveBPMFrontend::getFrontEnd();
    }
    public function liveConvUpdate(){
 		$args = array(
 			'last_id' => $_REQUEST['last_id'],
 			'thread_id' => $_REQUEST['thread_id'],
 			'sender' => $_REQUEST['sender']
 		);

 		$response = TophiveBPMProcessAjax::liveConvUpdate( $args );
 		wp_send_json( $response );

    }
    public static function postMessage(){
 		if( !is_user_logged_in() ){
 			return;
 		}
 		$args = array(
 			'content' => $_REQUEST['text'],
 			'thread_id' => $_REQUEST['thread_id'],
 			'sender_id' => $_REQUEST['sender'],
 			'recipients' => $_REQUEST['recipients']
 		);

 		$response['thread_id'] = TophiveBPMProcessAjax::postMessage( $args );
 		$response['chat_list'] = TophiveBPMFrontend::getChatList();;

 		wp_send_json( $response );
    }
    public static function frontendassets(){
		wp_enqueue_script( 'tophive-bpm', WP_TH_BPM_JS_URL . 'th-bpm.js', array(), '1.0.0' );
		wp_enqueue_style( 'tophive-bpm', WP_TH_BPM_CSS_URL . 'th-bpm.css', array(), '1.0.0' );
		$localize = array(
			'ajaxurl'	=> admin_url('admin-ajax.php'),
			'nonce'     => wp_create_nonce(WP_TH_BPM_SLUG),
		);
		wp_localize_script( 'tophive-bpm', 'Tophive_BPM', $localize );
    }
	public static function getInstance(){
		if (empty(self::$instance)) {
			self::$instance = new self();
		}
		return self::$instance;
	}

}
spl_autoload_register(__NAMESPACE__ . '\\autoload');

add_action( 'plugins_loaded', array( TophiveBuddyPressMessenger::getInstance(), 'init' ) );


function autoload($class = '') {
    if (!strstr($class, 'TophiveBpMessenger')){
        return;
    }
    $result = str_replace('TophiveBpMessenger\\', '', $class);
    $result = str_replace('\\', '/', $result);
    require $result . '.php';
}