jQuery(document).ready(function(jQuery){
	setInterval(function(){
		updateUserLastActiveTime();
	}, 30000);
	if( jQuery('.conversion-content.open').length > 0 ){
		scrollBottom();
		setInterval(function(){
			var thread_id = jQuery('.conversion-content').data('thread-id');
			var sender = jQuery('.conversion-content').data('sender');
			var last_id = jQuery('.conversion-content').data('last-id');
			updateConversation(thread_id, sender, last_id);
		}, 2000);
	}
	// function escape(s){
	// 	return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
	// }

	// function replaceStringWithEmoji(string){
	//   var emojiMap = {
	//     ':)': '😊',
	//     ':(': '🙁',
	//     ':D': '😁',
	//     ';(': '😥',
	//     ':O': '😮',
	//     ';)': '😉',
	//     '8)': '😎',
	//     '>:@': '😡',
	//   };
	//   var pattern = new RegExp(
	//     Object.keys(emojiMap).map(escape).join('|'),
	//     'g'
	//   );
	//   return string.replace(pattern, match => emojiMap[match]);
	// };
	jQuery(document).on('keypress', '.conversion-form form .conv-text', function (e) {
		var _that = jQuery(this);
        if(e.which === 13 && !e.shiftKey) {
            e.preventDefault();
            var text = _that.val();

            if( text !== '' ){
            	var time = new Date();
  				var texttime = time.toLocaleString('en-US', { hour: 'numeric', minute: 'numeric', hour12: true });
	            var thread_id = _that.attr('data-thread-id');
	            var sender = _that.attr('data-sender');
	            var recipients = _that.attr('data-recipients');
	            
	            jQuery('.conversion-content').append('<div class="single-conversation c-right temp"><span class="c-right">'+ text +'<span class="time">'+ texttime +'</span></span></div>');
	            scrollBottom();
	            sendMessage( _that, text, thread_id, sender, recipients );
	            clearTextArea(_that);
            }
        }
    });
    jQuery(document).on('click', '.th-messenger-chat-main .conversion-form .send--button', function (e) {
        var _that = jQuery(this).parent().find('textarea');
        e.preventDefault();
        var text = _that.val();

        if( text !== '' ){
            var time = new Date();
            var texttime = time.toLocaleString('en-US', { hour: 'numeric', minute: 'numeric', hour12: true });
            var thread_id = _that.attr('data-thread-id');
            var sender = _that.attr('data-sender');
            var recipients = _that.attr('data-recipients');
            
            jQuery('.conversion-content').append('<div class="single-conversation c-right temp"><span class="c-right">'+ text +'<span class="time">'+ texttime +'</span></span></div>');
            scrollBottom();
            sendMessage( _that, text, thread_id, sender, recipients );
            clearTextArea(_that);
        }
    });
    jQuery(document).on('click', '.th-bpm-chat-members .single-thread', function(){
    	var _that = jQuery(this);
    	_that.removeClass('unread');
    	if( jQuery( window ).width() < 439 ){
    		jQuery(this).parents('.tophive-bp-messenger-main-wrapper').addClass('showing-chat mobile-menu');
    	}
    	var thread_id 	= jQuery(this).attr('data-thread-id');
    	var recipients 	= jQuery(this).attr('data-recipients');
        setConversationonLive( _that, thread_id, recipients );
    });
    jQuery(document).on('click', '.private-msg', function(e){
    	e.preventDefault();
    	jQuery('.tophive-bp-messenger-sticky-main').addClass('messenger-open');
    	var recipients 	= jQuery(this).attr('data-recipients-id');
    	var _that 	= jQuery('.th-messenger-chat-main');
        setButtonConversationonLive( recipients );
    });

    jQuery(document).on('click', '.show_searched_members .single-thread', function(){
    	var _that = jQuery(this);
    	if( jQuery( window ).width() < 439 ){
    		jQuery(this).parents('.tophive-bp-messenger-main-wrapper').addClass('showing-chat mobile-menu');
    	}
    	var recipients 	= jQuery(this).attr('data-recipient');
    	jQuery('.search_chat_members').val('');
    	jQuery('.show_searched_members').html('');
        setNewConversationonLive( _that, recipients );
    });
    
    jQuery(document).on('click', '.chat-filed-header .mobile-back', function(){
    	if( jQuery( window ).width() < 439 ){
    		jQuery(this).parents('.tophive-bp-messenger-main-wrapper').removeClass('showing-chat mobile-menu');
    	}
    	jQuery(this).parents('.tophive-bp-messenger-main-wrapper').removeClass('show_chat');
    });

    jQuery('.messenger-toggler').on('click', function(){
    	jQuery(this).parent().toggleClass('messenger-open');
    });
    jQuery('.search_chat_members').on('keyup', function(e){
    	var s = jQuery('.search_chat_members').val();
    	jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'tophive_search_chat_members',
                s : s
            },
            success : function (response) {
            	jQuery('.show_searched_members').html(response);
            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });
    });
    function setConversationonLive( _that, thread_id, recipients ){
    	var main_conteiner = _that.parents('.tophive-bp-messenger-main-wrapper');
    	var chat_container = _that.parents('.tophive-bp-messenger-main-wrapper').find('.th-messenger-chat-main');
    	chat_container.addClass('loading');
    	main_conteiner.addClass('show_chat');
    	jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'tophive_fetch_conversations',
                thread_id : thread_id,
                recipients : recipients
            },
            success : function (response) {
				chat_container.html(response).removeClass('loading'); 
		    	scrollBottom();
            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });
    }
    function setNewConversationonLive( _that, recipients ){
    	var main_conteiner = _that.parents('.tophive-bp-messenger-main-wrapper');
    	var chat_container = _that.parents('.tophive-bp-messenger-main-wrapper').find('.th-messenger-chat-main');
    	chat_container.addClass('loading');
    	main_conteiner.addClass('show_chat');
    	jQuery('.th-messenger-chat-main').addClass('loading');
    	jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'tophive_fetch_new_conversations',
                recipients : recipients
            },
            success : function (response) { 
		    	jQuery('.th-messenger-chat-main').html(response);
		    	jQuery('.th-messenger-chat-main').removeClass('loading');
		    	scrollBottom();
            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });
    }
    function setButtonConversationonLive( recipients ){
    	var main_conteiner = jQuery('.tophive-bp-messenger-main-wrapper');
    	var chat_container = jQuery('.tophive-bp-messenger-main-wrapper').find('.th-messenger-chat-main');
    	chat_container.addClass('loading');
    	main_conteiner.addClass('show_chat');
    	jQuery('.th-messenger-chat-main').addClass('loading');
    	jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'tophive_fetch_new_conversations',
                recipients : recipients
            },
            success : function (response) { 
		    	jQuery('.th-messenger-chat-main').html(response);
		    	jQuery('.th-messenger-chat-main').removeClass('loading');
		    	scrollBottom();
            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });
    }
	function scrollBottom(){
	    var element = document.getElementById("conversion-content");
		element.scrollTop = element.scrollHeight;
	}
	function clearTextArea(el){
		el.val('');
	}
	function sendMessage( _that, text, thread_id, sender, recipients ){
		jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'tophive_bpm_post_message',
                text : text,
                thread_id : thread_id,
                sender : sender,
                recipients : recipients
            },
            success : function (response) { 
				_that.attr('data-thread-id', response.thread_id);
				jQuery('.th-bpm-chat-members').html(response.chat_list);

            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });
	}
	function getMessage( $args ){}
	function getChatList( $args ){}
	function switchChatHeader( $args ){}
	function switchChatContainer( $args ){}
	function switchChatForm( $args ){}
	function refreshMessage(){

	}
	function updateChatList(){
		jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'tophive_bpm_update_chat_list'
            },
            success : function (response) {
				console.log(response);
				// jQuery('.th-bpm-chat-members').html(response.chatlist);
            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });		
	}
	function updateConversation( thread_id, sender, last_id ){
		jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'tophive_bpm_live_update_conversation',
                last_id : last_id,
                thread_id : thread_id,
                sender : sender
            },
            success : function (response) {
            	// console.log(response);
				if( response.data ){
					if ( jQuery(".single-conversation[data-conv-id=" + response.data.id + "]").length == 0) {
						jQuery(".single-conversation.temp").remove();
						jQuery('.conversion-content.open[data-thread-id=' + response.data.thread_id + ']').append(response.html);
						jQuery('.conversion-content.open[data-thread-id=' + response.data.thread_id + ']').attr('data-last-id', response.data.id);
						scrollBottom();
					}
				}
				if( response.has_new === true ){
					jQuery('.th-bpm-chat-members').html(response.chatlist);
				}
				if( response.total > 0 ){
					jQuery('.new-message-count').removeClass('hidden');
					jQuery('.new-message-count').html(response.total);
				}else{
					jQuery('.new-message-count').addClass('hidden');
				}
            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });
	}
	function updateUserLastActiveTime( thread_id, sender, last_id ){
		jQuery.ajax({
            url     : Tophive_BPM.ajaxurl,
            type    : 'post',
            data    : {
                action : 'user_last_active_time'
            },
            success : function (response) {
				// console.log(response);
            },
            error: function(xhr, ajaxOptions, thrownError){
                console.log(xhr);
            }
        });
	}
});