<?php 
namespace TophiveBpMessenger\inc;

class TophiveBPMProcessAjax
{
	private static $instance = null;
    public static function postMessage( $args )
    {
 		if( !is_user_logged_in() ){
 			return;
 		}
 		if( isset($args['thread_id']) && !empty($args['thread_id']) ){
    		TophiveBPMBackend::markThreadAsRead( $thread_id );
 		}
 		// global $wpdb;
 		// $response = array();
 		// $table = $wpdb->base_prefix . 'bp_messages_messages';
 		// $wpdb->insert(
 		// 	$table,
 		// 	array(
 		// 		'thread_id' => $args['thread_id'],
 		// 		'sender_id' => $args['sender'],
 		// 		'message' => $args['text'],
 		// 		'date_sent' => date("Y-m-d h:i:s")
 		// 	),
 		// 	array(
 		// 		'%d', '%d', '%s', '%s'
 		// 	)
 		// );
 		// $msg_id = $wpdb->insert_id;
 		// $response['msg_id'] = $msg_id;
 		// $response['delivery_status'] = 1;
 		// $response['recipients'] = $args['recipients'];
 		// self::updateMessageStatus( $msg_id, 1 );
 		// self::updateMessageRecipients( $msg_id, $args['thread_id'], $args['recipients'] );
 		// return $response;
 		return messages_new_message($args);
    }
    public static function updateUserChatList(){
    	global $wpdb;
    	$user_id = get_current_user_id();

    	$messages_table = $wpdb->base_prefix . 'bp_messages_messages';
    	$messages_meta_table = $wpdb->base_prefix . 'bp_messages_meta';

    	$results = $wpdb->get_results("SELECT * FROM $messages_table d, $messages_meta_table k WHERE k.message_id = d.id and k.meta_key = 'msg_recipients' and k.meta_value = {$user_id}", ARRAY_A);
    	$msg_ids = array();
    	foreach ($results as $key => $value) {
			$results[$key]['status'] = self::getMsgStatus( $value['message_id'] );
    	}
    	return $results;
    }
    public function getMsgStatus( $msg_id ){
    	global $wpdb;
    	$messages_meta_table = $wpdb->base_prefix . 'bp_messages_meta';
    	$status = $wpdb->get_results("SELECT * FROM $messages_meta_table WHERE message_id={$msg_id} and meta_key='msg_delivery_status'");
    	return $status[0]->meta_value;
    }
    public static function updateMessageRecipients( $msg_id, $thread_id, $recipients ){
 		global $wpdb;
 			
    	$table = $wpdb->base_prefix . 'bp_messages_meta';
 		$wpdb->insert(
 			$table,
 			array(
 				'message_id' => $msg_id,
 				'meta_key' => 'msg_recipients',
 				'meta_value' => $recipients,

 			),
 			array(
 				'%d', '%s', '%s'
 			)
 		);
 		return $wpdb->insert_id;
    }
    public static function updateMessageStatus( $msg_id, $status ){
 		global $wpdb;
    	$table = $wpdb->base_prefix . 'bp_messages_meta';
 		$wpdb->insert(
 			$table,
 			array(
 				'message_id' => $msg_id,
 				'meta_key' => 'msg_delivery_status',
 				'meta_value' => $status,

 			),
 			array(
 				'%d', '%s', '%d'
 			)
 		);
    }
    public static function updateConversation( $thread_id, $recipients ){
    	TophiveBPMBackend::markThreadAsRead( $thread_id );
    	$recipients = explode(',', $recipients);
    	$html = '';
    	$html .= TophiveBPMFrontend::getConversationHeader( $thread_id, $recipients );
    	$html .= TophiveBPMFrontend::getConversationContent( $thread_id, $recipients );
    	$html .= TophiveBPMFrontend::getConversationFooter( $thread_id, $recipients );
		return $html;
	}
    public static function liveConvUpdate( $args ){
 		global $wpdb;
    	$last_conv = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}bp_messages_messages WHERE thread_id={$args['thread_id']} ORDER BY id DESC LIMIT 1", ARRAY_A);
    	$conv = $last_conv[0];
    	$class = $conv['sender_id'] == get_current_user_id() ? 'c-right' : 'c-left';
    	$response['data'] = $conv;
    	$response['html'] = '<div class="single-conversation '. $class .'" data-conv-id="'. $conv['id'] .'"><span class="'. $class .'">'. self::convertintoURL($conv['message']) .'<span class="time">'. date('h:i a', strtotime($conv['date_sent'])) .'</span></span></div>';
    	$response['chatlist'] = TophiveBPMFrontend::getChatList();
    	$response['has_new'] = TophiveBPMBackend::userHasNewThread();
    	$response['total'] = TophiveBPMBackend::getTotalNewThreads();
    	return $response;
    }
    public  static function convertintoURL( $content ){
		$url = '~(?:(https?)://([^\s<]+)|(www\.[^\s<]+?\.[^\s<]+))(?<![\.,:])~i'; 
		return preg_replace($url, '<a href="$0" target="_blank" title="$0">$0</a>', $content);
	}
    public function searchMembers($text){
		global $wpdb;
		$html = '';
		if( !empty(trim($text)) ){
			$users = $wpdb->get_results("SELECT ID, display_name FROM {$wpdb->base_prefix}users WHERE user_nicename LIKE '%$text%' OR user_email LIKE '%$text%' OR  display_name LIKE '%$text%'");
			$html .= '<div class="searched-members">';
			if( !empty($users) ){
				foreach ($users as $user) {
					if( $user->ID != get_current_user_id() ){
						$html .= '<div class="single-thread" data-recipient="'. $user->ID .'">';

						$html .= get_avatar( $user->ID, 40 );
							$html .= '<div class="item-content">';
								$html .= '<span class="name">' . get_the_author_meta( 'display_name', $user->ID ) . '</span>';
							$html .= '</div>';
						$html .= '</div>';
					}else{
						$html .= '';
					}
				}
			}else{
				$html .= '<p class="no_users">' . esc_html__( 'No users found', WP_TH_BPM_SLUG ) . '</p>';
			}
			$html .= '</div>';
		}
		return $html;
	}
    public static function getInstance(){
		if (empty(self::$instance)) {
			self::$instance = new self();
		}
	}
}
?>