<?php  
namespace TophiveBpMessenger\inc;
/**
 * Tophive Messenger Frontend and shortcode
 */
class TophiveBPMBackend
{
	private static $instance = null;

	public static function getChatList(){
		
	}
	private static function isUserHasFriends(){}
	public static function userHasConversations( $user_id='' ){
		global $wpdb;
		if( empty($user_id) ){
			$user_id = get_current_user_id();
		}
		if( !empty(self::getUserThreadsIDs($user_id)) ){
			return true;
		}else{
			return false;
		}
	}
	
	public static function getMessageStatus( $msg_id ){

	}
	public static function getConversations( $thread_id ){
		global $wpdb;
		$conversations = $wpdb->get_results("SELECT id, sender_id, message, date_sent FROM {$wpdb->base_prefix}bp_messages_messages WHERE thread_id={$thread_id}", ARRAY_A);
		return $conversations;
	}
	
	public function getLastMsgFromThread( $id ){
		global $wpdb;
		$last_msg = $wpdb->get_results("SELECT message, date_sent, sender_id FROM {$wpdb->base_prefix}bp_messages_messages WHERE thread_id={$id} ORDER BY date_sent DESC LIMIT 1", ARRAY_A);
		$pre_text = $last_msg[0]['sender_id'] == get_current_user_id() ? 'You: ' : '';
		return '<span class="last-thread-text">' . $pre_text . $last_msg[0]['message'] . '</span> · <span>'. self::th_bpm_time_elapsed_string( '@' . strtotime($last_msg[0]['date_sent']) ) .'</span>';
	}
	public function getUserLastActivity( $user_id ){
		$res = array();
		$last_activity = get_user_meta( $user_id, 'user_last_active', true );
		if( !empty($last_activity) ){
			$time_diff = time() - (int)$last_activity;
			if( $time_diff < 60 ){
				$res['text'] = esc_html__( 'Active Now', 'default' );
				$res['status'] = 'live';
				$res['class'] = 'live';
			}else{
				$res['text'] = esc_html( 'Active ', WP_TH_BPM_SLUG ) . self::th_bpm_time_elapsed_string('@'. $last_activity) . esc_html__(' ago', WP_TH_BPM_SLUG);
				$res['status'] = 'offline';
				$res['class'] =  'offline';
			}
		}else{
			$res['text'] = '';
			$res['status'] = false;
		}
		return $res;
	}

   /**
	* Get Thread id from the recipients
	*  
	* @since 1.0.0 
	*  
	* @param Array of recipients
	* 		@type array $recipients  Required. ID/IDs of the recipients other than current user id 
	*  
	* @return int thread_id of the recepients of exists or false if not exists
	*  
	*/
	public static function getThreadIDFromRecipients( $recipients = array() ){
		global $wpdb;
		if( !empty($recipients) ){
			array_push($recipients, get_current_user_id());
			$count = count($recipients);
			$recipients = '(' . implode(',', $recipients) . ')';
			$results = $wpdb->get_results("SELECT thread_id from {$wpdb->base_prefix}bp_messages_recipients WHERE user_id IN {$recipients} GROUP BY thread_id HAVING COUNT(DISTINCT user_id) = {$count} LIMIT 1");
			if( !empty($results) ){
				return $results[0]->thread_id;
			}else{
				return false;
			}
		}
	}

   /**
	* Get Recipients from thread id
	*  
	* @since 1.0.0 
	*  
	* @param thread_id
	* 		@type int $thread_id  Required. thread_id to get recipients
	* 
	* @return array of recipients ids
	*  
	*/
	public static function getRecipientsFromThreadID( $thread_id ){
		global $wpdb;
		$recipients = array();
		$users = $wpdb->get_results("SELECT user_id FROM {$wpdb->base_prefix}bp_messages_recipients WHERE thread_id={$thread_id}");
		foreach ($users as $key => $user) {
			$recipients[] = $user->user_id;
		}
		return $recipients;
	}
   /**
	* Get Thread type from thread id
	*  
	* @since 1.0.0 
	*  
	* @param thread_id
	* 		@type int $thread_id  Required. thread_id to get type
	* 
	* @return string Thread type ('single|group')
	*  
	*/
	public static function getThreadTypeFromThreadID( $thread_id ){
		global $wpdb;
		$users = $wpdb->get_results("SELECT user_id FROM {$wpdb->base_prefix}bp_messages_recipients WHERE thread_id={$thread_id}");
		if( count($users) > 2 ){
			return 'group';
		}else{
			return 'single';
		}
	}
   /**
	* Get Current Users Threads
	*  
	* @since 1.0.0
	*  
	* @param thread_id
	* 		@type int $thread_id  Required. thread_id to get type
	* 
	* @return string Thread type ('single|group')
	*  
	*/
	
	public static function getUserThreadsIDs( $user_id='' ){
		global $wpdb;
		if( empty($user_id) ){
			$user_id = get_current_user_id();
		}
		$thread_ids = array();
		$current_user_threads = $wpdb->get_results("SELECT DISTINCT thread_id FROM {$wpdb->base_prefix}bp_messages_recipients WHERE user_id={$user_id}");
		foreach ($current_user_threads as $thread) {
			array_push($thread_ids, $thread->thread_id);
		}
		$thread_ids_string = '(' . implode(',', $thread_ids) . ')';
		$threads = $wpdb->get_results("SELECT DISTINCT thread_id, MAX(id) FROM {$wpdb->base_prefix}bp_messages_messages WHERE thread_id IN {$thread_ids_string} GROUP BY thread_id ORDER BY MAX(id) DESC");

		$lastest_thread_ids = array();
		foreach ($threads as $thread) {
			array_push($lastest_thread_ids, $thread->thread_id);			
		}
		return $lastest_thread_ids;
	}
   /**
	* Get Conversations From A thread
	*  
	* @since 1.0.0
	*  
	* @param thread_id
	* 		@type int $thread_id  Required. thread_id to get conversations
	* 
	* @return Array
	* 		Array of conversations
	*  		{
	*			$ID 	int
	*			$text 	String
	*			$date 	String	
	*		}
	*  	
	*/
	public function getConversationsFromThreadID( $thread_id ){
		global $wpdb;
		$conversations = array();
		$c = $wpdb->get_results("SELECT id, sender_id, message, date_sent FROM {$wpdb->base_prefix}bp_messages_messages WHERE thread_id={$thread_id}", ARRAY_A);
		
		foreach($c as $conv){
		    $date = date("F j,Y",strtotime($conv['date_sent']));
		    // if(array_key_exists($date,$conversations)){
		    //     $conversations[$date][] = array(
		    //         'id'      => $conv['id'],
		    //         'message' => $conv['message'],
		    //         'sender_id' => $conv['sender_id'],
		    //         'date_sent' => $conv['date_sent']
		    //     );
		    // }
		    // else{
		        // array_push($conversations,$date);
		        $conversations[$date][] = array(
		            'id'      => $conv['id'],
		            'message' => $conv['message'],
		            'sender_id' => $conv['sender_id'],
		            'date_sent' => $conv['date_sent']
		        );
		    // }
		}
		return $conversations;
	}
	/**
	* Get Last Conversation Conversations From A thread id
	*  
	* @since 1.0.0
	*  
	* @param thread_id
	* 		@type int $thread_id  Required. thread_id to get last conversations
	* 
	* @return Array
	* 		Array of conversations
	*  		{
	*			$ID 	int
	*			$message 	String
	*			$date 	String	
	*		}
	*  	
	*/
	public function getLastConversationFromThreadID( $thread_id ){
		global $wpdb;
		$last_msg = $wpdb->get_results("SELECT id, message, date_sent, sender_id FROM {$wpdb->base_prefix}bp_messages_messages WHERE thread_id={$thread_id} ORDER BY date_sent DESC LIMIT 1", ARRAY_A);
		return $last_msg[0];
	}
	/**
	* Get Last Conversation ID From an existing thread id
	*  
	* @since 1.0.0
	*  
	* @param thread_id
	* 		@type int $thread_id  Required. thread_id to get last conversation ID
	* 
	* @return int Conversation ID
	*  	
	*/
	public function getLastConversationID( $thread_id ){
		global $wpdb;
		$last_msg = $wpdb->get_results("SELECT id FROM {$wpdb->base_prefix}bp_messages_messages WHERE thread_id={$thread_id} ORDER BY date_sent DESC LIMIT 1", ARRAY_A);
		return $last_msg[0]['id'];
	}
	/**
	* Get total unread count from thread id
	*  
	* @since 1.1.0
	*  
	* @param thread_id
	* 		@type int $user_id  Optional
	* 
	* @return int Total Unread Messages Count
	*  	
	*/
	public function getTotalNewThreads( $user_id = '' ){
		global $wpdb;
		if( empty($user_id) ){
			$user_id = get_current_user_id();
		}
		$total_unread = $wpdb->get_results("SELECT thread_id FROM {$wpdb->base_prefix}bp_messages_recipients WHERE user_id={$user_id} and unread_count > 0");
		return count($total_unread);
	}
	/**
	* Check if a thread is unread from thread id
	*  
	* @since 1.1.0
	*  
	* @param thread_id
	* 		@type int $thread_id  	Required. thread_id to check
	* 		@type int $user_id  	Optional. user_id of a thread
	* 
	* @return Boolean
	*  	
	*/
	public function isThreadUnread( $thread_id, $user_id = '' ){
		global $wpdb;
		if( empty($user_id) ){
			$user_id = get_current_user_id();
		}
		$total_unread = $wpdb->get_results("SELECT thread_id FROM {$wpdb->base_prefix}bp_messages_recipients WHERE thread_id={$thread_id} and user_id={$user_id} and unread_count > 0");
		if( count($total_unread) > 0 ){
			return true;
		}else{
			return false;
		}
	}
	/**
	* Check if a user has new thread. This function is used to check dynamically on ajax
	*  
	* @since 1.1.0
	*  
	* @param user_id
	* 		@type int $user_id  Optional. user_id to check new messages
	* 
	* @return Boolean
	*  	
	*/
	public function userHasNewThread( $user_id = '' ){
		global $wpdb;
		if( empty($user_id) ){
			$user_id = get_current_user_id();
		}	
		if( self::getTotalNewThreads( $user_id ) > 0 ){
			return true;
		}else{
			return false;
		}
	}
	public function markThreadAsRead( $thread_id, $user_id = '' ){
		global $wpdb;
		if( empty($user_id) ){
			$user_id = get_current_user_id();
		}
		$table = $wpdb->base_prefix . 'bp_messages_recipients';

		$updated = $wpdb->update(
			$table,
			array(
				'unread_count' => 0
			),
			array(
				'user_id' => $user_id,
				'thread_id' => $thread_id
			)
		);
		if( $updated ){
			return 'success';
		}else{
			return 'failed';
		}
	}
	public function th_bpm_time_elapsed_string($datetime, $full = false) {
	    $now = new \DateTime;
	    $ago = new \DateTime($datetime);
	    $diff = $now->diff($ago);
	    $diff->w = floor($diff->d / 7);
	    $diff->d -= $diff->w * 7;

	    $string = array(
	        'y' => 'year',
	        'm' => 'month',
	        'w' => 'week',
	        'd' => 'day',
	        'h' => 'hr',
	        'i' => 'min',
	        's' => 'sec',
	    );
	    foreach ($string as $k => &$v) {
	        if ($diff->$k) {
            	$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
	        } else {
	            unset($string[$k]);
	        }
	    }

	    if (!$full) $string = array_slice($string, 0, 1);
	    return $string ? implode(', ', $string) . esc_html__( '', 'metafans' ) : esc_html__('just now', 'metafans');
	}
	public static function getRecipients($thread_id){
		global $wpdb;
		return $wpdb->get_results( $wpdb->prepare( "SELECT user_id FROM {$wpdb->base_prefix}bp_messages_recipients WHERE thread_id = %d", $thread_id ) );		
	} 
	public static function getTimeZoneFromIpAddress(){
	    $clientsIpAddress = self::get_client_ip();

	    $clientInformation = unserialize(file_get_contents('http://www.geoplugin.net/php.gp?ip='.$clientsIpAddress));

	    $clientsLatitude = $clientInformation['geoplugin_latitude'];
	    $clientsLongitude = $clientInformation['geoplugin_longitude'];
	    $clientsCountryCode = $clientInformation['geoplugin_countryCode'];

	    $timeZone = self::get_nearest_timezone($clientsLatitude, $clientsLongitude, $clientsCountryCode) ;

	    return $timeZone;

	}

	public static function get_client_ip() {
	    $ipaddress = '';
	    if (getenv('HTTP_CLIENT_IP'))
	        $ipaddress = getenv('HTTP_CLIENT_IP');
	    else if(getenv('HTTP_X_FORWARDED_FOR'))
	        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
	    else if(getenv('HTTP_X_FORWARDED'))
	        $ipaddress = getenv('HTTP_X_FORWARDED');
	    else if(getenv('HTTP_FORWARDED_FOR'))
	        $ipaddress = getenv('HTTP_FORWARDED_FOR');
	    else if(getenv('HTTP_FORWARDED'))
	        $ipaddress = getenv('HTTP_FORWARDED');
	    else if(getenv('REMOTE_ADDR'))
	        $ipaddress = getenv('REMOTE_ADDR');
	    else
	        $ipaddress = 'UNKNOWN';
	    return $ipaddress;
	}

	public static function get_nearest_timezone($cur_lat, $cur_long, $country_code = '') {
	    $timezone_ids = ($country_code) ? \DateTimeZone::listIdentifiers(\DateTimeZone::PER_COUNTRY, $country_code)
	        : \DateTimeZone::listIdentifiers();

	    if($timezone_ids && is_array($timezone_ids) && isset($timezone_ids[0])) {

	        $time_zone = '';
	        $tz_distance = 0;

	        //only one identifier?
	        if (count($timezone_ids) == 1) {
	            $time_zone = $timezone_ids[0];
	        } else {

	            foreach($timezone_ids as $timezone_id) {
	                $timezone = new \DateTimeZone($timezone_id);
	                $location = $timezone->getLocation();
	                $tz_lat   = $location['latitude'];
	                $tz_long  = $location['longitude'];

	                $theta    = $cur_long - $tz_long;
	                $distance = (sin(deg2rad($cur_lat)) * sin(deg2rad($tz_lat)))
	                    + (cos(deg2rad($cur_lat)) * cos(deg2rad($tz_lat)) * cos(deg2rad($theta)));
	                $distance = acos($distance);
	                $distance = abs(rad2deg($distance));
	                // echo '<br />'.$timezone_id.' '.$distance;

	                if (!$time_zone || $tz_distance > $distance) {
	                    $time_zone   = $timezone_id;
	                    $tz_distance = $distance;
	                }

	            }
	        }
	        return  $time_zone;
	    }
	    return 'unknown';
	}
    public static function getInstance(){
		if (empty(self::$instance)) {
			self::$instance = new self();
		}
	}
}