<?php
/**
 * Product Loop Start
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version 	3.3.0
 */
global $wp_query;
?>
<?php
	$type = 'grid';
    if(isset($_GET['type'])){
        $type = $_GET['type'];
    }
    $number = sv_get_option('woo_shop_number',12);
	if(isset($_GET['number'])){
	    $number = $_GET['number'];
	}
?>
<h3 class="page-title">
	<span><?php woocommerce_page_title(); ?></span>
</h3>
<div class="sortPagiBar">
	<ul class="display-product-option">
        <li class="view-as-grid <?php if($type == 'grid') echo 'selected'?>">
            <a href="<?php echo esc_url(sv_get_key_url('type','grid'))?>"><span><?php esc_html_e("grid","megastore")?></span></a>
        </li>
        <li class="view-as-list <?php if($type == 'list') echo 'selected'?>">
            <a href="<?php echo esc_url(sv_get_key_url('type','list'))?>"><span><?php esc_html_e("list","megastore")?></span></a>
        </li>
    </ul>
	<div class="sortPagiBar-inner">
		<nav>
			<?php
				echo paginate_links( array(
					'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
					'format'       => '',
					'add_args'     => '',
					'current'      => max( 1, get_query_var( 'paged' ) ),
					'total'        => $wp_query->max_num_pages,
					'prev_text' => '<span>'.esc_html__( '&laquo; Prev', 'megastore' ).'</span>',
            		'next_text' => '<span>'.esc_html__( 'Next &raquo;', 'megastore' ).'</span>',
					'type'         => 'list',
					'end_size'     => 2,
					'mid_size'     => 1
				) );
			?>
		</nav>
        <div class="show-product-item">
        	<span><?php esc_html_e("Show ","megastore")?><?php echo esc_attr($number)?></span>
        	<ul class="per-page-list">
				<li><a href="<?php echo esc_url(sv_get_key_url('number','6'))?>"><?php esc_html_e("Show 6","megastore")?></a></li>
				<li><a href="<?php echo esc_url(sv_get_key_url('number','9'))?>"><?php esc_html_e("Show 9","megastore")?></a></li>
				<li><a href="<?php echo esc_url(sv_get_key_url('number','12'))?>"><?php esc_html_e("Show 12","megastore")?></a></li>
				<li><a href="<?php echo esc_url(sv_get_key_url('number','18'))?>"><?php esc_html_e("Show 18","megastore")?></a></li>
				<li><a href="<?php echo esc_url(sv_get_key_url('number','24'))?>"><?php esc_html_e("Show 24","megastore")?></a></li>
				<li><a href="<?php echo esc_url(sv_get_key_url('number','48'))?>"><?php esc_html_e("Show 48","megastore")?></a></li>
			</ul>
        </div>
        
        <div class="sort-product">
        	<?php woocommerce_catalog_ordering()?>
        </div>
	</div>
</div>
<div class="category-products">
	<ul class="products product <?php echo esc_attr($type)?> row">