<?php
$data = '';
$gallery = get_post_meta(get_the_ID(), 'format_gallery', true);
if (!empty($gallery)){
    $array = explode(',', $gallery);
    if(is_array($array) && !empty($array)){
        
        $data .= '<div class="entry-photo"><div class="gallery-slider">';
        foreach ($array as $key => $item) {
            $thumbnail_url = wp_get_attachment_url($item);
            $data .='<div class="image-slider">';
            $data .= '<img src="' . esc_url($thumbnail_url) . '" alt="image-slider">';           
            $data .= '</div>';
        }
        $data .='</div></div>';
    }
}
?>

<h2 class="page-title">
    <?php the_title()?>
    <?php echo (is_sticky()) ? '<i class="fa fa-thumb-tack"></i>':''?>
</h2>
<div class="page-content clearfix">
    <article class="entry-detail">
        <?php sv_display_metabox();?>
        <?php if(!empty($data)) echo balanceTags($data);?>
        <div class="entry-content clearfix">
            <?php the_content();?>
        </div>
        <div class="entry-tags">
            <span><i class="fa fa-tags" aria-hidden="true"></i> <?php esc_html_e("Tags:",'megastore');?></span>
            <?php $tags = get_the_tag_list(' ',', ',' ');?>
            <?php if($tags) echo balanceTags($tags); else esc_html_e("No Tag",'megastore');?>
        </div>
    </article>
</div>